/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.fm.storade.agent.catalog;

import com.sun.netstorage.fm.storade.agent.catalog.Catalog;
import com.sun.netstorage.fm.storade.agent.util.XmlElement;
import java.io.File;
import java.lang.reflect.Constructor;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.LinkedList;
import java.util.Properties;

public class Loader {
    public static final String DISCOVER = "Discover";
    public static final String REPORT = "Report";
    public static final String MESSAGE = "Message";
    public static final String DIAGNOSTIC = "Diagnostic";
    private String type;
    private XmlElement impl;
    private File dir;
    public static final String _SOURCE_REVISION = "$Revision: 1.3 $";
    static /* synthetic */ Class class$java$util$Properties;

    public Loader(String type) {
        this.type = type;
        this.initImpl();
    }

    private void initImpl() {
        try {
            this.dir = new File(Catalog.getCatalogDir(this.type));
            File ifile = new File(this.dir, "implementation.xml");
            this.impl = new XmlElement(ifile);
        }
        catch (Exception e) {
            this.impl = null;
        }
    }

    public XmlElement getInterfaceElement(String implName) {
        if (this.impl == null) {
            return null;
        }
        return this.impl.getElement("interface", "name", implName);
    }

    public Object getImpl(String implName) {
        try {
            return this.getJavaImpl(implName);
        }
        catch (Exception e) {
            return null;
        }
    }

    public ClassLoader getClassLoader() {
        File lib = new File(this.dir, "lib");
        if (lib.exists()) {
            try {
                LinkedList<URL> jars = new LinkedList<URL>();
                jars.add(new URL("file:" + lib.getAbsolutePath() + "/"));
                File[] files = lib.listFiles();
                for (int i = 0; i < files.length; ++i) {
                    String fname = files[i].getName();
                    if (!fname.endsWith(".jar")) continue;
                    jars.add(new URL("file:" + files[i].getAbsolutePath()));
                }
                URL[] urls = new URL[jars.size()];
                jars.toArray(urls);
                URLClassLoader loader = new URLClassLoader(urls, this.getClass().getClassLoader());
                return loader;
            }
            catch (Exception e) {
                e.printStackTrace();
                return this.getClass().getClassLoader();
            }
        }
        return this.getClass().getClassLoader();
    }

    public Object getJavaImpl(String implName) throws Exception {
        XmlElement jface = this.getInterfaceElement(implName);
        if (jface == null) {
            throw new IllegalArgumentException(this.type + ":" + implName);
        }
        XmlElement jload = jface.getElement("load", "type", "java");
        if (jload == null) {
            return null;
        }
        Class<?> iclass = Class.forName(jload.getStringValue("module"), true, this.getClassLoader());
        Properties args = jload.getProperties("property", "name");
        try {
            Constructor<?> ctor = iclass.getConstructor(class$java$util$Properties == null ? (class$java$util$Properties = Loader.class$("java.util.Properties")) : class$java$util$Properties);
            return ctor.newInstance(args);
        }
        catch (NoSuchMethodException nsme) {
            Constructor<?> ctor = iclass.getConstructor(null);
            return ctor.newInstance(null);
        }
    }

    public Properties getInterfaceConfig(String name) {
        try {
            XmlElement jface = this.getInterfaceElement(name);
            XmlElement info = jface.getElement("info");
            return info.getProperties("property", "name");
        }
        catch (Exception e) {
            return null;
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

