/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.fm.storade.agent;

import com.sun.netstorage.fm.storade.agent.AgentRegistry;
import com.sun.netstorage.fm.storade.resource.diags.Diagnosable;
import com.sun.netstorage.fm.storade.resource.discovery.Probe;
import com.sun.netstorage.fm.storade.resource.report.ReportGenerator;
import java.lang.reflect.Constructor;
import java.util.LinkedList;

public class AgentFactory {
    public Probe getProbe(String devType) {
        try {
            return (Probe)this.load(AgentRegistry.getDeviceProperty(devType, "Probe.class"));
        }
        catch (Exception e) {
            throw new IllegalArgumentException();
        }
    }

    public Probe[] getProbes(String searchType) {
        if (searchType == null) {
            throw new IllegalArgumentException();
        }
        String[] type = AgentRegistry.getRegisteredTypes();
        LinkedList<Probe> list = new LinkedList<Probe>();
        if (type != null) {
            for (int i = 0; i < type.length; ++i) {
                Probe probe = this.getProbe(type[i]);
                if (probe == null) continue;
                list.add(probe);
            }
        }
        Probe[] probes = new Probe[list.size()];
        list.toArray(probes);
        return probes;
    }

    public ReportGenerator getReportGenerator(String devType) {
        try {
            return (ReportGenerator)this.load(AgentRegistry.getDeviceProperty(devType, "Report.class"));
        }
        catch (Exception e) {
            throw new IllegalArgumentException();
        }
    }

    public Diagnosable getDiagnosable(String devType) {
        return (Diagnosable)this.load(AgentRegistry.getDeviceProperty(devType, "Diag.class"));
    }

    public Object getManagedResourceInterface(String devType, String interfaceName) {
        return this.load(AgentRegistry.getDeviceProperty(devType, interfaceName + ".class"));
    }

    private Object load(String className) {
        try {
            Class<?> c = Class.forName(className);
            Constructor<?> creator = c.getConstructor(new Class[0]);
            return creator.newInstance(new Object[0]);
        }
        catch (Exception e) {
            return null;
        }
    }

    public void System_exit(int rc) {
        System.exit(rc);
    }

    public Runtime getRuntime() {
        return Runtime.getRuntime();
    }

    public static void main(String[] args) {
        try {
            if (args.length != 2) {
                System.out.println("Usage: <type> <interface>");
                System.exit(1);
            }
            AgentFactory af = new AgentFactory();
            System.out.println(af.getManagedResourceInterface(args[0], args[1]));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

