/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.fm.storade.agent;

import com.sun.netstorage.fm.storade.util.LockManager;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.TreeMap;
import java.util.Vector;

public class AgentConfig {
    private File cfgFile;
    private Properties prop = new Properties();
    private List hostCfg = new Vector();
    private List devCfg = new Vector();
    private List notifCfg = new Vector();
    public static final String _SOURCE_REVISION = "$Revision: 1.1 $";

    public AgentConfig() throws IOException {
        this("/opt/SUNWstade/DATA/rasagent.conf");
    }

    public AgentConfig(String path) throws IOException {
        this(new File(path));
    }

    public AgentConfig(File cfgFile) throws IOException {
        this.cfgFile = cfgFile;
    }

    public synchronized void readConfig() throws IOException {
        this.readConfig(new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(this.cfgFile), "UTF8")));
    }

    public synchronized String getProperty(String key) {
        return this.prop.getProperty(key);
    }

    public synchronized void setProperty(String name, String value) {
        this.prop.setProperty(name, value);
    }

    public Properties[] getDevices() {
        if (this.devCfg == null || this.devCfg.size() == 0) {
            return new Properties[0];
        }
        Properties[] devs = new Properties[this.devCfg.size()];
        this.devCfg.toArray(devs);
        return devs;
    }

    public Properties[] getHosts() {
        if (this.hostCfg == null || this.hostCfg.size() == 0) {
            return new Properties[0];
        }
        Properties[] hosts = new Properties[this.hostCfg.size()];
        this.hostCfg.toArray(hosts);
        return hosts;
    }

    public Properties[] getNotifications() {
        if (this.notifCfg == null || this.notifCfg.size() == 0) {
            return new Properties[0];
        }
        Properties[] notifs = new Properties[this.notifCfg.size()];
        this.notifCfg.toArray(notifs);
        return notifs;
    }

    public Properties findDevice(String name, String value) {
        for (int i = 0; i < this.devCfg.size(); ++i) {
            Properties tp = (Properties)this.devCfg.get(i);
            if (tp == null || !value.equals(tp.getProperty(name))) continue;
            return tp;
        }
        return null;
    }

    public synchronized String toString() {
        StringWriter sw = new StringWriter();
        PrintWriter out = new PrintWriter(sw);
        this.store(out);
        return sw.toString();
    }

    public void addNewDevices(Properties[] devs) throws IOException {
        LockManager lockMgr = new LockManager("rasagent.conf");
        if (lockMgr.lock(5, 10)) {
            int i;
            for (i = 0; i < devs.length; ++i) {
                Properties tp = this.findDevice("key", devs[i].getProperty("key"));
                if (tp == null) continue;
                throw new IOException("Device exists.");
            }
            for (i = 0; i < devs.length; ++i) {
                this.devCfg.add(devs[i]);
            }
        } else {
            throw new IOException("Unable to lock rasagent.conf");
        }
        this.store();
        lockMgr.unlock();
    }

    public void updateDevice(Properties device) throws IOException {
        String key = device.getProperty("key");
        LockManager lockMgr = new LockManager("rasagent.conf");
        if (lockMgr.lock(5, 10)) {
            for (int i = 0; i < this.devCfg.size(); ++i) {
                Properties tp = (Properties)this.devCfg.get(i);
                if (tp == null || !key.equals(tp.getProperty("key"))) continue;
                this.devCfg.set(i, tp);
                break;
            }
        } else {
            throw new IOException("Unable to lock rasagent.conf");
        }
        this.store();
        lockMgr.unlock();
    }

    private synchronized void readConfig(BufferedReader in) throws IOException {
        Properties place = this.prop;
        List adder = null;
        while (true) {
            int i;
            char first;
            String line;
            if ((line = in.readLine()) == null) {
                if (adder == null) break;
                adder.add(place);
                break;
            }
            if (line.length() == 0 || (first = line.charAt(0)) == '\n') continue;
            if (first == '[') {
                if (place != null && adder != null) {
                    adder.add(place);
                }
                place = new Properties();
                if (line.startsWith("[host")) {
                    adder = this.hostCfg;
                    continue;
                }
                if (line.startsWith("[device")) {
                    adder = this.devCfg;
                    continue;
                }
                if (line.startsWith("[notification")) {
                    adder = this.notifCfg;
                    continue;
                }
                adder = null;
                place = null;
                continue;
            }
            if (place == null || (i = line.indexOf("=")) <= 0) continue;
            String name = line.substring(0, i);
            String value = line.substring(i + 1);
            if (name == null) continue;
            if (value == null) {
                value = "";
            }
            place.setProperty(name, value);
        }
    }

    private synchronized void store() throws IOException {
        File tmpFile = new File(this.cfgFile + "~");
        this.store(tmpFile);
        if (!tmpFile.renameTo(this.cfgFile)) {
            throw new IOException("Rename failed.");
        }
    }

    private synchronized void store(File f) throws IOException {
        if (!f.exists()) {
            f.createNewFile();
        }
        FileOutputStream fos = new FileOutputStream(f);
        OutputStreamWriter out = new OutputStreamWriter((OutputStream)fos, "UTF8");
        this.store(new PrintWriter(out));
        ((Writer)out).flush();
        ((Writer)out).close();
    }

    private synchronized void store(PrintWriter out) {
        int i;
        this.list(this.prop, out);
        for (i = 0; i < this.hostCfg.size(); ++i) {
            out.println();
            out.println("[host" + (i + 1) + "]");
            this.list((Properties)this.hostCfg.get(i), out);
        }
        for (i = 0; i < this.devCfg.size(); ++i) {
            out.println();
            out.println("[device" + (i + 1) + "]");
            this.list((Properties)this.devCfg.get(i), out);
        }
        for (i = 0; i < this.notifCfg.size(); ++i) {
            out.println();
            out.println("[notification" + (i + 1) + "]");
            this.list((Properties)this.notifCfg.get(i), out);
        }
    }

    private synchronized void list(Properties p, PrintWriter out) {
        TreeMap<Object, Object> t = new TreeMap<Object, Object>(p);
        Set<Map.Entry<Object, Object>> s = t.entrySet();
        Iterator<Map.Entry<Object, Object>> iter = s.iterator();
        while (iter.hasNext()) {
            Map.Entry<Object, Object> entry = iter.next();
            Object key = entry.getKey();
            Object value = entry.getValue();
            out.println(key + "=" + value);
        }
    }

    public static void main(String[] args) {
        try {
            if (args.length == 0) {
                AgentConfig r = new AgentConfig();
                r.readConfig();
                System.out.println(r.toString());
            } else if (args.length == 1) {
                AgentConfig r = new AgentConfig(new File(args[0]));
                r.readConfig();
                System.out.println(r.toString());
            } else if (args.length == 2) {
                AgentConfig r = new AgentConfig(new File(args[0]));
                r.readConfig();
                int i = args[1].indexOf("=");
                String name = args[1].substring(0, i);
                String value = args[1].substring(i + 1);
                Properties devProps = r.findDevice(name, value);
                PrintWriter pw = new PrintWriter(System.out);
                r.list(devProps, pw);
                pw.flush();
            } else {
                System.err.println("Usage DeviceConfig <file> [device]");
                System.exit(-1);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        System.exit(0);
    }
}

