/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.mgmt.fm.storade.ui.viewbeans.topology;

import com.iplanet.jato.RequestContext;
import com.sun.netstorage.mgmt.fm.storade.schema.Device;
import com.sun.netstorage.mgmt.fm.storade.schema.Event;
import com.sun.netstorage.mgmt.fm.storade.schema.Value;
import com.sun.netstorage.mgmt.fm.storade.schema.topology.AssetSummary;
import com.sun.netstorage.mgmt.fm.storade.schema.topology.Host;
import com.sun.netstorage.mgmt.fm.storade.schema.topology.Hub;
import com.sun.netstorage.mgmt.fm.storade.schema.topology.Info;
import com.sun.netstorage.mgmt.fm.storade.schema.topology.Port;
import com.sun.netstorage.mgmt.fm.storade.schema.topology.PortInfo;
import com.sun.netstorage.mgmt.fm.storade.schema.topology.Storage;
import com.sun.netstorage.mgmt.fm.storade.schema.topology.Switch;
import com.sun.netstorage.mgmt.fm.storade.schema.topology.Topology;
import com.sun.netstorage.mgmt.fm.storade.schema.topology.TopologyResultDocument;
import com.sun.netstorage.mgmt.fm.storade.ui.util.Debug;
import com.sun.netstorage.mgmt.fm.storade.ui.util.DeviceUtil;
import com.sun.netstorage.mgmt.fm.storade.ui.util.LocalizeUtil;
import com.sun.netstorage.mgmt.fm.storade.ui.viewbeans.topology.AbstractNode;
import com.sun.netstorage.mgmt.fm.storade.ui.viewbeans.topology.HostNode;
import com.sun.netstorage.mgmt.fm.storade.ui.viewbeans.topology.Link;
import com.sun.netstorage.mgmt.fm.storade.ui.viewbeans.topology.StorageNode;
import com.sun.netstorage.mgmt.fm.storade.ui.viewbeans.topology.SwitchNode;
import com.sun.web.ui.model.CCTopologyEdge;
import com.sun.web.ui.model.CCTopologyModel;
import com.sun.web.ui.model.CCTopologyModelInterface;
import com.sun.web.ui.model.CCTopologyNode;
import java.util.ArrayList;
import java.util.Locale;
import java.util.Properties;

public class TopologyModel
extends CCTopologyModel {
    private static final String HOST_CATEGORY = "hosts";
    private static final String SWITCH_CATEGORY = "switches";
    private static final String STORAGE_CATEGORY = "storage";
    private TopologyResultDocument.TopologyResult result = null;

    public TopologyModel(RequestContext requestContext, TopologyResultDocument.TopologyResult result) {
        super(requestContext.getServletContext());
        this.init(requestContext, result);
    }

    private void init(RequestContext rc, TopologyResultDocument.TopologyResult result) {
        if (result == null) {
            return;
        }
        this.result = result;
        Topology topology = result.getTopology();
        Event[] events = result.getALARMS().getEventArray();
        Locale locale = rc.getRequest().getLocale();
        ArrayList<CCTopologyNode> nodes = new ArrayList<CCTopologyNode>();
        ArrayList links = new ArrayList();
        ArrayList<CCTopologyNode> hostsList = new ArrayList<CCTopologyNode>();
        String labelChoice = (String)rc.getServletContext().getAttribute("storade.topologyLabel");
        String tooltipChoice = (String)rc.getServletContext().getAttribute("storade.topologyTooltip");
        Host[] topoHosts = topology.getHostArray();
        for (int i = 0; i < topoHosts.length; ++i) {
            HostNode topoNode = new HostNode(topoHosts[i].getID());
            Info info = topoHosts[i].getInfo();
            Info.VALUE[] values = info.getVALUEArray();
            for (int j = 0; j < values.length; ++j) {
                topoNode.addAttribute(values[j].getID(), values[j].getStringValue());
            }
            CCTopologyNode node = this.createNode(topoNode, HOST_CATEGORY, events, labelChoice, tooltipChoice, locale);
            nodes.add(node);
            hostsList.add(node);
            Port port = topoHosts[i].getPort();
            if (port == null) continue;
            Port.VALUE[] portValues = port.getVALUEArray();
            for (int j = 0; j < portValues.length; ++j) {
                String nodeValue = portValues[j].getStringValue();
                Link link = this.buildLink(topoHosts[i].getID(), portValues[j].getID(), nodeValue);
                this.addLink(link, links);
            }
        }
        ArrayList<CCTopologyNode> switchesList = new ArrayList<CCTopologyNode>();
        Switch[] topoSwitches = topology.getSwitchArray();
        for (int i = 0; i < topoSwitches.length; ++i) {
            SwitchNode topoNode = new SwitchNode(topoSwitches[i].getID());
            Info info = topoSwitches[i].getInfo();
            Info.VALUE[] values = info.getVALUEArray();
            for (int j = 0; j < values.length; ++j) {
                topoNode.addAttribute(values[j].getID(), values[j].getStringValue());
            }
            CCTopologyNode node = this.createNode(topoNode, SWITCH_CATEGORY, events, labelChoice, tooltipChoice, locale);
            nodes.add(node);
            switchesList.add(node);
            Port port = topoSwitches[i].getPort();
            if (port == null) continue;
            Port.VALUE[] portValues = port.getVALUEArray();
            for (int j = 0; j < portValues.length; ++j) {
                String nodeValue = portValues[j].getStringValue();
                Link link = this.buildLink(topoSwitches[i].getID(), portValues[j].getID(), nodeValue);
                this.addLink(link, links);
            }
        }
        Hub[] topoHubs = topology.getHUBArray();
        for (int i = 0; i < topoHubs.length; ++i) {
            SwitchNode topoNode = new SwitchNode(topoHubs[i].getID());
            Info info = topoHubs[i].getInfo();
            Info.VALUE[] values = info.getVALUEArray();
            for (int j = 0; j < values.length; ++j) {
                topoNode.addAttribute(values[j].getID(), values[j].getStringValue());
            }
            CCTopologyNode node = this.createNode(topoNode, SWITCH_CATEGORY, events, labelChoice, tooltipChoice, locale);
            nodes.add(node);
            switchesList.add(node);
            Port port = topoHubs[i].getPort();
            if (port == null) continue;
            Port.VALUE[] portValues = port.getVALUEArray();
            for (int j = 0; j < portValues.length; ++j) {
                String nodeValue = portValues[j].getStringValue();
                Link link = this.buildLink(topoHubs[i].getID(), portValues[j].getID(), nodeValue);
                this.addLink(link, links);
            }
        }
        Storage[] topoStorage = topology.getStorageArray();
        for (int i = 0; i < topoStorage.length; ++i) {
            if (!this.isDirectAttached(topoStorage[i])) continue;
            StorageNode topoNode = new StorageNode(topoStorage[i].getID());
            Info info = topoStorage[i].getInfo();
            Info.VALUE[] values = info.getVALUEArray();
            for (int j = 0; j < values.length; ++j) {
                topoNode.addAttribute(values[j].getID(), values[j].getStringValue());
            }
            CCTopologyNode node = this.createNode(topoNode, STORAGE_CATEGORY, events, labelChoice, tooltipChoice, locale);
            nodes.add(node);
            switchesList.add(node);
            Port port = topoStorage[i].getPort();
            if (port == null) continue;
            Port.VALUE[] portValues = port.getVALUEArray();
            for (int j = 0; j < portValues.length; ++j) {
                String nodeValue = portValues[j].getStringValue();
                Link link = this.buildLink(topoStorage[i].getID(), portValues[j].getID(), nodeValue);
                if (link == null) continue;
                this.addLink(link, links);
            }
        }
        ArrayList<CCTopologyNode> storageList = new ArrayList<CCTopologyNode>();
        for (int i = 0; i < topoStorage.length; ++i) {
            if (this.isDirectAttached(topoStorage[i])) continue;
            StorageNode topoNode = new StorageNode(topoStorage[i].getID());
            Info info = topoStorage[i].getInfo();
            Info.VALUE[] values = info.getVALUEArray();
            for (int j = 0; j < values.length; ++j) {
                topoNode.addAttribute(values[j].getID(), values[j].getStringValue());
            }
            CCTopologyNode node = this.createNode(topoNode, STORAGE_CATEGORY, events, labelChoice, tooltipChoice, locale);
            nodes.add(node);
            storageList.add(node);
            Port port = topoStorage[i].getPort();
            if (port == null) continue;
            Port.VALUE[] portValues = port.getVALUEArray();
            for (int j = 0; j < portValues.length; ++j) {
                String nodeValue = portValues[j].getStringValue();
                Link link = this.buildLink(topoStorage[i].getID(), portValues[j].getID(), nodeValue);
                if (link == null) continue;
                this.addLink(link, links);
            }
        }
        CCTopologyNode[] hosts = new CCTopologyNode[hostsList.size()];
        CCTopologyNode[] switches = new CCTopologyNode[switchesList.size()];
        CCTopologyNode[] devices = new CCTopologyNode[storageList.size()];
        hostsList.toArray(hosts);
        switchesList.toArray(switches);
        storageList.toArray(devices);
        this.setTierNodes((CCTopologyModelInterface.Node[][])new CCTopologyNode[][]{hosts, switches, devices});
        ArrayList<CCTopologyEdge> edgeList = new ArrayList<CCTopologyEdge>();
        for (int i = 0; i < links.size(); ++i) {
            Link link = (Link)links.get(i);
            CCTopologyNode node1 = null;
            CCTopologyNode node2 = null;
            String id = link.toString();
            String display = link.toStringForName();
            for (int j = 0; j < nodes.size(); ++j) {
                CCTopologyNode node = (CCTopologyNode)nodes.get(j);
                if (node.getId().equals(link.getNode1())) {
                    node1 = node;
                }
                if (!node.getId().equals(link.getNode2())) continue;
                node2 = node;
            }
            if (node1 == null || node2 == null) continue;
            edgeList.add(this.createEdge(node1, node2, id, display));
        }
        this.setEdges((CCTopologyModelInterface.Edge[])edgeList.toArray(new CCTopologyEdge[edgeList.size()]));
    }

    private boolean isDirectAttached(Storage topoStorage) {
        boolean isDirectAttach = false;
        Port port = topoStorage.getPort();
        if (port != null) {
            Port.VALUE[] portValues = port.getVALUEArray();
            for (int j = 0; j < portValues.length; ++j) {
                String id = portValues[j].getID();
                String nodeValue = portValues[j].getStringValue();
                if (!DeviceUtil.isHost(nodeValue)) continue;
                isDirectAttach = true;
                break;
            }
        }
        return isDirectAttach;
    }

    private void addLink(Link link, ArrayList links) {
        boolean exist = false;
        for (int i = 0; i < links.size(); ++i) {
            Link current = (Link)links.get(i);
            if (!current.equals(link)) continue;
            exist = true;
            break;
        }
        if (!exist) {
            links.add(link);
        }
    }

    private CCTopologyNode createNode(AbstractNode node, String type, Event[] events, String labelChoice, String tooltipChoice, Locale locale) {
        String id = node.getID();
        String label = "";
        label = "ipAddress".equals(labelChoice) ? node.getIPAddress() : ("vendorModel".equals(labelChoice) ? this.createVendorModel(node.getVendor(), node.getModel()) : node.getName());
        if (label == null || "".equals(label)) {
            String vendorModel;
            label = node.getName() != null && !"".equals(node.getName()) ? node.getName() : (node.getIPAddress() != null && !"".equals(node.getIPAddress()) ? node.getIPAddress() : ((vendorModel = this.createVendorModel(node.getVendor(), node.getModel())) != null && !"".equals(vendorModel) ? vendorModel : "N/A"));
        }
        String tip = "";
        if (tooltipChoice != null) {
            String vendorModel;
            if (tooltipChoice.indexOf("deviceName") != -1 && !"deviceName".equals(labelChoice) && node.getName() != null && !"".equals(node.getName())) {
                tip = tip + node.getName() + " ";
            }
            if (tooltipChoice.indexOf("ipAddress") != -1 && !"ipAddress".equals(labelChoice) && node.getIPAddress() != null && !"".equals(node.getIPAddress())) {
                tip = tip + node.getIPAddress() + " ";
            }
            if (tooltipChoice.indexOf("vendorModel") != -1 && !"vendorModel".equals(labelChoice) && (vendorModel = this.createVendorModel(node.getVendor(), node.getModel())) != null && !"".equals(vendorModel)) {
                tip = tip + vendorModel + " ";
            }
        }
        int action = 0;
        boolean inFilter = true;
        int icon = 0;
        int badge = 0;
        String badgeTip = "";
        if (HOST_CATEGORY.equals(type)) {
            icon = 1;
            action = 1;
        } else if (SWITCH_CATEGORY.equals(type)) {
            icon = 2;
            action = 2;
        } else if (STORAGE_CATEGORY.equals(type)) {
            icon = 3;
            action = 3;
        }
        Event event = TopologyModel.getMaxSeverityAlarm(id, events);
        if (event != null) {
            badgeTip = TopologyModel.getLocalizedEventType(event.getEventType(), locale);
            badge = TopologyModel.alarmToCcSeverity(Integer.parseInt(event.getSeverity()));
        }
        boolean isLiving = false;
        isLiving = id.startsWith("host") ? this.isLivingHost(id) : (id.startsWith("hba") ? this.isLivingHBADevice(id) : this.isLivingDevice(id));
        action = isLiving ? Integer.MIN_VALUE : 0;
        return new CCTopologyNode(id, label, tip, action, inFilter, icon, badge, badgeTip, Integer.MIN_VALUE);
    }

    private CCTopologyEdge createEdge(CCTopologyNode node1, CCTopologyNode node2, String id, String display) {
        int badge = 0;
        String tooltip = display;
        String badgeTooltip = id;
        boolean inFilter = true;
        return new CCTopologyEdge(id, (CCTopologyModelInterface.Node)node1, (CCTopologyModelInterface.Node)node2, tooltip, 0, inFilter, badge, badgeTooltip, Integer.MIN_VALUE, false, false);
    }

    private static int alarmToCcSeverity(int alarmSeverity) {
        switch (alarmSeverity) {
            case 3: {
                return 1;
            }
            case 2: {
                return 2;
            }
            case 1: {
                return 3;
            }
            case -2147483648: {
                return 4;
            }
        }
        return 0;
    }

    private static Event getMaxSeverityAlarm(String id, Event[] events) {
        int index;
        String key = id;
        Event event = null;
        int severity = 0;
        if (id != null && (index = key.indexOf(58)) != -1) {
            key = key.substring(index + 1);
        }
        if (events != null) {
            for (int i = 0; i < events.length; ++i) {
                int s;
                if (!events[i].getKey().equals(key) || (s = Integer.parseInt(events[i].getSeverity())) <= severity) continue;
                severity = s;
                event = events[i];
            }
        }
        return event;
    }

    private boolean isLivingHost(String hostID) {
        Value[] values;
        if (this.result.getHosts() == null) {
            return true;
        }
        if (hostID == null) {
            return false;
        }
        int pos = hostID.indexOf(":");
        if (pos != -1) {
            hostID = hostID.substring(pos + 1);
        }
        if ((values = this.result.getHosts().getVALUEArray()) != null) {
            for (int j = 0; j < values.length; ++j) {
                String s = values[j].getID();
                if (s == null || !s.equals(hostID)) continue;
                return true;
            }
        }
        return false;
    }

    private boolean isLivingHBADevice(String deviceID) {
        if (this.result.getREPORTLIST() == null) {
            return true;
        }
        if (deviceID == null) {
            return false;
        }
        AssetSummary[] assets = this.result.getREPORTLIST().getREPORTArray();
        for (int i = 0; i < assets.length; ++i) {
            AssetSummary asset = assets[i];
            if (!deviceID.equals(asset.getKey())) continue;
            return true;
        }
        return false;
    }

    private boolean isLivingDevice(String deviceID) {
        if (this.result.getDEVICES() == null) {
            return true;
        }
        if (deviceID == null) {
            return false;
        }
        Device[] devices = this.result.getDEVICES().getDEVICEArray();
        for (int i = 0; i < devices.length; ++i) {
            String searchID;
            String dtype = null;
            String key = null;
            Value[] values = devices[i].getVALUEArray();
            if (values != null) {
                for (int j = 0; j < values.length; ++j) {
                    String s = values[j].getID();
                    if ("type".equals(s)) {
                        dtype = values[j].getStringValue();
                        continue;
                    }
                    if (!"key".equals(s)) continue;
                    key = values[j].getStringValue();
                }
            }
            if (!deviceID.equals(searchID = dtype + ":" + key)) continue;
            return true;
        }
        return false;
    }

    private static String getLocalizedEventType(String in, Locale locale) {
        if (in == null) {
            return null;
        }
        String toBeLocalized = in;
        int pos1 = toBeLocalized.indexOf(".");
        int pos2 = toBeLocalized.lastIndexOf(".");
        if (pos1 != -1 && pos2 != -1) {
            toBeLocalized = pos1 == pos2 ? toBeLocalized.substring(pos1 + 1) : toBeLocalized.substring(pos1 + 1, pos2);
        }
        return LocalizeUtil.getLocalizedString("com.sun.netstorage.mgmt.fm.storade.ui.resources.Events", toBeLocalized, locale);
    }

    private String createVendorModel(String vendor, String model) {
        if (vendor != null && model != null) {
            String comb = vendor + "/" + model;
            if (comb.startsWith("/")) {
                return comb.substring(1);
            }
            if (comb.endsWith("/")) {
                return comb.substring(0, comb.length() - 1);
            }
            return comb;
        }
        if (vendor != null) {
            return vendor;
        }
        if (model != null) {
            return model;
        }
        return null;
    }

    private String getPortName(String deviceID, String portID) {
        if (deviceID == null || portID == null) {
            return null;
        }
        Topology topology = this.result.getTopology();
        if (topology == null) {
            return portID;
        }
        String ret = null;
        Switch[] topoSwitches = topology.getSwitchArray();
        for (int i = 0; i < topoSwitches.length; ++i) {
            Switch device = topoSwitches[i];
            if (!deviceID.equals(device.getID())) continue;
            PortInfo portInfo = device.getPortInfo();
            PortInfo.ELEMENT[] elements = portInfo.getELEMENTArray();
            for (int j = 0; j < elements.length; ++j) {
                if (!portID.equals(elements[j].getID())) continue;
                ret = this.fetchPortName(elements[j].getVALUEArray());
            }
        }
        if (ret != null) {
            return ret;
        }
        Storage[] topoStorages = topology.getStorageArray();
        for (int i = 0; i < topoStorages.length; ++i) {
            Storage device = topoStorages[i];
            if (!deviceID.equals(device.getID())) continue;
            PortInfo portInfo = device.getPortInfo();
            if (portInfo == null) {
                Debug.println("PORTINFO IS NULL");
                continue;
            }
            PortInfo.ELEMENT[] elements = portInfo.getELEMENTArray();
            for (int j = 0; j < elements.length; ++j) {
                if (!portID.equals(elements[j].getID())) continue;
                ret = this.fetchPortName(elements[j].getVALUEArray());
            }
        }
        if (ret != null) {
            return ret;
        }
        Host[] topoHosts = topology.getHostArray();
        for (int i = 0; i < topoHosts.length; ++i) {
            Host device = topoHosts[i];
            if (!deviceID.equals(device.getID())) continue;
            PortInfo portInfo = device.getPortInfo();
            if (portInfo == null) {
                Debug.println("PORTINFO IS NULL");
                continue;
            }
            PortInfo.ELEMENT[] elements = portInfo.getELEMENTArray();
            for (int j = 0; j < elements.length; ++j) {
                if (!portID.equals(elements[j].getID())) continue;
                ret = this.fetchPortName(elements[j].getVALUEArray());
            }
        }
        if (ret != null) {
            return ret;
        }
        return portID;
    }

    private String fetchPortName(PortInfo.ELEMENT.VALUE[] values) {
        Properties p = new Properties();
        for (int i = 0; i < values.length; ++i) {
            p.setProperty(values[i].getID(), values[i].getStringValue());
        }
        if (p.getProperty("PortLabel") != null) {
            return p.getProperty("PortLabel");
        }
        if (p.getProperty("PortId") != null) {
            return p.getProperty("PortId");
        }
        if (p.getProperty("PortLabel") != null) {
            return p.getProperty("PortLabel");
        }
        if (p.getProperty("sw_PortNum") != null) {
            return p.getProperty("sw_PortNum");
        }
        if (p.getProperty("Id") != null) {
            return p.getProperty("Id");
        }
        if (p.getProperty("LocalPortWWN") != null) {
            return p.getProperty("LocalPortWWN");
        }
        return null;
    }

    private Link buildLink(String node1, String port1, String nodeValue) {
        Link link = null;
        int i = nodeValue.lastIndexOf(58);
        if (i != -1) {
            String node2 = nodeValue.substring(0, i);
            String port2 = nodeValue.substring(i + 1);
            String portName1 = this.getPortName(node1, port1);
            String portName2 = this.getPortName(node2, port2);
            link = new Link(node1, port1, portName1, node2, port2, portName2);
        }
        return link;
    }
}

