/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.mgmt.fm.storade.ui.viewbeans.topology;

import com.sun.netstorage.mgmt.fm.storade.schema.Value;
import com.sun.netstorage.mgmt.fm.storade.schema.topology.CompareSnapshotResultDocument;
import com.sun.netstorage.mgmt.fm.storade.schema.topology.SnapshotListResultDocument;
import com.sun.netstorage.mgmt.fm.storade.ui.model.ActionTableModel;
import com.sun.netstorage.mgmt.fm.storade.ui.util.Connection;
import com.sun.netstorage.mgmt.fm.storade.ui.util.DateUtil;
import com.sun.netstorage.mgmt.fm.storade.ui.util.NavUtil;
import com.sun.web.ui.model.CCActionTableModel;
import com.sun.web.ui.model.CCTopologyModelInterface;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Locale;

class TopologyDataHelper {
    static String[] APPLET_PARAM_HEADER = new String[]{"<param name=urlRefresh value=\"GO=GUI::Graph::get_topos&topo=boblu10.central.sun.com\">", "<param name=webproc  value=\"/rashttp\">", "<param name=timeRefresh value=\"10000\">", "<param name=zoomLabel value=\"Zoom\">", "<param name=isCustomer value=\"\">", "<param name=graphicsButton value=1>", "<param name=circle value=\"\">", "<param name=browser value=\"sun\">"};
    private static final String ZOOM_HEADER = "ZOOM=";
    private static final String ORIENT_HEADER = "ORIENT=";

    private TopologyDataHelper() {
    }

    private static String getComponent(String component) {
        String result = component;
        int index = component.lastIndexOf(58);
        if (index != -1) {
            result = component.substring(0, index);
        }
        return result;
    }

    private static String getPort(String component) {
        String result = component;
        int index = component.lastIndexOf(58);
        if (index != -1) {
            result = component.substring(index + 1);
        }
        return result;
    }

    private static boolean isSwitchInList(String switchID, String portID, ArrayList items) {
        boolean found = false;
        for (int k = 0; k < items.size(); ++k) {
            Item item = (Item)items.get(k);
            if (!portID.equals(item.switchPort) || !switchID.equals(item.switchID)) continue;
            found = true;
            break;
        }
        return found;
    }

    private static boolean isDeviceInList(String deviceID, String portID, ArrayList items) {
        boolean found = false;
        for (int k = 0; k < items.size(); ++k) {
            Item item = (Item)items.get(k);
            if (!portID.equals(item.toPort) || !deviceID.equals(item.toComponentID)) continue;
            found = true;
            break;
        }
        return found;
    }

    public static boolean populateDirectAttachedConnectionTable(ActionTableModel model, CCTopologyModelInterface gModel) {
        if (gModel == null || model == null) {
            return false;
        }
        boolean tableFilled = false;
        ArrayList<String> keys = new ArrayList<String>();
        CCTopologyModelInterface.Edge[] edges = gModel.getEdges();
        for (int i = 0; i < edges.length; ++i) {
            CCTopologyModelInterface.Edge edge = edges[i];
            CCTopologyModelInterface.Node node1 = edge.getSource();
            CCTopologyModelInterface.Node node2 = edge.getDestination();
            if (2 == node1.getIcon() || 2 == node2.getIcon()) continue;
            keys.add(edge.getId());
            tableFilled = true;
            if (i != 0) {
                model.appendRow();
            }
            model.setValue("directConnectionStr", "connection.connected");
            if (1 != node1.getIcon()) {
                CCTopologyModelInterface.Node tmp = node1;
                node1 = node2;
                node2 = tmp;
            }
            if (Integer.MIN_VALUE == node1.getAction()) {
                model.setValue("ParentInDirectAttachedStoradeHREF", NavUtil.compose(new String[]{node1.getId()}));
                model.setValue("hostStr", node1.getLabel());
                model.setValue("hostStr1", null);
                model.setValue("hostStr3", node1.getLabel());
            } else {
                model.setValue("ParentInDirectAttachedStoradeHREF", null);
                model.setValue("hostStr", null);
                model.setValue("hostStr1", node1.getLabel());
                model.setValue("hostStr3", node1.getLabel());
            }
            model.setValue("hostPortStr", TopologyDataHelper.getPort(edge.getTooltip(), node1.getId()));
            model.setValue("storagePortStr", TopologyDataHelper.getPort(edge.getTooltip(), node2.getId()));
            if (Integer.MIN_VALUE == node2.getAction()) {
                model.setValue("ParentInDirectAttached2StoradeHREF", NavUtil.compose(new String[]{node2.getId()}));
                model.setValue("storageStr", node2.getLabel());
                model.setValue("storageStr2", null);
                model.setValue("storageStr3", node2.getLabel());
                continue;
            }
            model.setValue("ParentInDirectAttached2StoradeHREF", null);
            model.setValue("storageStr", null);
            model.setValue("storageStr2", node2.getLabel());
            model.setValue("storageStr3", node2.getLabel());
        }
        String[] keysArr = new String[keys.size()];
        keys.toArray(keysArr);
        model.setKeys(keysArr);
        return tableFilled;
    }

    public static boolean populateConnectionTable(ActionTableModel model, CCTopologyModelInterface gModel) {
        if (gModel == null || model == null) {
            return false;
        }
        boolean tableFilled = false;
        ArrayList<String> keys = new ArrayList<String>();
        CCTopologyModelInterface.Edge[] edges = gModel.getEdges();
        for (int i = 0; i < edges.length; ++i) {
            CCTopologyModelInterface.Edge edge = edges[i];
            CCTopologyModelInterface.Node node1 = edge.getSource();
            CCTopologyModelInterface.Node node2 = edge.getDestination();
            if (2 != node1.getIcon() && 2 != node2.getIcon()) continue;
            tableFilled = true;
            if (2 != node1.getIcon()) {
                CCTopologyModelInterface.Node tmp = node1;
                node1 = node2;
                node2 = tmp;
            }
            keys.add(edge.getId());
            if (i != 0) {
                model.appendRow();
            }
            model.setValue("connectionStr", "connection.connected");
            if (Integer.MIN_VALUE == node1.getAction()) {
                model.setValue("ParentStoradeHREF", NavUtil.compose(new String[]{node1.getId()}));
                model.setValue("switchStr", node1.getLabel());
                model.setValue("switchStr1", null);
                model.setValue("switchStr3", node1.getLabel());
            } else {
                model.setValue("ParentStoradeHREF", null);
                model.setValue("switchStr", null);
                model.setValue("switchStr1", node1.getLabel());
                model.setValue("switchStr3", node1.getLabel());
            }
            model.setValue("switchPortStr", TopologyDataHelper.getPort(edge.getTooltip(), node1.getId()));
            model.setValue("devicePortStr", TopologyDataHelper.getPort(edge.getTooltip(), node2.getId()));
            if (Integer.MIN_VALUE == node2.getAction()) {
                model.setValue("Parent2StoradeHREF", NavUtil.compose(new String[]{node2.getId()}));
                model.setValue("deviceStr", node2.getLabel());
                model.setValue("deviceStr2", null);
                model.setValue("deviceStr3", node2.getLabel());
                continue;
            }
            model.setValue("Parent2StoradeHREF", null);
            model.setValue("deviceStr", null);
            model.setValue("deviceStr2", node2.getLabel());
            model.setValue("deviceStr3", node2.getLabel());
        }
        String[] keysArr = new String[keys.size()];
        keys.toArray(keysArr);
        model.setKeys(keysArr);
        return tableFilled;
    }

    public static void populateCompareSnapshotsTable(CCActionTableModel model, CompareSnapshotResultDocument.CompareSnapshotResult result, Locale locale) {
        if (result != null) {
            Value[] values = result.getCOMPARESNAPSHOT().getVALUEArray();
            for (int i = 0; i < values.length; ++i) {
                if (i != 0) {
                    model.appendRow();
                }
                model.setValue("deviceTypeStr", (Object)values[i].getID());
                model.setValue("changeStr", (Object)values[i].getStringValue());
            }
        }
    }

    public static void populateSnapshotTable(ActionTableModel model, SnapshotListResultDocument.SnapshotListResult result, Locale locale) {
        ArrayList<String> keys = new ArrayList<String>();
        if (result != null) {
            Value[] values = result.getSNAPSHOTLIST().getVALUEArray();
            for (int i = 0; i < values.length; ++i) {
                if (i != 0) {
                    model.appendRow();
                }
                model.setValue("timeStampStr", TopologyDataHelper.keyToDateObj(values[i].getStringValue()));
                keys.add(values[i].getID());
            }
            String[] keysArr = new String[keys.size()];
            keys.toArray(keysArr);
            model.setKeys(keysArr);
        }
    }

    static String buildAppletParameters(String parameters, String requestServer) {
        int index;
        StringBuffer buffer = new StringBuffer();
        for (int i = 0; i < APPLET_PARAM_HEADER.length; ++i) {
            buffer.append(APPLET_PARAM_HEADER[i] + "\n");
        }
        int j = 0;
        int i = 1;
        String s2 = parameters;
        String ip = Connection.getMyBestIP();
        String protocol = Connection.getMyProtocol();
        String port = Connection.getMyPort();
        String nodePrefix = requestServer + "/" + Connection.getAppName() + "/reports/AssetDetails?assetID=";
        buffer.append("<param name=nodeprefix value=\"" + nodePrefix + "\">\n");
        buffer.append("<param name=userPassword value=\"" + Connection.getIPCAuthentication() + "\"> \n");
        while ((index = s2.indexOf("\n")) != -1) {
            String s = s2.substring(0, index);
            if (j < 2) {
                String param;
                if (s.startsWith(ZOOM_HEADER)) {
                    param = s.substring(ZOOM_HEADER.length());
                    if ("-1".equals(param)) {
                        param = "1";
                    }
                    buffer.append("<param name=zoom value=\"" + param + "\">\n");
                } else if (s.startsWith(ORIENT_HEADER)) {
                    param = s.substring(ORIENT_HEADER.length());
                    buffer.append("<param name=orientation value=\"" + param + "\">\n");
                }
            } else {
                buffer.append("<param name=object" + i + " value=\"" + s + "\">\n");
                ++i;
            }
            s2 = s2.substring(index + 1);
            ++j;
        }
        return buffer.toString();
    }

    private static String getPort(String edgeID, String nodeID) {
        if (edgeID == null || nodeID == null) {
            return null;
        }
        int idPos = edgeID.indexOf(nodeID);
        if (idPos == -1) {
            return null;
        }
        int portPos = idPos + nodeID.length() + 1;
        int portEndPos = edgeID.indexOf("<", portPos);
        if (portEndPos == -1) {
            return edgeID.substring(portPos);
        }
        return edgeID.substring(portPos, portEndPos);
    }

    public static Date keyToDateObj(String key) {
        SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        Date timeObj = new Date();
        try {
            int pos = key.lastIndexOf(".");
            String dateStr = key.substring(pos + 1);
            dateStr = dateStr.replace('_', ' ');
            timeObj = formatter.parse(dateStr);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return timeObj;
    }

    public static String keyToDate(String key, Locale locale) {
        if (key == null) {
            return null;
        }
        try {
            int pos = key.lastIndexOf(".");
            String dateStr = key.substring(pos + 1);
            dateStr = dateStr.replace('_', ' ');
            String localizedTime = DateUtil.toString1(DateUtil.toDate1(dateStr), locale);
            return localizedTime;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return key;
        }
    }

    public static boolean isKeyInSequence(String key1, String key2) {
        Date date2;
        if (key1 == null || key2 == null) {
            return true;
        }
        Date date1 = TopologyDataHelper.keyToDateObj(key1);
        return date1.before(date2 = TopologyDataHelper.keyToDateObj(key2));
    }

    static class Item {
        String switchID;
        String switchPort;
        boolean connected;
        String toPort;
        String toComponent;
        String toComponentID;

        Item() {
        }
    }
}

