/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.mgmt.fm.storade.ui.viewbeans.topology;

import com.sun.netstorage.mgmt.fm.storade.schema.jobs.RunLinkTestResultDocument;
import com.sun.netstorage.mgmt.fm.storade.schema.topology.DeleteSnapshotResultDocument;
import com.sun.netstorage.mgmt.fm.storade.schema.topology.TakeSnapshotResultDocument;
import com.sun.netstorage.mgmt.fm.storade.ui.util.Connection;
import com.sun.netstorage.mgmt.fm.storade.ui.util.Debug;
import com.sun.netstorage.mgmt.fm.storade.ui.util.XmlUtil;
import java.net.URLEncoder;

public class Setter {
    private Setter() {
    }

    public static boolean startSANDiscovery(String agent) {
        try {
            String s = Connection.getComboHeader();
            s = s + "?GO=Client::SAN::startSnapshot";
            if (agent != null) {
                s = s + "&agent=" + URLEncoder.encode(agent, "UTF-8");
            }
            String data = Connection.getData(s);
            Debug.println("REQUEST: " + s);
            Debug.println("DATA: " + data);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return true;
    }

    public static TakeSnapshotResultDocument.TakeSnapshotResult takeSnapshot() {
        TakeSnapshotResultDocument.TakeSnapshotResult result = null;
        try {
            String s = Connection.getComboHeader();
            s = s + "?GO=Client::TO::takeSnapshot";
            String data = Connection.getData(s);
            data = XmlUtil.addHeader(data, "TakeSnapshotResult");
            Debug.println("REQUEST: " + s);
            Debug.println("DATA: " + data);
            TakeSnapshotResultDocument resultDoc = TakeSnapshotResultDocument.Factory.parse((String)data);
            result = resultDoc.getTakeSnapshotResult();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return result;
    }

    public static DeleteSnapshotResultDocument.DeleteSnapshotResult deleteSnapshot(String key) {
        DeleteSnapshotResultDocument.DeleteSnapshotResult result = null;
        try {
            String s = Connection.getComboHeader();
            s = s + "?GO=Client::TO::deleteSnapshot&snapshot=" + URLEncoder.encode(key, "UTF-8");
            String data = Connection.getData(s);
            data = XmlUtil.addHeader(data, "DeleteSnapshotResult");
            Debug.println("REQUEST: " + s);
            Debug.println("DATA: " + data);
            DeleteSnapshotResultDocument resultDoc = DeleteSnapshotResultDocument.Factory.parse((String)data);
            result = resultDoc.getDeleteSnapshotResult();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return result;
    }

    public static RunLinkTestResultDocument.RunLinkTestResult runLinkTest(String setterCommand) {
        RunLinkTestResultDocument.RunLinkTestResult result = null;
        try {
            String s = Connection.getComboHeader();
            s = s + "?GO=Client::Diag::runLinkTest&" + setterCommand;
            String data = Connection.getData(s);
            data = XmlUtil.addHeader(data, "runLinkTestResult");
            Debug.println("REQUEST: " + s);
            Debug.println("DATA: " + data);
            RunLinkTestResultDocument resultDoc = RunLinkTestResultDocument.Factory.parse((String)data);
            result = resultDoc.getRunLinkTestResult();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return result;
    }

    public static boolean setAutoLayout(String width, String height) {
        boolean isOK = true;
        try {
            String s = Connection.getComboHeader();
            s = s + "?GO=GUI::Layout::run";
            s = s + "&Layout=1";
            s = s + "&width=" + width;
            s = s + "&height=" + height;
            String data = Connection.getData(s);
            Debug.println("REQUEST: " + s);
            Debug.println("DATA: " + data);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            isOK = false;
        }
        return isOK;
    }

    public static String getPrintableApplet(String webserverDir, String user, String zoom, String topo) {
        String filename = null;
        try {
            String s = Connection.getComboHeader();
            if (topo == null) {
                topo = "MERGE-MASTER";
            }
            s = s + "?GO=Client::TO::getPrintableApplet";
            s = s + "&webserverDir=" + URLEncoder.encode(webserverDir, "UTF-8");
            s = s + "&user=" + URLEncoder.encode(user, "UTF-8");
            s = s + "&zoom=" + zoom;
            s = s + "&FILTER=*";
            s = s + "&topo=" + URLEncoder.encode(topo, "UTF-8");
            if (!"MERGE-MASTER".equals(topo)) {
                s = s + "&HIST=true";
            }
            String data = Connection.getData(s);
            Debug.println("REQUEST: " + s);
            Debug.println("DATA: " + data);
            filename = data;
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return filename;
    }
}

