/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.mgmt.fm.storade.ui.viewbeans.revision;

import com.iplanet.jato.RequestManager;
import com.iplanet.jato.model.ModelControlException;
import com.iplanet.jato.view.ContainerView;
import com.iplanet.jato.view.ContainerViewBase;
import com.iplanet.jato.view.View;
import com.iplanet.jato.view.event.ChildContentDisplayEvent;
import com.iplanet.jato.view.event.ChildDisplayEvent;
import com.iplanet.jato.view.event.DisplayEvent;
import com.iplanet.jato.view.event.RequestInvocationEvent;
import com.sun.netstorage.mgmt.fm.storade.schema.asset.RESERVESTATUSDocument;
import com.sun.netstorage.mgmt.fm.storade.schema.revision.PatchUpgradeReportResultDocument;
import com.sun.netstorage.mgmt.fm.storade.ui.common.UIMastHeadViewBeanBase;
import com.sun.netstorage.mgmt.fm.storade.ui.model.ActionTableModel;
import com.sun.netstorage.mgmt.fm.storade.ui.util.Connection;
import com.sun.netstorage.mgmt.fm.storade.ui.util.DateUtil;
import com.sun.netstorage.mgmt.fm.storade.ui.util.DelimUtil;
import com.sun.netstorage.mgmt.fm.storade.ui.util.UserUtil;
import com.sun.netstorage.mgmt.fm.storade.ui.view.ActionTable;
import com.sun.netstorage.mgmt.fm.storade.ui.view.ActionTableInterface;
import com.sun.netstorage.mgmt.fm.storade.ui.viewbeans.revision.Getter;
import com.sun.netstorage.mgmt.fm.storade.ui.viewbeans.revision.RADataHelper;
import com.sun.netstorage.mgmt.fm.storade.ui.viewbeans.revision.Setter;
import com.sun.web.ui.common.CCI18N;
import com.sun.web.ui.view.html.CCButton;
import com.sun.web.ui.view.html.CCStaticTextField;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;

public class RAUpgradeViewBean
extends UIMastHeadViewBeanBase {
    public static final String PAGE_NAME = "RAUpgrade";
    public static final String DEFAULT_DISPLAY_URL = "/jsp/revision/RAUpgrade.jsp";
    public static final String CHILD_STATICTEXT = "StaticText";
    public static final String CHILD_REPORT_TEXT = "ReportText";
    public static final String CHILD_NO_REPORT_TEXT = "NoReportText";
    public static final String CHILD_GENERATE_BUTTON = "generateRevAnalysisUpgradeReportButton";
    public static final String CHILD_CLEAR_BUTTON = "clearRevAnalysisUpgradeReportButton";
    public static final String CHILD_RA_TABLE = "RevisionAnalysisUpgradeReportTable";
    public static final String CHILD_ALARM_HREF = "alarmHREF";
    private ActionTableModel raTableModel = new ActionTableModel(RequestManager.getRequestContext().getServletContext(), "/xml/table/RevisionAnalysisUpgradeTable.xml");
    private PatchUpgradeReportResultDocument.PatchUpgradeReportResult result;
    private Locale locale;
    private Boolean reservationStatus;
    private static final String ALERT_MSG = "alertMsg";
    private static String tableTitle;

    public RAUpgradeViewBean() {
        super(PAGE_NAME, DEFAULT_DISPLAY_URL);
        this.initModel();
    }

    protected void subRegisterChildren() {
        this.registerChild(CHILD_STATICTEXT, CCStaticTextField.class);
        this.registerChild(CHILD_REPORT_TEXT, CCStaticTextField.class);
        this.registerChild(CHILD_NO_REPORT_TEXT, CCStaticTextField.class);
        this.registerChild(CHILD_GENERATE_BUTTON, CCButton.class);
        this.registerChild(CHILD_CLEAR_BUTTON, CCButton.class);
        this.registerChild(CHILD_RA_TABLE, ActionTable.class);
        this.raTableModel.registerChildren((ContainerViewBase)this);
    }

    protected View subCreateChild(String name) {
        if (name.equals(CHILD_STATICTEXT)) {
            CCStaticTextField child = new CCStaticTextField((ContainerView)this, name, null);
            return child;
        }
        if (name.equals(CHILD_REPORT_TEXT)) {
            String date = RADataHelper.getUpgradeReportDate(this.getResult());
            if (date != null) {
                try {
                    date = DateUtil.toString1(DateUtil.toDate1(date), this.locale);
                }
                catch (Exception ex) {
                    // empty catch block
                }
            }
            Object[] params = new String[]{date};
            CCI18N cci18n = new CCI18N(this.getRequestContext(), "com.sun.netstorage.mgmt.fm.storade.ui.resources.ApplicationResources");
            String value = cci18n.getMessage("assets.revision.upgrade.report", params);
            CCStaticTextField child = new CCStaticTextField((ContainerView)this, name, (Object)value);
            return child;
        }
        if (name.equals(CHILD_NO_REPORT_TEXT)) {
            CCStaticTextField child = new CCStaticTextField((ContainerView)this, name, null);
            child = this.updateIfError(child, name);
            return child;
        }
        if (name.equals(CHILD_GENERATE_BUTTON)) {
            CCButton child = new CCButton((ContainerView)this, name, null);
            this.disableButtonIfNotPrivilege((View)child);
            if (this.isReserved() || this.isRefreshing()) {
                child.setDisabled(true);
            }
            return child;
        }
        if (name.equals(CHILD_CLEAR_BUTTON)) {
            CCButton child = new CCButton((ContainerView)this, name, null);
            this.disableButtonIfNotPrivilege((View)child);
            if (this.isReserved() || this.isRefreshing()) {
                child.setDisabled(true);
            }
            return child;
        }
        if (name.equals(CHILD_RA_TABLE)) {
            ActionTable child = new ActionTable((ContainerView)this, this.raTableModel, name);
            return child;
        }
        if (this.raTableModel.isChildSupported(name)) {
            View view = this.raTableModel.createChild((View)this, name);
            this.disableButtonIfNotPrivilege(view);
            return view;
        }
        return null;
    }

    private void initModel() {
        this.raTableModel.setSelectionType("multiple");
        this.raTableModel.setActionValue("applyButton", "button.apply");
        this.raTableModel.setActionValue("viewAffectedVolumes", "assets.revision.upgrade.viewVol");
        this.raTableModel.setActionValue("deviceNameCol", "table.header.name");
        this.raTableModel.setActionValue("ipCol", "table.header.ip");
        this.raTableModel.setActionValue("patchIDCol", "assets.revision.upgrade.table.patchID");
        this.raTableModel.setActionValue("patchSynopsisCol", "assets.revision.upgrade.table.patchSynopsis");
        this.raTableModel.setActionValue("alarmCol", "assets.table.alarms");
        this.raTableModel.setActionValue("fruCol", "assets.revision.upgrade.table.fru");
    }

    private CCStaticTextField updateIfError(CCStaticTextField child, String name) {
        HttpServletRequest request = RequestManager.getRequestContext().getRequest();
        if (request.getParameter("refresh") == null) {
            String err = RADataHelper.getError(this.getResult());
            String date = RADataHelper.getDate(this.getResult());
            if (date != null) {
                try {
                    date = DateUtil.toString1(DateUtil.toDate1(date), this.locale);
                }
                catch (Exception ex) {
                    // empty catch block
                }
            }
            if (err != null) {
                Object[] params = new String[]{date};
                CCI18N cci18n = new CCI18N(this.getRequestContext(), "com.sun.netstorage.mgmt.fm.storade.ui.resources.ApplicationResources");
                String value = cci18n.getMessage("assets.revision.upgrade.noreport.error", params);
                child = new CCStaticTextField((ContainerView)this, name, (Object)value);
            }
        }
        return child;
    }

    private PatchUpgradeReportResultDocument.PatchUpgradeReportResult getResult() {
        if (this.result == null) {
            this.result = Getter.getRevisionAnalysisUpgrade();
        }
        return this.result;
    }

    private boolean isReserved() {
        if (this.reservationStatus == null) {
            try {
                String assetID = "system";
                RESERVESTATUSDocument.RESERVESTATUS r = com.sun.netstorage.mgmt.fm.storade.ui.viewbeans.reports.Getter.getReserveStatus(assetID);
                if (r != null) {
                    this.reservationStatus = "yes".equalsIgnoreCase(r.getSTATUS()) ? new Boolean(true) : new Boolean(false);
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        if (this.reservationStatus == null) {
            return false;
        }
        return this.reservationStatus;
    }

    private boolean isRefreshing() {
        String err;
        boolean isRefreshing = false;
        HttpServletRequest request = RequestManager.getRequestContext().getRequest();
        if (request.getParameter("refresh") != null && !RADataHelper.containsReport(this.getResult()) && (err = RADataHelper.getError(this.getResult())) == null) {
            isRefreshing = true;
        }
        return isRefreshing;
    }

    public boolean beginClearButtonSectionDisplay(ChildDisplayEvent event) throws ModelControlException {
        boolean doDisplay = RADataHelper.containsReport(this.getResult());
        return doDisplay;
    }

    public boolean beginRevisionAnalysisReportSectionDisplay(ChildDisplayEvent event) throws ModelControlException {
        boolean doDisplay = RADataHelper.containsReport(this.getResult());
        return doDisplay;
    }

    public boolean beginNoRevisionAnalysisReportSectionDisplay(ChildDisplayEvent event) throws ModelControlException {
        boolean doDisplay = !RADataHelper.containsReport(this.getResult());
        return doDisplay;
    }

    public String endChildDisplay(ChildContentDisplayEvent event) throws ModelControlException {
        String childName = event.getChildName();
        String content = event.getContent();
        try {
            if ("RevisionAnalysisReportSection".equals(childName)) {
                if (tableTitle == null) {
                    CCI18N cci18n = new CCI18N(this.getRequestContext(), "com.sun.netstorage.mgmt.fm.storade.ui.resources.ApplicationResources");
                    tableTitle = cci18n.getMessage("assets.revision.upgrade.table.title");
                }
                Pattern p = Pattern.compile(tableTitle + "&#160;\\(.+\\)");
                Matcher m = p.matcher(content);
                content = m.replaceAll(tableTitle + "&#160;(" + RADataHelper.getNumberOfPatches(this.getResult()) + ")");
                return content;
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return super.endChildDisplay(event);
    }

    private int countSelectableRows() {
        int numRows = 0;
        if (this.raTableModel != null) {
            for (int i = 0; i < this.raTableModel.getNumRows(); ++i) {
                if (!this.raTableModel.isSelectionVisible(i)) continue;
                ++numRows;
            }
        }
        return numRows;
    }

    public void beginDisplay(DisplayEvent event) {
        HttpServletRequest request = RequestManager.getRequestContext().getRequest();
        this.locale = request.getLocale();
        if (this.locale == null) {
            this.locale = Locale.getDefault();
        }
        HttpSession session = this.getRequestContext().getRequest().getSession();
        session.setAttribute("storade.privilegedRole", (Object)new Boolean(UserUtil.isPrivilegedRole(request)).toString());
        session.setAttribute("storade.systemReserved", (Object)new Boolean(this.isReserved()).toString());
        CCI18N cci18n = new CCI18N(this.getRequestContext(), "com.sun.netstorage.mgmt.fm.storade.ui.resources.ApplicationResources");
        String warningMessageUpgrade = cci18n.getMessage("assets.revision.upgrade.warning.upgrade", null);
        session.setAttribute("warningMessageUpgrade", (Object)warningMessageUpgrade);
        String warningMessageClear = cci18n.getMessage("assets.revision.upgrade.warning.clear", null);
        session.setAttribute("warningMessageClear", (Object)warningMessageClear);
        try {
            if (this.getResult() != null) {
                RADataHelper.populateUpgradeTableModel(this.getResult(), this.raTableModel, this.locale, this.getRequestContext(), false);
                this.setPageSessionAttribute("numSelectableRows", new Integer(this.countSelectableRows()));
                String s = RADataHelper.buildDeviceTypeString(this.raTableModel);
                session.setAttribute("deviceTypes", (Object)s);
            }
        }
        catch (Exception ex) {
            // empty catch block
        }
        String alertMsg = (String)session.getAttribute(ALERT_MSG);
        if ("true".equals(alertMsg)) {
            session.removeAttribute(ALERT_MSG);
            if (request.getParameter("refresh") != null) {
                this.doPageRefresh();
            }
        } else {
            this.checkIfReserved();
            if (request.getParameter("refresh") != null && !RADataHelper.containsReport(this.getResult())) {
                this.setInlineAlert("info", "assets.revision.upgrade.info", null, null, null);
                String err = RADataHelper.getError(this.getResult());
                if (err != null) {
                    this.setInlineAlert("error", "assets.revision.upgrade.error", null, null, null);
                } else {
                    this.doPageRefresh();
                }
            }
        }
        try {
            super.beginDisplay(event);
        }
        catch (Exception ex) {
            // empty catch block
        }
    }

    public void handleDeviceNameStrHREFRequest(RequestInvocationEvent event) {
        String assetID = (String)this.getDisplayFieldValue("deviceNameStrHREF");
        String url = "/" + Connection.getAppName() + "/reports/AssetDetails";
        url = url + "?" + "assetID=" + this.urlencode(assetID);
        try {
            event.getRequestContext().getResponse().sendRedirect(url);
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
    }

    public void handleAlarmHREFRequest(RequestInvocationEvent event) {
        String id = (String)this.getDisplayFieldValue(CHILD_ALARM_HREF);
        String linkStr = DelimUtil.decompose(id);
        String url = "/" + Connection.getAppName() + "/alarms/Alarms" + linkStr;
        try {
            event.getRequestContext().getResponse().sendRedirect(url);
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
    }

    public void handleGenerateRevAnalysisUpgradeReportButtonRequest(RequestInvocationEvent event) {
        boolean isGenerated = Setter.generateUpgradeReport();
        String url = "/" + Connection.getAppName() + "/revision/RAUpgrade";
        if (isGenerated) {
            this.setInlineAlert("info", "assets.revision.upgrade.info", null, null, null);
            url = url + "?refresh=true";
        } else {
            this.setInlineAlert("info", "assets.revision.upgrade.error", null, null, null);
        }
        HttpSession session = this.getRequestContext().getRequest().getSession();
        session.setAttribute(ALERT_MSG, (Object)"true");
        try {
            event.getRequestContext().getResponse().sendRedirect(url);
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
    }

    public void handleClearRevAnalysisUpgradeReportButtonRequest(RequestInvocationEvent event) {
        Setter.clearUpgradeReport();
        this.setInlineAlert("info", "assets.revision.upgrade.clearReport", null, null, null);
        String url = "/" + Connection.getAppName() + "/revision/RAUpgrade";
        try {
            event.getRequestContext().getResponse().sendRedirect(url);
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
    }

    public void handleApplyButtonRequest(RequestInvocationEvent event) {
        boolean isApplied;
        ActionTableInterface child = (ActionTableInterface)this.getChild(CHILD_RA_TABLE);
        ArrayList keys = child.getSelectedKeysForCurrentPage();
        String command = "";
        ArrayList<String> keysList = new ArrayList<String>();
        for (int i = 0; i < keys.size(); ++i) {
            String id = (String)keys.get(i);
            String[] values = DelimUtil.desaggregate(id);
            String ip = null;
            String name = null;
            Object patch = null;
            try {
                ip = values[0];
                name = values[1];
                if (values.length > 2) {
                    String patchID = values[2];
                    command = command + "&patch_" + this.urlencode(ip + "#" + patchID);
                } else {
                    command = command + "&sel_" + this.urlencode(ip);
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
            keysList.add(ip);
        }
        String[] keysArray = new String[keysList.size()];
        keysList.toArray(keysArray);
        int nbrRows = 0;
        try {
            Integer i = (Integer)this.getPageSessionAttribute("numSelectableRows");
            nbrRows = i;
        }
        catch (Exception ex) {
            // empty catch block
        }
        if (keys.size() >= nbrRows) {
            command = "&ALL=ALL";
        }
        if (isApplied = Setter.applyPatches(command)) {
            this.setInlineAlert("info", "assets.revision.upgrade.apply", null, null, null);
        } else {
            this.setInlineAlert("info", "assets.revision.upgrade.apply.error", null, null, null);
        }
        HttpSession session = this.getRequestContext().getRequest().getSession();
        session.setAttribute(ALERT_MSG, (Object)"true");
        String url = "/" + Connection.getAppName() + "/revision/RAUpgrade";
        try {
            event.getRequestContext().getResponse().sendRedirect(url);
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
    }

    public void handleViewAffectedVolumesRequest(RequestInvocationEvent event) {
        ActionTableInterface child = (ActionTableInterface)this.getChild(CHILD_RA_TABLE);
        ArrayList keys = child.getSelectedKeysForCurrentPage();
        String name = "";
        int i = 0;
        if (i < keys.size()) {
            String id = (String)keys.get(i);
            String[] values = DelimUtil.desaggregate(id);
            name = id;
            try {
                name = values[1];
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        String url = "/" + Connection.getAppName() + "/revision/AffectedVolumes";
        url = url + "?array=" + this.urlencode(name);
        try {
            event.getRequestContext().getResponse().sendRedirect(url);
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
    }
}

