/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.mgmt.fm.storade.ui.viewbeans.revision;

import com.iplanet.jato.RequestContext;
import com.sun.netstorage.mgmt.fm.storade.schema.asset.AssetContent;
import com.sun.netstorage.mgmt.fm.storade.schema.asset.AssetLogical;
import com.sun.netstorage.mgmt.fm.storade.schema.asset.AssetResultDocument;
import com.sun.netstorage.mgmt.fm.storade.schema.asset.AssetValue;
import com.sun.netstorage.mgmt.fm.storade.schema.asset.Component;
import com.sun.netstorage.mgmt.fm.storade.schema.revision.PatchData;
import com.sun.netstorage.mgmt.fm.storade.schema.revision.PatchUpgrade;
import com.sun.netstorage.mgmt.fm.storade.schema.revision.PatchUpgradeDevice;
import com.sun.netstorage.mgmt.fm.storade.schema.revision.PatchUpgradeFRU;
import com.sun.netstorage.mgmt.fm.storade.schema.revision.PatchUpgradeReportResultDocument;
import com.sun.netstorage.mgmt.fm.storade.ui.common.AlarmConstants;
import com.sun.netstorage.mgmt.fm.storade.ui.model.ActionTableModel;
import com.sun.netstorage.mgmt.fm.storade.ui.util.DelimUtil;
import com.sun.netstorage.mgmt.fm.storade.ui.util.DeviceUtil;
import com.sun.netstorage.mgmt.fm.storade.ui.util.StringUtil;
import com.sun.netstorage.mgmt.fm.storade.ui.viewbeans.reports.Getter;
import com.sun.netstorage.mgmt.fm.storade.ui.viewbeans.reports.RackDataHelper;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class RADataHelper {
    private static final String ALARM_HREF = "alarmHREF";
    private static final String ALARM = "alarms";
    private static final Pattern pattern = Pattern.compile("u([0-9])+d([0-9])+");
    private static String VOL_KEY = "fruDiskVolName";
    private static final String ARRAY = "array";
    private static final String DSP = "dsp";
    private static final String SP = "sp";

    private RADataHelper() {
    }

    private static boolean isDisk(String name) {
        Matcher matcher = pattern.matcher(name);
        return matcher.matches();
    }

    private static String convertToStoradeFormat(String name) {
        String s = name.replaceAll("d0", "d");
        return s;
    }

    static Map getVolumes() {
        HashMap arrays = new HashMap();
        try {
            String summaryID = RackDataHelper.getSummaryID();
            AssetResultDocument.AssetResult assetResult = Getter.getReportDetails(summaryID);
            AssetContent content = assetResult.getReport().getContent();
            AssetLogical logical = content.getLOGICAL();
            Component[] lComponents = logical.getCOMPONENTArray();
            for (int j = 0; j < lComponents.length; ++j) {
                String id = lComponents[j].getID();
                if (id == null || !id.startsWith("volume.")) continue;
                String name = null;
                String disksString = null;
                AssetValue[] values = lComponents[j].getValueArray();
                if (values != null) {
                    for (int k = 0; k < values.length; ++k) {
                        String prop = values[k].getID();
                        String value = values[k].getStringValue();
                        if ("name".equals(prop)) {
                            name = value;
                            continue;
                        }
                        if (!"physicalDisks".equals(prop)) continue;
                        disksString = value;
                    }
                }
                if (name == null || disksString == null) continue;
                StringTokenizer st = new StringTokenizer(disksString, ",");
                while (st.hasMoreTokens()) {
                    ArrayList<String> volumes;
                    String value = st.nextToken().trim();
                    String disk = null;
                    String array = null;
                    String volumeName = null;
                    int lastIndex = value.lastIndexOf(46);
                    int index = value.indexOf(46);
                    if (lastIndex != -1) {
                        disk = value.substring(lastIndex + 1);
                        disk = RADataHelper.convertToStoradeFormat(disk);
                    }
                    if (index != -1) {
                        array = value.substring(0, value.indexOf(46));
                    }
                    volumeName = name;
                    if (disk == null || array == null || volumeName == null) continue;
                    HashMap disks = (HashMap)arrays.get(array);
                    if (disks == null) {
                        disks = new HashMap();
                        volumes = new ArrayList<String>();
                        volumes.add(volumeName);
                        disks.put(disk, volumes);
                        arrays.put(array, disks);
                        continue;
                    }
                    volumes = (ArrayList<String>)disks.get(disk);
                    if (volumes == null) {
                        volumes = new ArrayList();
                        disks.put(disk, volumes);
                    }
                    volumes.add(volumeName);
                }
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return arrays;
    }

    static String[] getVolumeNames(Map arrays, String array, String disk) {
        ArrayList volumeList;
        String[] volumes = null;
        Map disks = (Map)arrays.get(array);
        if (disks != null && (volumeList = (ArrayList)disks.get(disk)) != null) {
            volumes = new String[volumeList.size()];
            volumeList.toArray(volumes);
        }
        return volumes;
    }

    public static String getUpgradeReportDate(PatchUpgradeReportResultDocument.PatchUpgradeReportResult result) {
        String date = null;
        if (result != null) {
            PatchUpgrade pu = result.getPATCHUPGRADEREPORT();
            date = pu.getDATE();
        }
        return date;
    }

    public static boolean containsReport(PatchUpgradeReportResultDocument.PatchUpgradeReportResult result) {
        String d;
        PatchUpgrade pu;
        boolean doContainReport = false;
        if (result != null && (pu = result.getPATCHUPGRADEREPORT()) != null && (d = pu.getDATE()) != null && !"".equals(d)) {
            doContainReport = true;
        }
        return doContainReport;
    }

    public static boolean containsPatches(PatchUpgradeReportResultDocument.PatchUpgradeReportResult result) {
        PatchUpgrade pu;
        boolean doContainPatches = false;
        if (result != null && (pu = result.getPATCHUPGRADEREPORT()) != null) {
            PatchUpgradeDevice[] pd = pu.getDEVICEArray();
            block0: for (int i = 0; i < pd.length; ++i) {
                PatchData[] pData = pd[i].getPATCHDATAArray();
                if (pData == null) continue;
                for (int j = 0; j < pData.length; ++j) {
                    String pID = pData[j].getPATCHID();
                    if (pID == null || "".equals(pID)) continue;
                    doContainPatches = true;
                    break block0;
                }
            }
        }
        return doContainPatches;
    }

    public static String getTrace(PatchUpgradeReportResultDocument.PatchUpgradeReportResult result) {
        PatchUpgrade pu;
        String trace = "";
        if (result != null && (pu = result.getPATCHUPGRADEREPORT()) != null) {
            trace = pu.getTRACE();
        }
        return trace;
    }

    public static String getStdout(PatchUpgradeReportResultDocument.PatchUpgradeReportResult result) {
        PatchUpgrade pu;
        String stdout = "";
        if (result != null && (pu = result.getPATCHUPGRADEREPORT()) != null) {
            stdout = pu.getSTDOUT();
        }
        return stdout;
    }

    public static String getErrorCount(PatchUpgradeReportResultDocument.PatchUpgradeReportResult result) {
        PatchUpgrade pu;
        String errorCount = "0";
        if (result != null && (pu = result.getPATCHUPGRADEREPORT()) != null && pu.getERRORCOUNT() != null && !"".equals(pu.getERRORCOUNT())) {
            errorCount = pu.getERRORCOUNT();
        }
        return errorCount;
    }

    public static String getDate(PatchUpgradeReportResultDocument.PatchUpgradeReportResult result) {
        String d;
        String date = null;
        if (result != null && (d = result.getDATE()) != null && !"".equals(d)) {
            date = d;
        }
        return date;
    }

    public static String getError(PatchUpgradeReportResultDocument.PatchUpgradeReportResult result) {
        String error;
        String err = null;
        if (result != null && (error = result.getERROR()) != null && !"".equals(error)) {
            err = error;
        }
        return err;
    }

    public static String[] getPatches(PatchUpgradeReportResultDocument.PatchUpgradeReportResult result, String device) {
        PatchUpgrade pu;
        ArrayList<String> patchesList = new ArrayList<String>();
        if (result != null && (pu = result.getPATCHUPGRADEREPORT()) != null) {
            PatchUpgradeDevice[] pd = pu.getDEVICEArray();
            for (int i = 0; i < pd.length; ++i) {
                PatchData[] pData;
                String name = pd[i].getNAME();
                if (name == null || !name.equals(device) || (pData = pd[i].getPATCHDATAArray()) == null) continue;
                for (int j = 0; j < pData.length; ++j) {
                    String pID = pData[j].getPATCHID();
                    if (pID == null || "".equals(pID)) continue;
                    patchesList.add(pID);
                }
            }
        }
        String[] patches = new String[patchesList.size()];
        patchesList.toArray(patches);
        return patches;
    }

    public static String[] getDisks(PatchUpgradeReportResultDocument.PatchUpgradeReportResult result, String patchID, String array) {
        PatchUpgrade pu;
        ArrayList<String> disksList = new ArrayList<String>();
        if (result != null && (pu = result.getPATCHUPGRADEREPORT()) != null) {
            PatchUpgradeDevice[] pd = pu.getDEVICEArray();
            for (int i = 0; i < pd.length; ++i) {
                String name = pd[i].getNAME();
                PatchData[] pData = pd[i].getPATCHDATAArray();
                if (pData == null) continue;
                for (int j = 0; j < pData.length; ++j) {
                    PatchUpgradeFRU[] frus;
                    String pID = pData[j].getPATCHID();
                    if (name == null || pID == null || !name.equals(array) || !pID.equals(patchID) || (frus = pData[j].getFRUArray()) == null) continue;
                    int k = 0;
                    while (j < frus.length) {
                        String fruName;
                        if (frus[k].getNAME() != null && RADataHelper.isDisk(fruName = RADataHelper.convertToStoradeFormat(frus[k].getNAME()))) {
                            disksList.add(fruName);
                        }
                        ++j;
                    }
                }
            }
        }
        String[] disks = new String[disksList.size()];
        disksList.toArray(disks);
        return disks;
    }

    private static void addAlarms(String name, String key, String alarmSev, ActionTableModel raTableModel) {
        raTableModel.setValue(ALARM_HREF, null);
        raTableModel.setValue(ALARM, null);
        try {
            int severity = Integer.parseInt(alarmSev);
            String str = DelimUtil.compose(ALARM_HREF, new String[]{key, name});
            if (severity == 1) {
                raTableModel.setValue(ALARM_HREF, str);
                raTableModel.setValue(ALARM, AlarmConstants.getSeverityObject(1));
            } else if (severity == 2) {
                raTableModel.setValue(ALARM_HREF, str);
                raTableModel.setValue(ALARM, AlarmConstants.getSeverityObject(2));
            } else if (severity == 3) {
                raTableModel.setValue(ALARM, AlarmConstants.getSeverityObject(3));
                raTableModel.setValue(ALARM_HREF, str);
            }
        }
        catch (Exception ex) {
            // empty catch block
        }
    }

    private static ArrayList addServiceProcessorPatches(String name, String key, String ip, String alarmSev, PatchData[] pData, ActionTableModel raTableModel, boolean rowAdded) {
        ArrayList<String> keysList = new ArrayList<String>();
        if (rowAdded) {
            raTableModel.appendRow();
        }
        rowAdded = true;
        RADataHelper.addAlarms(name, key, alarmSev, raTableModel);
        raTableModel.setValue("deviceNameStr", name);
        raTableModel.setValue("deviceNameStrHREF", key);
        raTableModel.setValue("ipStr", ip);
        String allPatchID = "";
        String allSynopsis = "";
        String allFRUs = "";
        if (pData != null) {
            for (int j = 0; j < pData.length; ++j) {
                PatchUpgradeFRU[] frus;
                String patchID = pData[j].getPATCHID();
                String patchSynopsis = pData[j].getPATCHSYNOPSIS();
                if (pData[j].getERROR() != null && !"".equals(pData[j].getERROR())) {
                    patchSynopsis = patchSynopsis + " - " + pData[j].getERROR();
                }
                allPatchID = allPatchID + patchID;
                if (j != pData.length - 1) {
                    allPatchID = allPatchID + "<br>";
                }
                allSynopsis = allSynopsis + patchSynopsis;
                if (j != pData.length - 1) {
                    allSynopsis = allSynopsis + "<br>";
                }
                if ((frus = pData[j].getFRUArray()) == null) continue;
                for (int k = 0; k < frus.length; ++k) {
                    if (frus[k].getNAME() == null) continue;
                    String fruName = RADataHelper.convertToStoradeFormat(frus[j].getNAME());
                    allFRUs = allFRUs + fruName;
                    if (frus[k].getCLASS() != null && !"".equals(frus[k].getCLASS())) {
                        allFRUs = allFRUs + " (" + frus[k].getCLASS() + ")";
                    }
                    if (k == frus.length - 1) continue;
                    allFRUs = allFRUs + "<br>";
                }
            }
        }
        keysList.add(DelimUtil.aggregate(new String[]{ip, name}));
        raTableModel.setValue("patchIDStr", StringUtil.toBlank(allPatchID));
        raTableModel.setValue("patchSynopsisStr", StringUtil.toBlank(allSynopsis));
        raTableModel.setValue("fruStr", StringUtil.toBlank(allFRUs));
        if (allPatchID == null || "".equals(allPatchID)) {
            raTableModel.setSelectionVisible(false);
        }
        return keysList;
    }

    private static ArrayList addDevicePatches(String name, String key, String ip, String alarmSev, boolean skipNoPatch, PatchData[] pData, ActionTableModel raTableModel, boolean rowAdded) {
        ArrayList<String> keysList = new ArrayList<String>();
        if (pData != null) {
            if (pData.length != 0) {
                for (int j = 0; j < pData.length; ++j) {
                    String patchID = pData[j].getPATCHID();
                    String patchSynopsis = pData[j].getPATCHSYNOPSIS();
                    if (skipNoPatch && (patchID == null || "".equals(patchID))) continue;
                    if (pData[j].getERROR() != null && !"".equals(pData[j].getERROR())) {
                        patchSynopsis = patchSynopsis + " - " + pData[j].getERROR();
                    }
                    if (rowAdded) {
                        raTableModel.appendRow();
                    }
                    rowAdded = true;
                    RADataHelper.addAlarms(name, key, alarmSev, raTableModel);
                    keysList.add(DelimUtil.aggregate(new String[]{ip, name, patchID, patchSynopsis}));
                    raTableModel.setValue("deviceNameStr", name);
                    raTableModel.setValue("deviceNameStrHREF", key);
                    raTableModel.setValue("ipStr", ip);
                    raTableModel.setValue("patchIDStr", StringUtil.toBlank(patchID));
                    raTableModel.setValue("patchSynopsisStr", StringUtil.toBlank(patchSynopsis));
                    if (patchID == null || "".equals(patchID)) {
                        raTableModel.setSelectionVisible(false);
                    }
                    PatchUpgradeFRU[] frus = pData[j].getFRUArray();
                    String s = "";
                    if (frus != null) {
                        for (int k = 0; k < frus.length; ++k) {
                            if (frus[k].getNAME() == null) continue;
                            String fruName = RADataHelper.convertToStoradeFormat(frus[k].getNAME());
                            s = s + fruName;
                            if (frus[k].getCLASS() != null && !"".equals(frus[k].getCLASS())) {
                                s = s + " (" + frus[k].getCLASS() + ")";
                            }
                            if (k == frus.length - 1) continue;
                            s = s + "<br>";
                        }
                    }
                    raTableModel.setValue("fruStr", StringUtil.toBlank(s));
                }
            } else if (!skipNoPatch) {
                if (rowAdded) {
                    raTableModel.appendRow();
                }
                rowAdded = true;
                RADataHelper.addAlarms(name, key, alarmSev, raTableModel);
                keysList.add(DelimUtil.aggregate(new String[]{ip, name, "", ""}));
                raTableModel.setSelectionVisible(false);
                raTableModel.setValue("deviceNameStr", name);
                raTableModel.setValue("deviceNameStrHREF", key);
                raTableModel.setValue("ipStr", ip);
                raTableModel.setValue("patchIDStr", StringUtil.toBlank(""));
                raTableModel.setValue("patchSynopsisStr", StringUtil.toBlank(""));
                raTableModel.setValue("fruStr", StringUtil.toBlank(""));
            }
        }
        return keysList;
    }

    public static int getNumberOfPatches(PatchUpgradeReportResultDocument.PatchUpgradeReportResult result) {
        int n = 0;
        PatchUpgrade pu = result.getPATCHUPGRADEREPORT();
        if (pu != null) {
            PatchUpgradeDevice[] pd = pu.getDEVICEArray();
            for (int i = 0; i < pd.length; ++i) {
                PatchData[] pData = pd[i].getPATCHDATAArray();
                if (pData == null) continue;
                for (int j = 0; j < pData.length; ++j) {
                    String pID = pData[j].getPATCHID();
                    if (pID == null || "".equals(pID)) continue;
                    ++n;
                }
            }
        }
        return n;
    }

    public static void populateUpgradeTableModel(PatchUpgradeReportResultDocument.PatchUpgradeReportResult result, ActionTableModel raTableModel, Locale locale, RequestContext requestContext, boolean skipNoPatch) throws IllegalArgumentException {
        PatchUpgrade pu;
        boolean rowAdded = false;
        if (result != null && (pu = result.getPATCHUPGRADEREPORT()) != null) {
            PatchUpgradeDevice[] pd = pu.getDEVICEArray();
            ArrayList keysList = new ArrayList();
            if (pd != null) {
                for (int i = 0; i < pd.length; ++i) {
                    ArrayList l;
                    String name = pd[i].getNAME();
                    String ip = pd[i].getIP();
                    String key = pd[i].getTYPE() + ":" + pd[i].getKEY();
                    String alarmSev = pd[i].getALARMSEVERITY();
                    PatchData[] pData = pd[i].getPATCHDATAArray();
                    if ((pData == null || pData.length == 0) && skipNoPatch) continue;
                    if (SP.equals(name)) {
                        l = RADataHelper.addServiceProcessorPatches(name, key, ip, alarmSev, pData, raTableModel, rowAdded);
                        keysList.addAll(l);
                        if (l.size() <= 0) continue;
                        rowAdded = true;
                        continue;
                    }
                    l = RADataHelper.addDevicePatches(name, key, ip, alarmSev, skipNoPatch, pData, raTableModel, rowAdded);
                    keysList.addAll(l);
                    if (l.size() <= 0) continue;
                    rowAdded = true;
                }
            }
            String[] keysArray = new String[keysList.size()];
            keysList.toArray(keysArray);
            raTableModel.setKeys(keysArray);
        }
    }

    static String buildDeviceTypeString(ActionTableModel raTableModel) {
        int i;
        ArrayList<String> list = new ArrayList<String>();
        if (raTableModel != null) {
            String key;
            for (i = 1; i < raTableModel.getNumRows(); ++i) {
                raTableModel.setRowIndex(i);
                if (!raTableModel.isSelectionVisible()) continue;
                key = (String)raTableModel.getValue("deviceNameStrHREF");
                if (DeviceUtil.isSP(key)) {
                    list.add(SP);
                    continue;
                }
                if (DeviceUtil.isDSP(key)) {
                    list.add(DSP);
                    continue;
                }
                list.add(ARRAY);
            }
            raTableModel.setRowIndex(0);
            if (raTableModel.isSelectionVisible()) {
                key = (String)raTableModel.getValue("deviceNameStrHREF");
                if (DeviceUtil.isSP(key)) {
                    list.add(SP);
                } else if (DeviceUtil.isDSP(key)) {
                    list.add(DSP);
                } else {
                    list.add(ARRAY);
                }
            }
        }
        String s = "\"\"";
        if (list.size() != 0) {
            s = "";
            for (i = 0; i < list.size(); ++i) {
                String element = (String)list.get(i);
                s = s + "\"" + element + "\"";
                if (i == list.size() - 1) continue;
                s = s + ", ";
            }
        }
        return s;
    }
}

