/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.mgmt.fm.storade.ui.viewbeans.reports;

import com.iplanet.jato.RequestContext;
import com.iplanet.jato.RequestManager;
import com.iplanet.jato.model.DefaultModel;
import com.iplanet.jato.view.ContainerView;
import com.iplanet.jato.view.ContainerViewBase;
import com.iplanet.jato.view.View;
import com.iplanet.jato.view.event.DisplayEvent;
import com.iplanet.jato.view.event.RequestInvocationEvent;
import com.sun.netstorage.mgmt.fm.storade.schema.asset.AssetResultDocument;
import com.sun.netstorage.mgmt.fm.storade.ui.common.UIMastHeadViewBeanBase;
import com.sun.netstorage.mgmt.fm.storade.ui.util.Connection;
import com.sun.netstorage.mgmt.fm.storade.ui.util.DelimUtil;
import com.sun.netstorage.mgmt.fm.storade.ui.util.DeviceUtil;
import com.sun.netstorage.mgmt.fm.storade.ui.util.TableUtil;
import com.sun.netstorage.mgmt.fm.storade.ui.viewbeans.reports.AssetsDataHelper;
import com.sun.netstorage.mgmt.fm.storade.ui.viewbeans.reports.Getter;
import com.sun.web.ui.model.CCActionTableModel;
import com.sun.web.ui.model.CCActionTableModelInterface;
import com.sun.web.ui.view.table.CCActionTable;
import java.io.IOException;
import java.io.Serializable;
import java.util.Locale;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;

public class VolumeSummaryViewBean
extends UIMastHeadViewBeanBase {
    public static final String PAGE_NAME = "VolumeSummary";
    public static final String DEFAULT_DISPLAY_URL = "/jsp/reports/VolumeSummary.jsp";
    static final String PAGE_TITLE = "page.title.volumeSummary1";
    public static final String CHILD_VOLUME_TABLE = "VolumeSummaryTable";
    public static final String CHILD_COMPONENT_HREF = "volumeHREF";
    private CCActionTableModel volumeSummaryModel;
    private AssetResultDocument.AssetResult result;

    public VolumeSummaryViewBean() {
        super(PAGE_NAME, DEFAULT_DISPLAY_URL);
    }

    public void setRequestContext(RequestContext ctx) {
        super.setRequestContext(ctx);
        this.initModel();
    }

    protected void subRegisterChildren() {
        this.registerChild(CHILD_VOLUME_TABLE, CCActionTable.class);
        this.getTableModel().registerChildren((ContainerViewBase)this);
    }

    protected View subCreateChild(String name) {
        if (name.equals(CHILD_VOLUME_TABLE)) {
            CCActionTable child = new CCActionTable((ContainerView)this, (CCActionTableModelInterface)this.getTableModel(), name);
            return child;
        }
        if (this.getTableModel().isChildSupported(name)) {
            return this.getTableModel().createChild((View)this, name);
        }
        return null;
    }

    private void initModel() {
    }

    private CCActionTableModel getTableModel() {
        if (this.volumeSummaryModel == null) {
            String[] headers;
            HttpServletRequest request = RequestManager.getRequestContext().getRequest();
            String type = request.getParameter("type");
            if (type == null) {
                type = (String)this.getPageSessionAttribute("type");
            }
            if ((headers = AssetsDataHelper.getColumnHeaders(this.getResult(), type)) == null || headers.length == 0) {
                this.volumeSummaryModel = new CCActionTableModel(RequestManager.getRequestContext().getServletContext(), "/xml/table/VolumeSummaryTable.xml");
                this.volumeSummaryModel.setActionValue("volume", (Object)"asset.details.volume.name");
                this.volumeSummaryModel.setActionValue("volumeStatus", (Object)"table.header.status");
                this.volumeSummaryModel.setActionValue("poolref", (Object)"asset.details.volume.pool");
            } else {
                String key;
                StringBuffer buf = new StringBuffer();
                buf.append(TableUtil.addTableHeader());
                for (int i = 0; i < headers.length; ++i) {
                    if (i == 0) {
                        buf.append(TableUtil.addLeftTextColumnWithHREF(headers[i] + "Col", headers[i], CHILD_COMPONENT_HREF));
                        continue;
                    }
                    buf.append(TableUtil.addLeftTextColumn(headers[i] + "Col", headers[i]));
                }
                buf.append(TableUtil.addTableFooter());
                this.volumeSummaryModel = new CCActionTableModel(buf.toString());
                Locale locale = request.getLocale();
                if (locale == null) {
                    locale = Locale.getDefault();
                }
                if ((key = request.getParameter("key")) == null) {
                    key = (String)this.getPageSessionAttribute("key");
                }
                String deviceType = DeviceUtil.getDeviceType(key);
                for (int i = 0; i < headers.length; ++i) {
                    String localizedHeader = DeviceUtil.getLocalizedKey(deviceType, headers[i], locale);
                    this.volumeSummaryModel.setActionValue(headers[i] + "Col", (Object)localizedHeader);
                }
            }
        }
        return this.volumeSummaryModel;
    }

    private AssetResultDocument.AssetResult getResult() {
        if (this.result == null) {
            HttpServletRequest request = RequestManager.getRequestContext().getRequest();
            String key = request.getParameter("key");
            if (key == null) {
                key = (String)this.getPageSessionAttribute("key");
            }
            try {
                this.result = Getter.getReportDetails(key);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return this.result;
    }

    public void beginDisplay(DisplayEvent event) {
        HttpServletRequest request = RequestManager.getRequestContext().getRequest();
        Locale locale = request.getLocale();
        if (locale == null) {
            locale = Locale.getDefault();
        }
        String key = request.getParameter("key");
        String type = request.getParameter("type");
        if (key == null) {
            key = (String)this.getPageSessionAttribute("key");
        }
        this.setPageSessionAttribute("key", (Serializable)((Object)key));
        if (type == null) {
            type = (String)this.getPageSessionAttribute("type");
        }
        this.setPageSessionAttribute("type", (Serializable)((Object)type));
        String displayName = request.getParameter("displayName");
        if (displayName == null) {
            displayName = (String)this.getPageSessionAttribute("displayName");
        }
        this.setPageSessionAttribute("displayName", (Serializable)((Object)displayName));
        if (key != null) {
            try {
                if (this.getResult() != null) {
                    this.setAlarmSummary(this.getResult().getAlarmSummary());
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
            String name = key;
            try {
                if (DeviceUtil.isDSP(key)) {
                    String[] columns = AssetsDataHelper.getColumnHeaders(this.getResult(), type);
                    name = AssetsDataHelper.populateDSPVolumeSummaryModel(this.getResult(), (DefaultModel)this.getTableModel(), key, type, columns, locale);
                } else {
                    name = AssetsDataHelper.populateVolumeSummaryModel(this.getResult(), (DefaultModel)this.getTableModel(), key, type, locale);
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
            if (displayName == null) {
                displayName = name;
            }
            this.setPageTitle(PAGE_TITLE, new String[]{displayName});
        }
        super.beginDisplay(event);
    }

    public void handleComponentHREFRequest(RequestInvocationEvent event) throws ServletException, IOException {
        String id = (String)this.getDisplayFieldValue(CHILD_COMPONENT_HREF);
        String[] values = DelimUtil.desaggregate(id);
        String key = null;
        String comp = null;
        String compName = null;
        try {
            key = values[0];
            comp = values[1];
            compName = values[2];
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        String page = "reports/Component";
        page = page + "?key=" + this.urlencode(key);
        page = page + "&summary=" + this.urlencode(comp);
        page = page + "&componentName=" + this.urlencode(compName);
        String url = "/" + Connection.getAppName() + "/" + page;
        RequestContext requestContext = event.getRequestContext();
        requestContext.getResponse().sendRedirect(url);
    }

    public void handleVolumeHREFRequest(RequestInvocationEvent event) throws ServletException, IOException {
        String id = (String)this.getDisplayFieldValue(CHILD_COMPONENT_HREF);
        String displayName = (String)this.getPageSessionAttribute("displayName");
        String[] values = DelimUtil.desaggregate(id);
        String key = null;
        String comp = null;
        String compName = null;
        try {
            key = values[0];
            comp = values[1];
            compName = values[2];
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        String page = "reports/Component";
        page = page + "?key=" + this.urlencode(key);
        page = page + "&summary=" + this.urlencode(comp);
        page = page + "&componentName=" + this.urlencode(compName);
        if (displayName != null) {
            page = page + "&displayName=" + this.urlencode(displayName);
        }
        String url = "/" + Connection.getAppName() + "/" + page;
        RequestContext requestContext = event.getRequestContext();
        requestContext.getResponse().sendRedirect(url);
    }
}

