/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.mgmt.fm.storade.ui.viewbeans.reports;

import com.iplanet.jato.RequestContext;
import com.iplanet.jato.view.ContainerView;
import com.iplanet.jato.view.ContainerViewBase;
import com.iplanet.jato.view.View;
import com.iplanet.jato.view.event.DisplayEvent;
import com.sun.netstorage.mgmt.fm.storade.schema.asset.AssetComponent;
import com.sun.netstorage.mgmt.fm.storade.schema.asset.AssetContent;
import com.sun.netstorage.mgmt.fm.storade.schema.asset.AssetResultDocument;
import com.sun.netstorage.mgmt.fm.storade.schema.asset.AssetValue;
import com.sun.netstorage.mgmt.fm.storade.schema.asset.Component;
import com.sun.netstorage.mgmt.fm.storade.ui.common.UIMastHeadViewBeanBase;
import com.sun.netstorage.mgmt.fm.storade.ui.util.StringUtil;
import com.sun.netstorage.mgmt.fm.storade.ui.util.TableUtil;
import com.sun.netstorage.mgmt.fm.storade.ui.viewbeans.reports.Getter;
import com.sun.web.ui.model.CCActionTableModel;
import com.sun.web.ui.model.CCActionTableModelInterface;
import com.sun.web.ui.view.table.CCActionTable;
import java.util.ArrayList;

public class SpaTraySummaryViewBean
extends UIMastHeadViewBeanBase {
    public static final String PAGE_NAME = "SpaTraySummary";
    public static final String DEFAULT_DISPLAY_URL = "/jsp/reports/SpaTraySummary.jsp";
    public static final String CHILD_COMPONENT_SUMMARY_TABLE = "ComponentSummaryTable";
    private CCActionTableModel tableModel;
    private AssetResultDocument.AssetResult result;
    private static final String VALUE_VENDOR = "vendor";
    private static final String VALUE_MODEL = "model";
    private static final String VALUE_SERIAL = "serialNo";
    private static final String VALUE_REVISION = "revision";

    public SpaTraySummaryViewBean() {
        super(PAGE_NAME, DEFAULT_DISPLAY_URL);
        this.initModel();
    }

    public void setRequestContext(RequestContext ctx) {
        super.setRequestContext(ctx);
    }

    protected void subRegisterChildren() {
        this.registerChild(CHILD_COMPONENT_SUMMARY_TABLE, CCActionTable.class);
        this.tableModel.registerChildren((ContainerViewBase)this);
    }

    protected View subCreateChild(String name) {
        if (name.equals(CHILD_COMPONENT_SUMMARY_TABLE)) {
            CCActionTable child = new CCActionTable((ContainerView)this, (CCActionTableModelInterface)this.tableModel, name);
            return child;
        }
        if (this.tableModel.isChildSupported(name)) {
            return this.tableModel.createChild((View)this, name);
        }
        return null;
    }

    private void initModel() {
        StringBuffer buf = new StringBuffer();
        buf.append(TableUtil.addTableHeader());
        buf.append(TableUtil.addLeftTextColumn("nameCol", "name", false));
        buf.append(TableUtil.addLeftTextColumn("vendorCol", VALUE_VENDOR, false));
        buf.append(TableUtil.addLeftTextColumn("modelCol", VALUE_MODEL, false));
        buf.append(TableUtil.addLeftTextColumn("serialCol", "serial", false));
        buf.append(TableUtil.addLeftTextColumn("revisionCol", VALUE_REVISION, false));
        buf.append(TableUtil.addTableFooter());
        this.tableModel = new CCActionTableModel(buf.toString());
        this.tableModel.setActionValue("nameCol", (Object)"asset.details.table.componentName");
        this.tableModel.setActionValue("vendorCol", (Object)"asset.details.table.componentVendor");
        this.tableModel.setActionValue("modelCol", (Object)"asset.details.table.componentModel");
        this.tableModel.setActionValue("serialCol", (Object)"asset.details.table.componentSerialNumber");
        this.tableModel.setActionValue("revisionCol", (Object)"asset.details.table.componentRevision");
    }

    private void populateTable() {
        if (this.result != null) {
            AssetComponent fru;
            AssetContent content = this.result.getReport().getContent();
            ArrayList componentList = new ArrayList();
            if (content != null && (fru = content.getFRU()) != null) {
                Component[] c = fru.getCOMPONENTArray();
                for (int i = 0; i < c.length; ++i) {
                    String name = c[i].getID();
                    AssetValue[] values = c[i].getValueArray();
                    String vendor = "-";
                    String model = "-";
                    String serial = "-";
                    String revision = "-";
                    if (values != null) {
                        for (int j = 0; j < values.length; ++j) {
                            String s = values[j].getID();
                            if (VALUE_VENDOR.equals(s)) {
                                vendor = StringUtil.toBlank(values[j].getStringValue());
                                continue;
                            }
                            if (VALUE_MODEL.equals(s)) {
                                model = StringUtil.toBlank(values[j].getStringValue());
                                continue;
                            }
                            if (VALUE_SERIAL.equals(s)) {
                                serial = StringUtil.toBlank(values[j].getStringValue());
                                continue;
                            }
                            if (!VALUE_REVISION.equals(s)) continue;
                            revision = StringUtil.toBlank(values[j].getStringValue());
                        }
                    }
                    if (i != 0) {
                        this.tableModel.appendRow();
                    }
                    this.tableModel.setValue("name", (Object)name);
                    this.tableModel.setValue(VALUE_VENDOR, (Object)vendor);
                    this.tableModel.setValue(VALUE_MODEL, (Object)model);
                    this.tableModel.setValue("serial", (Object)serial);
                    this.tableModel.setValue(VALUE_REVISION, (Object)revision);
                }
            }
        }
    }

    public void beginDisplay(DisplayEvent event) {
        try {
            this.result = Getter.getSpaTray();
            this.setAlarmSummary(this.result.getAlarmSummary());
            this.populateTable();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        super.beginDisplay(event);
    }
}

