/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.mgmt.fm.storade.ui.viewbeans.reports;

import com.sun.netstorage.mgmt.fm.storade.schema.asset.BatteryControlResultDocument;
import com.sun.netstorage.mgmt.fm.storade.schema.asset.CompareResultDocument;
import com.sun.netstorage.mgmt.fm.storade.schema.asset.ControllerControlResultDocument;
import com.sun.netstorage.mgmt.fm.storade.schema.asset.LEDControlResultDocument;
import com.sun.netstorage.mgmt.fm.storade.schema.asset.PingResultDocument;
import com.sun.netstorage.mgmt.fm.storade.schema.asset.SEActionResultDocument;
import com.sun.netstorage.mgmt.fm.storade.schema.asset.SnapshotResultDocument;
import com.sun.netstorage.mgmt.fm.storade.ui.util.Connection;
import com.sun.netstorage.mgmt.fm.storade.ui.util.Debug;
import com.sun.netstorage.mgmt.fm.storade.ui.util.DeviceUtil;
import com.sun.netstorage.mgmt.fm.storade.ui.util.XmlUtil;
import java.net.URLEncoder;

public class Setter {
    private Setter() {
    }

    public static void setNote(String id, String text) {
        try {
            String s = Connection.getComboHeader();
            String postData = "GO=Client::Config::setDeviceInfo";
            postData = postData + "&key=" + URLEncoder.encode(id, "UTF-8");
            postData = postData + "&info=" + URLEncoder.encode(text, "UTF-8");
            Debug.println("REQUEST: " + s);
            String data = Connection.postData(s, postData);
            Debug.println("DATA: " + data);
        }
        catch (Exception ex) {
            Debug.println("EXCEPTION WHILE WRITING NOTE: " + ex);
            ex.printStackTrace();
        }
    }

    public static void setMonitor(String id, boolean doMonitor) {
        String monitor = "N";
        if (doMonitor) {
            monitor = "Y";
        }
        try {
            String s = Connection.getComboHeader();
            s = s + "?GO=Client::Config::monitorDevice";
            s = s + "&key=" + URLEncoder.encode(id, "UTF-8");
            s = s + "&monitor=" + URLEncoder.encode(monitor, "UTF-8");
            String data = Connection.getData(s);
            Debug.println("REQUEST: " + s);
            Debug.println("DATA: " + data);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public static void setNameAndPassword(String id, String name, String password) {
        String key = id;
        key = DeviceUtil.getDeviceName(key);
        try {
            String s = Connection.getComboHeader();
            s = s + "?GO=Client::Config::updateDevice";
            s = s + "&key=" + URLEncoder.encode(key, "UTF-8");
            s = s + "&name=" + URLEncoder.encode(name, "UTF-8");
            s = s + "&password=" + URLEncoder.encode(password, "UTF-8");
            String data = Connection.getData(s);
            Debug.println("REQUEST: " + s);
            Debug.println("DATA: " + data);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public static void remove(String id) {
        try {
            String s = Connection.getComboHeader();
            s = s + "?GO=Client::Device::Remove&format=xml";
            s = s + "&key=" + URLEncoder.encode(id, "UTF-8");
            String data = Connection.getData(s);
            Debug.println("REQUEST: " + s);
            Debug.println("DATA: " + data);
            if (!"OK".equals(data)) {
                throw new IllegalArgumentException("Invalid key: " + id);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public static boolean generateExceptionReport() {
        try {
            String s = Connection.getComboHeader();
            s = s + "?GO=Client::ExceptionReport::RUNback";
            String data = Connection.getData(s);
            Debug.println("REQUEST: " + s);
            Debug.println("DATA: " + data);
            if (data.indexOf("ERROR") != -1) {
                return false;
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return true;
    }

    private static String buildString(String[] all) {
        if (all == null) {
            return "";
        }
        String r = "";
        for (int i = 0; i < all.length; ++i) {
            r = r + all[i];
            if (i >= all.length - 1) continue;
            r = r + "\t";
        }
        return r;
    }

    public static boolean setVolVerifyOptions(String activate, String fixOption, String frequency, String rate, String[] sundayTimes, String[] mondayTimes, String[] tuesdayTimes, String[] wednesdayTimes, String[] thursdayTimes, String[] fridayTimes, String[] saturdayTimes) {
        try {
            String times;
            String s = Connection.getComboHeader();
            s = s + "?GO=Client::VolVerify::setOptions";
            if (activate != null && "yes".equals(activate)) {
                s = s + "&volVerify=Y";
            }
            if (fixOption != null && "yes".equals(fixOption)) {
                s = s + "&fix=Y";
            }
            if (frequency != null) {
                s = s + "&freq=" + frequency;
            }
            if (rate != null) {
                s = s + "&rate=" + rate;
            }
            s = s + "&time0=";
            if (sundayTimes != null) {
                times = Setter.buildString(sundayTimes);
                s = s + URLEncoder.encode(times, "UTF-8");
            }
            s = s + "&time1=";
            if (mondayTimes != null) {
                times = Setter.buildString(mondayTimes);
                s = s + URLEncoder.encode(times, "UTF-8");
            }
            s = s + "&time2=";
            if (tuesdayTimes != null) {
                times = Setter.buildString(tuesdayTimes);
                s = s + URLEncoder.encode(times, "UTF-8");
            }
            s = s + "&time3=";
            if (wednesdayTimes != null) {
                times = Setter.buildString(wednesdayTimes);
                s = s + URLEncoder.encode(times, "UTF-8");
            }
            s = s + "&time4=";
            if (thursdayTimes != null) {
                times = Setter.buildString(thursdayTimes);
                s = s + URLEncoder.encode(times, "UTF-8");
            }
            s = s + "&time5=";
            if (fridayTimes != null) {
                times = Setter.buildString(fridayTimes);
                s = s + URLEncoder.encode(times, "UTF-8");
            }
            s = s + "&time6=";
            if (saturdayTimes != null) {
                times = Setter.buildString(saturdayTimes);
                s = s + URLEncoder.encode(times, "UTF-8");
            }
            String data = Connection.getData(s);
            Debug.println("REQUEST: " + s);
            Debug.println("DATA: " + data);
            if (data.indexOf("ERROR") != -1) {
                return false;
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return true;
    }

    public static boolean setReserve(String key, String name, String desc, int expires, boolean force) {
        if (key == null) {
            return false;
        }
        try {
            String s = Connection.getComboHeader();
            int pos = key.indexOf(":");
            if (pos != -1) {
                key = key.substring(pos + 1);
            }
            s = s + "?GO=Client::Advisor::reserve";
            s = s + "&key=" + URLEncoder.encode(key, "UTF-8");
            s = s + "&name=" + URLEncoder.encode(name, "UTF-8");
            s = s + "&desc=" + URLEncoder.encode(desc, "UTF-8");
            s = s + "&expires=" + URLEncoder.encode(Integer.toString(expires), "UTF-8");
            s = force ? s + "&force=1" : s + "&force=0";
            String data = Connection.getData(s);
            Debug.println("REQUEST: " + s);
            Debug.println("DATA: " + data);
            if (data.indexOf("ERROR") != -1) {
                return false;
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return true;
    }

    public static boolean setRelease(String key) {
        if (key == null) {
            return false;
        }
        try {
            String s = Connection.getComboHeader();
            int pos = key.indexOf(":");
            if (pos != -1) {
                key = key.substring(pos + 1);
            }
            s = s + "?GO=Client::Advisor::release";
            s = s + "&key=" + URLEncoder.encode(key, "UTF-8");
            String data = Connection.getData(s);
            Debug.println("REQUEST: " + s);
            Debug.println("DATA: " + data);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return true;
    }

    public static LEDControlResultDocument.LEDControlResult blinkArrayLEDs(String deviceID) {
        LEDControlResultDocument.LEDControlResult result = null;
        try {
            String s = Connection.getComboHeader();
            s = s + "?GO=Client::6130Control::blinkArrayLEDs&deviceID=" + URLEncoder.encode(deviceID, "UTF-8");
            String data = Connection.getData(s);
            data = XmlUtil.addHeader(data, "LEDControlResult");
            Debug.println("REQUEST: " + s);
            Debug.println("DATA: " + data);
            LEDControlResultDocument resultDoc = LEDControlResultDocument.Factory.parse((String)data);
            result = resultDoc.getLEDControlResult();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return result;
    }

    public static LEDControlResultDocument.LEDControlResult blinkTrayLEDs(String deviceID, String trayID) {
        LEDControlResultDocument.LEDControlResult result = null;
        try {
            String s = Connection.getComboHeader();
            s = s + "?GO=Client::6130Control::blinkTrayLEDs&deviceID=" + URLEncoder.encode(deviceID, "UTF-8") + "&fruID=" + URLEncoder.encode(trayID, "UTF-8");
            String data = Connection.getData(s);
            data = XmlUtil.addHeader(data, "LEDControlResult");
            Debug.println("REQUEST: " + s);
            Debug.println("DATA: " + data);
            LEDControlResultDocument resultDoc = LEDControlResultDocument.Factory.parse((String)data);
            result = resultDoc.getLEDControlResult();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return result;
    }

    public static LEDControlResultDocument.LEDControlResult blinkDriveLED(String deviceID, String driveID) {
        LEDControlResultDocument.LEDControlResult result = null;
        try {
            String s = Connection.getComboHeader();
            s = s + "?GO=Client::6130Control::blinkDriveLED&deviceID=" + URLEncoder.encode(deviceID, "UTF-8") + "&fruID=" + URLEncoder.encode(driveID, "UTF-8");
            String data = Connection.getData(s);
            data = XmlUtil.addHeader(data, "LEDControlResult");
            Debug.println("REQUEST: " + s);
            Debug.println("DATA: " + data);
            LEDControlResultDocument resultDoc = LEDControlResultDocument.Factory.parse((String)data);
            result = resultDoc.getLEDControlResult();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return result;
    }

    public static LEDControlResultDocument.LEDControlResult stopLEDBlinking(String deviceID) {
        LEDControlResultDocument.LEDControlResult result = null;
        try {
            String s = Connection.getComboHeader();
            s = s + "?GO=Client::6130Control::stopLEDBlinking&deviceID=" + URLEncoder.encode(deviceID, "UTF-8");
            String data = Connection.getData(s);
            data = XmlUtil.addHeader(data, "LEDControlResult");
            Debug.println("REQUEST: " + s);
            Debug.println("DATA: " + data);
            LEDControlResultDocument resultDoc = LEDControlResultDocument.Factory.parse((String)data);
            result = resultDoc.getLEDControlResult();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return result;
    }

    public static ControllerControlResultDocument.ControllerControlResult activateController(String deviceID, String fruID) {
        ControllerControlResultDocument.ControllerControlResult result = null;
        try {
            String s = Connection.getComboHeader();
            s = s + "?GO=Client::6130Control::activateController&deviceID=" + URLEncoder.encode(deviceID, "UTF-8") + "&fruID=" + URLEncoder.encode(fruID, "UTF-8");
            String data = Connection.getData(s);
            data = XmlUtil.addHeader(data, "ControllerControlResult");
            Debug.println("REQUEST: " + s);
            Debug.println("DATA: " + data);
            ControllerControlResultDocument resultDoc = ControllerControlResultDocument.Factory.parse((String)data);
            result = resultDoc.getControllerControlResult();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return result;
    }

    public static ControllerControlResultDocument.ControllerControlResult deactivateController(String deviceID, String fruID) {
        ControllerControlResultDocument.ControllerControlResult result = null;
        try {
            String s = Connection.getComboHeader();
            s = s + "?GO=Client::6130Control::deactivateController&deviceID=" + URLEncoder.encode(deviceID, "UTF-8") + "&fruID=" + URLEncoder.encode(fruID, "UTF-8");
            String data = Connection.getData(s);
            data = XmlUtil.addHeader(data, "ControllerControlResult");
            Debug.println("REQUEST: " + s);
            Debug.println("DATA: " + data);
            ControllerControlResultDocument resultDoc = ControllerControlResultDocument.Factory.parse((String)data);
            result = resultDoc.getControllerControlResult();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return result;
    }

    public static BatteryControlResultDocument.BatteryControlResult resetBattery(String deviceID, String fruID) {
        BatteryControlResultDocument.BatteryControlResult result = null;
        try {
            String s = Connection.getComboHeader();
            s = s + "?GO=Client::6130Control::resetBattery&deviceID=" + URLEncoder.encode(deviceID, "UTF-8") + "&fruID=" + URLEncoder.encode(fruID, "UTF-8");
            String data = Connection.getData(s);
            data = XmlUtil.addHeader(data, "BatteryControlResult");
            Debug.println("REQUEST: " + s);
            Debug.println("DATA: " + data);
            BatteryControlResultDocument resultDoc = BatteryControlResultDocument.Factory.parse((String)data);
            result = resultDoc.getBatteryControlResult();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return result;
    }

    public static SEActionResultDocument.SEActionResult bootSEArray(String array, String password) {
        SEActionResultDocument.SEActionResult result = null;
        try {
            String s = Connection.getComboHeader();
            s = s + "?GO=Client::SEControl::boot_w&array=" + URLEncoder.encode(array, "UTF-8") + "&password=" + URLEncoder.encode(password, "UTF-8");
            String data = Connection.getData(s);
            data = XmlUtil.addHeader(data, "SEActionResult");
            Debug.println("DATA: " + data);
            SEActionResultDocument resultDoc = SEActionResultDocument.Factory.parse((String)data);
            result = resultDoc.getSEActionResult();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return result;
    }

    public static SEActionResultDocument.SEActionResult configureArray(String ipno, boolean config) {
        SEActionResultDocument.SEActionResult result = null;
        try {
            String s = Connection.getComboHeader();
            s = s + "?GO=Client::SEControl::configure&ipno=" + URLEncoder.encode(ipno, "UTF-8");
            if (!config) {
                s = s + "&UNCONF=1";
            }
            String data = Connection.getData(s);
            data = XmlUtil.addHeader(data, "SEActionResult");
            Debug.println("REQUEST: " + s);
            Debug.println("DATA: " + data);
            SEActionResultDocument resultDoc = SEActionResultDocument.Factory.parse((String)data);
            result = resultDoc.getSEActionResult();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return result;
    }

    public static SEActionResultDocument.SEActionResult saveInventory(String file) {
        SEActionResultDocument.SEActionResult result = null;
        try {
            String s = Connection.getComboHeader();
            s = s + "?GO=Client::SEControl::saveInventory&F=" + URLEncoder.encode(file, "UTF-8");
            String data = Connection.getData(s);
            int pos = data.indexOf("XMLSTART");
            if (pos != -1) {
                data = data.substring(pos + 8);
            }
            data = XmlUtil.addHeader(data, "SEActionResult");
            Debug.println("REQUEST: " + s);
            Debug.println("DATA: " + data);
            SEActionResultDocument resultDoc = SEActionResultDocument.Factory.parse((String)data);
            result = resultDoc.getSEActionResult();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return result;
    }

    public static SEActionResultDocument.SEActionResult locateSETray(String deviceID, String fruID, boolean on) {
        SEActionResultDocument.SEActionResult result = null;
        try {
            String s = Connection.getComboHeader();
            s = s + "?GO=Client::SEControl::arrayLocate&deviceID=" + URLEncoder.encode(deviceID, "UTF-8") + "&fruID=" + URLEncoder.encode(fruID, "UTF-8");
            if (!on) {
                s = s + "&NOLOCATE=1";
            }
            String data = Connection.getData(s);
            data = XmlUtil.addHeader(data, "SEActionResult");
            Debug.println("REQUEST: " + s);
            Debug.println("DATA: " + data);
            SEActionResultDocument resultDoc = SEActionResultDocument.Factory.parse((String)data);
            result = resultDoc.getSEActionResult();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return result;
    }

    public static SnapshotResultDocument.SnapshotResult snapshot(String deviceID) {
        SnapshotResultDocument.SnapshotResult result = null;
        try {
            String s = Connection.getRascgiComboHeader();
            s = s + "?GO=Client::Inventory::snapshot&key=" + URLEncoder.encode(deviceID, "UTF-8");
            String data = Connection.getData(s);
            data = XmlUtil.addHeader(data, "SnapshotResult");
            Debug.println("REQUEST: " + s);
            Debug.println("DATA: " + data);
            SnapshotResultDocument resultDoc = SnapshotResultDocument.Factory.parse((String)data);
            result = resultDoc.getSnapshotResult();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return result;
    }

    public static CompareResultDocument.CompareResult compare(String deviceID) {
        CompareResultDocument.CompareResult result = null;
        try {
            String s = Connection.getRascgiComboHeader();
            s = s + "?GO=Client::Inventory::compare&key=" + URLEncoder.encode(deviceID, "UTF-8");
            String data = Connection.getData(s);
            data = XmlUtil.addHeader(data, "CompareResult");
            Debug.println("REQUEST: " + s);
            Debug.println("DATA: " + data);
            CompareResultDocument resultDoc = CompareResultDocument.Factory.parse((String)data);
            result = resultDoc.getCompareResult();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return result;
    }

    public static SEActionResultDocument.SEActionResult runDSPCommand(String deviceID, String command) {
        SEActionResultDocument.SEActionResult result = null;
        try {
            String s = Connection.getComboHeader();
            s = s + "?GO=Client::SEControl::runDSPCommand&deviceID=" + URLEncoder.encode(deviceID, "UTF-8");
            s = s + "&command=" + URLEncoder.encode(command, "UTF-8");
            String data = Connection.getData(s);
            data = XmlUtil.addHeader(data, "SEActionResult");
            Debug.println("REQUEST: " + s);
            Debug.println("DATA: " + data);
            SEActionResultDocument resultDoc = SEActionResultDocument.Factory.parse((String)data);
            result = resultDoc.getSEActionResult();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return result;
    }

    public static SEActionResultDocument.SEActionResult runArrayCommand(String deviceID, String command) {
        SEActionResultDocument.SEActionResult result = null;
        try {
            String s = Connection.getComboHeader();
            s = s + "?GO=Client::SEControl::runArrayCommand&deviceID=" + URLEncoder.encode(deviceID, "UTF-8");
            s = s + "&command=" + URLEncoder.encode(command, "UTF-8");
            String data = Connection.getData(s);
            data = XmlUtil.addHeader(data, "SEActionResult");
            Debug.println("REQUEST: " + s);
            Debug.println("DATA: " + data);
            SEActionResultDocument resultDoc = SEActionResultDocument.Factory.parse((String)data);
            result = resultDoc.getSEActionResult();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return result;
    }

    public static SEActionResultDocument.SEActionResult runHostCommand(String command) {
        SEActionResultDocument.SEActionResult result = null;
        try {
            String s = Connection.getComboHeader();
            s = s + "?GO=Client::SEControl::runHostCommand&command=" + URLEncoder.encode(command, "UTF-8");
            String data = Connection.getData(s);
            data = XmlUtil.addHeader(data, "SEActionResult");
            Debug.println("REQUEST: " + s);
            Debug.println("DATA: " + data);
            SEActionResultDocument resultDoc = SEActionResultDocument.Factory.parse((String)data);
            result = resultDoc.getSEActionResult();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return result;
    }

    public static SEActionResultDocument.SEActionResult deleteARP(String cardNumber) {
        SEActionResultDocument.SEActionResult result = null;
        try {
            String s = Connection.getComboHeader();
            s = s + "?GO=Client::SEControl::deleteARP&cardNumber=" + cardNumber;
            String data = Connection.getData(s);
            data = XmlUtil.addHeader(data, "SEActionResult");
            Debug.println("REQUEST: " + s);
            Debug.println("DATA: " + data);
            SEActionResultDocument resultDoc = SEActionResultDocument.Factory.parse((String)data);
            result = resultDoc.getSEActionResult();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return result;
    }

    public static PingResultDocument.PingResult ping(String slotNumber, boolean isGateway) {
        PingResultDocument.PingResult result = null;
        try {
            String s = Connection.getComboHeader();
            s = isGateway ? s + "?GO=Client::SEControl::pingDefaultGateway&cardNumber=" + slotNumber : s + "?GO=Client::SEControl::pingAllLinks&cardNumber=" + slotNumber;
            String data = Connection.getData(s);
            data = XmlUtil.addHeader(data, "PingResult");
            Debug.println("REQUEST: " + s);
            Debug.println("DATA: " + data);
            PingResultDocument resultDoc = PingResultDocument.Factory.parse((String)data);
            result = resultDoc.getPingResult();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return result;
    }
}

