/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.mgmt.fm.storade.ui.viewbeans.reports;

import com.iplanet.jato.RequestManager;
import com.iplanet.jato.view.ContainerView;
import com.iplanet.jato.view.View;
import com.iplanet.jato.view.event.DisplayEvent;
import com.iplanet.jato.view.event.RequestInvocationEvent;
import com.sun.netstorage.mgmt.fm.storade.schema.Device;
import com.sun.netstorage.mgmt.fm.storade.schema.Value;
import com.sun.netstorage.mgmt.fm.storade.schema.asset.AssetComponent;
import com.sun.netstorage.mgmt.fm.storade.schema.asset.AssetContent;
import com.sun.netstorage.mgmt.fm.storade.schema.asset.AssetResultDocument;
import com.sun.netstorage.mgmt.fm.storade.schema.asset.AssetValue;
import com.sun.netstorage.mgmt.fm.storade.schema.asset.AssetsResultDocument;
import com.sun.netstorage.mgmt.fm.storade.schema.asset.Component;
import com.sun.netstorage.mgmt.fm.storade.ui.common.UIViewBeanBase;
import com.sun.netstorage.mgmt.fm.storade.ui.util.App;
import com.sun.netstorage.mgmt.fm.storade.ui.util.ApplicationsParser;
import com.sun.netstorage.mgmt.fm.storade.ui.util.Connection;
import com.sun.netstorage.mgmt.fm.storade.ui.util.Debug;
import com.sun.netstorage.mgmt.fm.storade.ui.util.SubTask;
import com.sun.netstorage.mgmt.fm.storade.ui.util.SystemUtil;
import com.sun.netstorage.mgmt.fm.storade.ui.util.Task;
import com.sun.netstorage.mgmt.fm.storade.ui.viewbeans.reports.Getter;
import com.sun.web.ui.model.CCNavNode;
import com.sun.web.ui.model.CCNavNodeInterface;
import com.sun.web.ui.model.CCTreeModel;
import com.sun.web.ui.model.CCTreeModelInterface;
import com.sun.web.ui.view.alert.CCAlertInline;
import com.sun.web.ui.view.html.CCStaticTextField;
import com.sun.web.ui.view.tree.CCDynamicTree;
import com.sun.web.ui.view.tree.CCTreeEventHandlerInterface;
import java.io.File;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.StringTokenizer;
import javax.servlet.http.HttpServletRequest;

public class ServiceTreeViewBean
extends UIViewBeanBase
implements CCTreeEventHandlerInterface {
    public static final String PAGE_NAME = "ServiceTree";
    public static final String DEFAULT_DISPLAY_URL = "/jsp/reports/ServiceTree.jsp";
    public static final String CHILD_TEXT = "StaticText";
    public static final String CHILD_TREE = "Tree";
    public static final String CHILD_SCRIPT_TEXT = "ScriptText";
    public static final String CHILD_ALERT = "Alert";
    public static final String CHILD_PAGE_TITLE = "PageTitle";
    public static final String CHILD_INDEX_HREF = "IndexHref";
    public static final String CHILD_LABEL = "Label";
    public static final String CHILD_TESTCASE_HREF = "TestCaseHref";
    public static final String CHILD_TESTCASE_MENU = "TestCaseMenu";
    public static final String JAVASCRIPT_HEADER = "javascript:";
    private ArrayList services;
    public static final int MAX_SERVICE_NUMBER = 100;
    public static final long RELOAD_TIME = 180000L;
    private static CCTreeModel model = null;
    private static long lastUpdateTime = 0L;
    private static boolean onPopulating = false;
    private static String logMessage = "";
    private String logMessage2 = "";
    private static boolean hasFailure = false;
    private boolean hasFailure2 = false;
    private HashMap reportPool = new HashMap();

    public ServiceTreeViewBean() {
        super(PAGE_NAME, DEFAULT_DISPLAY_URL);
        this.init();
        this.registerChildren();
    }

    protected void registerChildren() {
        this.registerChild(CHILD_TREE, CCDynamicTree.class);
        this.registerChild(CHILD_SCRIPT_TEXT, CCStaticTextField.class);
        this.registerChild(CHILD_ALERT, CCAlertInline.class);
    }

    protected View createChild(String name) {
        if (name.equals(CHILD_SCRIPT_TEXT)) {
            CCStaticTextField child = new CCStaticTextField((ContainerView)this, name, null);
            return child;
        }
        if (name.equals(CHILD_ALERT)) {
            CCAlertInline child = new CCAlertInline((ContainerView)this, name, null);
            return child;
        }
        if (name.equals(CHILD_TREE)) {
            long currentTime = System.currentTimeMillis();
            if (!(lastUpdateTime != 0L && currentTime - lastUpdateTime <= 180000L || onPopulating)) {
                this.populateModel();
            }
            CCDynamicTree child = new CCDynamicTree((CCTreeEventHandlerInterface)this, name, (CCTreeModelInterface)model);
            return child;
        }
        throw new IllegalArgumentException("Invalid child name [" + name + "]");
    }

    public void beginDisplay(DisplayEvent event) {
        CCNavNodeInterface node;
        HttpServletRequest request = RequestManager.getRequestContext().getRequest();
        String pageName = request.getParameter("pageName");
        String devName = request.getParameter("devName");
        String fruName = request.getParameter("fruName");
        if ("NULL".equals(pageName)) {
            pageName = null;
        }
        if ("NULL".equals(devName)) {
            devName = null;
        }
        if ("NULL".equals(fruName)) {
            fruName = null;
        }
        if (hasFailure) {
            this.displayAlert("error", "error.serviceTree", null, logMessage, null);
        }
        if (pageName != null && (node = this.getNode(pageName, devName, fruName)) != null) {
            ((CCDynamicTree)this.getChild(CHILD_TREE)).yokeTo(node.getId());
            this.setDisplayFieldValue(CHILD_SCRIPT_TEXT, "<script language=\"JavaScript1.2\"> " + node.getOnClick().substring(JAVASCRIPT_HEADER.length(), node.getOnClick().indexOf(";") + 1) + "</script>");
        }
    }

    public void nodeClicked(RequestInvocationEvent event, int nodeID, String treeName) {
        if (nodeID == 0) {
            this.populateModel();
        }
        this.forwardTo(this.getRequestContext());
    }

    public void turnerClicked(RequestInvocationEvent event, int nodeID, String treeName) {
        this.forwardTo(this.getRequestContext());
    }

    private void init() {
        if (this.services == null) {
            String serviceConfigDir = "/WEB-INF/";
            String fullServiceConfigDir = RequestManager.getRequestContext().getServletContext().getRealPath(serviceConfigDir);
            if (fullServiceConfigDir == null) {
                fullServiceConfigDir = serviceConfigDir;
            }
            File dir = new File(fullServiceConfigDir);
            File[] files = dir.listFiles();
            for (int i = 0; i < files.length; ++i) {
                File f = files[i];
                Debug.println("get file " + f.toString());
                if (SystemUtil.isSystemEdition() && f.toString().indexOf("services-se") == -1 || !SystemUtil.isSystemEdition() && f.toString().indexOf("services-ee") == -1) continue;
                String fullPath = f.toString();
                try {
                    ApplicationsParser ap = new ApplicationsParser();
                    if (this.services == null) {
                        this.services = ap.parse(fullPath);
                        continue;
                    }
                    this.services.addAll(ap.parse(fullPath));
                    continue;
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                    throw new IllegalStateException("Problem occurs when reading applications.xml file at " + fullPath + "/n");
                }
            }
        }
    }

    private CCNavNodeInterface getNode(String pageName, String devName, String fruName) {
        if (model == null) {
            this.populateModel();
        }
        try {
            pageName = "=" + URLEncoder.encode(pageName, "UTF-8");
        }
        catch (Exception ex) {
            ex.printStackTrace();
            pageName = "=" + pageName;
        }
        List nodes = model.getNodes();
        return this.findNode(nodes, pageName, devName, fruName);
    }

    private CCNavNodeInterface findNode(List nodes, String pageName, String devName, String fruName) {
        if (nodes == null || pageName == null) {
            return null;
        }
        for (int i = 0; i < nodes.size(); ++i) {
            CCNavNodeInterface ret;
            CCNavNodeInterface n = (CCNavNodeInterface)nodes.get(i);
            if (n.getOnClick() != null && n.getOnClick().indexOf(pageName) != -1) {
                if (n.getValue() == null) {
                    return n;
                }
                if (this.isInNodeValue(devName, n.getValue())) {
                    return n;
                }
                if (this.isInNodeValue(fruName, n.getValue()) && n.getParent() != null && this.isInNodeValue(devName, n.getParent().getValue())) {
                    return n;
                }
            }
            if ((ret = this.findNode(n.getChildren(), pageName, devName, fruName)) == null) continue;
            return ret;
        }
        return null;
    }

    private void populateModel() {
        onPopulating = true;
        try {
            Debug.println("load tree model ...");
            lastUpdateTime = System.currentTimeMillis();
            CCTreeModel model2 = new CCTreeModel();
            CCNavNode root = new CCNavNode(0, "serviceAdvisor", "serviceAdvisor", null);
            root.setAsRoot();
            model2.addNode((CCNavNodeInterface)root);
            root.setExpanded(true);
            HttpServletRequest request = RequestManager.getRequestContext().getRequest();
            Locale locale = request.getLocale();
            AssetsResultDocument.AssetsResult result = Getter.getSimpleAssets();
            if (result == null) {
                model = model2;
                logMessage = this.logMessage2 + "Get device list ... Failed <br>";
                hasFailure = true;
                onPopulating = false;
                return;
            }
            this.logMessage2 = this.logMessage2 + "Get device list ... Done <br>";
            Device[] devices = result.getDEVICES().getDEVICEArray();
            for (int i = 0; i < this.services.size(); ++i) {
                App app = (App)this.services.get(i);
                CCNavNode n = new CCNavNode(i + 1, app.name, app.name, null);
                if (app.navMap != null) {
                    n.setOnClick(this.buildLink(app.navMap.defaultTarget, null, null, null, null, null, null, null, this.getBoolean(app.checkPassword)));
                } else {
                    n.setNotClickable(true);
                }
                n.setExpanded(true);
                root.addChild((CCNavNodeInterface)n);
                int j = 0;
                for (j = 0; j < app.tasks.size(); ++j) {
                    Task task = (Task)app.tasks.get(j);
                    CCNavNode nn = new CCNavNode((i + 1) * 100 + j, task.name, task.name, null);
                    if (task.navMap != null) {
                        nn.setOnClick(this.buildLink(task.navMap.defaultTarget, null, null, null, null, null, null, null, this.getBoolean(task.checkPassword) || this.getBoolean(app.checkPassword)));
                    } else {
                        nn.setNotClickable(true);
                    }
                    nn.setExpanded(true);
                    n.addChild((CCNavNodeInterface)nn);
                    int k = 0;
                    for (k = 0; k < task.subTasks.size(); ++k) {
                        SubTask subTask = (SubTask)task.subTasks.get(k);
                        CCNavNode nnn = new CCNavNode((i + 1) * 100 * 100 + j * 100 + k, subTask.name, subTask.name, null);
                        if (subTask.navMap != null) {
                            nnn.setOnClick(this.buildLink(subTask.navMap.defaultTarget, null, null, null, null, null, null, null, this.getBoolean(subTask.checkPassword) || this.getBoolean(task.checkPassword) || this.getBoolean(app.checkPassword)));
                        } else {
                            nnn.setNotClickable(true);
                        }
                        nnn.setExpanded(true);
                        nn.addChild((CCNavNodeInterface)nnn);
                        int numContextSubTask = 0;
                        if (subTask.useContext != null && subTask.navMap != null) {
                            numContextSubTask = this.addNodeForContext(nnn, subTask.useContext, subTask.navMap.defaultTarget, result, (i + 1) * 100 * 100 * 100 + j * 100 * 100 + k * 100, this.getBoolean(subTask.checkPassword) || this.getBoolean(task.checkPassword) || this.getBoolean(app.checkPassword));
                            nnn.setNotClickable(true);
                            nnn.setOnClick(null);
                            nnn.setExpanded(false);
                            continue;
                        }
                        nnn.setAcceptsChildren(false);
                    }
                    int numContextTask = 0;
                    if (task.useContext != null && task.navMap != null) {
                        numContextTask = this.addNodeForContext(nn, task.useContext, task.navMap.defaultTarget, result, (i + 1) * 100 * 100 + j * 100 + k, this.getBoolean(task.checkPassword) || this.getBoolean(app.checkPassword));
                        nn.setNotClickable(true);
                        nn.setOnClick(null);
                        nn.setExpanded(false);
                        continue;
                    }
                    if (task.subTasks.size() != 0) continue;
                    nn.setAcceptsChildren(false);
                }
                int numContextApp = 0;
                if (app.useContext != null && app.navMap != null) {
                    numContextApp = this.addNodeForContext(n, app.useContext, app.navMap.defaultTarget, result, (i + 1) * 100 + j, this.getBoolean(app.checkPassword));
                    n.setNotClickable(true);
                    n.setExpanded(false);
                    continue;
                }
                if (app.tasks.size() != 0) continue;
                n.setAcceptsChildren(false);
            }
            model = model2;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            model = new CCTreeModel();
            CCNavNode root = new CCNavNode(0, "serviceAdvisor", "serviceAdvisor", null);
            root.setAsRoot();
            model.addNode((CCNavNodeInterface)root);
            root.setExpanded(true);
            this.logMessage2 = this.logMessage2 + "get unexpected exception, please check the log.<br>";
            this.hasFailure2 = true;
        }
        hasFailure = this.hasFailure2;
        logMessage = this.logMessage2;
        onPopulating = false;
    }

    private int addNodeForContext(CCNavNode node, String useContext, String link, AssetsResultDocument.AssetsResult result, int startNum, boolean passwd) {
        if (result == null || useContext == null || node == null || link == null) {
            return 0;
        }
        int ret = 0;
        String deviceType = null;
        String fruType = null;
        String fruType2 = null;
        String fruProp = null;
        if (useContext.indexOf(":") != -1) {
            deviceType = useContext.substring(0, useContext.indexOf(":"));
            String tmp = useContext.substring(useContext.indexOf(":") + 1);
            if (tmp.startsWith("(") && tmp.endsWith(")")) {
                fruType2 = tmp.substring(1, tmp.length() - 1);
            } else {
                fruType = tmp;
                if (fruType.indexOf("[") != -1) {
                    fruProp = fruType.substring(fruType.indexOf("[") + 1, fruType.indexOf("]"));
                    fruType = fruType.substring(0, fruType.indexOf("["));
                }
            }
        } else {
            deviceType = useContext;
        }
        Device[] devices = result.getDEVICES().getDEVICEArray();
        if (devices != null) {
            for (int i = 0; i < devices.length; ++i) {
                AssetComponent port;
                String s2;
                AssetValue[] a_values;
                String state;
                String hKey;
                String type2;
                String key2;
                String name2;
                int jj;
                Component[] components;
                Value[] values = devices[i].getVALUEArray();
                String type = null;
                String name = "";
                String key = null;
                if (values != null) {
                    for (int j = 0; j < values.length; ++j) {
                        String s = values[j].getID();
                        if ("type".equals(s)) {
                            type = values[j].getStringValue();
                            continue;
                        }
                        if ("key".equals(s)) {
                            key = values[j].getStringValue();
                            continue;
                        }
                        if (!"name".equals(s)) continue;
                        name = values[j].getStringValue();
                    }
                }
                String deviceID = type + ":" + key;
                if (type == null || !type.equals(deviceType)) continue;
                if (fruType == null) {
                    CCNavNode n = new CCNavNode(startNum++, name, name, null, false);
                    n.setOnClick(this.buildLink(link, name, deviceID, null, null, null, deviceType, fruType2, passwd));
                    n.setValue(this.buildNodeValue(name, key));
                    node.addChild((CCNavNodeInterface)n);
                    ++ret;
                    continue;
                }
                if (fruType == null) continue;
                AssetResultDocument.AssetResult a_result = (AssetResultDocument.AssetResult)this.reportPool.get(deviceID);
                if (a_result == null) {
                    Set keys = this.reportPool.keySet();
                    if (!keys.contains(deviceID)) {
                        a_result = Getter.getSimpleReportDetails(deviceID);
                        this.reportPool.put(deviceID, a_result);
                        if (a_result != null) {
                            this.logMessage2 = this.logMessage2 + "Get device report " + deviceID + " ... Done <br>";
                        } else {
                            this.logMessage2 = this.logMessage2 + "Get device report " + deviceID + " ... Failed <br>";
                            this.hasFailure2 = true;
                        }
                    }
                    if (a_result == null) continue;
                }
                AssetContent content = null;
                if (a_result.getReport() != null) {
                    content = a_result.getReport().getContent();
                }
                if (content == null) continue;
                int startNum2 = 0;
                CCNavNode n = new CCNavNode(startNum, name, name, null, true);
                node.addChild((CCNavNodeInterface)n);
                n.setValue(this.buildNodeValue(name, key));
                n.setNotClickable(true);
                ++ret;
                AssetComponent fru = content.getFRU();
                AssetComponent comp = content.getCOMPONENT();
                ArrayList<CCNavNode> subNodeArray = new ArrayList<CCNavNode>();
                if (comp != null) {
                    components = comp.getCOMPONENTArray();
                    for (jj = 0; jj < components.length; ++jj) {
                        name2 = "";
                        key2 = null;
                        type2 = null;
                        hKey = "";
                        state = "";
                        name2 = key2 = components[jj].getID();
                        a_values = components[jj].getValueArray();
                        if (a_values != null) {
                            for (int k = 0; k < a_values.length; ++k) {
                                s2 = a_values[k].getID();
                                if ("type".equals(s2)) {
                                    type2 = a_values[k].getStringValue();
                                    continue;
                                }
                                if ("name".equals(s2)) {
                                    name2 = a_values[k].getStringValue();
                                    name2 = this.translateName(name2);
                                    continue;
                                }
                                if ("keyValue".equals(s2)) {
                                    hKey = a_values[k].getStringValue();
                                    continue;
                                }
                                if (fruProp == null || !fruProp.equals(s2)) continue;
                                state = a_values[k].getStringValue();
                            }
                        }
                        if (!this.isFruTypeIncluded(fruType, type2)) continue;
                        CCNavNode nn = new CCNavNode(startNum * 100 + startNum2, this.getNameState(name2, state), name2, null, false);
                        ++startNum2;
                        nn.setValue(this.buildNodeValue(name2, key2));
                        nn.setOnClick(this.buildLink(link, name, deviceID, name2, key2, hKey, deviceType, type2, passwd));
                        subNodeArray.add(nn);
                        ++ret;
                    }
                }
                if (fru != null) {
                    components = fru.getCOMPONENTArray();
                    for (jj = 0; jj < components.length; ++jj) {
                        name2 = "";
                        key2 = null;
                        type2 = null;
                        hKey = "";
                        state = "";
                        name2 = key2 = components[jj].getID();
                        a_values = components[jj].getValueArray();
                        if (a_values != null) {
                            for (int k = 0; k < a_values.length; ++k) {
                                s2 = a_values[k].getID();
                                if ("type".equals(s2)) {
                                    type2 = a_values[k].getStringValue();
                                    continue;
                                }
                                if ("name".equals(s2)) {
                                    name2 = a_values[k].getStringValue();
                                    name2 = this.translateName(name2);
                                    continue;
                                }
                                if ("keyValue".equals(s2)) {
                                    hKey = a_values[k].getStringValue();
                                    continue;
                                }
                                if (fruProp == null || !fruProp.equals(s2)) continue;
                                state = a_values[k].getStringValue();
                            }
                        }
                        if (!this.isFruTypeIncluded(fruType, type2)) continue;
                        CCNavNode nn = new CCNavNode(startNum * 100 + startNum2, this.getNameState(name2, state), name2, null, false);
                        ++startNum2;
                        nn.setOnClick(this.buildLink(link, name, deviceID, name2, key2, hKey, deviceType, type2, passwd));
                        nn.setValue(this.buildNodeValue(name2, key2));
                        subNodeArray.add(nn);
                        ++ret;
                    }
                }
                if (this.isFruTypeIncluded(fruType, "port") && (port = content.getPORT()) != null) {
                    Component[] components2 = port.getCOMPONENTArray();
                    for (int m = 0; m < components2.length; ++m) {
                        String name22 = key2 = components2[m].getID();
                        String type22 = "";
                        String hKey2 = "";
                        String state2 = "";
                        AssetValue[] a_values2 = components2[m].getValueArray();
                        if (a_values2 != null) {
                            for (int k = 0; k < a_values2.length; ++k) {
                                String s22 = a_values2[k].getID();
                                if ("type".equals(s22)) {
                                    type22 = a_values2[k].getStringValue();
                                    continue;
                                }
                                if ("name".equals(s22)) {
                                    name22 = a_values2[k].getStringValue();
                                    continue;
                                }
                                if ("keyValue".equals(s22)) {
                                    hKey2 = a_values2[k].getStringValue();
                                    continue;
                                }
                                if (fruProp == null || !fruProp.equals(s22)) continue;
                                state2 = a_values2[k].getStringValue();
                            }
                        }
                        CCNavNode nn = new CCNavNode(startNum * 100 + startNum2, this.getNameState(name22, state2), name22, null, false);
                        nn.setValue(this.buildNodeValue(name22, key2));
                        ++startNum2;
                        nn.setOnClick(this.buildLink(link, name, deviceID, name22, key2, hKey2, deviceType, "port", passwd));
                        subNodeArray.add(nn);
                        ++ret;
                    }
                }
                ++startNum;
                if (subNodeArray.size() <= 0) continue;
                MyComparator myComparator = new MyComparator("asc");
                Collections.sort(subNodeArray, myComparator);
                for (int t = 0; t < subNodeArray.size(); ++t) {
                    n.addChild((CCNavNodeInterface)((CCNavNode)subNodeArray.get(t)));
                }
            }
        }
        return ret;
    }

    private boolean getBoolean(String booleanStr) {
        return "true".equals(booleanStr);
    }

    private String buildLink(String in, String deviceName, String deviceID, String fruName, String fruID, String fruKey, String deviceType, String fruType, boolean passwd) {
        if (in == null) {
            return null;
        }
        String s = null;
        String handler = "";
        handler = passwd ? "/reports/ServicePassword" : "/reports/ServiceFile";
        try {
            s = "javascript:top.advisor.location='/" + Connection.getAppName() + handler + "?location=" + URLEncoder.encode(in, "UTF-8") + "'; return false;";
            if (deviceName != null && deviceID != null && fruName != null && fruID != null) {
                s = "javascript:top.advisor.location='/" + Connection.getAppName() + handler + "?location=" + URLEncoder.encode(in, "UTF-8") + "&deviceName=" + URLEncoder.encode(deviceName, "UTF-8") + "&deviceID=" + URLEncoder.encode(deviceID, "UTF-8") + "&fruName=" + URLEncoder.encode(fruName, "UTF-8") + "&fruID=" + URLEncoder.encode(fruID, "UTF-8") + "&fruKey=" + URLEncoder.encode(fruKey, "UTF-8");
                if (deviceType != null) {
                    s = s + "&deviceType=" + URLEncoder.encode(deviceType, "UTF-8");
                }
                if (fruType != null) {
                    s = s + "&fruType=" + URLEncoder.encode(fruType, "UTF-8");
                }
                s = s + "'; return false;";
            } else if (deviceName != null && deviceID != null) {
                s = "javascript:top.advisor.location='/" + Connection.getAppName() + handler + "?location=" + URLEncoder.encode(in, "UTF-8") + "&deviceName=" + URLEncoder.encode(deviceName, "UTF-8") + "&deviceID=" + URLEncoder.encode(deviceID, "UTF-8");
                if (deviceType != null) {
                    s = s + "&deviceType=" + URLEncoder.encode(deviceType, "UTF-8");
                }
                if (fruType != null) {
                    s = s + "&fruType=" + URLEncoder.encode(fruType, "UTF-8");
                }
                s = s + "'; return false;";
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return s;
    }

    private String buildNodeValue(String name, String key) {
        return "|" + name + "|" + key + "|";
    }

    private boolean isInNodeValue(String in, String nodeValue) {
        if (nodeValue == null || in == null) {
            return false;
        }
        StringTokenizer st = new StringTokenizer(nodeValue, "|");
        while (st.hasMoreTokens()) {
            String v = st.nextToken();
            if (!in.equals(v) && !in.startsWith(v + ".")) continue;
            return true;
        }
        return false;
    }

    private boolean isFruTypeIncluded(String fruTypeCombo, String fruType) {
        if (fruTypeCombo == null || fruType == null) {
            return false;
        }
        fruTypeCombo = "," + fruTypeCombo + ",";
        return fruTypeCombo.indexOf("," + fruType + ",") != -1;
    }

    private void displayAlert(String category, String summary, String[] summaryArg, String detail, String[] detailArg) {
        ((CCAlertInline)this.getChild(CHILD_ALERT)).setValue((Object)category);
        if (summary != null) {
            if (summaryArg != null) {
                ((CCAlertInline)this.getChild(CHILD_ALERT)).setSummary(summary, (Object[])summaryArg);
            } else {
                ((CCAlertInline)this.getChild(CHILD_ALERT)).setSummary(summary);
            }
        }
        if (detail != null) {
            if (detailArg != null) {
                ((CCAlertInline)this.getChild(CHILD_ALERT)).setDetail(detail, (Object[])detailArg);
            } else {
                ((CCAlertInline)this.getChild(CHILD_ALERT)).setDetail(detail);
            }
        }
    }

    private String getNameState(String name, String state) {
        if (state == null || "".equals(state.trim())) {
            return name;
        }
        return name + " (" + state + ")";
    }

    private String translateName(String in) {
        if (in == null) {
            return in;
        }
        if (in.endsWith(".Midplane")) {
            in = in.substring(0, in.indexOf(".Midplane"));
        }
        return in;
    }

    private class MyComparator
    implements Comparator {
        private String sortRule;

        public MyComparator(String sortRule) {
            this.sortRule = sortRule;
        }

        public int compare(Object o1, Object o2) {
            try {
                String prop1 = ((CCNavNode)o1).getLabel();
                String prop2 = ((CCNavNode)o2).getLabel();
                if (this.sortRule.equals("desc")) {
                    if (prop1 == null) {
                        return 1;
                    }
                    if (prop2 == null) {
                        return -1;
                    }
                    return prop1.compareTo(prop2) * -1;
                }
                if (prop1 == null) {
                    return -1;
                }
                if (prop2 == null) {
                    return 1;
                }
                return prop1.compareTo(prop2);
            }
            catch (Exception ex) {
                ex.printStackTrace();
                return -1;
            }
        }

        public boolean equals(Object obj) {
            return false;
        }
    }
}

