/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.mgmt.fm.storade.ui.viewbeans.reports;

import com.sun.netstorage.mgmt.fm.storade.schema.asset.ExceptionReportElement;
import com.sun.netstorage.mgmt.fm.storade.schema.asset.ExceptionReportResultDocument;
import com.sun.netstorage.mgmt.fm.storade.ui.model.ActionTableModel;
import com.sun.netstorage.mgmt.fm.storade.ui.util.AbbreviationUtil;
import java.util.Locale;

public class ExceptionReportDataHelper {
    private ExceptionReportDataHelper() {
    }

    private static String getFRU(String fru) {
        String result = fru;
        int index = fru.indexOf(46);
        if (index != -1) {
            result = result.substring(0, index);
        }
        return result;
    }

    public static String getDate(ExceptionReportResultDocument.ExceptionReportResult result) {
        String date = null;
        if (result != null) {
            date = result.getSTATUS().getLASTRUN();
        }
        return date;
    }

    public static String getStatusDetail(ExceptionReportResultDocument.ExceptionReportResult result) {
        String statusDetail = null;
        if (result != null) {
            statusDetail = result.getSTATUS().getSTATUSDETAIL();
        }
        return statusDetail;
    }

    public static void populateReportTable(ExceptionReportResultDocument.ExceptionReportResult result, ActionTableModel tableModel, Locale locale) {
        ExceptionReportElement[] elements;
        if (result != null && result.getELEMENTS() != null && (elements = result.getELEMENTS().getELEMENTArray()) != null) {
            for (int i = 0; i < elements.length; ++i) {
                if (i != 0) {
                    tableModel.appendRow();
                }
                tableModel.setValue("device", elements[i].getDEVICE());
                tableModel.setValue("deviceType", AbbreviationUtil.getAbbreviation(elements[i].getTYPE(), 2, locale));
                tableModel.setValue("fruType", elements[i].getFRUTYPE());
                tableModel.setValue("fru", ExceptionReportDataHelper.getFRU(elements[i].getFRU()));
                tableModel.setValue("desc", elements[i].getDESCRIPTION());
                tableModel.setValue("currentvalue", elements[i].getCURRENTVALUE());
                tableModel.setValue("defaultvalue", elements[i].getDEFAULTVALUE());
            }
        }
    }
}

