/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.mgmt.fm.storade.ui.viewbeans.reports;

import com.iplanet.jato.model.DefaultModel;
import com.sun.netstorage.mgmt.fm.storade.schema.Device;
import com.sun.netstorage.mgmt.fm.storade.schema.Event;
import com.sun.netstorage.mgmt.fm.storade.schema.Value;
import com.sun.netstorage.mgmt.fm.storade.schema.asset.ARPResultDocument;
import com.sun.netstorage.mgmt.fm.storade.schema.asset.AssetComponent;
import com.sun.netstorage.mgmt.fm.storade.schema.asset.AssetContent;
import com.sun.netstorage.mgmt.fm.storade.schema.asset.AssetId;
import com.sun.netstorage.mgmt.fm.storade.schema.asset.AssetLogical;
import com.sun.netstorage.mgmt.fm.storade.schema.asset.AssetResultDocument;
import com.sun.netstorage.mgmt.fm.storade.schema.asset.AssetSummary;
import com.sun.netstorage.mgmt.fm.storade.schema.asset.AssetSystem;
import com.sun.netstorage.mgmt.fm.storade.schema.asset.AssetValue;
import com.sun.netstorage.mgmt.fm.storade.schema.asset.AssetsResultDocument;
import com.sun.netstorage.mgmt.fm.storade.schema.asset.CompareDelete;
import com.sun.netstorage.mgmt.fm.storade.schema.asset.CompareInsert;
import com.sun.netstorage.mgmt.fm.storade.schema.asset.CompareResultDocument;
import com.sun.netstorage.mgmt.fm.storade.schema.asset.CompareUpdate;
import com.sun.netstorage.mgmt.fm.storade.schema.asset.Component;
import com.sun.netstorage.mgmt.fm.storade.schema.asset.ComponentContent;
import com.sun.netstorage.mgmt.fm.storade.schema.asset.ComponentResultDocument;
import com.sun.netstorage.mgmt.fm.storade.schema.asset.DSPNetworkConfigResultDocument;
import com.sun.netstorage.mgmt.fm.storade.schema.asset.DeviceCompare;
import com.sun.netstorage.mgmt.fm.storade.schema.asset.FruCompare;
import com.sun.netstorage.mgmt.fm.storade.schema.asset.MonitoringResultDocument;
import com.sun.netstorage.mgmt.fm.storade.schema.asset.PingResultDocument;
import com.sun.netstorage.mgmt.fm.storade.schema.asset.SECompareResultDocument;
import com.sun.netstorage.mgmt.fm.storade.schema.asset.SEListArrayResultDocument;
import com.sun.netstorage.mgmt.fm.storade.ui.common.AlarmConstants;
import com.sun.netstorage.mgmt.fm.storade.ui.model.ActionTableModel;
import com.sun.netstorage.mgmt.fm.storade.ui.util.AbbreviationUtil;
import com.sun.netstorage.mgmt.fm.storade.ui.util.DateUtil;
import com.sun.netstorage.mgmt.fm.storade.ui.util.Debug;
import com.sun.netstorage.mgmt.fm.storade.ui.util.DelimUtil;
import com.sun.netstorage.mgmt.fm.storade.ui.util.DeviceUtil;
import com.sun.netstorage.mgmt.fm.storade.ui.util.LocalizeUtil;
import com.sun.netstorage.mgmt.fm.storade.ui.util.NavUtil;
import com.sun.netstorage.mgmt.fm.storade.ui.util.StateUtil;
import com.sun.netstorage.mgmt.fm.storade.ui.util.StringUtil;
import com.sun.netstorage.mgmt.fm.storade.ui.util.VolumeUtil;
import com.sun.netstorage.mgmt.fm.storade.ui.viewbeans.reports.Getter;
import com.sun.netstorage.mgmt.fm.storade.ui.viewbeans.reports.Setter;
import com.sun.web.ui.model.CCPropertySheetModel;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Locale;
import java.util.Properties;
import java.util.Set;
import java.util.StringTokenizer;

public class AssetsDataHelper {
    private static final String POOL = "pool";
    static final String ID = "id.name";
    static final String VALUE_ID = "id";
    static final String VALUE_STATE = "state";
    static final String VALUE_STATUS = "status";
    static final String VALUE_AVAILABILITY = "availability";
    static final String VALUE_REVISION = "revision";
    static final String VALUE_SERIAL = "serial";
    static final String VALUE_NAME = "name";
    static final String VALUE_DISKS = "disks";
    static final String VALUE_CAPACITY = "capacity";
    static final String VALUE_RAID_LEVEL = "raidLevel";
    static final String VALUE_SOURCE_POOL = "sourcePool";
    static final String VALUE_WWN = "wwn";
    static final String VALUE_TYPE_TYPE = "type";
    static final String VALUE_SUMMARY = "summary";
    private static final String SETUP_ACTIVE = "active";
    private static final String SETUP_TYPE = "type";
    private static final String SETUP_KEY = "key";
    private static final String SETUP_NAME = "name";
    private static final String SETUP_WWN = "wwn";
    private static final String SETUP_PASSWORD = "telnet";
    private static final String SETUP_HOST = "host";
    static final String VALUE_TYPE = "value";
    private static final String TYPE_HOST = "host";
    private static final String TYPE_HBA_SWITCH = "hbaswitch";
    private static final String TYPE_HBA_STORAGE = "hbastorage";
    private static final String SYSTEM = "system.";
    private static final String INFO = "info.";
    private static final String[] VOL_VERIFY_ARRAYS = new String[]{"t3", "6020", "6120"};
    private static final String ALARM_HREF = "alarmHREF";
    private static final String ALARM = "alarms";
    private static String[] defaultColumns = new String[]{"state", "status", "revision", "serial", "name"};
    private static String[] defaultColumnsValues = new String[]{"componentState", "componentStatus", "componentRevision", "componentSerialNumber", "componentName"};
    private static final String[] NAME_KEYS = new String[]{"._ElementName", ".ElementName", ".name"};

    private AssetsDataHelper() {
    }

    private static int countAlarmsByDev(Event[] events, int severity, String assetID) {
        int n = 0;
        if (events != null) {
            for (int i = 0; i < events.length; ++i) {
                int s = Integer.parseInt(events[i].getSeverity());
                if (!assetID.equals(events[i].getKey()) || s != severity) continue;
                ++n;
            }
        }
        return n;
    }

    private static void addAlarmsToDevice(String assetID, String assetName, DefaultModel tableModel, Event[] events) {
        String key = assetID;
        int index = key.indexOf(58);
        if (index != -1) {
            key = key.substring(index + 1);
        }
        int downAlarmsByDev = AssetsDataHelper.countAlarmsByDev(events, 3, key);
        int criticalAlarmsByDev = AssetsDataHelper.countAlarmsByDev(events, 2, key);
        int majorAlarmsByDev = AssetsDataHelper.countAlarmsByDev(events, 1, key);
        int minorAlarmsByDev = AssetsDataHelper.countAlarmsByDev(events, Integer.MIN_VALUE, key);
        String str = DelimUtil.compose(ALARM_HREF, new String[]{assetID, assetName});
        if (downAlarmsByDev != 0) {
            tableModel.setValue(ALARM_HREF, (Object)str);
            tableModel.setValue(ALARM, (Object)AlarmConstants.getSeverityObject(3));
        } else if (criticalAlarmsByDev != 0) {
            tableModel.setValue(ALARM_HREF, (Object)str);
            tableModel.setValue(ALARM, (Object)AlarmConstants.getSeverityObject(2));
        } else if (majorAlarmsByDev != 0) {
            tableModel.setValue(ALARM_HREF, (Object)str);
            tableModel.setValue(ALARM, (Object)AlarmConstants.getSeverityObject(1));
        } else if (minorAlarmsByDev != 0) {
            tableModel.setValue(ALARM_HREF, (Object)str);
            tableModel.setValue(ALARM, (Object)AlarmConstants.getSeverityObject(Integer.MIN_VALUE));
        } else {
            tableModel.setValue(ALARM_HREF, null);
            tableModel.setValue(ALARM, null);
        }
    }

    public static void populateAssets(AssetsResultDocument.AssetsResult result, String agent, ActionTableModel tableModel, Locale locale) throws IllegalArgumentException {
        ArrayList<String> keysList = new ArrayList<String>();
        boolean rowAdded = false;
        String localhost = "";
        try {
            localhost = InetAddress.getLocalHost().getHostName();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        Event[] events = result.getALARMS().getEventArray();
        HashMap<String, AssetSummary> map = new HashMap<String, AssetSummary>();
        AssetSummary[] assets = result.getREPORTLIST().getReportArray();
        if (assets != null) {
            int i;
            for (i = 0; i < assets.length; ++i) {
                AssetSummary asset = assets[i];
                String type = DeviceUtil.getDeviceType(asset.getKey());
                if (!TYPE_HBA_SWITCH.equals(type) && !TYPE_HBA_STORAGE.equals(type) || agent != null && !agent.equals(asset.getHost())) continue;
                if (rowAdded) {
                    tableModel.appendRow();
                }
                String currentID = asset.getKey();
                String name = asset.getName();
                keysList.add(DelimUtil.aggregate(new String[]{currentID, name}));
                tableModel.setValue("monitorStr", "-");
                tableModel.setValue("hostStr", asset.getHost());
                tableModel.setValue("nameStr", asset.getName());
                tableModel.setValue("typeStr", AbbreviationUtil.getAbbreviation(asset.getType(), 1, locale));
                tableModel.setValue("idStr", asset.getWwn());
                tableModel.setValue("lastProbeStr", DateUtil.toDate1(asset.getDate()));
                tableModel.setValue("AssetDetailsStoradeHREF", NavUtil.compose(new String[]{asset.getKey(), asset.getHost()}));
                AssetsDataHelper.addAlarmsToDevice(asset.getKey(), asset.getName(), (DefaultModel)tableModel, events);
                rowAdded = true;
            }
            for (i = 0; i < assets.length; ++i) {
                String key = assets[i].getKey();
                map.put(key, assets[i]);
            }
        }
        HashMap<String, String> map2 = new HashMap<String, String>();
        Device[] devices = result.getDEVICES().getDEVICEArray();
        if (devices != null) {
            for (int i = 0; i < devices.length; ++i) {
                String active = null;
                String dtype = null;
                String key = null;
                String name = null;
                String wwn = null;
                String host = null;
                Value[] values = devices[i].getVALUEArray();
                if (values == null) continue;
                for (int j = 0; j < values.length; ++j) {
                    String s = values[j].getID();
                    if (SETUP_ACTIVE.equals(s)) {
                        active = values[j].getStringValue();
                        continue;
                    }
                    if ("type".equals(s)) {
                        dtype = values[j].getStringValue();
                        continue;
                    }
                    if (SETUP_KEY.equals(s)) {
                        key = values[j].getStringValue();
                        continue;
                    }
                    if ("name".equals(s)) {
                        name = values[j].getStringValue();
                        continue;
                    }
                    if ("wwn".equals(s)) {
                        wwn = values[j].getStringValue();
                        continue;
                    }
                    if (!"host".equals(s) || (host = values[j].getStringValue()) != null && !"".equals(host.trim())) continue;
                    host = localhost;
                }
                String currentID = dtype + ":" + key;
                Debug.println("Device ID: " + currentID);
                if (map2.get(currentID) != null) continue;
                map2.put(currentID, currentID);
                AssetSummary asset = (AssetSummary)map.get(currentID);
                Debug.println("Found matching asset: " + asset);
                String monitorStatus = "N".equals(active) ? LocalizeUtil.getLocalizedString("assets.unmonitored", locale) : LocalizeUtil.getLocalizedString("assets.monitored", locale);
                if (wwn == null && asset != null) {
                    wwn = asset.getWwn();
                }
                if (wwn == null || "".equals(wwn)) {
                    wwn = key;
                }
                if (name == null && asset != null) {
                    name = asset.getName();
                }
                String monitoringAgent = null;
                monitoringAgent = asset != null ? asset.getHost() : host;
                if (agent != null && !agent.equals(monitoringAgent)) continue;
                if (rowAdded) {
                    tableModel.appendRow();
                }
                keysList.add(DelimUtil.aggregate(new String[]{currentID, name}));
                if (asset == null) {
                    tableModel.setValue("monitorStr", monitorStatus);
                    tableModel.setValue("hostStr", monitoringAgent);
                    tableModel.setValue("nameStr", name);
                    tableModel.setValue("typeStr", AbbreviationUtil.getAbbreviation(dtype, 1, locale));
                    tableModel.setValue("idStr", wwn);
                    tableModel.setValue("AssetDetailsStoradeHREF", NavUtil.compose(new String[]{currentID, null}));
                    tableModel.setValue("lastProbeStr", null);
                    AssetsDataHelper.addAlarmsToDevice(currentID, name, (DefaultModel)tableModel, events);
                } else {
                    tableModel.setValue("monitorStr", monitorStatus);
                    tableModel.setValue("hostStr", monitoringAgent);
                    tableModel.setValue("nameStr", name);
                    tableModel.setValue("typeStr", AbbreviationUtil.getAbbreviation(asset.getType(), 1, locale));
                    tableModel.setValue("idStr", wwn);
                    tableModel.setValue("lastProbeStr", DateUtil.toDate1(asset.getDate()));
                    tableModel.setValue("AssetDetailsStoradeHREF", NavUtil.compose(new String[]{asset.getKey(), monitoringAgent}));
                    AssetsDataHelper.addAlarmsToDevice(asset.getKey(), asset.getName(), (DefaultModel)tableModel, events);
                }
                rowAdded = true;
            }
        }
        String[] keysArray = new String[keysList.size()];
        keysList.toArray(keysArray);
        tableModel.setKeys(keysArray);
    }

    public static String[] getAgentNames(AssetsResultDocument.AssetsResult result) {
        HashMap<String, String> map = new HashMap<String, String>();
        String[] agentsArray = null;
        if (result != null) {
            Device[] devices;
            AssetSummary[] assets = result.getREPORTLIST().getReportArray();
            if (assets != null) {
                for (int i = 0; i < assets.length; ++i) {
                    map.put(assets[i].getHost(), assets[i].getHost());
                }
            }
            if ((devices = result.getDEVICES().getDEVICEArray()) != null) {
                for (int i = 0; i < devices.length; ++i) {
                    String host = null;
                    Value[] values = devices[i].getVALUEArray();
                    if (values != null) {
                        for (int j = 0; j < values.length; ++j) {
                            String s = values[j].getID();
                            if (!"host".equals(s)) continue;
                            host = values[j].getStringValue();
                        }
                    }
                    if (host == null) continue;
                    map.put(host, host);
                }
            }
            Set keys = map.keySet();
            agentsArray = new String[keys.size()];
            keys.toArray(agentsArray);
        }
        return agentsArray;
    }

    public static boolean isReportAvailable(AssetResultDocument.AssetResult result) {
        boolean available = false;
        if (result.getReport() != null && result.getReport().getContent() != null) {
            available = true;
        }
        return available;
    }

    public static Component[] getAllComponents(AssetResultDocument.AssetResult result) {
        Component[] components = null;
        if (result != null) {
            AssetContent content = result.getReport().getContent();
            ArrayList<Component> componentList = new ArrayList<Component>();
            if (content != null) {
                AssetLogical logical;
                AssetComponent port;
                AssetComponent comp;
                Component[] c;
                AssetComponent fru = content.getFRU();
                if (fru != null && (c = fru.getCOMPONENTArray()) != null) {
                    componentList.addAll(Arrays.asList(c));
                }
                if ((comp = content.getCOMPONENT()) != null && (c = comp.getCOMPONENTArray()) != null) {
                    componentList.addAll(Arrays.asList(c));
                }
                if ((port = content.getPORT()) != null && (c = port.getCOMPONENTArray()) != null) {
                    componentList.addAll(Arrays.asList(c));
                }
                if ((logical = content.getLOGICAL()) != null && (c = logical.getCOMPONENTArray()) != null) {
                    componentList.addAll(Arrays.asList(c));
                }
            }
            components = new Component[componentList.size()];
            componentList.toArray(components);
        }
        return components;
    }

    public static String[] getColumnHeaders(AssetResultDocument.AssetResult result, String type) {
        if (result == null || type == null) {
            return null;
        }
        String[] headers = null;
        LinkedHashSet<String> set = new LinkedHashSet<String>();
        if (result.getReport() == null) {
            return null;
        }
        AssetContent content = result.getReport().getContent();
        if (content != null) {
            Component[] components = AssetsDataHelper.getAllComponents(result);
            if (components == null) {
                return null;
            }
            for (int j = 0; j < components.length; ++j) {
                String currentType = components[j].getID();
                String name = components[j].getID();
                int index = currentType.indexOf(46);
                if (index != -1) {
                    currentType = currentType.substring(0, index);
                }
                if (!type.equals(currentType)) continue;
                AssetValue[] values = components[j].getValueArray();
                for (int k = 0; k < values.length; ++k) {
                    String value;
                    String s = values[k].getID();
                    if (!VALUE_SUMMARY.equals(s) || (value = values[k].getStringValue()) == null) continue;
                    StringTokenizer st = new StringTokenizer(value, ",");
                    while (st.hasMoreTokens()) {
                        String column = st.nextToken();
                        set.add(column);
                    }
                }
            }
        }
        headers = new String[set.size()];
        set.toArray(headers);
        return headers;
    }

    private static void populate(DefaultModel componentModel, String assetID, String type, Component[] components, String[] columns) {
        String[] selectedColumns = defaultColumns;
        String[] selectedColumnsValues = defaultColumnsValues;
        if (columns != null && columns.length != 0) {
            selectedColumns = columns;
            selectedColumnsValues = columns;
        }
        for (int j = 0; j < components.length; ++j) {
            String currentType = components[j].getID();
            String name = components[j].getID();
            int index = currentType.indexOf(46);
            if (index != -1) {
                currentType = currentType.substring(0, index);
            }
            if (!type.equals(currentType)) continue;
            componentModel.appendRow();
            for (int ll = 0; ll < selectedColumns.length; ++ll) {
                componentModel.setValue(selectedColumnsValues[ll], (Object)"-");
            }
            componentModel.setValue("componentName", (Object)name);
            AssetValue[] values = components[j].getValueArray();
            block2: for (int k = 0; k < values.length; ++k) {
                String s = values[k].getID();
                for (int l = 0; l < selectedColumns.length; ++l) {
                    if (!selectedColumns[l].equals(s)) continue;
                    String value = values[k].getStringValue();
                    if (VALUE_STATE.equals(s)) {
                        value = StateUtil.getState(value);
                    }
                    value = StringUtil.toBlank(value);
                    componentModel.setValue(selectedColumnsValues[l], (Object)value);
                    if (!"componentName".equals(selectedColumnsValues[l])) continue block2;
                    name = value;
                    continue block2;
                }
            }
            String s = DelimUtil.aggregate(new String[]{assetID, components[j].getID(), name});
            componentModel.setValue("componentHREF", (Object)s);
        }
    }

    public static String populateComponentSummaryModel(AssetResultDocument.AssetResult result, DefaultModel componentModel, String assetID, String type, String[] columns) throws IllegalArgumentException {
        AssetComponent port;
        AssetComponent compo;
        Component[] components;
        AssetComponent fru;
        if (result == null || result.getReport() == null) {
            return null;
        }
        AssetContent content = result.getReport().getContent();
        if (content == null) {
            return null;
        }
        String assetName = "";
        AssetId ids = content.getID();
        if (ids != null) {
            AssetValue[] idValues = ids.getValueArray();
            for (int j = 0; j < idValues.length; ++j) {
                String s = idValues[j].getID();
                if (!ID.equals(s)) continue;
                assetName = idValues[j].getStringValue();
                break;
            }
        }
        if ((fru = content.getFRU()) != null) {
            components = fru.getCOMPONENTArray();
            AssetsDataHelper.populate(componentModel, assetID, type, components, columns);
        }
        if ((compo = content.getCOMPONENT()) != null) {
            components = compo.getCOMPONENTArray();
            AssetsDataHelper.populate(componentModel, assetID, type, components, columns);
        }
        if ((port = content.getPORT()) != null) {
            components = port.getCOMPONENTArray();
            AssetsDataHelper.populate(componentModel, assetID, type, components, columns);
        }
        return assetName;
    }

    private static String getID(String s) {
        if (s == null) {
            return s;
        }
        int index = s.indexOf(46);
        if (index != -1) {
            s = s.substring(index + 1);
        }
        return s;
    }

    private static String formatDiskString(String s) {
        if (s == null) {
            return s;
        }
        if (s.startsWith(",")) {
            s = s.substring(1, s.length() - 1);
        }
        if (s.endsWith(",")) {
            s = s.substring(0, s.length() - 1);
        }
        s = s.replaceAll(",", ", ");
        s = s.replaceAll("\"", "");
        return s;
    }

    public static String populatePoolSummaryModel(AssetResultDocument.AssetResult result, DefaultModel componentModel, String assetID, String[] type, Locale locale) {
        AssetLogical logical;
        if (result == null || result.getReport() == null) {
            return null;
        }
        AssetContent content = result.getReport().getContent();
        String assetName = "";
        AssetId ids = content.getID();
        if (ids != null) {
            AssetValue[] idValues = ids.getValueArray();
            for (int j = 0; j < idValues.length; ++j) {
                String s = idValues[j].getID();
                if (!ID.equals(s)) continue;
                assetName = idValues[j].getStringValue();
                break;
            }
        }
        if ((logical = content.getLOGICAL()) == null) {
            return null;
        }
        Component[] components = logical.getCOMPONENTArray();
        for (int j = 0; j < components.length; ++j) {
            String currentType = components[j].getID();
            String name = components[j].getID();
            int index = currentType.indexOf(46);
            if (index != -1) {
                currentType = currentType.substring(0, index);
                name = name.substring(index + 1);
            }
            boolean doMatch = false;
            if (type != null) {
                for (int k = 0; k < type.length; ++k) {
                    if (!type[k].equals(currentType)) continue;
                    doMatch = true;
                    break;
                }
            }
            if (!doMatch) continue;
            componentModel.appendRow();
            componentModel.setValue("poolValue", (Object)name);
            AssetValue[] values = components[j].getValueArray();
            String id = components[j].getID();
            String poolStatusValue = "-";
            String poolStateValue = "-";
            String poolValue = "-";
            String disksValue = "-";
            String capacityValue = "-";
            String raidLevelValue = "-";
            for (int k = 0; k < values.length; ++k) {
                String s = values[k].getID();
                if (VALUE_STATUS.equals(s)) {
                    poolStatusValue = values[k].getStringValue();
                    continue;
                }
                if (VALUE_STATE.equals(s)) {
                    poolStateValue = values[k].getStringValue();
                    continue;
                }
                if ("name".equals(s)) {
                    name = values[k].getStringValue();
                    poolValue = values[k].getStringValue();
                    continue;
                }
                if (VALUE_DISKS.equals(s)) {
                    disksValue = AssetsDataHelper.formatDiskString(values[k].getStringValue());
                    continue;
                }
                if (VALUE_CAPACITY.equals(s)) {
                    capacityValue = VolumeUtil.convert(values[k].getStringValue(), locale);
                    continue;
                }
                if (VALUE_RAID_LEVEL.equals(s)) {
                    raidLevelValue = values[k].getStringValue();
                    continue;
                }
                if (!VALUE_ID.equals(s)) continue;
                id = values[k].getStringValue();
            }
            componentModel.setValue("poolStatusValue", (Object)poolStatusValue);
            componentModel.setValue("poolStateValue", (Object)poolStateValue);
            componentModel.setValue("poolValue", (Object)poolValue);
            componentModel.setValue("disksValue", (Object)disksValue);
            componentModel.setValue("capacityValue", (Object)capacityValue);
            componentModel.setValue("raidLevelValue", (Object)raidLevelValue);
            String s = DelimUtil.aggregate(new String[]{assetID, id, name});
            componentModel.setValue("poolHREF", (Object)s);
        }
        return assetName;
    }

    private static String findPoolForVolume(String id, AssetResultDocument.AssetResult result) {
        String idWWN = id;
        String idName = id;
        int index1 = idWWN.indexOf(58);
        if (index1 != -1) {
            idWWN = idWWN.substring(index1 + 1);
        }
        AssetContent content = result.getReport().getContent();
        AssetLogical logical = content.getLOGICAL();
        Component[] components = logical.getCOMPONENTArray();
        for (int j = 0; j < components.length; ++j) {
            String currentType = components[j].getID();
            String name = components[j].getID();
            int index = currentType.indexOf(46);
            if (index != -1) {
                currentType = currentType.substring(0, index);
                name = name.substring(index + 1);
            }
            if (!POOL.equals(currentType)) continue;
            boolean found = false;
            AssetValue[] values = components[j].getValueArray();
            for (int k = 0; k < values.length; ++k) {
                found = false;
                String s = values[k].getID();
                if ("wwn".equals(s)) {
                    String wwn = values[k].getStringValue();
                    if (!idWWN.equals(wwn)) continue;
                    found = true;
                    continue;
                }
                if (!"name".equals(s)) continue;
                idName = values[k].getStringValue();
            }
            if (found) break;
        }
        return idName;
    }

    public static String populateVolumeSummaryModel(AssetResultDocument.AssetResult result, DefaultModel componentModel, String assetID, String type, Locale locale) {
        AssetLogical logical;
        if (result == null || result.getReport() == null) {
            return null;
        }
        AssetContent content = result.getReport().getContent();
        String assetName = "";
        AssetId ids = content.getID();
        if (ids != null) {
            AssetValue[] idValues = ids.getValueArray();
            for (int j = 0; j < idValues.length; ++j) {
                String s = idValues[j].getID();
                if (!ID.equals(s)) continue;
                assetName = idValues[j].getStringValue();
                break;
            }
        }
        if ((logical = content.getLOGICAL()) == null) {
            return null;
        }
        Component[] components = logical.getCOMPONENTArray();
        for (int j = 0; j < components.length; ++j) {
            String currentType = components[j].getID();
            String name = components[j].getID();
            int index = currentType.indexOf(46);
            if (index != -1) {
                currentType = currentType.substring(0, index);
                name = name.substring(index + 1);
            }
            if (!type.equals(currentType)) continue;
            componentModel.appendRow();
            componentModel.setValue("volumeValue", (Object)name);
            componentModel.setValue("volumeStatusValue", (Object)StringUtil.toBlank(null));
            componentModel.setValue("volumeValue", (Object)StringUtil.toBlank(null));
            componentModel.setValue("poolrefValue", (Object)StringUtil.toBlank(null));
            componentModel.setValue("poolrefValue", (Object)StringUtil.toBlank(null));
            AssetValue[] values = components[j].getValueArray();
            for (int k = 0; k < values.length; ++k) {
                String s = values[k].getID();
                if (VALUE_STATUS.equals(s)) {
                    componentModel.setValue("volumeStatusValue", (Object)values[k].getStringValue());
                    continue;
                }
                if ("name".equals(s)) {
                    name = values[k].getStringValue();
                    componentModel.setValue("volumeValue", (Object)values[k].getStringValue());
                    continue;
                }
                if (VALUE_SOURCE_POOL.equals(s)) {
                    String poolID = values[k].getStringValue();
                    poolID = AssetsDataHelper.findPoolForVolume(poolID, result);
                    componentModel.setValue("poolrefValue", (Object)poolID);
                    continue;
                }
                if (!"slices".equals(s)) continue;
                componentModel.setValue("poolrefValue", (Object)AssetsDataHelper.formatDiskString(values[k].getStringValue()));
            }
            String s = DelimUtil.aggregate(new String[]{assetID, components[j].getID(), name});
            componentModel.setValue("volumeHREF", (Object)s);
        }
        return null;
    }

    public static String populateDSPVolumeSummaryModel(AssetResultDocument.AssetResult result, DefaultModel componentModel, String assetID, String type, String[] columns, Locale locale) {
        if (result == null || result.getReport() == null) {
            return null;
        }
        AssetContent content = result.getReport().getContent();
        AssetLogical logical = content.getLOGICAL();
        if (logical == null) {
            return null;
        }
        String[] selectedColumns = new String[]{"name", VALUE_STATUS, "slices"};
        String[] selectedColumnsValues = new String[]{"volumeValue", "volumeStatusValue", "poolrefValue"};
        if (columns != null && columns.length != 0) {
            selectedColumns = columns;
            selectedColumnsValues = columns;
        }
        Component[] components = logical.getCOMPONENTArray();
        for (int j = 0; j < components.length; ++j) {
            String currentType = components[j].getID();
            String name = components[j].getID();
            int index = currentType.indexOf(46);
            if (index != -1) {
                currentType = currentType.substring(0, index);
                name = name.substring(index + 1);
            }
            if (!type.equals(currentType)) continue;
            componentModel.appendRow();
            componentModel.setValue("volumeValue", (Object)name);
            AssetValue[] values = components[j].getValueArray();
            block1: for (int k = 0; k < values.length; ++k) {
                String s = values[k].getID();
                for (int l = 0; l < selectedColumns.length; ++l) {
                    if (!selectedColumns[l].equals(s)) continue;
                    String value = values[k].getStringValue();
                    if (VALUE_STATE.equals(s)) {
                        value = StateUtil.getState(value);
                    }
                    if ("name".equals(s)) {
                        name = value;
                    }
                    value = StringUtil.toBlank(value);
                    componentModel.setValue(selectedColumnsValues[l], (Object)value);
                    continue block1;
                }
            }
            String s = DelimUtil.aggregate(new String[]{assetID, components[j].getID(), name});
            componentModel.setValue("volumeHREF", (Object)s);
        }
        return null;
    }

    public static String populateHBASummaryModel(AssetResultDocument.AssetResult result, DefaultModel componentModel, String assetID, String type, Locale locale) {
        AssetComponent port;
        if (result == null || result.getReport() == null) {
            return null;
        }
        AssetContent content = result.getReport().getContent();
        String assetName = "";
        AssetId ids = content.getID();
        if (ids != null) {
            AssetValue[] idValues = ids.getValueArray();
            for (int j = 0; j < idValues.length; ++j) {
                String s = idValues[j].getID();
                if (!ID.equals(s)) continue;
                assetName = idValues[j].getStringValue();
                break;
            }
        }
        if ((port = content.getFRU()) == null) {
            return null;
        }
        Component[] components = port.getCOMPONENTArray();
        for (int j = 0; j < components.length; ++j) {
            String currentType = components[j].getID();
            String name = components[j].getID();
            int index = currentType.indexOf(46);
            if (index != -1) {
                currentType = currentType.substring(0, index);
                name = name.substring(index + 1);
            }
            if (!type.equals(currentType)) continue;
            componentModel.appendRow();
            componentModel.setValue("hbaValue", (Object)name);
            componentModel.setValue("revisionValue", (Object)StringUtil.toBlank(null));
            componentModel.setValue("logicalPathValue", (Object)StringUtil.toBlank(null));
            AssetValue[] values = components[j].getValueArray();
            for (int k = 0; k < values.length; ++k) {
                String s = values[k].getID();
                if (VALUE_STATE.equals(s)) {
                    componentModel.setValue("hbaStateValue", (Object)values[k].getStringValue());
                    continue;
                }
                if ("name".equals(s)) {
                    name = values[k].getStringValue();
                    componentModel.setValue("hbaValue", (Object)values[k].getStringValue());
                    continue;
                }
                if (VALUE_REVISION.equals(s)) {
                    componentModel.setValue("revisionValue", (Object)values[k].getStringValue());
                    continue;
                }
                if (!"keyValue".equals(s)) continue;
                componentModel.setValue("logicalPathValue", (Object)values[k].getStringValue());
            }
            String s = DelimUtil.aggregate(new String[]{assetID, components[j].getID(), name});
            componentModel.setValue("hbaHREF", (Object)s);
        }
        return null;
    }

    public static String populateLogicalComponentSummaryModel(AssetResultDocument.AssetResult result, DefaultModel componentModel, String assetID, String type) throws IllegalArgumentException {
        AssetContent content = result.getReport().getContent();
        String assetName = "";
        AssetId ids = content.getID();
        if (ids != null) {
            AssetValue[] idValues = ids.getValueArray();
            for (int j = 0; j < idValues.length; ++j) {
                String s = idValues[j].getID();
                if (!ID.equals(s)) continue;
                assetName = idValues[j].getStringValue();
                break;
            }
        }
        AssetLogical logical = content.getLOGICAL();
        Component[] components = logical.getCOMPONENTArray();
        for (int j = 0; j < components.length; ++j) {
            String currentType = components[j].getID();
            Object name = components[j].getID();
            int index = currentType.indexOf(46);
            if (index != -1) {
                currentType = currentType.substring(0, index);
                name = ((String)name).substring(index + 1);
            }
            try {
                name = Integer.valueOf((String)name);
            }
            catch (Exception ex) {
                // empty catch block
            }
            if (!type.equals(currentType)) continue;
            componentModel.appendRow();
            componentModel.setValue("componentName", name);
            componentModel.setValue("componentStatus", (Object)StringUtil.toBlank(null));
            componentModel.setValue("componentLogicalName", (Object)StringUtil.toBlank(null));
            AssetValue[] values = components[j].getValueArray();
            for (int k = 0; k < values.length; ++k) {
                String s = values[k].getID();
                if (VALUE_STATUS.equals(s)) {
                    componentModel.setValue("componentStatus", (Object)values[k].getStringValue());
                    continue;
                }
                if (!"name".equals(s)) continue;
                componentModel.setValue("componentLogicalName", (Object)values[k].getStringValue());
            }
            String s = DelimUtil.aggregate(new String[]{assetID, components[j].getID(), name.toString()});
            componentModel.setValue("componentHREF", (Object)s);
        }
        return assetName;
    }

    public static void populateComponentTableModel(ComponentResultDocument.ComponentResult result, DefaultModel componentModel, String key, String comp, Locale locale) throws IllegalArgumentException {
        ComponentContent content = result.getReport().getContent();
        ComponentContent.Value[] values = content.getValueArray();
        if (values != null) {
            boolean rowAdded = false;
            for (int i = 0; i < values.length; ++i) {
                if (rowAdded) {
                    componentModel.appendRow();
                }
                String prop = DeviceUtil.getPropertyName(values[i].getID());
                prop = "host".equals(DeviceUtil.getDeviceType(key)) && comp != null && (comp.startsWith("storage") || comp.startsWith("switch")) ? DeviceUtil.getLocalizedKeyForInbandDevice(prop, locale) : DeviceUtil.getLocalizedKey(DeviceUtil.getDeviceType(key), prop, locale);
                if (DeviceUtil.isDisplayableProperty(prop)) {
                    rowAdded = true;
                    prop = StringUtil.toPropFormat(prop);
                    componentModel.setValue("propertyName", (Object)prop);
                    componentModel.setValue("propertyValue", (Object)values[i].getStringValue());
                    continue;
                }
                rowAdded = false;
            }
        }
    }

    public static String getComponentName(ComponentResultDocument.ComponentResult result, String key, String comp) throws IllegalArgumentException {
        String name = null;
        ComponentContent content = result.getReport().getContent();
        ComponentContent.Value[] values = content.getValueArray();
        if (values != null) {
            block0: for (int i = 0; i < NAME_KEYS.length; ++i) {
                for (int j = 0; j < values.length; ++j) {
                    String prop = values[j].getID();
                    if (!prop.endsWith(NAME_KEYS[i])) continue;
                    name = values[j].getStringValue();
                    break block0;
                }
            }
        }
        return name;
    }

    public static void removeDevice(String key) throws Exception {
        if (key == null) {
            throw new IllegalArgumentException("at least one parameter is null");
        }
        Setter.remove(key);
    }

    public static void populateSetupPropertySheetModel(MonitoringResultDocument.MonitoringResult result, CCPropertySheetModel propertySheetModel, String assetID, String type) throws IllegalArgumentException {
        String active = null;
        String dtype = null;
        String key = null;
        String name = null;
        String password = null;
        Device[] devices = result.getDEVICES().getDEVICEArray();
        if (devices != null) {
            for (int i = 0; i < devices.length; ++i) {
                Value[] values = devices[i].getVALUEArray();
                if (values == null) continue;
                name = null;
                password = null;
                for (int j = 0; j < values.length; ++j) {
                    String s = values[j].getID();
                    if (SETUP_ACTIVE.equals(s)) {
                        active = values[j].getStringValue();
                        continue;
                    }
                    if ("type".equals(s)) {
                        dtype = values[j].getStringValue();
                        continue;
                    }
                    if (SETUP_KEY.equals(s)) {
                        key = values[j].getStringValue();
                        continue;
                    }
                    if ("name".equals(s)) {
                        name = values[j].getStringValue();
                        continue;
                    }
                    if (!SETUP_PASSWORD.equals(s)) continue;
                    password = Getter.decodePassword(values[j].getStringValue());
                }
                String currentID = dtype + ":" + key;
                if (!assetID.equals(currentID)) continue;
                Debug.println("Found matching device: " + assetID);
                String v = "true";
                if ("N".equals(active)) {
                    v = "false";
                }
                propertySheetModel.setValue("MonitorValue", (Object)v);
                propertySheetModel.setValue("DeviceNameValue", (Object)name);
                propertySheetModel.setValue("PasswordValue", (Object)password);
                break;
            }
        }
    }

    public static String getMonitoringAgent(String key) {
        Device[] devices;
        if (key == null) {
            return null;
        }
        String agent = null;
        AssetsResultDocument.AssetsResult result = Getter.getAssets();
        AssetSummary[] assets = result.getREPORTLIST().getReportArray();
        if (assets != null) {
            for (int i = 0; i < assets.length; ++i) {
                AssetSummary asset = assets[i];
                if (!asset.getKey().equals(key)) continue;
                agent = asset.getHost();
                Debug.println("Found Agent: " + agent + " monitoring: " + key);
                break;
            }
        }
        if (agent == null && (devices = result.getDEVICES().getDEVICEArray()) != null) {
            for (int i = 0; i < devices.length; ++i) {
                String dkey = null;
                String host = null;
                String dtype = null;
                Value[] values = devices[i].getVALUEArray();
                if (values != null) {
                    for (int j = 0; j < values.length; ++j) {
                        String s = values[j].getID();
                        if ("host".equals(s)) {
                            host = values[j].getStringValue();
                            continue;
                        }
                        if ("type".equals(s)) {
                            dtype = values[j].getStringValue();
                            continue;
                        }
                        if (!SETUP_KEY.equals(s)) continue;
                        dkey = values[j].getStringValue();
                    }
                }
                if (!key.equals(dtype + ":" + dkey)) continue;
                agent = host;
                Debug.println("Found Agent: " + agent + " monitoring: " + dtype + ":" + dkey);
                break;
            }
        }
        return agent;
    }

    public static String populateSystemParameters(AssetResultDocument.AssetResult result, DefaultModel assetSysParamsModel, String assetID, Locale locale) {
        AssetSystem system;
        AssetId ids;
        String name = "";
        AssetContent content = null;
        if (result.getReport() != null && (ids = (content = result.getReport().getContent()).getID()) != null) {
            AssetValue[] idValues = ids.getValueArray();
            for (int j = 0; j < idValues.length; ++j) {
                String s = idValues[j].getID();
                if (!ID.equals(s)) continue;
                name = idValues[j].getStringValue();
                break;
            }
        }
        if ((system = content.getStorageSystem()) != null) {
            AssetValue[] systemValues = system.getValueArray();
            boolean rowAdded = false;
            for (int j = 0; j < systemValues.length; ++j) {
                String prop;
                if (rowAdded) {
                    assetSysParamsModel.appendRow();
                }
                if ((prop = systemValues[j].getID()).startsWith(SYSTEM)) {
                    prop = prop.substring(SYSTEM.length());
                }
                if (prop.startsWith(INFO)) {
                    prop = prop.substring(INFO.length());
                }
                if (DeviceUtil.isDisplayableProperty(prop = DeviceUtil.getLocalizedKey(DeviceUtil.getDeviceType(assetID), prop, locale))) {
                    rowAdded = true;
                    prop = StringUtil.toPropFormat(prop);
                    assetSysParamsModel.setValue("propertyName", (Object)prop);
                    assetSysParamsModel.setValue("propertyValue", (Object)systemValues[j].getStringValue());
                    continue;
                }
                rowAdded = false;
            }
        }
        return name;
    }

    static boolean isVolVerifyNeeded(AssetsResultDocument.AssetsResult result) {
        if (result == null) {
            return false;
        }
        Device[] devices = result.getDEVICES().getDEVICEArray();
        if (devices != null) {
            for (int i = 0; i < devices.length; ++i) {
                Value[] values = devices[i].getVALUEArray();
                if (values == null) continue;
                for (int j = 0; j < values.length; ++j) {
                    String s = values[j].getID();
                    if (!"type".equals(s)) continue;
                    String type = values[j].getStringValue();
                    for (int k = 0; k < VOL_VERIFY_ARRAYS.length; ++k) {
                        if (!VOL_VERIFY_ARRAYS[k].equals(type)) continue;
                        return true;
                    }
                }
            }
        }
        return false;
    }

    public static void populateFruList(AssetResultDocument.AssetResult result, DefaultModel model, String fruType, Locale locale) {
        if (result == null) {
            return;
        }
        AssetContent content = result.getReport().getContent();
        boolean tableStart = false;
        if (content != null) {
            AssetComponent fru = content.getFRU();
            if (fru != null) {
                Component[] components = fru.getCOMPONENTArray();
                for (int j = 0; j < components.length; ++j) {
                    String s = components[j].getID();
                    Properties p = new Properties();
                    AssetValue[] values = components[j].getValueArray();
                    if (values == null) continue;
                    for (int k = 0; k < values.length; ++k) {
                        p.setProperty(values[k].getID(), values[k].getStringValue());
                    }
                    if (fruType != null && !fruType.equals(p.getProperty("type"))) continue;
                    if (tableStart) {
                        model.appendRow();
                    }
                    tableStart = true;
                    model.setValue("nameValue", (Object)p.getProperty("name"));
                    model.setValue("stateValue", (Object)("state." + p.getProperty(VALUE_STATE)));
                    model.setValue("statusValue", (Object)p.getProperty(VALUE_STATUS));
                    model.setValue("revisionValue", (Object)p.getProperty(VALUE_REVISION));
                    model.setValue("serialValue", (Object)p.getProperty(VALUE_SERIAL));
                }
            }
            AssetComponent comp = content.getCOMPONENT();
            if (fru != null) {
                Component[] components = comp.getCOMPONENTArray();
                for (int j = 0; j < components.length; ++j) {
                    String s = components[j].getID();
                    Properties p = new Properties();
                    AssetValue[] values = components[j].getValueArray();
                    if (values == null) continue;
                    for (int k = 0; k < values.length; ++k) {
                        p.setProperty(values[k].getID(), values[k].getStringValue());
                    }
                    if (fruType != null && !fruType.equals(p.getProperty("type"))) continue;
                    if (tableStart) {
                        model.appendRow();
                    }
                    tableStart = true;
                    model.setValue("nameValue", (Object)p.getProperty("name"));
                    model.setValue("stateValue", (Object)p.getProperty(VALUE_STATE));
                    model.setValue("statusValue", (Object)p.getProperty(VALUE_STATUS));
                    model.setValue("availabilityValue", (Object)p.getProperty("avail"));
                    model.setValue("modelValue", (Object)p.getProperty("model"));
                    model.setValue("revisionValue", (Object)p.getProperty(VALUE_REVISION));
                }
            }
        }
    }

    public static boolean populateInsertModel(CompareResultDocument.CompareResult result, DefaultModel insertModel) throws IllegalArgumentException {
        if (result == null || insertModel == null) {
            return false;
        }
        if (result.getINVENTORY().getINSERTArray() == null || result.getINVENTORY().getINSERTArray().length == 0) {
            return false;
        }
        for (int i = 0; i < result.getINVENTORY().getINSERTArray().length; ++i) {
            CompareInsert insert = result.getINVENTORY().getINSERTArray()[i];
            if (i != 0) {
                insertModel.appendRow();
            }
            insertModel.setValue("insertNameStr", (Object)insert.getFULLTOPIC());
            insertModel.setValue("insertSerialStr", (Object)insert.getSERIAL());
        }
        return true;
    }

    public static boolean populateDeleteModel(CompareResultDocument.CompareResult result, DefaultModel deleteModel) throws IllegalArgumentException {
        if (result == null || deleteModel == null) {
            return false;
        }
        if (result.getINVENTORY().getDELETEArray() == null || result.getINVENTORY().getDELETEArray().length == 0) {
            return false;
        }
        for (int i = 0; i < result.getINVENTORY().getDELETEArray().length; ++i) {
            CompareDelete delete = result.getINVENTORY().getDELETEArray()[i];
            if (i != 0) {
                deleteModel.appendRow();
            }
            deleteModel.setValue("deleteNameStr", (Object)delete.getFULLTOPIC());
            deleteModel.setValue("deleteSerialStr", (Object)delete.getSERIAL());
        }
        return true;
    }

    public static void populateDSPNetworkConfigModels(DSPNetworkConfigResultDocument.DSPNetworkConfigResult result, DefaultModel linksModel, DefaultModel configModel, DefaultModel portModel, Locale locale) throws IllegalArgumentException {
        int i;
        if (result == null || linksModel == null || configModel == null || portModel == null) {
            return;
        }
        for (i = 0; i < result.getLINKS().getVALUEArray().length; ++i) {
            Value link = result.getLINKS().getVALUEArray()[i];
            if (i != 0) {
                linksModel.appendRow();
            }
            linksModel.setValue("ipStr", (Object)link.getID());
            linksModel.setValue("statusStr", (Object)link.getStringValue());
        }
        for (i = 0; i < result.getCONFIG().getVALUEArray().length; ++i) {
            Value config = result.getCONFIG().getVALUEArray()[i];
            if (i != 0) {
                configModel.appendRow();
            }
            configModel.setValue("configNameStr", (Object)("dsp.networkConfig." + config.getID()));
            configModel.setValue("configValueStr", (Object)config.getStringValue());
        }
        for (i = 0; i < result.getPORT().getVALUEArray().length; ++i) {
            Value port = result.getPORT().getVALUEArray()[i];
            if (i != 0) {
                portModel.appendRow();
            }
            portModel.setValue("portNameStr", (Object)("dsp.port." + port.getID()));
            portModel.setValue("portValueStr", (Object)port.getStringValue());
        }
    }

    public static void populateDSPARPModels(ARPResultDocument.ARPResult result, DefaultModel ARPModel, Locale locale) throws IllegalArgumentException {
        if (result == null || ARPModel == null) {
            return;
        }
        for (int i = 0; i < result.getARP().getVALUEArray().length; ++i) {
            Value arp = result.getARP().getVALUEArray()[i];
            if (i != 0) {
                ARPModel.appendRow();
            }
            ARPModel.setValue("ipStr", (Object)arp.getID());
            ARPModel.setValue("macStr", (Object)arp.getStringValue());
        }
    }

    public static boolean populateUpdateModel(CompareResultDocument.CompareResult result, DefaultModel updateModel) throws IllegalArgumentException {
        if (result == null || updateModel == null) {
            return false;
        }
        if (result.getINVENTORY().getUPDATEArray() == null || result.getINVENTORY().getUPDATEArray().length == 0) {
            return false;
        }
        for (int i = 0; i < result.getINVENTORY().getUPDATEArray().length; ++i) {
            CompareUpdate update = result.getINVENTORY().getUPDATEArray()[i];
            if (i != 0) {
                updateModel.appendRow();
            }
            updateModel.setValue("nameStr", (Object)update.getCOMPONENT());
            updateModel.setValue("serialStr", (Object)update.getSERIAL());
            updateModel.setValue("availStr", (Object)update.getAVAILABILITY());
            updateModel.setValue("oldAvailStr", (Object)update.getOLDAVAILABILITY());
            updateModel.setValue("revisionStr", (Object)update.getREVISION());
            updateModel.setValue("oldRevisionStr", (Object)update.getOLDREVISION());
        }
        return true;
    }

    public static void populatePingModel(PingResultDocument.PingResult result, DefaultModel pingModel, Locale locale) throws IllegalArgumentException {
        if (result == null || pingModel == null) {
            return;
        }
        for (int i = 0; i < result.getLINKS().getLINKArray().length; ++i) {
            if (i != 0) {
                pingModel.appendRow();
            }
            Value[] values = result.getLINKS().getLINKArray()[i].getVALUEArray();
            String resultData = "";
            String errorString = "";
            for (int j = 0; j < values.length; ++j) {
                Value value = values[j];
                if ("ErrorCode".equals(value.getID())) {
                    pingModel.setValue("ErrorCodeStr", (Object)value.getStringValue());
                } else if ("IPaddr".equals(value.getID())) {
                    pingModel.setValue("IPaddrStr", (Object)value.getStringValue());
                } else if ("LinkState".equals(value.getID())) {
                    pingModel.setValue("LinkStateStr", (Object)value.getStringValue());
                } else if ("ResultData".equals(value.getID())) {
                    resultData = value.getStringValue();
                } else if ("ErrorString".equals(value.getID())) {
                    errorString = value.getStringValue();
                } else if ("Status".equals(value.getID())) {
                    pingModel.setValue("StatusStr", (Object)value.getStringValue());
                }
                if (resultData == null || "".equals(resultData.trim())) {
                    pingModel.setValue("ResultDataStr", (Object)errorString);
                    continue;
                }
                pingModel.setValue("ResultDataStr", (Object)resultData);
            }
        }
    }

    public static void populateSEArrayModel(SEListArrayResultDocument.SEListArrayResult result, ActionTableModel arrayModel, Locale locale) throws IllegalArgumentException {
        if (result == null || arrayModel == null) {
            return;
        }
        ArrayList<String> keys = new ArrayList<String>();
        for (int i = 0; i < result.getARRAYArray().length; ++i) {
            Value array = result.getARRAYArray()[i];
            if (i != 0) {
                arrayModel.appendRow();
            }
            arrayModel.setValue("nameStr", array.getStringValue());
            arrayModel.setValue("ipnoStr", array.getID());
            keys.add(array.getID());
        }
        String[] keysArray = new String[keys.size()];
        keys.toArray(keysArray);
        arrayModel.setKeys(keysArray);
    }

    public static boolean populateSECompareModel(SECompareResultDocument.SECompareResult result, DefaultModel updateModel, Locale locale) throws IllegalArgumentException {
        boolean toUpdateTopo = false;
        if (result == null || updateModel == null) {
            return toUpdateTopo;
        }
        for (int i = 0; i < result.getDeviceArray().length; ++i) {
            DeviceCompare dc = result.getDeviceArray()[i];
            if (i != 0) {
                updateModel.appendRow();
            }
            updateModel.setValue("nameStr", (Object)dc.getName());
            updateModel.setValue("ipnoStr", (Object)dc.getIpno());
            updateModel.setValue("typeStr", (Object)AbbreviationUtil.getAbbreviation(dc.getType(), 2, locale));
            if ("update".equals(dc.getChange())) {
                if (dc.getFruArray().length == 0) {
                    updateModel.setValue("updateStr", (Object)"SECompare.noChange");
                    continue;
                }
                String changes = "";
                for (int j = 0; j < dc.getFruArray().length; ++j) {
                    FruCompare fc = dc.getFruArray()[j];
                    changes = "remove".equals(fc.getChange()) ? changes + LocalizeUtil.getLocalizedString("SECompare.fruRemoved", new String[]{fc.getId(), fc.getEntry()}, locale) + "<br>" : ("add".equals(fc.getChange()) ? changes + LocalizeUtil.getLocalizedString("SECompare.fruAdded", new String[]{fc.getId(), fc.getEntry()}, locale) + "<br>" : changes + LocalizeUtil.getLocalizedString("SECompare.fruUpdated", new String[]{fc.getId(), fc.getEntry(), fc.getFrom(), fc.getTo()}, locale) + "<br>");
                }
                if (!"".equals(changes)) {
                    changes = changes.substring(0, changes.length() - 4);
                }
                updateModel.setValue("updateStr", (Object)changes);
                continue;
            }
            if ("remove".equals(dc.getChange())) {
                updateModel.setValue("updateStr", (Object)"SECompare.removed");
                toUpdateTopo = true;
                continue;
            }
            if (!"add".equals(dc.getChange())) continue;
            updateModel.setValue("updateStr", (Object)"SECompare.added");
            toUpdateTopo = true;
        }
        return toUpdateTopo;
    }
}

