/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.mgmt.fm.storade.ui.viewbeans.reports;

import com.iplanet.jato.model.DefaultModel;
import com.sun.netstorage.mgmt.fm.storade.schema.Event;
import com.sun.netstorage.mgmt.fm.storade.schema.Value;
import com.sun.netstorage.mgmt.fm.storade.schema.asset.AssetComponent;
import com.sun.netstorage.mgmt.fm.storade.schema.asset.AssetContent;
import com.sun.netstorage.mgmt.fm.storade.schema.asset.AssetHeader;
import com.sun.netstorage.mgmt.fm.storade.schema.asset.AssetId;
import com.sun.netstorage.mgmt.fm.storade.schema.asset.AssetLogical;
import com.sun.netstorage.mgmt.fm.storade.schema.asset.AssetResultDocument;
import com.sun.netstorage.mgmt.fm.storade.schema.asset.AssetSAN;
import com.sun.netstorage.mgmt.fm.storade.schema.asset.AssetSystem;
import com.sun.netstorage.mgmt.fm.storade.schema.asset.AssetValue;
import com.sun.netstorage.mgmt.fm.storade.schema.asset.Component;
import com.sun.netstorage.mgmt.fm.storade.schema.asset.DiagList;
import com.sun.netstorage.mgmt.fm.storade.schema.asset.DiagTest;
import com.sun.netstorage.mgmt.fm.storade.schema.asset.TestInfo;
import com.sun.netstorage.mgmt.fm.storade.schema.asset.TestValue;
import com.sun.netstorage.mgmt.fm.storade.ui.common.AlarmConstants;
import com.sun.netstorage.mgmt.fm.storade.ui.model.ActionTableModel;
import com.sun.netstorage.mgmt.fm.storade.ui.util.DateUtil;
import com.sun.netstorage.mgmt.fm.storade.ui.util.Debug;
import com.sun.netstorage.mgmt.fm.storade.ui.util.DelimUtil;
import com.sun.netstorage.mgmt.fm.storade.ui.util.DeviceUtil;
import com.sun.netstorage.mgmt.fm.storade.ui.util.StateUtil;
import com.sun.netstorage.mgmt.fm.storade.ui.util.StringUtil;
import com.sun.netstorage.mgmt.fm.storade.ui.util.SystemUtil;
import com.sun.netstorage.mgmt.fm.storade.ui.viewbeans.reports.AssetsDataHelper;
import com.sun.netstorage.mgmt.fm.storade.ui.viewbeans.reports.Setter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Locale;

public class AssetDetailsDataHelper {
    private static final int FRU = 1;
    private static final int COMPONENT = 2;
    private static final int LOGICAL = 3;
    static final String ID = "id.name";
    private static final String VALUE_ID = "id";
    private static final String VALUE_STATE = "state";
    private static final String VALUE_STATUS = "status";
    private static final String VALUE_AVAILABILITY = "availability";
    private static final String VALUE_REVISION = "revision";
    private static final String VALUE_SERIAL = "serial";
    private static final String VALUE_NAME = "name";
    private static final String VALUE_DISKS = "disks";
    private static final String VALUE_CAPACITY = "capacity";
    private static final String VALUE_RAID_LEVEL = "raidLevel";
    private static final String VALUE_SOURCE_POOL = "sourcePool";
    private static final String VALUE_WWN = "wwn";
    private static final String VALUE_TYPE_TYPE = "type";
    private static final String DIAG_NAME = "name";
    private static final String DIAG_TYPE = "node";
    private static final String CONFIG_IP = "ipno";
    private static final String CONFIG_TIME = "time_added";
    private static final String CONFIG_TYPE = "type";
    private static final String CONFIG_KEY = "key";
    private static final String CONFIG_CLASS = "class";
    private static final String CONFIG_ACTIVE = "active";
    private static final String CONFIG_MONITORED = "typeMonitored";
    private static final String HEADER_DEVICE_IP = "device_ip";
    private static final String HEADER_DEVICE_KEY = "device_key";
    private static final String HEADER_DEVICE_NAME = "device_name";
    private static final String HEADER_DEVICE_TYPE = "device_type";
    private static final String HEADER_DEVICE_LABEL = "device_label";
    private static final String VALUE_TYPE = "value";
    private static final String SAN_PORT = "port";
    private static final String SAN_PORT_NO = "portNo";
    private static final String SAN_REMOTE_NAME = "remote_name";
    private static final String SAN_REMOTE_PORT = "remote_port";
    private static final String SAN_REMOTE_PORT_NO = "remote_portNo";
    private static final String CLASS_SWITCH = "switch.";
    private static final String CLASS_DSP = "switch.dsp";
    private static final String ALARM_HREF = "alarmHREF";
    private static final String ALARM_BY_FRU_TYPE_HREF = "alarmByFRUTypeHREF";
    private static final String ALARM_FRU = "alarmsFRU";
    private static final String ALARM_BY_TYPE_HREF = "alarmByTypeHREF";
    private static final String ALARM = "alarms";
    private static final String ALARM_BY_LOGICAL_TYPE_HREF = "alarmByLogicalTypeHREF";
    private static final String ALARM_LOGICAL = "alarmsLogical";
    private static final String AVAILABILITY_NOT_INSTALLED = "Not Installed";
    private static final String[] SPECIFIC_LOGICAL = new String[]{"volume", "vdisk", "logicaldrive", "pool"};

    private AssetDetailsDataHelper() {
    }

    private static int countAlarms(Event[] events, int severity) {
        int n = 0;
        if (events != null) {
            for (int i = 0; i < events.length; ++i) {
                int s = Integer.parseInt(events[i].getSeverity());
                if (s != severity) continue;
                ++n;
            }
        }
        return n;
    }

    private static int countAlarms(Event[] events, int severity, String type) {
        int n = 0;
        if (events != null) {
            for (int i = 0; i < events.length; ++i) {
                int s = Integer.parseInt(events[i].getSeverity());
                if (type == null || !events[i].getTopic().startsWith(type + ".") || s != severity) continue;
                ++n;
            }
        }
        return n;
    }

    private static String getDeviceIDMatchingAlarmType(Event[] events, String type) {
        String deviceID = null;
        if (events != null) {
            for (int i = 0; i < events.length; ++i) {
                if (type == null || !events[i].getTopic().startsWith(type + ".")) continue;
                deviceID = events[i].getType() + ":" + events[i].getKey();
                break;
            }
        }
        return deviceID;
    }

    private static String[] getTypesFromRackType(String type) {
        if ("6020 controllerCard".equals(type)) {
            type = "controller";
        } else if ("6020 diskDrive".equals(type)) {
            type = "disk";
        } else if ("6020 powerUnit".equals(type)) {
            type = "power";
        } else if ("6020 loopCard".equals(type)) {
            type = "loopcard";
        } else if ("6020 midplane".equals(type)) {
            type = "midplane";
        } else if ("Dsp psu".equals(type)) {
            type = "psu";
        } else if ("Dsp Managment Card".equals(type)) {
            type = "MIC";
        } else if ("Dsp I/O Combo Card".equals(type)) {
            type = "SIO";
        } else if ("Dsp I/O Card".equals(type)) {
            type = "SIO";
        } else if ("Dsp Storage Resource Card".equals(type)) {
            type = "SRC";
        } else if ("Dsp Switch Fabric Card".equals(type)) {
            type = "SFC";
        } else if ("Dsp fantray".equals(type)) {
            type = "fantray";
        } else if ("Sp".equals(type)) {
            type = "sp";
        } else if ("fcPort".equals(type)) {
            type = "fibrePort";
        }
        String[] types = new String[]{type};
        return types;
    }

    private static void addAlarms(String assetID, String assetName, ActionTableModel tableModel, Event[] events, String type, int compType) {
        AssetDetailsDataHelper.addAlarms(assetID, assetName, tableModel, events, type, compType, false);
    }

    private static void addAlarms(String assetID, String assetName, ActionTableModel tableModel, Event[] events, String type, int compType, boolean isRack) {
        String name;
        String HREF2;
        if (compType == 1) {
            HREF2 = ALARM_BY_FRU_TYPE_HREF;
            name = ALARM_FRU;
        } else if (compType == 2) {
            HREF2 = ALARM_BY_TYPE_HREF;
            name = ALARM;
        } else {
            HREF2 = ALARM_BY_LOGICAL_TYPE_HREF;
            name = ALARM_LOGICAL;
        }
        String str = DelimUtil.compose(HREF2, new String[]{assetID, assetName, type});
        int downAlarmsByType = AssetDetailsDataHelper.countAlarms(events, 3, type);
        int criticalAlarmsByType = AssetDetailsDataHelper.countAlarms(events, 2, type);
        int majorAlarmsByType = AssetDetailsDataHelper.countAlarms(events, 1, type);
        int minorAlarmsByType = AssetDetailsDataHelper.countAlarms(events, Integer.MIN_VALUE, type);
        if (isRack) {
            Debug.println("Rack Conversion: " + assetID + " " + assetName + " " + type);
            String[] types = AssetDetailsDataHelper.getTypesFromRackType(type);
            for (int i = 0; i < types.length; ++i) {
                downAlarmsByType = AssetDetailsDataHelper.countAlarms(events, 3, types[i]);
                criticalAlarmsByType = AssetDetailsDataHelper.countAlarms(events, 2, types[i]);
                majorAlarmsByType = AssetDetailsDataHelper.countAlarms(events, 1, types[i]);
                minorAlarmsByType = AssetDetailsDataHelper.countAlarms(events, Integer.MIN_VALUE, types[i]);
                if (downAlarmsByType == 0 && criticalAlarmsByType == 0 && majorAlarmsByType == 0 && minorAlarmsByType == 0) continue;
                assetID = AssetDetailsDataHelper.getDeviceIDMatchingAlarmType(events, types[i]);
                str = DelimUtil.compose(HREF2, new String[]{assetID, assetName, types[i]});
            }
        }
        if (downAlarmsByType != 0) {
            tableModel.setValue(HREF2, str);
            tableModel.setValue(name, AlarmConstants.getSeverityObject(3));
        } else if (criticalAlarmsByType != 0) {
            tableModel.setValue(HREF2, str);
            tableModel.setValue(name, AlarmConstants.getSeverityObject(2));
        } else if (majorAlarmsByType != 0) {
            tableModel.setValue(HREF2, str);
            tableModel.setValue(name, AlarmConstants.getSeverityObject(1));
        } else if (minorAlarmsByType != 0) {
            tableModel.setValue(HREF2, str);
            tableModel.setValue(name, AlarmConstants.getSeverityObject(Integer.MIN_VALUE));
        } else {
            tableModel.setValue(HREF2, null);
            tableModel.setValue(name, null);
        }
    }

    private static int countInstalled(String key, Component[] components) {
        int total = 0;
        int notInstalled = 0;
        block0: for (int j = 0; j < components.length; ++j) {
            String s = components[j].getID();
            int index = s.indexOf(46);
            if (index != -1) {
                s = s.substring(0, index);
            }
            if (!key.equals(s)) continue;
            ++total;
            AssetValue[] values = components[j].getValueArray();
            if (values == null) continue;
            for (int k = 0; k < values.length; ++k) {
                String s2 = values[k].getID();
                if (!VALUE_AVAILABILITY.equals(s2)) continue;
                String value = values[k].getStringValue();
                if (!AVAILABILITY_NOT_INSTALLED.equals(value)) continue block0;
                ++notInstalled;
                continue block0;
            }
        }
        return total - notInstalled;
    }

    private static boolean isStandardHeaderParameter(String name) {
        boolean r = false;
        if (HEADER_DEVICE_IP.equals(name)) {
            r = true;
        } else if (HEADER_DEVICE_KEY.equals(name)) {
            r = true;
        } else if (HEADER_DEVICE_NAME.equals(name)) {
            r = true;
        } else if (HEADER_DEVICE_TYPE.equals(name)) {
            r = true;
        } else if (HEADER_DEVICE_LABEL.equals(name)) {
            r = true;
        }
        return r;
    }

    public static boolean isDeviceValueFalse(AssetResultDocument.AssetResult result, String key) {
        boolean isValueSet = true;
        if (result != null && result.getDEVICERESULT() != null && result.getDEVICERESULT().getDEVICE() != null && result.getDEVICERESULT().getDEVICE().getVALUEArray() != null) {
            Value[] values = result.getDEVICERESULT().getDEVICE().getVALUEArray();
            for (int j = 0; j < values.length; ++j) {
                String s = values[j].getID();
                if (!key.equals(s) || !"N".equals(values[j].getStringValue())) continue;
                isValueSet = false;
                break;
            }
        }
        return isValueSet;
    }

    public static boolean isDeviceMonitored(AssetResultDocument.AssetResult result) {
        return AssetDetailsDataHelper.isDeviceValueFalse(result, CONFIG_ACTIVE);
    }

    public static boolean isDeviceTypeMonitored(AssetResultDocument.AssetResult result) {
        return AssetDetailsDataHelper.isDeviceValueFalse(result, CONFIG_MONITORED);
    }

    public static boolean isReportAvailable(AssetResultDocument.AssetResult result) {
        return AssetsDataHelper.isReportAvailable(result);
    }

    private static void addProperty(DefaultModel detailsTableModel, String name, String value) {
        if (value != null) {
            detailsTableModel.appendRow();
            detailsTableModel.setValue("propertyName", (Object)name);
            detailsTableModel.setValue("propertyValue1", (Object)value);
            detailsTableModel.setValue("propertyValue2", null);
            detailsTableModel.setValue("alarmHref", null);
            detailsTableModel.setValue("alarmObj", null);
            detailsTableModel.setValue("alarmType", null);
        }
    }

    public static String getAssetName(AssetResultDocument.AssetResult result, String assetID) {
        AssetHeader header;
        Component[] headers;
        String s;
        int j;
        AssetId ids;
        String name = "";
        AssetContent content = null;
        if (result.getReport() != null && (ids = (content = result.getReport().getContent()).getID()) != null) {
            AssetValue[] idValues = ids.getValueArray();
            for (j = 0; j < idValues.length; ++j) {
                s = idValues[j].getID();
                if (!ID.equals(s)) continue;
                name = idValues[j].getStringValue();
                break;
            }
        }
        if ("".equals(name) && content != null && content.getHEADER() != null && (headers = (header = content.getHEADER()).getCOMPONENTArray()) != null) {
            block1: for (j = 0; j < headers.length; ++j) {
                AssetValue[] values;
                s = headers[j].getID();
                if (!HEADER_DEVICE_NAME.equals(s) || (values = headers[j].getValueArray()) == null) continue;
                for (int k = 0; k < values.length; ++k) {
                    String s2 = values[k].getID();
                    if (!VALUE_TYPE.equals(s2)) continue;
                    name = values[k].getStringValue();
                    continue block1;
                }
            }
        }
        if ("".equals(name)) {
            Debug.println("Cannot Find device/component name from ID: id.name");
            name = assetID;
            name = DeviceUtil.getDeviceName(name);
        }
        return name;
    }

    public static boolean hasSystemParameters(AssetResultDocument.AssetResult result) {
        boolean hasSystemParameters = true;
        if (result != null) {
            AssetSystem system;
            AssetContent content = null;
            if (result.getReport() != null && (system = (content = result.getReport().getContent()).getStorageSystem()) == null) {
                hasSystemParameters = false;
            }
        }
        return hasSystemParameters;
    }

    private static String getAlarmLink(String assetID, String name, int severity) {
        String str = null;
        str = SystemUtil.isSystemEdition() && DeviceUtil.isRack(assetID) ? DelimUtil.compose("AssetAlarmLinkSeverityOnly", new String[]{Integer.toString(severity)}) : DelimUtil.compose("AssetAlarmLinkSeverity", new String[]{assetID, name, Integer.toString(severity)});
        return str;
    }

    public static void populateAssetDetailsDetails(AssetResultDocument.AssetResult result, DefaultModel detailsTableModel, String assetID, Locale locale) throws IllegalArgumentException {
        AssetHeader header;
        Component[] headers;
        String name = AssetDetailsDataHelper.getAssetName(result, assetID);
        Event[] events = result.getALARMS().getEventArray();
        AssetContent content = null;
        if (result.getReport() != null) {
            content = result.getReport().getContent();
        }
        int downAlarms = AssetDetailsDataHelper.countAlarms(events, 3);
        int criticalAlarms = AssetDetailsDataHelper.countAlarms(events, 2);
        int majorAlarms = AssetDetailsDataHelper.countAlarms(events, 1);
        int minorAlarms = AssetDetailsDataHelper.countAlarms(events, Integer.MIN_VALUE);
        Debug.println("Down Alarms: " + downAlarms);
        Debug.println("Critical Alarms: " + criticalAlarms);
        Debug.println("Major Alarms: " + majorAlarms);
        Debug.println("Minor Alarms: " + minorAlarms);
        detailsTableModel.appendRow();
        detailsTableModel.setValue("propertyName", (Object)"down.alarms.property");
        String str = AssetDetailsDataHelper.getAlarmLink(assetID, name, 3);
        if (downAlarms == 0) {
            detailsTableModel.setValue("alarmType", (Object)AlarmConstants.getSeverityObject(3));
            detailsTableModel.setValue("propertyValue1", (Object)"0");
            detailsTableModel.setValue("propertyValue2", null);
            detailsTableModel.setValue("alarmHref", null);
            detailsTableModel.setValue("alarmObj", null);
        } else {
            detailsTableModel.setValue("alarmType", null);
            detailsTableModel.setValue("propertyValue1", null);
            detailsTableModel.setValue("propertyValue2", (Object)Integer.toString(downAlarms));
            detailsTableModel.setValue("alarmHref", (Object)str);
            detailsTableModel.setValue("alarmObj", (Object)AlarmConstants.getSeverityObject(3));
        }
        detailsTableModel.appendRow();
        detailsTableModel.setValue("propertyName", (Object)"critical.alarms.property");
        str = AssetDetailsDataHelper.getAlarmLink(assetID, name, 2);
        if (criticalAlarms == 0) {
            detailsTableModel.setValue("alarmType", (Object)AlarmConstants.getSeverityObject(2));
            detailsTableModel.setValue("propertyValue1", (Object)"0");
            detailsTableModel.setValue("propertyValue2", null);
            detailsTableModel.setValue("alarmHref", null);
            detailsTableModel.setValue("alarmObj", null);
        } else {
            detailsTableModel.setValue("alarmType", null);
            detailsTableModel.setValue("propertyValue1", null);
            detailsTableModel.setValue("propertyValue2", (Object)Integer.toString(criticalAlarms));
            detailsTableModel.setValue("alarmHref", (Object)str);
            detailsTableModel.setValue("alarmObj", (Object)AlarmConstants.getSeverityObject(2));
        }
        detailsTableModel.appendRow();
        detailsTableModel.setValue("propertyName", (Object)"major.alarms.property");
        str = AssetDetailsDataHelper.getAlarmLink(assetID, name, 1);
        if (majorAlarms == 0) {
            detailsTableModel.setValue("alarmType", (Object)AlarmConstants.getSeverityObject(1));
            detailsTableModel.setValue("propertyValue1", (Object)"0");
            detailsTableModel.setValue("propertyValue2", null);
            detailsTableModel.setValue("alarmHref", null);
            detailsTableModel.setValue("alarmObj", null);
        } else {
            detailsTableModel.setValue("alarmType", null);
            detailsTableModel.setValue("propertyValue1", null);
            detailsTableModel.setValue("propertyValue2", (Object)Integer.toString(majorAlarms));
            detailsTableModel.setValue("alarmHref", (Object)str);
            detailsTableModel.setValue("alarmObj", (Object)AlarmConstants.getSeverityObject(1));
        }
        detailsTableModel.appendRow();
        detailsTableModel.setValue("propertyName", (Object)"minor.alarms.property");
        detailsTableModel.setValue("alarmType", (Object)AlarmConstants.getSeverityObject(Integer.MIN_VALUE));
        str = AssetDetailsDataHelper.getAlarmLink(assetID, name, Integer.MIN_VALUE);
        if (minorAlarms == 0) {
            detailsTableModel.setValue("alarmType", (Object)AlarmConstants.getSeverityObject(Integer.MIN_VALUE));
            detailsTableModel.setValue("propertyValue1", (Object)"0");
            detailsTableModel.setValue("propertyValue2", null);
            detailsTableModel.setValue("alarmHref", null);
            detailsTableModel.setValue("alarmObj", null);
        } else {
            detailsTableModel.setValue("alarmType", null);
            detailsTableModel.setValue("propertyValue1", null);
            detailsTableModel.setValue("propertyValue2", (Object)Integer.toString(minorAlarms));
            detailsTableModel.setValue("alarmHref", (Object)str);
            detailsTableModel.setValue("alarmObj", (Object)AlarmConstants.getSeverityObject(1));
        }
        String ipno = null;
        String timeAdded = null;
        String type = DeviceUtil.getDeviceType(assetID);
        String configKey = null;
        if (result.getDEVICERESULT() != null && result.getDEVICERESULT().getDEVICE() != null && result.getDEVICERESULT().getDEVICE().getVALUEArray() != null) {
            Value[] values = result.getDEVICERESULT().getDEVICE().getVALUEArray();
            for (int j = 0; j < values.length; ++j) {
                String s = values[j].getID();
                if (CONFIG_IP.equals(s)) {
                    ipno = values[j].getStringValue();
                    continue;
                }
                if (CONFIG_TIME.equals(s)) {
                    timeAdded = values[j].getStringValue();
                    continue;
                }
                if ("type".equals(s)) {
                    type = values[j].getStringValue();
                    continue;
                }
                if (!CONFIG_KEY.equals(s)) continue;
                configKey = values[j].getStringValue();
            }
        }
        String detailedType = null;
        detailedType = type;
        if (ipno != null && !"".equals(ipno)) {
            AssetDetailsDataHelper.addProperty(detailsTableModel, "asset.ip", ipno);
        }
        if (timeAdded != null) {
            String localizedTime = timeAdded;
            try {
                localizedTime = DateUtil.toString1(DateUtil.toDate1(timeAdded), locale);
            }
            catch (Exception ex) {
                // empty catch block
            }
            AssetDetailsDataHelper.addProperty(detailsTableModel, "asset.timeAdded", localizedTime);
        }
        if (detailedType != null && content == null) {
            AssetDetailsDataHelper.addProperty(detailsTableModel, "asset.type", detailedType);
        }
        if (configKey != null) {
            AssetDetailsDataHelper.addProperty(detailsTableModel, "asset.configKey", configKey);
        }
        if (content == null) {
            return;
        }
        if (content.getHEADER() != null && (headers = (header = content.getHEADER()).getCOMPONENTArray()) != null) {
            block3: for (int j = 0; j < headers.length; ++j) {
                String s = headers[j].getID();
                AssetValue[] values = headers[j].getValueArray();
                if (values == null) continue;
                for (int k = 0; k < values.length; ++k) {
                    String s2 = values[k].getID();
                    if (!VALUE_TYPE.equals(s2)) continue;
                    String value = values[k].getStringValue();
                    if (ipno == null && HEADER_DEVICE_IP.equals(s)) {
                        AssetDetailsDataHelper.addProperty(detailsTableModel, "asset.ip", value);
                        continue block3;
                    }
                    if (configKey == null && HEADER_DEVICE_KEY.equals(s)) {
                        AssetDetailsDataHelper.addProperty(detailsTableModel, "asset.configKey", value);
                        continue block3;
                    }
                    if (HEADER_DEVICE_TYPE.equals(s)) {
                        detailedType = value;
                        AssetDetailsDataHelper.addProperty(detailsTableModel, "asset.type", detailedType);
                        continue block3;
                    }
                    if (AssetDetailsDataHelper.isStandardHeaderParameter(s) || !DeviceUtil.isDisplayableProperty(s = DeviceUtil.getLocalizedKey(type, s, locale))) continue block3;
                    value = DeviceUtil.getLocalizedValue(type, headers[j].getID(), value, locale);
                    s = StringUtil.toPropFormat(s);
                    AssetDetailsDataHelper.addProperty(detailsTableModel, s, value);
                    continue block3;
                }
            }
        }
    }

    public static void populateAssetDetailsDiags(AssetResultDocument.AssetResult result, ActionTableModel diagsModel, String assetID, Locale locale) throws IllegalArgumentException {
        DiagTest[] diagTest;
        ArrayList<String> diagKeys = new ArrayList<String>();
        DiagList diagList = result.getDIAGLIST();
        if (diagList != null && (diagTest = diagList.getDIAGTESTArray()) != null) {
            for (int i = 0; i < diagTest.length; ++i) {
                TestValue[] values;
                TestInfo testInfo = diagTest[i].getTESTINFO();
                if (testInfo == null || (values = testInfo.getValueArray()) == null) continue;
                diagsModel.appendRow();
                for (int j = 0; j < values.length; ++j) {
                    String v;
                    String s = values[j].getID();
                    if ("name".equals(s)) {
                        v = values[j].getStringValue();
                        diagsModel.setValue("diagName", v);
                        diagKeys.add(v);
                        continue;
                    }
                    if (!DIAG_TYPE.equals(s)) continue;
                    v = values[j].getStringValue();
                    diagsModel.setValue("diagType", "diag." + v);
                }
            }
        }
        String[] diagKeysArr = new String[diagKeys.size()];
        diagKeys.toArray(diagKeysArr);
        diagsModel.setKeys(diagKeysArr);
    }

    public static void populateAssetDetailsFRU(AssetResultDocument.AssetResult result, ActionTableModel fruTableModel, String assetID, boolean isRack, Locale locale) throws IllegalArgumentException {
        if (result == null) {
            return;
        }
        String name = AssetDetailsDataHelper.getAssetName(result, assetID);
        Event[] events = result.getALARMS().getEventArray();
        AssetContent content = null;
        if (result == null || result.getReport() != null) {
            content = result.getReport().getContent();
        }
        if (content == null) {
            return;
        }
        AssetComponent fru = content.getFRU();
        if (fru != null) {
            Component[] components = fru.getCOMPONENTArray();
            HashMap<String, Integer> map = new HashMap<String, Integer>();
            for (int j = 0; j < components.length; ++j) {
                Object obj;
                String s = components[j].getID();
                int index = s.indexOf(46);
                if (index != -1) {
                    s = s.substring(0, index);
                }
                if ((obj = map.get(s)) == null) {
                    map.put(s, new Integer(1));
                    continue;
                }
                Integer i = (Integer)obj;
                map.put(s, new Integer(i + 1));
            }
            Iterator keys = map.keySet().iterator();
            while (keys.hasNext()) {
                String key = (String)keys.next();
                Integer value = (Integer)map.get(key);
                String hrefKey = DelimUtil.aggregate(new String[]{assetID, key});
                fruTableModel.appendRow();
                String localizedKey = DeviceUtil.getLocalizedKey(DeviceUtil.getDeviceType(assetID), key, locale);
                fruTableModel.setValue("fruType", localizedKey);
                AssetDetailsDataHelper.addAlarms(assetID, name, fruTableModel, events, key, 1, isRack);
                int countInstalled = AssetDetailsDataHelper.countInstalled(key, components);
                fruTableModel.setValue("fruInstalled", new Integer(countInstalled));
                fruTableModel.setValue("fruQuantity", value);
                fruTableModel.setValue("fruTypeHREF", hrefKey);
            }
        }
    }

    public static void populateAssetDetailsComponent(AssetResultDocument.AssetResult result, ActionTableModel subcomponentTableModel, String assetID, boolean isRack, Locale locale) throws IllegalArgumentException {
        AssetComponent port;
        if (result == null) {
            return;
        }
        String name = AssetDetailsDataHelper.getAssetName(result, assetID);
        Event[] events = result.getALARMS().getEventArray();
        AssetContent content = null;
        if (result.getReport() != null) {
            content = result.getReport().getContent();
        }
        if (content == null) {
            return;
        }
        AssetComponent comp = content.getCOMPONENT();
        if (comp != null) {
            Component[] components = comp.getCOMPONENTArray();
            HashMap<String, Integer> map = new HashMap<String, Integer>();
            for (int j = 0; j < components.length; ++j) {
                Object obj;
                String s = components[j].getID();
                int index = s.indexOf(46);
                if (index != -1) {
                    s = s.substring(0, index);
                }
                if ((obj = map.get(s)) == null) {
                    map.put(s, new Integer(1));
                    continue;
                }
                Integer i = (Integer)obj;
                map.put(s, new Integer(i + 1));
            }
            Iterator keys = map.keySet().iterator();
            while (keys.hasNext()) {
                String key = (String)keys.next();
                Integer value = (Integer)map.get(key);
                String hrefKey = DelimUtil.aggregate(new String[]{assetID, key});
                subcomponentTableModel.appendRow();
                String localizedKey = DeviceUtil.getLocalizedKey(DeviceUtil.getDeviceType(assetID), key, locale);
                subcomponentTableModel.setValue("componentType", localizedKey);
                AssetDetailsDataHelper.addAlarms(assetID, name, subcomponentTableModel, events, key, 2, isRack);
                subcomponentTableModel.setValue("componentQuantity", value);
                subcomponentTableModel.setValue("componentTypeHREF", hrefKey);
            }
        }
        if ((port = content.getPORT()) != null) {
            Component[] ports = port.getCOMPONENTArray();
            HashMap<String, Integer> map = new HashMap<String, Integer>();
            for (int j = 0; j < ports.length; ++j) {
                Object obj;
                String s = ports[j].getID();
                int index = s.indexOf(46);
                if (index != -1) {
                    s = s.substring(0, index);
                }
                if ((obj = map.get(s)) == null) {
                    map.put(s, new Integer(1));
                    continue;
                }
                Integer i = (Integer)obj;
                map.put(s, new Integer(i + 1));
            }
            Iterator keys = map.keySet().iterator();
            while (keys.hasNext()) {
                String key = (String)keys.next();
                Integer value = (Integer)map.get(key);
                String hrefKey = DelimUtil.aggregate(new String[]{assetID, key});
                subcomponentTableModel.appendRow();
                String localizedKey = DeviceUtil.getLocalizedKey(DeviceUtil.getDeviceType(assetID), key, locale);
                subcomponentTableModel.setValue("componentType", localizedKey);
                AssetDetailsDataHelper.addAlarms(assetID, name, subcomponentTableModel, events, key, 2, isRack);
                subcomponentTableModel.setValue("componentQuantity", value);
                subcomponentTableModel.setValue("componentTypeHREF", hrefKey);
            }
        }
    }

    public static void populateAssetDetailsLogical(AssetResultDocument.AssetResult result, ActionTableModel logicalTableModel, String assetID, Locale locale) throws IllegalArgumentException {
        if (result == null) {
            return;
        }
        String name = AssetDetailsDataHelper.getAssetName(result, assetID);
        Event[] events = result.getALARMS().getEventArray();
        AssetContent content = null;
        if (result.getReport() != null) {
            content = result.getReport().getContent();
        }
        if (content == null) {
            return;
        }
        AssetLogical logical = content.getLOGICAL();
        if (logical != null) {
            Component[] lComponents = logical.getCOMPONENTArray();
            HashMap<String, Integer> map = new HashMap<String, Integer>();
            for (int j = 0; j < lComponents.length; ++j) {
                Object obj;
                String s = lComponents[j].getID();
                int index = s.indexOf(46);
                if (index != -1) {
                    s = s.substring(0, index);
                }
                if ((obj = map.get(s)) == null) {
                    map.put(s, new Integer(1));
                    continue;
                }
                Integer i = (Integer)obj;
                map.put(s, new Integer(i + 1));
            }
            Iterator keys = map.keySet().iterator();
            while (keys.hasNext()) {
                String key = (String)keys.next();
                Integer value = (Integer)map.get(key);
                String hrefKey = DelimUtil.aggregate(new String[]{assetID, key});
                logicalTableModel.appendRow();
                String localizedKey = DeviceUtil.getLocalizedKey(DeviceUtil.getDeviceType(assetID), key, locale);
                logicalTableModel.setValue("elementType", localizedKey);
                AssetDetailsDataHelper.addAlarms(assetID, name, logicalTableModel, events, key, 3);
                logicalTableModel.setValue("elementQuantity", value);
                logicalTableModel.setValue("elementTypeHREF", hrefKey);
            }
        }
    }

    public static void populateAssetDetailsFRUWithType(AssetResultDocument.AssetResult result, ActionTableModel fruTableModel, String assetID, Locale locale) throws IllegalArgumentException {
        if (result == null) {
            return;
        }
        AssetContent content = null;
        if (result.getReport() != null) {
            content = result.getReport().getContent();
        }
        if (content == null) {
            return;
        }
        AssetComponent fru = content.getFRU();
        if (fru != null) {
            Component[] components = fru.getCOMPONENTArray();
            for (int j = 0; j < components.length; ++j) {
                if (j != 0) {
                    fruTableModel.appendRow();
                }
                String s = components[j].getID();
                int index = s.indexOf(46);
                String name = components[j].getID();
                if (index != -1) {
                    s = s.substring(0, index);
                    name = name.substring(index + 1);
                }
                String type = s;
                String localizedType = DeviceUtil.getLocalizedKey(DeviceUtil.getDeviceType(assetID), type, locale);
                fruTableModel.setValue("fruTypeD", localizedType);
                fruTableModel.setValue("fruName", name);
                AssetValue[] values = components[j].getValueArray();
                if (values != null) {
                    String fruName = null;
                    String fruStatus = "-";
                    String fruState = "-";
                    String fruRevision = "-";
                    String fruSerialNumber = "-";
                    for (int k = 0; k < values.length; ++k) {
                        String s2 = values[k].getID();
                        if ("name".equals(s2)) {
                            name = values[k].getStringValue();
                            fruName = values[k].getStringValue();
                            continue;
                        }
                        if (VALUE_STATUS.equals(s2)) {
                            fruStatus = StringUtil.toBlank(values[k].getStringValue());
                            continue;
                        }
                        if (VALUE_STATE.equals(s2)) {
                            String state = values[k].getStringValue();
                            state = StateUtil.getState(state);
                            fruState = state = StringUtil.toBlank(state);
                            continue;
                        }
                        if (VALUE_REVISION.equals(s2)) {
                            fruRevision = StringUtil.toBlank(values[k].getStringValue());
                            continue;
                        }
                        if (!VALUE_SERIAL.equals(s2)) continue;
                        fruSerialNumber = StringUtil.toBlank(values[k].getStringValue());
                    }
                    if (fruName != null) {
                        fruTableModel.setValue("fruName", fruName);
                    }
                    fruTableModel.setValue("fruStatus", fruStatus);
                    fruTableModel.setValue("fruState", fruState);
                    fruTableModel.setValue("fruRevision", fruRevision);
                    fruTableModel.setValue("fruSerialNumber", fruSerialNumber);
                }
                String ls = DelimUtil.aggregate(new String[]{assetID, components[j].getID(), name});
                fruTableModel.setValue("fruHREF", ls);
            }
        }
    }

    public static void populateAssetDetailsSubComponentWithType(AssetResultDocument.AssetResult result, ActionTableModel subcomponentTableModel, String assetID, Locale locale) throws IllegalArgumentException {
        AssetComponent port;
        if (result == null) {
            return;
        }
        AssetContent content = null;
        if (result.getReport() != null) {
            content = result.getReport().getContent();
        }
        if (content == null) {
            return;
        }
        AssetComponent fru = content.getCOMPONENT();
        if (fru != null) {
            Component[] components = fru.getCOMPONENTArray();
            for (int j = 0; j < components.length; ++j) {
                if (j != 0) {
                    subcomponentTableModel.appendRow();
                }
                String s = components[j].getID();
                int index = s.indexOf(46);
                String name = components[j].getID();
                if (index != -1) {
                    s = s.substring(0, index);
                    name = name.substring(index + 1);
                }
                String type = s;
                String localizedType = DeviceUtil.getLocalizedKey(DeviceUtil.getDeviceType(assetID), type, locale);
                subcomponentTableModel.setValue("componentTypeD", localizedType);
                subcomponentTableModel.setValue("componentName", name);
                subcomponentTableModel.setValue("componentStatus", StringUtil.toBlank(null));
                subcomponentTableModel.setValue("componentState", StringUtil.toBlank(null));
                subcomponentTableModel.setValue("componentRevision", StringUtil.toBlank(null));
                subcomponentTableModel.setValue("componentSerialNumber", StringUtil.toBlank(null));
                AssetValue[] values = components[j].getValueArray();
                if (values != null) {
                    for (int k = 0; k < values.length; ++k) {
                        String s2 = values[k].getID();
                        if ("name".equals(s2)) {
                            name = values[k].getStringValue();
                            subcomponentTableModel.setValue("componentName", values[k].getStringValue());
                            continue;
                        }
                        if (VALUE_STATUS.equals(s2)) {
                            subcomponentTableModel.setValue("componentStatus", StringUtil.toBlank(values[k].getStringValue()));
                            continue;
                        }
                        if (VALUE_STATE.equals(s2)) {
                            String state = values[k].getStringValue();
                            state = StateUtil.getState(state);
                            subcomponentTableModel.setValue("componentState", StringUtil.toBlank(state));
                            continue;
                        }
                        if (VALUE_REVISION.equals(s2)) {
                            subcomponentTableModel.setValue("componentRevision", StringUtil.toBlank(values[k].getStringValue()));
                            continue;
                        }
                        if (!VALUE_SERIAL.equals(s2)) continue;
                        subcomponentTableModel.setValue("componentSerialNumber", StringUtil.toBlank(values[k].getStringValue()));
                    }
                }
                String ls = DelimUtil.aggregate(new String[]{assetID, components[j].getID(), name});
                subcomponentTableModel.setValue("componentHREF", ls);
            }
        }
        if ((port = content.getPORT()) != null) {
            Component[] components = port.getCOMPONENTArray();
            for (int j = 0; j < components.length; ++j) {
                subcomponentTableModel.appendRow();
                String s = components[j].getID();
                int index = s.indexOf(46);
                String name = components[j].getID();
                if (index != -1) {
                    s = s.substring(0, index);
                    name = name.substring(index + 1);
                }
                String type = s;
                String localizedType = DeviceUtil.getLocalizedKey(DeviceUtil.getDeviceType(assetID), type, locale);
                subcomponentTableModel.setValue("componentTypeD", localizedType);
                subcomponentTableModel.setValue("componentName", name);
                AssetValue[] values = components[j].getValueArray();
                if (values != null) {
                    for (int k = 0; k < values.length; ++k) {
                        String s2 = values[k].getID();
                        if ("name".equals(s2)) {
                            name = values[k].getStringValue();
                            subcomponentTableModel.setValue("componentName", values[k].getStringValue());
                            continue;
                        }
                        if (VALUE_STATUS.equals(s2)) {
                            subcomponentTableModel.setValue("componentStatus", StringUtil.toBlank(values[k].getStringValue()));
                            continue;
                        }
                        if (VALUE_STATE.equals(s2)) {
                            String state = values[k].getStringValue();
                            state = StateUtil.getState(state);
                            subcomponentTableModel.setValue("componentState", StringUtil.toBlank(state));
                            continue;
                        }
                        if (VALUE_REVISION.equals(s2)) {
                            subcomponentTableModel.setValue("componentRevision", StringUtil.toBlank(values[k].getStringValue()));
                            continue;
                        }
                        if (!VALUE_SERIAL.equals(s2)) continue;
                        subcomponentTableModel.setValue("componentSerialNumber", StringUtil.toBlank(values[k].getStringValue()));
                    }
                }
                String ls = DelimUtil.aggregate(new String[]{assetID, components[j].getID(), name});
                subcomponentTableModel.setValue("componentHREF", ls);
            }
        }
    }

    public static void populateConnections(AssetResultDocument.AssetResult result, ActionTableModel connectionModel, Locale locale) {
        if (result == null) {
            return;
        }
        AssetContent content = null;
        if (result.getReport() != null) {
            content = result.getReport().getContent();
        }
        if (content == null) {
            return;
        }
        AssetSAN san = content.getSAN();
        if (san != null) {
            Component[] components = san.getCOMPONENTArray();
            for (int j = 0; j < components.length; ++j) {
                if (j != 0) {
                    connectionModel.appendRow();
                }
                String port = null;
                String portNo = null;
                String remoteDevice = null;
                String remotePort = null;
                String remotePortNo = null;
                AssetValue[] values = components[j].getValueArray();
                if (values != null) {
                    for (int k = 0; k < values.length; ++k) {
                        String s2 = values[k].getID();
                        if (SAN_PORT.equals(s2)) {
                            port = values[k].getStringValue();
                            continue;
                        }
                        if (SAN_PORT_NO.equals(s2)) {
                            portNo = values[k].getStringValue();
                            continue;
                        }
                        if (SAN_REMOTE_NAME.equals(s2)) {
                            remoteDevice = values[k].getStringValue();
                            continue;
                        }
                        if (SAN_REMOTE_PORT.equals(s2)) {
                            remotePort = values[k].getStringValue();
                            continue;
                        }
                        if (!SAN_REMOTE_PORT_NO.equals(s2)) continue;
                        remotePortNo = values[k].getStringValue();
                    }
                }
                connectionModel.setValue("portValue", port);
                connectionModel.setValue("remotePortValue", remotePort);
                connectionModel.setValue("remoteDeviceValue", remoteDevice);
            }
        }
    }

    public static String populateVolumeSummaryModel(AssetResultDocument.AssetResult result, DefaultModel componentModel, String assetID, String type, Locale locale) {
        return AssetsDataHelper.populateVolumeSummaryModel(result, componentModel, assetID, type, locale);
    }

    public static String populatePoolSummaryModel(AssetResultDocument.AssetResult result, DefaultModel componentModel, String assetID, String[] type, Locale locale) {
        return AssetsDataHelper.populatePoolSummaryModel(result, componentModel, assetID, type, locale);
    }

    private static boolean isSpecificLogical(String type) {
        boolean isSpecific = false;
        for (int k = 0; k < SPECIFIC_LOGICAL.length; ++k) {
            if (!type.equals(SPECIFIC_LOGICAL[k])) continue;
            isSpecific = true;
            break;
        }
        return isSpecific;
    }

    public static void populateLogicalComponentSummaryModelWithType(AssetResultDocument.AssetResult result, ActionTableModel logicalTableModel, String assetID, Locale locale) throws IllegalArgumentException {
        if (result == null) {
            return;
        }
        AssetContent content = null;
        if (result.getReport() != null) {
            content = result.getReport().getContent();
        }
        if (content == null) {
            return;
        }
        AssetLogical logical = content.getLOGICAL();
        if (logical != null) {
            Component[] components = logical.getCOMPONENTArray();
            boolean rowAdded = false;
            for (int j = 0; j < components.length; ++j) {
                String s = components[j].getID();
                Object name = components[j].getID();
                int index = s.indexOf(46);
                if (index != -1) {
                    s = s.substring(0, index);
                    name = ((String)name).substring(index + 1);
                }
                try {
                    name = Integer.valueOf((String)name);
                }
                catch (Exception ex) {
                    // empty catch block
                }
                String type = s;
                if (AssetDetailsDataHelper.isSpecificLogical(type)) {
                    rowAdded = false;
                    continue;
                }
                if (rowAdded) {
                    logicalTableModel.appendRow();
                }
                String localizedType = DeviceUtil.getLocalizedKey(DeviceUtil.getDeviceType(assetID), type, locale);
                logicalTableModel.setValue("logicalType", localizedType);
                logicalTableModel.setValue("logicalName", name);
                logicalTableModel.setValue("logicalLogicalName", StringUtil.toBlank(null));
                logicalTableModel.setValue("logicalStatus", StringUtil.toBlank(null));
                AssetValue[] values = components[j].getValueArray();
                if (values != null) {
                    for (int k = 0; k < values.length; ++k) {
                        String s2 = values[k].getID();
                        if ("name".equals(s2)) {
                            logicalTableModel.setValue("logicalLogicalName", values[k].getStringValue());
                            continue;
                        }
                        if (!VALUE_STATUS.equals(s2)) continue;
                        logicalTableModel.setValue("logicalStatus", StringUtil.toBlank(values[k].getStringValue()));
                    }
                }
                String ls = DelimUtil.aggregate(new String[]{assetID, components[j].getID(), name.toString()});
                logicalTableModel.setValue("logicalHREF", ls);
                rowAdded = true;
            }
        }
    }

    public static boolean containsGenericLogicalComponents(AssetResultDocument.AssetResult result) {
        AssetLogical logical;
        AssetContent content;
        boolean hasGenericComponents = false;
        if (result != null && result.getReport() != null && (content = result.getReport().getContent()) != null && (logical = content.getLOGICAL()) != null) {
            Component[] components = logical.getCOMPONENTArray();
            for (int j = 0; j < components.length; ++j) {
                String currentType = components[j].getID();
                int index = currentType.indexOf(46);
                if (index != -1) {
                    currentType = currentType.substring(0, index);
                }
                boolean found = false;
                for (int k = 0; k < SPECIFIC_LOGICAL.length; ++k) {
                    if (!currentType.equals(SPECIFIC_LOGICAL[k])) continue;
                    found = true;
                    break;
                }
                if (found) continue;
                hasGenericComponents = true;
            }
        }
        return hasGenericComponents;
    }

    public static boolean isSwitch(AssetResultDocument.AssetResult result) {
        boolean isSwitch = false;
        if (result.getDEVICERESULT() != null && result.getDEVICERESULT().getDEVICE() != null && result.getDEVICERESULT().getDEVICE().getVALUEArray() != null) {
            Value[] values = result.getDEVICERESULT().getDEVICE().getVALUEArray();
            for (int j = 0; j < values.length; ++j) {
                String clazz;
                String s = values[j].getID();
                if (!CONFIG_CLASS.equals(s) || (clazz = values[j].getStringValue()) == null || !clazz.startsWith(CLASS_SWITCH) || clazz.equals(CLASS_DSP)) continue;
                isSwitch = true;
                break;
            }
        }
        return isSwitch;
    }

    public static void setNote(String key, String text) {
        Setter.setNote(key, text);
    }
}

