/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.mgmt.fm.storade.ui.viewbeans.jobs;

import com.sun.netstorage.mgmt.fm.storade.schema.jobs.Discovery;
import com.sun.netstorage.mgmt.fm.storade.schema.jobs.JobsSummaryResultDocument;
import com.sun.netstorage.mgmt.fm.storade.schema.jobs.Process;
import com.sun.netstorage.mgmt.fm.storade.schema.jobs.Processes;
import com.sun.netstorage.mgmt.fm.storade.schema.jobs.Snapshot;
import com.sun.netstorage.mgmt.fm.storade.schema.jobs.VolVerifyDevice;
import com.sun.netstorage.mgmt.fm.storade.schema.jobs.VolVerifyReport;
import com.sun.netstorage.mgmt.fm.storade.ui.model.ActionTableModel;
import com.sun.netstorage.mgmt.fm.storade.ui.util.AgentUtil;
import com.sun.netstorage.mgmt.fm.storade.ui.util.DateUtil;
import com.sun.netstorage.mgmt.fm.storade.ui.util.DelimUtil;
import com.sun.netstorage.mgmt.fm.storade.ui.util.LocalizeUtil;
import com.sun.netstorage.mgmt.fm.storade.ui.util.SystemUtil;
import com.sun.netstorage.mgmt.fm.storade.ui.viewbeans.diagnostics.DiagnosticsDataHelper;
import com.sun.netstorage.mgmt.fm.storade.ui.viewbeans.jobs.Getter;
import com.sun.netstorage.mgmt.fm.storade.ui.viewbeans.jobs.VolVerifyDataHelper;
import com.sun.web.ui.model.CCActionTableModel;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Locale;

public class JobsDataHelper {
    static final String JOB_DISCOVERY = "jobs.discovery";
    static final String JOB_DIAG = "jobs.diagnostics";
    static final String JOB_REVISION = "jobs.revision";
    static final String JOB_REPORT = "jobs.report";
    static final String JOB_AGENT = "jobs.agent";
    static final String JOB_ADMIN = "jobs.administration";
    static final String JOB_PATCH = "jobs.patch";
    static final String JOB_VOL_VERIFY = "jobs.volVerify";
    static final String JOB_VOL_VERIFY_KILL = "jobs.volVerify.termination";
    private static final String PROCESS_DIAG = "process.diag";
    private static final String PROCESS_REVISION = "process.Revision";
    private static final String PROCESS_FRU_REPORT = "process.fru_report";
    private static final String PROCESS_EXC_REPORT = "process.exception_report";
    private static final String PROCESS_RAS_PUSH = "process.ras_admin_push";
    private static final String PROCESS_RAS_AGENT = "process.rasagent";
    private static final String PROCESS_VOL_VERIFY = "process.volverify";
    private static final String PROCESS_EXTRACT = "process.Extract";
    private static final String PROCESS_PATCHLIST = "process.Patchlist";
    private static final String PROCESS_PATCHUPGRADE = "process.Upgrade";
    private static final String PROCESS_PATCHDOWNGRADE = "process.Downgrade";
    private static final String PROCESS_PATCHDOWNGRADEGRADE = "process.Patchdowngrade";
    static final String PROCESS_TYPE_PROCESS = "process";
    static final String PROCESS_TYPE_DIAG = "diag";
    static final String PROCESS_TYPE_DISCO = "disco";
    static final String[] UNIQUE = new String[]{"process.Patchdowngrade", "process.Patchlist", "process.Upgrade", "process.Downgrade"};
    static final String[] UNIQUE_NAME = new String[]{"Patchdowngrade", "Patchlist", "Upgrade", "Downgrade"};

    private JobsDataHelper() {
    }

    private static boolean doMatch(String jobType, String processType) {
        if (JOB_DIAG.equals(jobType)) {
            if (PROCESS_DIAG.equals(processType)) {
                return true;
            }
        } else if (!JOB_DISCOVERY.equals(jobType) && !JOB_DIAG.equals(jobType)) {
            if (JOB_REVISION.equals(jobType)) {
                if (PROCESS_REVISION.equals(processType)) {
                    return true;
                }
            } else if (JOB_REPORT.equals(jobType)) {
                if (PROCESS_FRU_REPORT.equals(processType)) {
                    return true;
                }
                if (PROCESS_EXC_REPORT.equals(processType)) {
                    return true;
                }
            } else if (JOB_AGENT.equals(jobType)) {
                if (PROCESS_RAS_AGENT.equals(processType)) {
                    return true;
                }
            } else if (JOB_ADMIN.equals(jobType)) {
                if (PROCESS_RAS_PUSH.equals(processType)) {
                    return true;
                }
                if (PROCESS_EXTRACT.equals(processType)) {
                    return true;
                }
            } else if (JOB_VOL_VERIFY_KILL.equals(jobType)) {
                if (PROCESS_VOL_VERIFY.equals(processType)) {
                    return true;
                }
            } else if (JOB_PATCH.equals(jobType)) {
                if (processType.indexOf(PROCESS_PATCHLIST) != -1) {
                    return true;
                }
                if (processType.indexOf(PROCESS_PATCHUPGRADE) != -1) {
                    return true;
                }
                if (processType.indexOf(PROCESS_PATCHDOWNGRADE) != -1) {
                    return true;
                }
                if (processType.indexOf(PROCESS_PATCHDOWNGRADEGRADE) != -1) {
                    return true;
                }
            }
        }
        return false;
    }

    public static void populatesJobSummaryTable(JobsSummaryResultDocument.JobsSummaryResult result, String jobType, ActionTableModel jobsTableModel, Locale locale) {
        Process[] process;
        ArrayList<String> keysList = new ArrayList<String>();
        boolean rowAdded = false;
        Date minStartAgent = null;
        Object maxStartAgent = null;
        SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        Processes processes = result.getPROCESSES();
        if (processes != null && (process = processes.getPROCESSArray()) != null) {
            for (int i = 0; i < process.length; ++i) {
                Date start = null;
                Date end = null;
                try {
                    if (process[i].getSTART() != null && !"".equals(process[i].getSTART())) {
                        start = formatter.parse(process[i].getSTART());
                    }
                }
                catch (ParseException ex) {
                    ex.printStackTrace();
                }
                try {
                    if (process[i].getEND() != null && !"".equals(process[i].getEND())) {
                        end = formatter.parse(process[i].getEND());
                    }
                }
                catch (ParseException ex) {
                    try {
                        String s = process[i].getSTART();
                        int index = s.indexOf(32);
                        if (index != -1) {
                            s = s.substring(0, index);
                            s = s + " " + process[i].getEND();
                            end = formatter.parse(s);
                        }
                    }
                    catch (ParseException ex2) {
                        ex2.printStackTrace();
                    }
                }
                String id = process[i].getID();
                String status = process[i].getSTATUS();
                String type = process[i].getTYPE();
                String name = process[i].getNAME();
                String host = process[i].getHOST();
                String localizedStatus = DiagnosticsDataHelper.getLocalizedStatus(status);
                if (JobsDataHelper.doMatch(JOB_AGENT, type)) {
                    minStartAgent = start;
                    maxStartAgent = end;
                }
                if (jobType != null && !JobsDataHelper.doMatch(jobType, type)) continue;
                String detailedType = JobsDataHelper.getJobType(type);
                String processType = PROCESS_TYPE_PROCESS;
                if (PROCESS_DIAG.equals(type)) {
                    String localizedType;
                    processType = PROCESS_TYPE_DIAG;
                    if (name != null && (localizedType = LocalizeUtil.getLocalizedString(PROCESS_DIAG, locale)) != null) {
                        detailedType = localizedType + " - " + name;
                    }
                }
                if (rowAdded) {
                    jobsTableModel.appendRow();
                }
                rowAdded = true;
                keysList.add(DelimUtil.aggregate(new String[]{id, host, processType}));
                jobsTableModel.setValue("jobDetailsHREF", id);
                jobsTableModel.setValue("viewDetailsStr", "action.viewDetails");
                jobsTableModel.setValue("type", detailedType);
                jobsTableModel.setValue("startTime", start);
                jobsTableModel.setValue("endTime", end);
                jobsTableModel.setValue("status", localizedStatus);
                jobsTableModel.setValue("agent", AgentUtil.getShortName(host));
            }
        }
        if (!SystemUtil.isSystemEdition() && (jobType == null || jobType.equals(JOB_DISCOVERY)) && result.getDISCOVERIES() != null) {
            long dateEnd;
            int totalAgentRunning = 0;
            Discovery[] discovery = result.getDISCOVERIES().getDISCOVERYArray();
            if (discovery != null) {
                for (int i = 0; i < discovery.length; ++i) {
                    String discoMode = discovery[i].getDISCOVERYMODE();
                    int agentsRunning = discovery[i].getAGENTSRUNNING().intValue();
                    int agentsStopped = discovery[i].getAGENTSSTOP().intValue();
                    int devFound = discovery[i].getDEVICESFOUND().intValue();
                    totalAgentRunning += agentsRunning;
                }
            }
            String jobStatus = null;
            jobStatus = totalAgentRunning == 0 ? "jobs.status.done" : "jobs.status.running";
            if (rowAdded) {
                jobsTableModel.appendRow();
            }
            keysList.add(DelimUtil.aggregate(new String[]{JOB_DISCOVERY, "", PROCESS_TYPE_DISCO}));
            jobsTableModel.setValue("jobDetailsHREF", JOB_DISCOVERY);
            jobsTableModel.setValue("viewDetailsStr", "action.viewDetails");
            jobsTableModel.setValue("type", JOB_DISCOVERY);
            long dateStart = JobsDataHelper.getDiscoveryStartTime();
            minStartAgent = dateStart == 0L ? new Date(System.currentTimeMillis()) : new Date(dateStart);
            maxStartAgent = dateStart == 0L ? minStartAgent : ((dateEnd = JobsDataHelper.getDiscoveryEndTime()) == 0L ? new Date(System.currentTimeMillis()) : (dateEnd == -1L ? null : new Date(dateEnd)));
            jobsTableModel.setValue("startTime", minStartAgent);
            jobsTableModel.setValue("endTime", maxStartAgent);
            jobsTableModel.setValue("status", jobStatus);
            jobsTableModel.setValue("agent", "-");
            jobsTableModel.setSelectionVisible(false);
        }
        if ((jobType == null || jobType.equals(JOB_VOL_VERIFY)) && JobsDataHelper.hasVolVerify(result)) {
            boolean isRunning = JobsDataHelper.isVolVerifyRunning(result);
            boolean isAborted = JobsDataHelper.isVolVerifyAborted(result);
            String status = "-";
            status = isRunning ? VolVerifyDataHelper.getLocalizedStatus("job.status.running") : (isAborted ? VolVerifyDataHelper.getLocalizedStatus("job.status.aborted") : VolVerifyDataHelper.getLocalizedStatus("job.status.done"));
            Date startTime = null;
            try {
                startTime = JobsDataHelper.getStartDate(result);
            }
            catch (Exception ex) {
                // empty catch block
            }
            Date endTime = null;
            if (!isRunning) {
                try {
                    endTime = JobsDataHelper.getEndDate(result);
                }
                catch (Exception ex) {
                    // empty catch block
                }
            }
            if (rowAdded) {
                jobsTableModel.appendRow();
            }
            keysList.add(DelimUtil.aggregate(new String[]{JOB_VOL_VERIFY, "", PROCESS_TYPE_DISCO}));
            jobsTableModel.setValue("jobDetailsHREF", JOB_VOL_VERIFY);
            jobsTableModel.setValue("viewDetailsStr", "action.viewDetails");
            jobsTableModel.setValue("type", JOB_VOL_VERIFY);
            jobsTableModel.setValue("startTime", startTime);
            jobsTableModel.setValue("endTime", endTime);
            jobsTableModel.setValue("status", status);
            jobsTableModel.setValue("agent", "-");
            jobsTableModel.setSelectionVisible(false);
        }
        String[] keysArray = new String[keysList.size()];
        keysList.toArray(keysArray);
        jobsTableModel.setKeys(keysArray);
    }

    public static boolean hasVolVerify(JobsSummaryResultDocument.JobsSummaryResult result) {
        VolVerifyDevice[] devices;
        VolVerifyReport report;
        boolean hasVolVerify = false;
        if (result != null && (report = result.getVOLVERIFYREPORT()) != null && (devices = report.getDEVICEArray()) != null && devices.length != 0) {
            hasVolVerify = true;
        }
        return hasVolVerify;
    }

    public static boolean isVolVerifyRunning(JobsSummaryResultDocument.JobsSummaryResult result) {
        VolVerifyDevice[] devices;
        VolVerifyReport report;
        boolean isRunning = false;
        if (result != null && (report = result.getVOLVERIFYREPORT()) != null && (devices = report.getDEVICEArray()) != null) {
            for (int i = 0; i < devices.length; ++i) {
                if ("ABORTED".equals(devices[i].getSTATUS()) || !"Running".equals(devices[i].getENDDATE())) continue;
                isRunning = true;
                break;
            }
        }
        return isRunning;
    }

    public static boolean isVolVerifyAborted(JobsSummaryResultDocument.JobsSummaryResult result) {
        VolVerifyDevice[] devices;
        VolVerifyReport report;
        boolean isAborted = false;
        if (result != null && (report = result.getVOLVERIFYREPORT()) != null && (devices = report.getDEVICEArray()) != null) {
            for (int i = 0; i < devices.length; ++i) {
                if (!"ABORTED".equals(devices[i].getSTATUS())) continue;
                isAborted = true;
                break;
            }
        }
        return isAborted;
    }

    public static Date getStartDate(JobsSummaryResultDocument.JobsSummaryResult result) {
        VolVerifyDevice[] devices;
        VolVerifyReport report;
        Date startDate = null;
        if (result != null && (report = result.getVOLVERIFYREPORT()) != null && (devices = report.getDEVICEArray()) != null) {
            SimpleDateFormat formatter = new SimpleDateFormat("MM-dd HH:mm:ss");
            for (int i = 0; i < devices.length; ++i) {
                Date start = null;
                try {
                    if (devices[i].getSTARTDATE() != null) {
                        start = formatter.parse(devices[i].getSTARTDATE());
                    }
                }
                catch (ParseException ex) {
                    // empty catch block
                }
                if (startDate == null) {
                    startDate = start;
                }
                if (startDate == null || start == null || startDate.compareTo(start) != 1) continue;
                startDate = start;
            }
        }
        if (startDate != null) {
            startDate.setYear(new Date().getYear());
        }
        return startDate;
    }

    public static Date getEndDate(JobsSummaryResultDocument.JobsSummaryResult result) {
        VolVerifyDevice[] devices;
        VolVerifyReport report;
        Date endDate = null;
        if (result != null && (report = result.getVOLVERIFYREPORT()) != null && (devices = report.getDEVICEArray()) != null) {
            SimpleDateFormat formatter = new SimpleDateFormat("MM-dd HH:mm:ss");
            for (int i = 0; i < devices.length; ++i) {
                Date end = null;
                try {
                    if (devices[i].getENDDATE() != null) {
                        end = formatter.parse(devices[i].getENDDATE());
                    }
                }
                catch (ParseException ex) {
                    // empty catch block
                }
                if (endDate == null) {
                    endDate = end;
                }
                if (endDate == null || end == null || endDate.compareTo(end) == 1) continue;
                endDate = end;
            }
        }
        if (endDate != null) {
            endDate.setYear(new Date().getYear());
        }
        return endDate;
    }

    public static void populateSANDiscoveryTable(String agent, JobsSummaryResultDocument.JobsSummaryResult result, CCActionTableModel jobsTableModel, Locale locale) {
        Snapshot[] snapshot;
        if (agent == null) {
            return;
        }
        if (result.getTOPOSNAPSHOTS() != null && (snapshot = result.getTOPOSNAPSHOTS().getSNAPSHOTArray()) != null) {
            for (int i = 0; i < snapshot.length; ++i) {
                String currentAgent = snapshot[i].getAGENT();
                if (!agent.equals(currentAgent)) continue;
                String status = snapshot[i].getSTATUS();
                String localizedStatus = DiagnosticsDataHelper.getLocalizedStatus(status);
                String startTime = snapshot[i].getSTARTTIME();
                String endTime = snapshot[i].getCREATED();
                String localizedStartTime = startTime;
                String localizedEndTime = endTime;
                try {
                    localizedStartTime = DateUtil.toString1(DateUtil.toDate1(startTime), locale);
                    localizedEndTime = DateUtil.toString1(DateUtil.toDate1(endTime), locale);
                }
                catch (Exception ex) {
                    // empty catch block
                }
                jobsTableModel.setValue("propertyName", (Object)"job.details.startDate");
                jobsTableModel.setValue("propertyValue", (Object)localizedStartTime);
                jobsTableModel.appendRow();
                jobsTableModel.setValue("propertyName", (Object)"job.details.endDate");
                jobsTableModel.setValue("propertyValue", (Object)localizedEndTime);
                jobsTableModel.appendRow();
                jobsTableModel.setValue("propertyName", (Object)"job.details.status");
                jobsTableModel.setValue("propertyValue", (Object)DiagnosticsDataHelper.getLocalizedStatus(status));
                jobsTableModel.appendRow();
                jobsTableModel.setValue("propertyName", (Object)"job.details.agent");
                jobsTableModel.setValue("propertyValue", (Object)agent);
                break;
            }
        }
    }

    public static String getSANDiscoveryErrorMsg(String agent, JobsSummaryResultDocument.JobsSummaryResult result, Locale locale) {
        Snapshot[] snapshot;
        if (agent == null) {
            return null;
        }
        String errorMsg = null;
        if (result.getTOPOSNAPSHOTS() != null && (snapshot = result.getTOPOSNAPSHOTS().getSNAPSHOTArray()) != null) {
            for (int i = 0; i < snapshot.length; ++i) {
                String currentAgent = snapshot[i].getAGENT();
                if (!agent.equals(currentAgent)) continue;
                errorMsg = snapshot[i].getERROR();
                break;
            }
        }
        return errorMsg;
    }

    public static boolean isSANDiscoveryRunning(String agent, JobsSummaryResultDocument.JobsSummaryResult result) {
        Snapshot[] snapshot;
        boolean isRunning = false;
        if (result.getTOPOSNAPSHOTS() != null && (snapshot = result.getTOPOSNAPSHOTS().getSNAPSHOTArray()) != null) {
            for (int i = 0; i < snapshot.length; ++i) {
                if (!"running".equals(snapshot[i].getSTATUS())) continue;
                isRunning = true;
                break;
            }
        }
        return isRunning;
    }

    public static long getDiscoveryEndTime() {
        Process[] process;
        JobsSummaryResultDocument.JobsSummaryResult result = Getter.getJobsSummary();
        SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        Processes processes = result.getPROCESSES();
        if (processes != null && (process = processes.getPROCESSArray()) != null) {
            Date lastestEnd = null;
            for (int i = 0; i < process.length; ++i) {
                Date end = null;
                try {
                    if (process[i].getTYPE() == null || !process[i].getTYPE().startsWith("discover")) continue;
                    if ("Running".equals(process[i].getSTATUS())) {
                        return -1L;
                    }
                    end = formatter.parse(process[i].getEND());
                    if (lastestEnd != null && end.compareTo(lastestEnd) <= 0) continue;
                    lastestEnd = end;
                    continue;
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
            if (lastestEnd != null) {
                return lastestEnd.getTime();
            }
        }
        return 0L;
    }

    public static long getDiscoveryStartTime() {
        Process[] process;
        JobsSummaryResultDocument.JobsSummaryResult result = Getter.getJobsSummary();
        SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        Processes processes = result.getPROCESSES();
        if (processes != null && (process = processes.getPROCESSArray()) != null) {
            Date lastestStart = null;
            for (int i = 0; i < process.length; ++i) {
                Date start = null;
                Object end = null;
                try {
                    if (process[i].getTYPE() == null || !process[i].getTYPE().startsWith("discover")) continue;
                    start = formatter.parse(process[i].getSTART());
                    if (lastestStart != null && start.compareTo(lastestStart) >= 0) continue;
                    lastestStart = start;
                    continue;
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
            if (lastestStart != null) {
                return lastestStart.getTime();
            }
        }
        return 0L;
    }

    public static long getDiscoveryStartTime(String host, String mechanism) {
        Process[] process;
        JobsSummaryResultDocument.JobsSummaryResult result = Getter.getJobsSummary();
        SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        Processes processes = result.getPROCESSES();
        if (processes != null && (process = processes.getPROCESSArray()) != null) {
            Date lastestStart = null;
            for (int i = 0; i < process.length; ++i) {
                Date start = null;
                Object end = null;
                try {
                    if (process[i].getTYPE() == null || !process[i].getTYPE().startsWith("discover") || process[i].getID() == null || process[i].getID().indexOf(mechanism) == -1 || host != null && !"".equals(host) && process[i].getID().indexOf(host) == -1) continue;
                    start = formatter.parse(process[i].getSTART());
                    if (lastestStart != null && start.compareTo(lastestStart) >= 0) continue;
                    lastestStart = start;
                    continue;
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
            if (lastestStart != null) {
                return lastestStart.getTime();
            }
        }
        return 0L;
    }

    static String getJobType(String job) {
        if (job == null) {
            return null;
        }
        String jobType = job;
        for (int i = 0; i < UNIQUE.length; ++i) {
            if (job.indexOf(UNIQUE[i]) == -1) continue;
            return UNIQUE[i];
        }
        return jobType;
    }

    static boolean requireFlag(String key) {
        int index;
        boolean requireFlag = false;
        if (key != null && (index = key.indexOf(58)) != -1) {
            String type = key.substring(index + 1);
            for (int i = 0; i < UNIQUE_NAME.length; ++i) {
                if (!UNIQUE_NAME[i].equals(type)) continue;
                requireFlag = true;
                break;
            }
        }
        return requireFlag;
    }
}

