/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.mgmt.fm.storade.ui.viewbeans.jobs;

import com.sun.netstorage.mgmt.fm.storade.schema.jobs.DiagDetailsResultDocument;
import com.sun.netstorage.mgmt.fm.storade.schema.jobs.JobDetailsResultDocument;
import com.sun.netstorage.mgmt.fm.storade.ui.model.ActionTableModel;
import com.sun.netstorage.mgmt.fm.storade.ui.util.DateUtil;
import com.sun.netstorage.mgmt.fm.storade.ui.util.LocalizeUtil;
import com.sun.netstorage.mgmt.fm.storade.ui.viewbeans.diagnostics.DiagnosticsDataHelper;
import java.util.Locale;

public class JobDetailsDataHelper {
    private static final String STORADE_STATUS_RUNNING = "Running";

    private JobDetailsDataHelper() {
    }

    public static void populateSummaryTable(JobDetailsResultDocument.JobDetailsResult result, ActionTableModel model, Locale locale) {
        model.setValue("nameStr", "job.details.host");
        if (result != null) {
            if (result.getDETAILS() != null) {
                if (result.getDETAILS().getHOST() != null && !"".equals(result.getDETAILS().getHOST())) {
                    model.setValue("valueStr", result.getDETAILS().getHOST());
                } else {
                    model.setValue("valueStr", LocalizeUtil.getLocalizedString("host.local", locale));
                }
            }
        } else {
            model.setValue("valueStr", null);
        }
        model.appendRow();
        model.setValue("nameStr", "job.details.startDate");
        if (result != null) {
            if (result.getDETAILS() != null && result.getDETAILS().getSTARTDATE() != null) {
                String localizedStartTime = result.getDETAILS().getSTARTDATE();
                try {
                    if (localizedStartTime != null && !"".equals(localizedStartTime)) {
                        localizedStartTime = DateUtil.toString1(DateUtil.toDate1(result.getDETAILS().getSTARTDATE()), locale);
                    }
                }
                catch (Exception ex) {
                    // empty catch block
                }
                model.setValue("valueStr", localizedStartTime);
            }
        } else {
            model.setValue("valueStr", null);
        }
        model.appendRow();
        model.setValue("nameStr", "job.details.endDate");
        if (result != null) {
            if (result.getDETAILS() != null && result.getDETAILS().getENDDATE() != null) {
                String localizedEndTime = result.getDETAILS().getENDDATE();
                try {
                    if (localizedEndTime != null && !"".equals(localizedEndTime)) {
                        localizedEndTime = DateUtil.toString1(DateUtil.toDate1(result.getDETAILS().getENDDATE()), locale);
                    }
                }
                catch (Exception ex) {
                    // empty catch block
                }
                model.setValue("valueStr", localizedEndTime);
            }
        } else {
            model.setValue("valueStr", null);
        }
        model.appendRow();
        model.setValue("nameStr", "job.details.status");
        if (result != null) {
            if (result.getDETAILS() != null && result.getDETAILS().getSTATUS() != null) {
                String status = result.getDETAILS().getSTATUS();
                String localizedStatus = DiagnosticsDataHelper.getLocalizedStatus(status);
                model.setValue("valueStr", localizedStatus);
            }
        } else {
            model.setValue("valueStr", null);
        }
    }

    public static String getData(JobDetailsResultDocument.JobDetailsResult result) {
        String data = null;
        if (result != null && result.getDETAILS() != null && result.getDETAILS().getINFO() != null && (data = result.getDETAILS().getINFO().getDATA()) != null) {
            data = data.replaceAll("\n", "<br>");
        }
        return data;
    }

    public static String getTrace(JobDetailsResultDocument.JobDetailsResult result) {
        String trace = null;
        if (result != null && result.getDETAILS() != null && result.getDETAILS().getINFO() != null && (trace = result.getDETAILS().getINFO().getTRACE()) != null) {
            trace = trace.replaceAll("\n", "<br>");
        }
        return trace;
    }

    public static String getDiagOutput(DiagDetailsResultDocument.DiagDetailsResult result) {
        String output = null;
        if (result != null && result.getDETAILS() != null && (output = result.getDETAILS().getOUTPUT()) != null) {
            output = output.replaceAll("<", "&lt;");
            output = output.replaceAll(">", "&gt;");
            output = output.replaceAll("\n", "<br>");
        }
        return output;
    }

    public static String getDiagError(DiagDetailsResultDocument.DiagDetailsResult result) {
        String error = null;
        if (result != null && result.getDETAILS() != null && (error = result.getDETAILS().getERROR()) != null) {
            error = error.replaceAll("<", "&lt;");
            error = error.replaceAll(">", "&gt;");
            error = error.replaceAll("\n", "<br>");
        }
        return error;
    }

    public static boolean isRunning(JobDetailsResultDocument.JobDetailsResult result) {
        String status;
        boolean isRunning = false;
        if (result != null && result.getDETAILS() != null && STORADE_STATUS_RUNNING.equals(status = result.getDETAILS().getSTATUS())) {
            isRunning = true;
        }
        return isRunning;
    }
}

