/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.mgmt.fm.storade.ui.viewbeans.jobs;

import com.iplanet.jato.RequestContext;
import com.iplanet.jato.RequestManager;
import com.iplanet.jato.view.ContainerView;
import com.iplanet.jato.view.ContainerViewBase;
import com.iplanet.jato.view.View;
import com.iplanet.jato.view.event.ChildDisplayEvent;
import com.iplanet.jato.view.event.DisplayEvent;
import com.iplanet.jato.view.event.RequestInvocationEvent;
import com.iplanet.jato.view.html.HREF;
import com.sun.netstorage.mgmt.fm.storade.schema.jobs.JobsSummaryResultDocument;
import com.sun.netstorage.mgmt.fm.storade.ui.common.UIMastHeadViewBeanBase;
import com.sun.netstorage.mgmt.fm.storade.ui.model.ActionTableModel;
import com.sun.netstorage.mgmt.fm.storade.ui.util.Connection;
import com.sun.netstorage.mgmt.fm.storade.ui.util.DateUtil;
import com.sun.netstorage.mgmt.fm.storade.ui.util.Debug;
import com.sun.netstorage.mgmt.fm.storade.ui.util.DelimUtil;
import com.sun.netstorage.mgmt.fm.storade.ui.util.SystemUtil;
import com.sun.netstorage.mgmt.fm.storade.ui.util.UserUtil;
import com.sun.netstorage.mgmt.fm.storade.ui.view.ActionTable;
import com.sun.netstorage.mgmt.fm.storade.ui.view.ActionTableInterface;
import com.sun.netstorage.mgmt.fm.storade.ui.viewbeans.jobs.Getter;
import com.sun.netstorage.mgmt.fm.storade.ui.viewbeans.jobs.JobsDataHelper;
import com.sun.netstorage.mgmt.fm.storade.ui.viewbeans.jobs.Setter;
import com.sun.web.ui.view.html.CCDropDownMenu;
import com.sun.web.ui.view.html.CCStaticTextField;
import java.io.IOException;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Locale;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;

public class HistoricalJobsViewBean
extends UIMastHeadViewBeanBase {
    public static final String PAGE_NAME = "HistoricalJobs";
    public static final String DEFAULT_DISPLAY_URL = "/jsp/jobs/HistoricalJobs.jsp";
    public static final String CHILD_JOBS_TABLE = "JobsTable";
    public static final String CHILD_DETAILS_HREF = "jobDetailsHREF";
    public static final String CHILD_START_TIME = "startTime";
    public static final String CHILD_END_TIME = "endTime";
    private ActionTableModel jobsModel;
    private String jobType;
    public static final String CHILD_FILTERMENU = "FilterMenu";
    public static final String CHILD_FILTERMENU_HREF = "FilterMenuHref";
    private static final String JOB_KEY = "jobs.";

    public HistoricalJobsViewBean() {
        super(PAGE_NAME, DEFAULT_DISPLAY_URL);
        this.initModel();
    }

    public void setRequestContext(RequestContext ctx) {
        super.setRequestContext(ctx);
    }

    protected void subRegisterChildren() {
        this.registerChild(CHILD_JOBS_TABLE, ActionTable.class);
        this.registerChild(CHILD_FILTERMENU_HREF, HREF.class);
        this.jobsModel.registerChildren((ContainerViewBase)this);
    }

    protected View subCreateChild(String name) {
        if (name.equals(CHILD_JOBS_TABLE)) {
            ActionTable child = new ActionTable((ContainerView)this, this.jobsModel, name);
            return child;
        }
        if (name.equals(CHILD_FILTERMENU_HREF)) {
            HREF child = new HREF((ContainerView)this, name, null);
            return child;
        }
        if (this.jobsModel.isChildSupported(name)) {
            View v = this.jobsModel.createChild((View)this, name);
            if (name.equals(CHILD_FILTERMENU) && this.jobType != null) {
                CCDropDownMenu filter = (CCDropDownMenu)v;
                filter.setValue((Object)this.jobType);
            }
            this.disableButtonIfNotPrivilege(v);
            return v;
        }
        return null;
    }

    private void initModel() {
        this.jobsModel = SystemUtil.isSystemEdition() ? new ActionTableModel(RequestManager.getRequestContext().getServletContext(), "/xml/table/ArchivedJobsTable_SE.xml") : new ActionTableModel(RequestManager.getRequestContext().getServletContext(), "/xml/table/ArchivedJobsTable.xml");
        this.jobsModel.setActionValue("deleteButton", "button.delete");
        this.jobsModel.setActionValue("jobDetailCol", "jobs.table.details");
        this.jobsModel.setActionValue("jobs.table.type", "jobs.table.type");
        this.jobsModel.setActionValue("jobs.table.startTime", "jobs.table.startTime");
        this.jobsModel.setActionValue("jobs.table.endTime", "jobs.table.endTime");
        this.jobsModel.setActionValue("jobs.table.status", "jobs.table.status");
        this.jobsModel.setActionValue("jobs.table.agent", "jobs.table.agent");
        this.jobsModel.setPrimarySortName(CHILD_START_TIME);
        this.jobsModel.setPrimarySortOrder("descending");
        this.jobsModel.setSecondarySortName(CHILD_END_TIME);
        this.jobsModel.setSecondarySortOrder("descending");
    }

    public boolean beginChildDisplay(ChildDisplayEvent event) {
        String childName;
        HttpServletRequest request = RequestManager.getRequestContext().getRequest();
        HttpSession session = this.getRequestContext().getRequest().getSession();
        session.setAttribute("storade.privilegedRole", (Object)new Boolean(UserUtil.isPrivilegedRole(request)).toString());
        Locale locale = request.getLocale();
        if (locale == null) {
            locale = Locale.getDefault();
        }
        if (CHILD_START_TIME.equals(childName = event.getChildName()) || CHILD_END_TIME.equals(childName)) {
            CCStaticTextField textField = (CCStaticTextField)this.getChild(childName);
            String formatMask = DateUtil.getMediumFormatMask(locale);
            textField.setFormatMask(formatMask);
        }
        return true;
    }

    public void beginDisplay(DisplayEvent event) {
        HttpServletRequest request = RequestManager.getRequestContext().getRequest();
        Locale locale = request.getLocale();
        if (locale == null) {
            locale = Locale.getDefault();
        }
        this.jobType = request.getParameter("jobType");
        JobsSummaryResultDocument.JobsSummaryResult result = null;
        try {
            result = Getter.getArchivedJobsSummary();
            this.setAlarmSummary(result.getAlarmSummary());
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        try {
            JobsDataHelper.populatesJobSummaryTable(result, this.jobType, this.jobsModel, locale);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        super.beginDisplay(event);
    }

    public void handleJobDetailsHREFRequest(RequestInvocationEvent event) {
        String id = (String)this.getDisplayFieldValue(CHILD_DETAILS_HREF);
        try {
            String page = "jobs/HistoricalJobDetails";
            page = page + "?id=" + this.urlencode(id);
            if (id.indexOf("Upgrade") != -1 || id.indexOf("Downgrade") != -1 || id.indexOf("Patchdowngrade") != -1 || id.indexOf("Patchlist") != -1) {
                page = "jobs/HistoricalJobPatchDetails";
                page = page + "?id=" + URLEncoder.encode(id, "UTF-8");
            }
            String url = "/" + Connection.getAppName() + "/" + page;
            RequestContext requestContext = event.getRequestContext();
            requestContext.getResponse().sendRedirect(url);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public void handleFilterMenuHrefRequest(RequestInvocationEvent event) {
        String value = this.getDisplayFieldValue(CHILD_FILTERMENU) != null ? (String)this.getDisplayFieldValue(CHILD_FILTERMENU) : "";
        String url = "/" + Connection.getAppName() + "/jobs/HistoricalJobs";
        if (value != null && value.startsWith(JOB_KEY)) {
            url = url + "?jobType=" + this.urlencode(value);
        }
        try {
            event.getRequestContext().getResponse().sendRedirect(url);
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
    }

    public void handleDeleteButtonRequest(RequestInvocationEvent event) {
        ActionTableInterface child = (ActionTableInterface)this.getChild(CHILD_JOBS_TABLE);
        ArrayList keys = child.getSelectedKeysForCurrentPage();
        int notDeletedNum = 0;
        StringBuffer buffer = new StringBuffer();
        for (int i = 0; i < keys.size(); ++i) {
            try {
                String id = (String)keys.get(i);
                Debug.println("SELECTED ID: " + id);
                String[] values = DelimUtil.desaggregate(id);
                String key = values[0];
                String host = values[1];
                String type = values[2];
                buffer.append(key);
                if (i != keys.size() - 1) {
                    buffer.append(", ");
                }
                Setter.deleteArchive(key, host, type);
                continue;
            }
            catch (Exception ex) {
                ++notDeletedNum;
                ex.printStackTrace();
            }
        }
        if (notDeletedNum != 0) {
            this.setInlineAlert("error", "jobs.inline.remove.error", null, null, null);
        } else {
            String[] param = new String[]{buffer.toString()};
            this.setInlineAlert("info", "jobs.inline.remove.info", param, null, null);
        }
        String url = "/" + Connection.getAppName() + "/jobs/HistoricalJobs";
        try {
            event.getRequestContext().getResponse().sendRedirect(url);
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
    }
}

