/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.mgmt.fm.storade.ui.viewbeans.events;

import com.sun.netstorage.mgmt.fm.storade.schema.admin.EventFilterResultDocument;
import com.sun.netstorage.mgmt.fm.storade.schema.admin.EventListResultDocument;
import com.sun.netstorage.mgmt.fm.storade.schema.admin.GridInfoResultDocument;
import com.sun.netstorage.mgmt.fm.storade.ui.util.Connection;
import com.sun.netstorage.mgmt.fm.storade.ui.util.Debug;
import com.sun.netstorage.mgmt.fm.storade.ui.util.LocalizeUtil;
import com.sun.netstorage.mgmt.fm.storade.ui.util.XmlUtil;
import java.net.URLEncoder;
import java.util.Locale;
import java.util.Properties;

public class Getter {
    private Getter() {
    }

    public static GridInfoResultDocument.GridInfoResult getGridInfoResult(Properties eventProp, Locale locale) {
        GridInfoResultDocument.GridInfoResult result = null;
        try {
            String type = eventProp.getProperty("type");
            String eventType = eventProp.getProperty("eventType");
            String element = eventProp.getProperty("element");
            String code = eventProp.getProperty("code");
            String s = Connection.getComboHeader() + "?GO=Client::EventLog::getGridInfo" + "&type=" + URLEncoder.encode(type + "." + eventType, "UTF-8") + "&comp=" + URLEncoder.encode(element, "UTF-8") + "&code=" + URLEncoder.encode(code, "UTF-8");
            locale = LocalizeUtil.resolveLocale(locale);
            s = s + "&locale=" + locale.toString();
            s = s + "&GO2=Client::Alarm::summary";
            String data = Connection.getData(s);
            data = XmlUtil.addHeader(data, "GridInfoResult");
            Debug.println("REQUEST: " + s);
            Debug.println("DATA: " + data);
            GridInfoResultDocument resultDoc = GridInfoResultDocument.Factory.parse((String)data);
            result = resultDoc.getGridInfoResult();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return result;
    }

    public static EventFilterResultDocument.EventFilterResult getEventFilterResult() {
        EventFilterResultDocument.EventFilterResult result = null;
        try {
            String s = Connection.getComboHeader() + "?GO=Client::EventLog::getHosts" + "&GO2=Client::EventLog::getCategories" + "&GO3=Client::EventLog::getTopics" + "&GO4=Client::EventLog::getTypes" + "&GO4=Client::EventLog::getSeverities";
            String data = Connection.getData(s);
            data = XmlUtil.addHeader(data, "EventFilterResult");
            Debug.println("REQUEST: " + s);
            Debug.println("DATA: " + data);
            EventFilterResultDocument resultDoc = EventFilterResultDocument.Factory.parse((String)data);
            result = resultDoc.getEventFilterResult();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return result;
    }

    public static EventListResultDocument.EventListResult getEventList(Properties eventProp) {
        EventListResultDocument.EventListResult result = null;
        String s = Connection.getComboHeader() + "?GO=Client::EventLog::getEventLog";
        try {
            String assetID = eventProp.getProperty("assetID");
            String eventID = null;
            String host = eventProp.getProperty("Host");
            String category = eventProp.getProperty("Category");
            String type = eventProp.getProperty("Type");
            String topic = eventProp.getProperty("Topic");
            String severity = eventProp.getProperty("Severity");
            String maxSize = eventProp.getProperty("MaxSize");
            String filter1 = eventProp.getProperty("Filter1");
            String aggr = eventProp.getProperty("Aggr");
            if (assetID != null) {
                int pos = assetID.indexOf(":");
                String type2 = assetID.substring(0, pos);
                String key = assetID.substring(pos + 1);
                s = s + "&key=" + URLEncoder.encode(key, "UTF-8") + "&type=" + URLEncoder.encode(type2, "UTF-8");
            }
            if (eventID != null) {
                s = s + "&eventID=" + URLEncoder.encode(eventID, "UTF-8");
            }
            if (host != null) {
                s = s + "&hostname=" + URLEncoder.encode(host, "UTF-8");
            }
            if (category != null) {
                s = s + "&category=" + URLEncoder.encode(category, "UTF-8");
            }
            if (type != null) {
                s = s + "&eventtype=" + URLEncoder.encode(type, "UTF-8");
            }
            if (topic != null) {
                s = s + "&event=" + URLEncoder.encode(topic, "UTF-8");
            }
            if (severity != null) {
                s = s + "&sev=" + URLEncoder.encode(severity, "UTF-8");
            }
            if (filter1 != null) {
                s = s + "&filter1=" + URLEncoder.encode(filter1, "UTF-8");
            }
            if (maxSize != null) {
                s = s + "&MAXSIZE=" + URLEncoder.encode(maxSize, "UTF-8");
            }
            if ("Y".equals(aggr)) {
                s = s + "&AGGR=1";
            }
            s = s + "&GO2=Client::Alarm::summary";
            s = s + "&GO3=Client::Config::listDevices";
            s = s + "&GO4=Client::Revision::getHosts";
            String data = Connection.getData(s);
            Debug.println("REQUEST: " + s);
            Debug.println("DATA: " + data);
            data = XmlUtil.addHeader(data, "EventListResult");
            EventListResultDocument resultDoc = EventListResultDocument.Factory.parse((String)data);
            result = resultDoc.getEventListResult();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return result;
    }
}

