/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.mgmt.fm.storade.ui.viewbeans.events;

import com.iplanet.jato.RequestContext;
import com.iplanet.jato.RequestManager;
import com.iplanet.jato.view.ContainerView;
import com.iplanet.jato.view.ContainerViewBase;
import com.iplanet.jato.view.View;
import com.iplanet.jato.view.event.ChildDisplayEvent;
import com.iplanet.jato.view.event.DisplayEvent;
import com.iplanet.jato.view.event.RequestInvocationEvent;
import com.iplanet.jato.view.html.HiddenField;
import com.sun.netstorage.mgmt.fm.storade.schema.admin.EventListResultDocument;
import com.sun.netstorage.mgmt.fm.storade.ui.common.UIMastHeadViewBeanBase;
import com.sun.netstorage.mgmt.fm.storade.ui.util.DateUtil;
import com.sun.netstorage.mgmt.fm.storade.ui.viewbeans.VBConstants;
import com.sun.netstorage.mgmt.fm.storade.ui.viewbeans.events.EventFilterViewBean;
import com.sun.netstorage.mgmt.fm.storade.ui.viewbeans.events.EventsDataHelper;
import com.sun.netstorage.mgmt.fm.storade.ui.viewbeans.events.Getter;
import com.sun.web.ui.model.CCActionTableModel;
import com.sun.web.ui.model.CCActionTableModelInterface;
import com.sun.web.ui.view.html.CCHref;
import com.sun.web.ui.view.html.CCStaticTextField;
import com.sun.web.ui.view.table.CCActionTable;
import java.util.Locale;
import java.util.Properties;
import javax.servlet.http.HttpServletRequest;

public class EventsViewBean
extends UIMastHeadViewBeanBase {
    public static final String PAGE_NAME = "Events";
    public static final String DEFAULT_DISPLAY_URL = "/jsp/events/Events.jsp";
    public static final String CHILD_TABLE = "EventsTable";
    public static final String CHILD_HOST = "Host";
    public static final String CHILD_CATEGORY = "Category";
    public static final String CHILD_TYPE = "Type";
    public static final String CHILD_SEVERITY = "Severity";
    public static final String CHILD_MAXSIZE = "MaxSize";
    public static final String CHILD_FILTER1 = "Filter1";
    public static final String CHILD_TOPIC = "Topic";
    public static final String CHILD_AGGR = "Aggr";
    public static final String CHILD_EVENTFILTER_COMMAND = "EventFilterCommand";
    public static final String ASSETID_KEY = "assetID";
    public static final String DISPLAYNAME_KEY = "displayName";
    public static final String EVENTPROP_KEY = "storade.eventProp";
    public static final String CHILD_EVENTFILTER_VIEW = "EventFilter";
    private CCActionTableModel eventsTableModel = new CCActionTableModel(RequestManager.getRequestContext().getServletContext(), "/xml/table/EventsTable.xml");

    public EventsViewBean() {
        super(PAGE_NAME, DEFAULT_DISPLAY_URL);
    }

    public void setRequestContext(RequestContext ctx) {
        super.setRequestContext(ctx);
        this.initModel();
    }

    protected void subRegisterChildren() {
        this.registerChild(CHILD_TABLE, CCActionTable.class);
        this.registerChild(CHILD_HOST, HiddenField.class);
        this.registerChild(CHILD_CATEGORY, HiddenField.class);
        this.registerChild(CHILD_TYPE, HiddenField.class);
        this.registerChild(CHILD_SEVERITY, HiddenField.class);
        this.registerChild(CHILD_MAXSIZE, HiddenField.class);
        this.registerChild(CHILD_FILTER1, HiddenField.class);
        this.registerChild(CHILD_TOPIC, HiddenField.class);
        this.registerChild(CHILD_AGGR, HiddenField.class);
        this.eventsTableModel.registerChildren((ContainerViewBase)this);
        this.registerChild(CHILD_EVENTFILTER_COMMAND, CCHref.class);
        this.registerChild(CHILD_EVENTFILTER_VIEW, EventFilterViewBean.class);
    }

    protected View subCreateChild(String name) {
        if (name.equals(CHILD_TABLE)) {
            CCActionTable child = new CCActionTable((ContainerView)this, (CCActionTableModelInterface)this.eventsTableModel, name);
            return child;
        }
        if (name.equals(CHILD_HOST) || name.equals(CHILD_CATEGORY) || name.equals(CHILD_TYPE) || name.equals(CHILD_SEVERITY) || name.equals(CHILD_MAXSIZE) || name.equals(CHILD_FILTER1) || name.equals(CHILD_TOPIC) || name.equals(CHILD_AGGR)) {
            HiddenField child = new HiddenField((ContainerView)this, name, null);
            return child;
        }
        if (name.equals(CHILD_EVENTFILTER_COMMAND)) {
            CCHref child = new CCHref((ContainerView)this, name, null);
            return child;
        }
        if (name.equals(CHILD_EVENTFILTER_VIEW)) {
            EventFilterViewBean child = new EventFilterViewBean((View)this, name);
            return child;
        }
        if (this.eventsTableModel.isChildSupported(name)) {
            return this.eventsTableModel.createChild((View)this, name);
        }
        return null;
    }

    private void initModel() {
        this.eventsTableModel.setActionValue("topicCol", (Object)"table.header.topic");
        this.eventsTableModel.setActionValue("dateCol", (Object)"table.header.time");
        this.eventsTableModel.setActionValue("parentNameCol", (Object)"table.header.parent");
        this.eventsTableModel.setActionValue("elementNameCol", (Object)"table.header.element");
        this.eventsTableModel.setActionValue("actionCol", (Object)"table.header.eventDetails");
        this.eventsTableModel.setPrimarySortName("dateStr");
        this.eventsTableModel.setPrimarySortOrder("descending");
        this.eventsTableModel.setAdvancedFilterChild(CHILD_EVENTFILTER_VIEW);
        this.eventsTableModel.setAdvancedFilterHeight(450);
        this.eventsTableModel.setProductNameAlt("secondaryMasthead.productNameAlt");
        this.eventsTableModel.setProductNameSrc(VBConstants.getProductImageForSecondaryMastHead());
    }

    public boolean beginChildDisplay(ChildDisplayEvent event) {
        String childName;
        HttpServletRequest request = RequestManager.getRequestContext().getRequest();
        Locale locale = request.getLocale();
        if (locale == null) {
            locale = Locale.getDefault();
        }
        if ("dateStr".equals(childName = event.getChildName())) {
            CCStaticTextField textField = (CCStaticTextField)this.getChild(childName);
            String formatMask = DateUtil.getMediumFormatMask(locale);
            textField.setFormatMask(formatMask);
        }
        return true;
    }

    public void beginDisplay(DisplayEvent event) {
        try {
            this.setInPageHelp("help.event.defaultSize", null);
            Properties eventProp = this.getEventProperties();
            EventListResultDocument.EventListResult result = Getter.getEventList(eventProp);
            this.setAlarmSummary(result.getAlarmSummary());
            Locale locale = RequestManager.getRequestContext().getRequest().getLocale();
            EventsDataHelper.populateEventsTableModel(result, this.eventsTableModel, eventProp, locale);
            String host = eventProp.getProperty(CHILD_HOST);
            String category = eventProp.getProperty(CHILD_CATEGORY);
            String type = eventProp.getProperty(CHILD_TYPE);
            String severity = eventProp.getProperty(CHILD_SEVERITY);
            String topic = eventProp.getProperty(CHILD_TOPIC);
            String maxSize = eventProp.getProperty(CHILD_MAXSIZE);
            String filter1 = eventProp.getProperty(CHILD_FILTER1);
            String aggr = eventProp.getProperty(CHILD_AGGR);
            this.setDisplayFieldValue(CHILD_HOST, host);
            this.setDisplayFieldValue(CHILD_CATEGORY, category);
            this.setDisplayFieldValue(CHILD_TYPE, type);
            this.setDisplayFieldValue(CHILD_SEVERITY, severity);
            this.setDisplayFieldValue(CHILD_TOPIC, topic);
            this.setDisplayFieldValue(CHILD_MAXSIZE, maxSize);
            this.setDisplayFieldValue(CHILD_FILTER1, filter1);
            this.setDisplayFieldValue(CHILD_AGGR, aggr);
            this.saveEventProperties(eventProp);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        try {
            super.beginDisplay(event);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    protected void setPageInfo() {
        Properties p = this.getEventProperties();
        String assetID = p.getProperty(ASSETID_KEY);
        String displayName = p.getProperty(DISPLAYNAME_KEY);
        if (displayName == null) {
            displayName = assetID;
        }
        if (assetID != null) {
            this.setPageTitle("page.title.subEventsFor", new String[]{displayName});
            this.setPageName("SubEvents");
        }
    }

    private Properties getEventProperties() {
        Properties p = (Properties)this.getPageSessionAttribute(EVENTPROP_KEY);
        if (p == null) {
            p = new Properties();
        }
        HttpServletRequest request = RequestManager.getRequestContext().getRequest();
        String assetID = request.getParameter(ASSETID_KEY);
        String displayName = request.getParameter(DISPLAYNAME_KEY);
        String host = (String)this.getDisplayFieldValue(CHILD_HOST);
        String category = (String)this.getDisplayFieldValue(CHILD_CATEGORY);
        String type = (String)this.getDisplayFieldValue(CHILD_TYPE);
        String severity = (String)this.getDisplayFieldValue(CHILD_SEVERITY);
        String topic = (String)this.getDisplayFieldValue(CHILD_TOPIC);
        String maxSize = (String)this.getDisplayFieldValue(CHILD_MAXSIZE);
        String filter1 = (String)this.getDisplayFieldValue(CHILD_FILTER1);
        String aggr = (String)this.getDisplayFieldValue(CHILD_AGGR);
        if (assetID != null) {
            p.setProperty(ASSETID_KEY, assetID);
        }
        if (displayName != null) {
            p.setProperty(DISPLAYNAME_KEY, displayName);
        }
        if (host != null) {
            p.setProperty(CHILD_HOST, host);
        }
        if (category != null) {
            p.setProperty(CHILD_CATEGORY, category);
        }
        if (type != null) {
            p.setProperty(CHILD_TYPE, type);
        }
        if (severity != null) {
            p.setProperty(CHILD_SEVERITY, severity);
        }
        if (topic != null) {
            p.setProperty(CHILD_TOPIC, topic);
        }
        if (maxSize != null) {
            p.setProperty(CHILD_MAXSIZE, maxSize);
        }
        if (filter1 != null) {
            p.setProperty(CHILD_FILTER1, filter1);
        }
        if (aggr != null) {
            p.setProperty(CHILD_AGGR, aggr);
        }
        if (p.getProperty(CHILD_MAXSIZE) == null) {
            p.setProperty(CHILD_MAXSIZE, "50000");
        }
        if (p.getProperty(CHILD_AGGR) == null) {
            p.setProperty(CHILD_AGGR, "N");
        }
        return p;
    }

    private void saveEventProperties(Properties p) {
        this.setPageSessionAttribute(EVENTPROP_KEY, p);
    }

    public void handleEventFilterCommandRequest(RequestInvocationEvent event) {
        this.forwardTo(this.getRequestContext());
    }
}

