/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.mgmt.fm.storade.ui.viewbeans.events;

import com.sun.netstorage.mgmt.fm.storade.schema.Device;
import com.sun.netstorage.mgmt.fm.storade.schema.Value;
import com.sun.netstorage.mgmt.fm.storade.schema.admin.EVENT;
import com.sun.netstorage.mgmt.fm.storade.schema.admin.EventListResultDocument;
import com.sun.netstorage.mgmt.fm.storade.schema.admin.GridInfoResultDocument;
import com.sun.netstorage.mgmt.fm.storade.ui.common.AlarmConstants;
import com.sun.netstorage.mgmt.fm.storade.ui.util.AbbreviationUtil;
import com.sun.netstorage.mgmt.fm.storade.ui.util.DateUtil;
import com.sun.netstorage.mgmt.fm.storade.ui.util.LocalizeUtil;
import com.sun.netstorage.mgmt.fm.storade.ui.util.NavUtil;
import com.sun.netstorage.mgmt.fm.storade.ui.viewbeans.alarms.AlarmsDataHelper;
import com.sun.web.ui.model.CCActionTableModel;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.Properties;

public class EventsDataHelper {
    private static final String SETUP_NAME = "name";
    private static final String SETUP_NAME2 = "devname";
    private static final String SETUP_TYPE = "type";
    private static final String SETUP_KEY = "key";

    private EventsDataHelper() {
    }

    private static boolean isLivingHost(EventListResultDocument.EventListResult result, String hostID) {
        Value[] values;
        boolean ret = false;
        if (result.getHosts() != null && (values = result.getHosts().getVALUEArray()) != null) {
            for (int j = 0; j < values.length; ++j) {
                String s = values[j].getID();
                if (s == null || !s.equals(hostID)) continue;
                ret = true;
                break;
            }
        }
        return ret;
    }

    private static String getDeviceName(EventListResultDocument.EventListResult result, EVENT event) {
        Device[] devices;
        String devName = null;
        String devName2 = null;
        String dtype = null;
        String key = null;
        String name = null;
        if (result.getDEVICES() != null && (devices = result.getDEVICES().getDEVICEArray()) != null) {
            for (int i = 0; i < devices.length; ++i) {
                Value[] values = devices[i].getVALUEArray();
                if (values != null) {
                    for (int j = 0; j < values.length; ++j) {
                        String s = values[j].getID();
                        if (SETUP_NAME.equals(s)) {
                            devName = values[j].getStringValue();
                            continue;
                        }
                        if (SETUP_NAME2.equals(s)) {
                            devName2 = values[j].getStringValue();
                            continue;
                        }
                        if (SETUP_TYPE.equals(s)) {
                            dtype = values[j].getStringValue();
                            continue;
                        }
                        if (!SETUP_KEY.equals(s)) continue;
                        key = values[j].getStringValue();
                    }
                }
                if (devName == null) {
                    devName = devName2;
                }
                if (devName == null || dtype == null || key == null || !dtype.equals(event.getTYPE()) || !key.equals(event.getKEY())) continue;
                name = devName;
                break;
            }
        }
        return name;
    }

    public static void populateEventsTableModel(EventListResultDocument.EventListResult result, CCActionTableModel eventsModel, Properties eventProp, Locale locale) {
        EVENT[] events = result.getLOG().getEVENTArray();
        String assetID = eventProp.getProperty("assetID");
        if (assetID == null) {
            assetID = "NavUtil.JustIgnoreIt";
        }
        if (events != null) {
            for (int i = 0; i < events.length; ++i) {
                EVENT event = events[i];
                String time = event.getDATE();
                SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                Date timeObj = new Date();
                try {
                    timeObj = formatter.parse(time);
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
                if (i != 0) {
                    eventsModel.appendRow();
                }
                eventsModel.setValue("dateStr", (Object)timeObj);
                String topic = EventsDataHelper.getLocalizedEventType(event.getEVENTTYPE(), locale);
                eventsModel.setValue("topicStr", (Object)topic);
                String displayName = "NO_NAME";
                if ("host".equals(event.getTYPE()) || "agent".equals(event.getTYPE())) {
                    String name;
                    boolean isLiving = EventsDataHelper.isLivingHost(result, event.getKEY());
                    if (isLiving) {
                        name = event.getKEY() + " (" + AbbreviationUtil.getAbbreviation(event.getTYPE(), 1, locale) + ")";
                        eventsModel.setValue("parentNameStr", (Object)name);
                        eventsModel.setValue("parentNameStr1", (Object)name);
                        eventsModel.setValue("parentNameStr2", null);
                        eventsModel.setValue("elementNameStr", (Object)event.getTOPIC());
                        eventsModel.setValue("ParentStoradeHREF", (Object)NavUtil.compose(new String[]{"host:" + event.getKEY()}));
                        displayName = event.getKEY();
                    } else {
                        name = event.getKEY() + " (" + AbbreviationUtil.getAbbreviation(event.getTYPE(), 1, locale) + ")";
                        eventsModel.setValue("parentNameStr", (Object)name);
                        eventsModel.setValue("parentNameStr2", (Object)name);
                        eventsModel.setValue("parentNameStr1", null);
                        eventsModel.setValue("elementNameStr", (Object)event.getTOPIC());
                        eventsModel.setValue("ParentStoradeHREF", null);
                    }
                } else {
                    String devName = EventsDataHelper.getDeviceName(result, event);
                    if (devName != null) {
                        eventsModel.setValue("parentNameStr", (Object)(devName + " (" + AbbreviationUtil.getAbbreviation(event.getTYPE(), 1, locale) + ")"));
                        eventsModel.setValue("parentNameStr1", (Object)(devName + " (" + AbbreviationUtil.getAbbreviation(event.getTYPE(), 1, locale) + ")"));
                        eventsModel.setValue("parentNameStr2", null);
                        eventsModel.setValue("elementNameStr", (Object)event.getTOPIC());
                        eventsModel.setValue("ParentStoradeHREF", (Object)NavUtil.compose(new String[]{event.getTYPE() + ":" + event.getKEY()}));
                        displayName = devName;
                    } else {
                        devName = event.getKEY() + " (" + AbbreviationUtil.getAbbreviation(event.getTYPE(), 1, locale) + ")";
                        eventsModel.setValue("parentNameStr", (Object)devName);
                        eventsModel.setValue("parentNameStr2", (Object)devName);
                        eventsModel.setValue("elementNameStr", (Object)event.getTOPIC());
                        eventsModel.setValue("parentNameStr1", null);
                        eventsModel.setValue("ParentStoradeHREF", null);
                    }
                }
                eventsModel.setValue("EventDetailsStoradeHREF", (Object)NavUtil.compose(new String[]{displayName, event.getTYPE(), event.getKEY(), event.getTOPIC(), event.getEVENTTYPE(), event.getSEVERITY(), event.getDESC(), event.getDATE(), event.getDATA(), event.getGRIDCODE(), event.getAGGR()}));
                eventsModel.setValue("viewEventDetailsStr", (Object)"action.viewEventDetails");
            }
        }
    }

    public static void populateEventDetailsTableModel(GridInfoResultDocument.GridInfoResult result, CCActionTableModel eventDetailsModel, Properties p, Locale locale) {
        String time;
        String severityStr = "";
        int severityInt = new Integer(p.getProperty("severity"));
        severityStr = AlarmConstants.getSeverityString(severityInt);
        eventDetailsModel.setValue("propertyValue2", null);
        eventDetailsModel.setValue("ParentStoradeHREF", null);
        eventDetailsModel.setValue("propertyName", (Object)"prop.header.severity");
        eventDetailsModel.setValue("propertyValue1", (Object)severityStr);
        String localizedTime = time = p.getProperty("date");
        try {
            localizedTime = DateUtil.toString1(DateUtil.toDate1(time), locale);
        }
        catch (Exception ex) {
            // empty catch block
        }
        eventDetailsModel.appendRow();
        eventDetailsModel.setValue("propertyName", (Object)"prop.header.time");
        eventDetailsModel.setValue("propertyValue1", (Object)localizedTime);
        String actionStr = result.getGRIDINFO().getACTIONABLE();
        actionStr = "1".equals(actionStr) ? "boolean.yes" : "boolean.no";
        eventDetailsModel.appendRow();
        eventDetailsModel.setValue("propertyName", (Object)"prop.header.actionable");
        eventDetailsModel.setValue("propertyValue1", (Object)actionStr);
        eventDetailsModel.appendRow();
        eventDetailsModel.setValue("propertyName", (Object)"prop.header.description");
        eventDetailsModel.setValue("propertyValue1", (Object)AlarmsDataHelper.breakLine(p.getProperty("desc"), 100));
        String displayName = p.getProperty("displayName");
        if ("NO_NAME".equals(displayName)) {
            eventDetailsModel.appendRow();
            eventDetailsModel.setValue("propertyName", (Object)"prop.header.component");
            eventDetailsModel.setValue("propertyValue1", (Object)(p.getProperty(SETUP_KEY) + " (" + p.getProperty(SETUP_TYPE) + ")"));
            eventDetailsModel.appendRow();
            eventDetailsModel.setValue("propertyName", (Object)"prop.header.element");
            eventDetailsModel.setValue("propertyValue1", (Object)p.getProperty("element"));
        } else {
            eventDetailsModel.appendRow();
            eventDetailsModel.setValue("propertyName", (Object)"prop.header.component");
            eventDetailsModel.setValue("propertyValue1", null);
            eventDetailsModel.setValue("propertyValue2", (Object)(displayName + " (" + p.getProperty(SETUP_TYPE) + ")"));
            String type2 = p.getProperty(SETUP_TYPE);
            if ("agent".equals(type2)) {
                type2 = "host";
            }
            eventDetailsModel.setValue("ParentStoradeHREF", (Object)NavUtil.compose(new String[]{type2 + ":" + p.getProperty(SETUP_KEY)}));
            eventDetailsModel.appendRow();
            eventDetailsModel.setValue("propertyName", (Object)"prop.header.element");
            eventDetailsModel.setValue("propertyValue1", (Object)p.getProperty("element"));
            eventDetailsModel.setValue("propertyValue2", null);
            eventDetailsModel.setValue("ParentStoradeHREF", null);
        }
        eventDetailsModel.setValue("propertyValue2", null);
        eventDetailsModel.setValue("ParentStoradeHREF", null);
        eventDetailsModel.appendRow();
        eventDetailsModel.setValue("propertyName", (Object)"prop.header.topic");
        eventDetailsModel.setValue("propertyValue1", (Object)EventsDataHelper.getLocalizedEventType(p.getProperty("eventType"), locale));
        eventDetailsModel.appendRow();
        eventDetailsModel.setValue("propertyName", (Object)"prop.header.info");
        eventDetailsModel.setValue("propertyValue1", (Object)AlarmsDataHelper.breakLine(result.getGRIDINFO().getINFO(), 100));
        eventDetailsModel.appendRow();
        eventDetailsModel.setValue("propertyName", (Object)"prop.header.gridCode");
        eventDetailsModel.setValue("propertyValue1", (Object)result.getGRIDINFO().getCODE());
        String aggrStr = p.getProperty("aggr");
        aggrStr = "Y".equals(aggrStr) ? "boolean.yes" : "boolean.no";
        eventDetailsModel.appendRow();
        eventDetailsModel.setValue("propertyName", (Object)"prop.header.aggregated");
        eventDetailsModel.setValue("propertyValue1", (Object)aggrStr);
    }

    private static String removeHeader(String in) {
        String key = ":";
        if (in == null) {
            return null;
        }
        int pos = in.indexOf(key);
        if (pos != -1) {
            return in.substring(pos + 1);
        }
        return in;
    }

    private static String getLocalizedEventType(String in, Locale locale) {
        if (in == null) {
            return null;
        }
        String toBeLocalized = in;
        int pos = toBeLocalized.indexOf(".");
        if (pos != -1) {
            toBeLocalized = toBeLocalized.substring(0, pos);
        }
        return LocalizeUtil.getLocalizedString("com.sun.netstorage.mgmt.fm.storade.ui.resources.Events", toBeLocalized, locale);
    }
}

