/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.mgmt.fm.storade.ui.viewbeans.discovery;

import com.sun.netstorage.mgmt.fm.storade.ui.util.Connection;
import com.sun.netstorage.mgmt.fm.storade.ui.util.Debug;
import java.net.URLEncoder;

public class Setter {
    private Setter() {
    }

    private static void startDisco(boolean isLocal, String monitor, String agent, String prefix, String ipList, String writeConfig, String discoType) {
        try {
            String s = Connection.getComboHeader();
            s = s + "?GO=Client::Discovery::discovery&method=" + discoType;
            s = s + "&select_host=";
            if (isLocal) {
                agent = "local";
                s = s + URLEncoder.encode(agent, "UTF-8");
            } else if (!isLocal && agent != null) {
                s = s + URLEncoder.encode(agent, "UTF-8");
            }
            if (prefix != null) {
                s = s + "&prefix=" + URLEncoder.encode(prefix, "UTF-8");
            }
            if (ipList != null) {
                s = s + "&ip_list=" + URLEncoder.encode(ipList, "UTF-8");
            }
            if (monitor != null) {
                s = s + "&monitor=" + URLEncoder.encode(monitor, "UTF-8");
            }
            if (writeConfig != null) {
                s = s + "&write_config=" + URLEncoder.encode(writeConfig, "UTF-8");
            }
            String data = Connection.getData(s);
            Debug.println("REQUEST: " + s);
            Debug.println("DATA: " + data);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public static void startDiscoveryFromIP(boolean isLocal, String monitor, String agent, String prefix, String ipList, String writeConfig) {
        String discoType = "Subnet";
        Setter.startDisco(isLocal, monitor, agent, prefix, ipList, writeConfig, discoType);
    }

    public static void startDiscoveryFromFile(boolean isLocal, String monitor, String agent, String prefix, String ipList, String writeConfig) {
        String discoType = "devicefromip";
        Setter.startDisco(isLocal, monitor, agent, prefix, ipList, writeConfig, discoType);
    }

    public static void startInbandDiscovery(boolean isLocal, String monitor, String agent, String prefix, String ipList, String writeConfig) {
        String discoType = "inband";
        Setter.startDisco(isLocal, monitor, agent, prefix, ipList, writeConfig, discoType);
    }

    public static void clear() {
        try {
            String s = Connection.getComboHeader();
            s = s + "?GO=Client::Discovery::clear";
            String data = Connection.getData(s);
            Debug.println("REQUEST: " + s);
            Debug.println("DATA: " + data);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public static void process() {
        try {
            String s = Connection.getComboHeader();
            s = s + "?GO=Client::Discovery::process";
            String data = Connection.getData(s);
            Debug.println("REQUEST: " + s);
            Debug.println("DATA: " + data);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }
}

