/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.mgmt.fm.storade.ui.viewbeans.discovery;

import com.iplanet.jato.RequestContext;
import com.iplanet.jato.view.ContainerView;
import com.iplanet.jato.view.View;
import com.iplanet.jato.view.event.DisplayEvent;
import com.iplanet.jato.view.event.RequestInvocationEvent;
import com.iplanet.jato.view.html.StaticTextField;
import com.sun.netstorage.mgmt.fm.storade.ui.common.UIMastHeadViewBeanBase;
import com.sun.netstorage.mgmt.fm.storade.ui.model.SimplePropertySheetModel;
import com.sun.netstorage.mgmt.fm.storade.ui.util.Debug;
import com.sun.netstorage.mgmt.fm.storade.ui.view.SimplePropertySheet;
import com.sun.netstorage.mgmt.fm.storade.ui.viewbeans.discovery.DeviceAddition;
import com.sun.web.ui.view.alert.CCAlertInline;
import com.sun.web.ui.view.html.CCButton;
import com.sun.web.ui.view.html.CCTextField;
import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;

public class DiscoverySetupViewBean
extends UIMastHeadViewBeanBase {
    public static final String PAGE_NAME = "DiscoverySetup";
    public static final String DEFAULT_DISPLAY_URL = "/jsp/discovery/DiscoverySetup.jsp";
    public static final String CHILD_INLINEHELP = "InlineHelp";
    public static final String CHILD_TEXT = "Text";
    public static final String CHILD_FROMIP = "FromIP";
    public static final String CHILD_TOIP = "ToIP";
    public static final String CHILD_TIMEOUT = "TimeOut";
    public static final String CHILD_OK_BUTTON = "OkButton";
    public static final String CHILD_CANCEL_BUTTON = "CancelButton";
    public static final String CHILD_PROPERTY_SHEET = "PropertySheet";
    public static final String CHILD_PAGE_TITLE = "PageTitle";
    public static final String CHILD_ALERT = "Alert";
    public static final String TIMEOUT_KEY = "DiscoveryTimeOut";
    public static final int WRONGSEQUENCE_ERROR = -1;
    public static final int TOOBIGRANGE_ERROR = -2;
    public static final int INVALIDFROMIP_ERROR = -3;
    public static final int INVALIDTOIP_ERROR = -4;
    public static final int INVALIDTIMEOUT_ERROR = -5;
    public static final int TIMEOUTREQUIRED_ERROR = -6;
    public static final int FROMIPREQUIRED_ERROR = -7;
    public static final int SERVICENOTFOUND_ERROR = -8;
    public static final int TIMEOUT_UPPERBOUND = 100;
    public static final int TIMEOUT_LOWERBOUND = 0;
    private SimplePropertySheetModel model = new SimplePropertySheetModel();
    public static final String sccs_id = "@(#)DiscoverySetupViewBean.java\t1.9 05/16/03 SMI";

    public DiscoverySetupViewBean() {
        super(PAGE_NAME, DEFAULT_DISPLAY_URL);
        this.initModel();
    }

    protected void subRegisterChildren() {
        this.registerChild(CHILD_ALERT, CCAlertInline.class);
        this.registerChild(CHILD_OK_BUTTON, CCButton.class);
        this.registerChild(CHILD_CANCEL_BUTTON, CCButton.class);
        this.registerChild(CHILD_INLINEHELP, StaticTextField.class);
        this.registerChild(CHILD_TEXT, StaticTextField.class);
        this.registerChild(CHILD_FROMIP, CCTextField.class);
        this.registerChild(CHILD_TOIP, CCTextField.class);
        this.registerChild(CHILD_TIMEOUT, CCTextField.class);
        this.registerChild(CHILD_PROPERTY_SHEET, SimplePropertySheet.class);
    }

    public void beginDisplay(DisplayEvent event) {
        Object ob;
        try {
            super.beginDisplay(event);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        this.setDisplayFieldValue(CHILD_INLINEHELP, "note.discoveryForNotAuto");
        String timeOut = (String)this.getSessionValue(TIMEOUT_KEY);
        int timeOutValue = 10;
        if (timeOut != null) {
            try {
                timeOutValue = new Integer(timeOut);
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        if ((ob = this.getDisplayFieldValue(CHILD_TIMEOUT)) == null) {
            this.setDisplayFieldValue(CHILD_TIMEOUT, timeOutValue);
        }
        CCButton child = (CCButton)this.getChild(CHILD_OK_BUTTON);
        child.setType("default");
        child = (CCButton)this.getChild(CHILD_CANCEL_BUTTON);
        child.setType("secondary");
    }

    protected View subCreateChild(String name) {
        if (name.equals(CHILD_INLINEHELP) || name.equals(CHILD_TEXT)) {
            StaticTextField child = new StaticTextField((ContainerView)this, name, null);
            return child;
        }
        if (name.equals(CHILD_TOIP) || name.equals(CHILD_FROMIP)) {
            CCTextField child = new CCTextField((ContainerView)this, name, null);
            return child;
        }
        if (name.equals(CHILD_TIMEOUT)) {
            CCTextField child = new CCTextField((ContainerView)this, name, null);
            child.setExtraHtml(" size=\"5\"");
            return child;
        }
        if (name.equals(CHILD_PROPERTY_SHEET)) {
            SimplePropertySheet child = new SimplePropertySheet((ContainerView)this, this.model, name);
            return child;
        }
        if (name.equals(CHILD_OK_BUTTON)) {
            CCButton child = new CCButton((ContainerView)this, name, null);
            return child;
        }
        if (name.equals(CHILD_CANCEL_BUTTON)) {
            CCButton child = new CCButton((ContainerView)this, name, null);
            child.setExtraHtml("onClick=\"javascript:window.close(); return false;\"");
            return child;
        }
        if (name.equals(CHILD_ALERT)) {
            CCAlertInline child = new CCAlertInline((ContainerView)this, name, null);
            child.setValue((Object)"info");
            child.setSummary("info.discoveryReminder", (Object[])new String[0]);
            child.setDetail("info.discoveryForNotAuto", (Object[])new String[0]);
            return child;
        }
        return null;
    }

    public void handleOkButtonRequest(RequestInvocationEvent event) throws ServletException, IOException {
        RequestContext requestContext = event.getRequestContext();
        HttpServletRequest request = requestContext.getRequest();
        String fromIP = request.getParameter("DiscoverySetup.FromIP");
        String toIP = request.getParameter("DiscoverySetup.ToIP");
        String timeOut = request.getParameter("DiscoverySetup.TimeOut");
        int errorCode = 999;
        if (toIP == null || "".equals(toIP.trim())) {
            toIP = fromIP;
        }
        if (fromIP == null || "".equals(fromIP.trim())) {
            errorCode = -7;
        }
        if (errorCode >= 0 && (timeOut == null || "".equals(timeOut.trim()))) {
            errorCode = -6;
        }
        InetAddress from = null;
        InetAddress to = null;
        if (errorCode >= 0) {
            try {
                from = InetAddress.getByName(fromIP);
            }
            catch (UnknownHostException uhe) {
                errorCode = -3;
            }
        }
        if (errorCode >= 0) {
            try {
                to = InetAddress.getByName(toIP);
            }
            catch (UnknownHostException uhe) {
                errorCode = -4;
            }
        }
        if (errorCode >= 0) {
            errorCode = this.getSearchRange(from, to);
        }
        int timeOutValue = 10;
        if (errorCode >= 0) {
            try {
                timeOutValue = new Integer(timeOut.trim());
                if (timeOutValue > 100 || timeOutValue < 0) {
                    errorCode = -5;
                }
            }
            catch (Exception ex) {
                errorCode = -5;
            }
        }
        if (errorCode >= 0) {
            for (int i = 0; i < errorCode; ++i) {
                String ip = this.getIpAddress(fromIP, i);
                try {
                    DeviceAddition.add(ip);
                    Debug.println("add ip " + ip);
                    continue;
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
        }
        switch (errorCode) {
            case -1: {
                this.setInlineAlert("error", "summary.invalidInput", null, "error.wrongSequenceBetween", new String[]{fromIP.trim(), toIP.trim()});
                break;
            }
            case -2: {
                this.setInlineAlert("error", "summary.invalidInput", null, "error.tooBigSearchRangeBetween", new String[]{fromIP.trim(), toIP.trim()});
                break;
            }
            case -3: {
                this.setInlineAlert("error", "summary.invalidInput", null, "error.invalidIPAddress", new String[]{fromIP.trim()});
                break;
            }
            case -4: {
                this.setInlineAlert("error", "summary.invalidInput", null, "error.invalidIPAddress", new String[]{toIP.trim()});
                break;
            }
            case -5: {
                this.setInlineAlert("error", "summary.invalidInput", null, "error.invalidTimeOut", new String[]{timeOut.trim(), "100", "0"});
                break;
            }
            case -6: {
                this.setInlineAlert("error", "summary.invalidInput", null, "error.timeOutIsRequired", null);
                break;
            }
            case -7: {
                this.setInlineAlert("error", "summary.invalidInput", null, "error.fromIPIsRequired", null);
                break;
            }
            case -8: {
                this.setInlineAlert("error", "summary.runTimeError", null, "error.serviceNotFound", null);
                break;
            }
            default: {
                this.setInlineAlert("info", "summary.discoveryFinished", null, "info.discoveryFinished", null);
            }
        }
        this.setDisplayFieldValue(CHILD_TOIP, toIP);
        this.setDisplayFieldValue(CHILD_FROMIP, fromIP);
        this.setDisplayFieldValue(CHILD_TIMEOUT, timeOut);
        this.forwardTo(this.getRequestContext());
    }

    private void initModel() {
        this.model.addProperty("prompt.fromIPAddress", CHILD_FROMIP, null, true);
        this.model.addProperty("prompt.toIPAddress", CHILD_TOIP, null, false);
        this.model.addProperty("prompt.timeOut", CHILD_TIMEOUT, "unit.second", true);
    }

    private int getSearchRange(InetAddress from, InetAddress to) {
        byte[] fromAddr = from.getAddress();
        byte[] toAddr = to.getAddress();
        int diff0 = this.bToI(toAddr[0]) - this.bToI(fromAddr[0]);
        int diff1 = this.bToI(toAddr[1]) - this.bToI(fromAddr[1]);
        int diff2 = this.bToI(toAddr[2]) - this.bToI(fromAddr[2]);
        int diff3 = this.bToI(toAddr[3]) - this.bToI(fromAddr[3]);
        if (diff0 < 0) {
            return -1;
        }
        if (diff0 == 0) {
            if (diff1 < 0) {
                return -1;
            }
            if (diff1 == 0) {
                if (diff2 < 0) {
                    return -1;
                }
                if (diff2 == 0 && diff3 < 0) {
                    return -1;
                }
            }
        }
        if (diff0 != 0 || diff1 != 0) {
            return -2;
        }
        int searchRange = 256 * diff2 + diff3 + 1;
        return searchRange;
    }

    private int bToI(byte b) {
        int i = b;
        if (i < 0) {
            i += 256;
        }
        return i;
    }

    private String getIpAddress(String baseIpAddress, int incr) {
        InetAddress addr = null;
        try {
            addr = InetAddress.getByName(baseIpAddress);
        }
        catch (UnknownHostException uhe) {
            return null;
        }
        byte[] numAddr = addr.getAddress();
        for (int i = 0; i < incr; ++i) {
            this.nextIpAddr(numAddr);
        }
        return this.getIpAddrStr(numAddr);
    }

    private String getIpAddrStr(byte[] ip) {
        return "" + (ip[0] & 0xFF) + "." + (ip[1] & 0xFF) + "." + (ip[2] & 0xFF) + "." + (ip[3] & 0xFF);
    }

    private void nextIpAddr(byte[] ip) {
        int d = ip[3] & 0xFF;
        if (d == 255) {
            ip[3] = 0;
            int c = ip[2] & 0xFF;
            ip[2] = c == 255 ? (byte)0 : (byte)(++c);
        } else {
            ip[3] = (byte)(++d);
        }
    }
}

