/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.mgmt.fm.storade.ui.viewbeans.discovery;

import com.iplanet.jato.RequestContext;
import com.iplanet.jato.RequestManager;
import com.iplanet.jato.model.DefaultModel;
import com.iplanet.jato.view.ContainerView;
import com.iplanet.jato.view.ContainerViewBase;
import com.iplanet.jato.view.View;
import com.iplanet.jato.view.event.DisplayEvent;
import com.iplanet.jato.view.event.RequestInvocationEvent;
import com.sun.netstorage.mgmt.fm.storade.schema.jobs.JobsSummaryResultDocument;
import com.sun.netstorage.mgmt.fm.storade.ui.common.UIMastHeadViewBeanBase;
import com.sun.netstorage.mgmt.fm.storade.ui.model.ActionTableModel;
import com.sun.netstorage.mgmt.fm.storade.ui.util.AgentUtil;
import com.sun.netstorage.mgmt.fm.storade.ui.util.Connection;
import com.sun.netstorage.mgmt.fm.storade.ui.util.Debug;
import com.sun.netstorage.mgmt.fm.storade.ui.view.ActionTable;
import com.sun.netstorage.mgmt.fm.storade.ui.viewbeans.discovery.DiscoveryDataHelper;
import com.sun.netstorage.mgmt.fm.storade.ui.viewbeans.discovery.Setter;
import com.sun.netstorage.mgmt.fm.storade.ui.viewbeans.jobs.Getter;
import com.sun.netstorage.mgmt.fm.storade.ui.viewbeans.jobs.JobsDataHelper;
import com.sun.web.ui.common.CCI18N;
import com.sun.web.ui.view.html.CCStaticTextField;
import java.util.Locale;
import javax.servlet.http.HttpServletRequest;

public class DiscoveryListViewBean
extends UIMastHeadViewBeanBase {
    public static final String PAGE_NAME = "DiscoveryList";
    public static final String DEFAULT_DISPLAY_URL = "/jsp/discovery/DiscoveryList.jsp";
    public static final String CHILD_DISCO_TEXT = "DiscoveryText";
    public static final String CHILD_DISCO_TABLE = "DiscoveryTable";
    private CCI18N cci18n;
    static final String DO_REFRESH_DISCOVERY = "doRefreshDiscovery";
    private ActionTableModel discoModel = new ActionTableModel(RequestManager.getRequestContext().getServletContext(), "/xml/table/DiscoveryTable.xml");

    public DiscoveryListViewBean() {
        super(PAGE_NAME, DEFAULT_DISPLAY_URL);
    }

    public DiscoveryListViewBean(String page, String url) {
        super(page, url);
    }

    public void setRequestContext(RequestContext ctx) {
        super.setRequestContext(ctx);
        this.initModel();
    }

    protected void subRegisterChildren() {
        this.registerChild(CHILD_DISCO_TEXT, CCStaticTextField.class);
        this.registerChild(CHILD_DISCO_TABLE, ActionTable.class);
        this.discoModel.registerChildren((ContainerViewBase)this);
    }

    protected View subCreateChild(String name) {
        if (name.equals(CHILD_DISCO_TEXT)) {
            CCStaticTextField child = new CCStaticTextField((ContainerView)this, name, null);
            return child;
        }
        if (name.equals(CHILD_DISCO_TABLE)) {
            ActionTable child = new ActionTable((ContainerView)this, this.discoModel, name);
            return child;
        }
        if (this.discoModel.isChildSupported(name)) {
            return this.discoModel.createChild((View)this, name);
        }
        return null;
    }

    private void initModel() {
        this.discoModel.setActionValue("add", "button.addToInventory");
        this.discoModel.setActionValue("clear", "button.clear");
        this.discoModel.setActionValue("discoModeCol", "discovery.table.discoMode");
        this.discoModel.setActionValue("agentCol", "discovery.table.agent");
        this.discoModel.setActionValue("devTypeCol", "discovery.table.devType");
        this.discoModel.setActionValue("devNameCol", "discovery.table.devName");
        this.discoModel.setActionValue("devIDCol", "discovery.table.devID");
    }

    public void beginDisplay(DisplayEvent event) {
        HttpServletRequest request = RequestManager.getRequestContext().getRequest();
        Locale locale = request.getLocale();
        this.cci18n = new CCI18N(this.getRequestContext(), "com.sun.netstorage.mgmt.fm.storade.ui.resources.ApplicationResources");
        int nAgents = 0;
        JobsSummaryResultDocument.JobsSummaryResult result = null;
        try {
            result = Getter.getJobsSummary();
            this.setAlarmSummary(result.getAlarmSummary());
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        if (result != null) {
            try {
                DiscoveryDataHelper.populatesSummaryTable(result, (DefaultModel)this.discoModel, locale);
                nAgents = DiscoveryDataHelper.getAgentsRunning(result);
                if (nAgents != 0) {
                    this.doPageRefresh();
                    this.setInlineAlert("info", "summary.discovery", null, "info.discovery.running", null);
                } else {
                    String lastStart = request.getParameter("lastStart");
                    String agent = request.getParameter("agent");
                    String mechanism = request.getParameter("mechanism");
                    if (lastStart != null) {
                        Debug.println("Last Start " + lastStart);
                        Debug.println("agent " + agent);
                        Debug.println("mechanism " + mechanism);
                        if (AgentUtil.isLocalHost(agent)) {
                            agent = "local";
                        }
                        if ("ip".equals(mechanism)) {
                            mechanism = "subnet";
                        } else if ("inband".equals(mechanism)) {
                            mechanism = "inband";
                        } else if ("file".equals(mechanism)) {
                            mechanism = "deviceIP";
                        }
                        long lastStartTime = new Long(lastStart);
                        long startTime = JobsDataHelper.getDiscoveryStartTime(agent, mechanism);
                        if (startTime <= lastStartTime) {
                            this.doPageRefresh();
                            this.setInlineAlert("info", "summary.discovery", null, "info.discovery.notStart", null);
                        }
                    }
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        Object[] params = new String[]{Integer.toString(nAgents)};
        String value = this.cci18n.getMessage("discovery.nbrAgents", params);
        this.setDisplayFieldValue(CHILD_DISCO_TEXT, value);
        super.beginDisplay(event);
    }

    public void handleAddRequest(RequestInvocationEvent event) {
        try {
            Setter.process();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        try {
            String page = "discovery/DiscoveryList";
            if ("JobDiscoveryList".equals(this.getName())) {
                page = "jobs/JobDiscoveryList";
            }
            String url = "/" + Connection.getAppName() + "/" + page;
            RequestContext requestContext = event.getRequestContext();
            requestContext.getResponse().sendRedirect(url);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public void handleClearRequest(RequestInvocationEvent event) {
        try {
            Setter.clear();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        try {
            String page = "discovery/DiscoveryList";
            if ("JobDiscoveryList".equals(this.getName())) {
                page = "jobs/JobDiscoveryList";
            }
            String url = "/" + Connection.getAppName() + "/" + page;
            RequestContext requestContext = event.getRequestContext();
            requestContext.getResponse().sendRedirect(url);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }
}

