/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.mgmt.fm.storade.ui.viewbeans.discovery;

import com.iplanet.jato.model.DefaultModel;
import com.sun.netstorage.mgmt.fm.storade.schema.admin.Host;
import com.sun.netstorage.mgmt.fm.storade.schema.admin.HostListResultDocument;
import com.sun.netstorage.mgmt.fm.storade.schema.jobs.Device;
import com.sun.netstorage.mgmt.fm.storade.schema.jobs.Discovery;
import com.sun.netstorage.mgmt.fm.storade.schema.jobs.JobsSummaryResultDocument;
import com.sun.netstorage.mgmt.fm.storade.ui.util.AbbreviationUtil;
import com.sun.netstorage.mgmt.fm.storade.ui.util.LocalizeUtil;
import com.sun.netstorage.mgmt.fm.storade.ui.viewbeans.admin.Getter;
import java.util.ArrayList;
import java.util.Locale;

public class DiscoveryDataHelper {
    public static int getAgentsRunning(JobsSummaryResultDocument.JobsSummaryResult result) {
        Discovery[] discovery;
        int n = 0;
        if (result != null && result.getDISCOVERIES() != null && (discovery = result.getDISCOVERIES().getDISCOVERYArray()) != null) {
            for (int i = 0; i < discovery.length; ++i) {
                int agentsRunning = discovery[i].getAGENTSRUNNING().intValue();
                n += agentsRunning;
            }
        }
        return n;
    }

    public static void populatesSummaryTable(JobsSummaryResultDocument.JobsSummaryResult result, DefaultModel model, Locale locale) {
        Discovery[] discovery;
        boolean rowAdded = false;
        if (result != null && result.getDISCOVERIES() != null && (discovery = result.getDISCOVERIES().getDISCOVERYArray()) != null) {
            for (int i = 0; i < discovery.length; ++i) {
                Device[] device;
                Discovery disco;
                String discoMode = discovery[i].getDISCOVERYMODE();
                int agentsRunning = discovery[i].getAGENTSRUNNING().intValue();
                int agentsStopped = discovery[i].getAGENTSSTOP().intValue();
                int devFound = discovery[i].getDEVICESFOUND().intValue();
                if (discoMode != null && !"".equals(discoMode)) {
                    discoMode = LocalizeUtil.getLocalizedString("mode." + discoMode, locale);
                }
                if ((disco = discovery[i]).getDEVICES() == null || (device = disco.getDEVICES().getDEVICEArray()) == null) continue;
                for (int j = 0; j < device.length; ++j) {
                    String agent = device[j].getAGENT();
                    String devType = device[j].getTYPE();
                    String devName = device[j].getDEVNAME();
                    String name = device[j].getNAME();
                    String devID = device[j].getKEY();
                    int index = agent.indexOf(46);
                    if (index != -1) {
                        agent = agent.substring(index + 1);
                    }
                    if (rowAdded) {
                        model.appendRow();
                    }
                    rowAdded = true;
                    if (devType != null) {
                        devType = AbbreviationUtil.getAbbreviation(devType, 2, locale);
                    }
                    if ("local".equals(agent)) {
                        agent = LocalizeUtil.getLocalizedString("host.local", locale);
                    }
                    model.setValue("discoMode", (Object)discoMode);
                    model.setValue("agent", (Object)agent);
                    model.setValue("devType", (Object)devType);
                    if (devName != null) {
                        model.setValue("devName", (Object)devName);
                    } else {
                        model.setValue("devName", (Object)name);
                    }
                    model.setValue("devID", (Object)devID);
                }
            }
        }
    }

    public static String[] getAgents() {
        Host[] hosts;
        ArrayList<String> namesList = new ArrayList<String>();
        HostListResultDocument doc = Getter.getHostListResultDocument();
        HostListResultDocument.HostListResult result = doc.getHostListResult();
        if (result != null && result.getHOSTS() != null && (hosts = result.getHOSTS().getHOSTArray()) != null) {
            for (int i = 0; i < hosts.length; ++i) {
                Host host = hosts[i];
                namesList.add(host.getNAME());
            }
        }
        String[] namesArray = new String[namesList.size()];
        namesList.toArray(namesArray);
        return namesArray;
    }
}

