/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.mgmt.fm.storade.ui.viewbeans.diagnostics;

import com.iplanet.jato.RequestContext;
import com.iplanet.jato.RequestManager;
import com.iplanet.jato.model.DefaultModel;
import com.iplanet.jato.model.ModelControlException;
import com.iplanet.jato.view.ContainerView;
import com.iplanet.jato.view.ContainerViewBase;
import com.iplanet.jato.view.View;
import com.iplanet.jato.view.event.ChildDisplayEvent;
import com.iplanet.jato.view.event.DisplayEvent;
import com.iplanet.jato.view.event.RequestInvocationEvent;
import com.iplanet.jato.view.html.Option;
import com.iplanet.jato.view.html.OptionList;
import com.sun.netstorage.mgmt.fm.storade.schema.Value;
import com.sun.netstorage.mgmt.fm.storade.schema.jobs.AnswerQuestionResultDocument;
import com.sun.netstorage.mgmt.fm.storade.schema.jobs.DiagDetailsResultDocument;
import com.sun.netstorage.mgmt.fm.storade.schema.jobs.GetQuestionResultDocument;
import com.sun.netstorage.mgmt.fm.storade.ui.common.UIMastHeadViewBeanBase;
import com.sun.netstorage.mgmt.fm.storade.ui.util.Connection;
import com.sun.netstorage.mgmt.fm.storade.ui.util.Debug;
import com.sun.netstorage.mgmt.fm.storade.ui.util.UserUtil;
import com.sun.netstorage.mgmt.fm.storade.ui.viewbeans.diagnostics.DiagnosticsDataHelper;
import com.sun.netstorage.mgmt.fm.storade.ui.viewbeans.diagnostics.Getter;
import com.sun.netstorage.mgmt.fm.storade.ui.viewbeans.diagnostics.Setter;
import com.sun.netstorage.mgmt.fm.storade.ui.viewbeans.jobs.JobDetailsDataHelper;
import com.sun.web.ui.common.CCI18N;
import com.sun.web.ui.model.CCActionTableModel;
import com.sun.web.ui.model.CCActionTableModelInterface;
import com.sun.web.ui.model.CCPageTitleModel;
import com.sun.web.ui.model.CCPageTitleModelInterface;
import com.sun.web.ui.view.html.CCButton;
import com.sun.web.ui.view.html.CCDropDownMenu;
import com.sun.web.ui.view.html.CCOption;
import com.sun.web.ui.view.html.CCStaticTextField;
import com.sun.web.ui.view.pagetitle.CCPageTitle;
import com.sun.web.ui.view.table.CCActionTable;
import java.io.Serializable;
import java.net.URLEncoder;
import java.util.Locale;
import javax.servlet.http.HttpServletRequest;

public class TestResultViewBean
extends UIMastHeadViewBeanBase {
    public static final String PAGE_NAME = "TestResult";
    private static final String PACKAGE_NAME = "diagnostics";
    static final String PAGE_TITLE = "page.title.testResult1";
    public static final String DEFAULT_DISPLAY_URL = "/jsp/diagnostics/TestResult.jsp";
    public static final String CHILD_DATA_TEXT = "DiagData";
    public static final String CHILD_TEST_RESULT_TABLE = "TestResultTable";
    public static final String CHILD_PAGE_TITLE = "PageTitle";
    public static final String CHILD_ABORT_BUTTON = "AbortButton";
    public static final String CHILD_ANSWER_OPTIONS = "AnswerOptions";
    public static final String CHILD_ANSWER_BUTTON = "AnswerButton";
    public static final String CHILD_ANSWER_TEXT = "AnswerText";
    private CCPageTitleModel pageTitleModel = new CCPageTitleModel(RequestManager.getRequestContext().getServletContext(), "/xml/pagetitle/TestResultPageTitle.xml");
    private CCActionTableModel testResultModel = new CCActionTableModel(RequestManager.getRequestContext().getServletContext(), "/xml/table/TestResultTable.xml");
    private CCI18N cci18n;
    private boolean showAnswer = false;
    private DiagDetailsResultDocument.DiagDetailsResult result = null;
    private String displayName;
    private static final String OK = "OK";
    private static final String ALREADY_STOPPED = "already stopped";

    public TestResultViewBean() {
        super(PAGE_NAME, DEFAULT_DISPLAY_URL);
    }

    public TestResultViewBean(String page, String url) {
        super(page, url);
    }

    public void setRequestContext(RequestContext ctx) {
        super.setRequestContext(ctx);
        this.initModel();
    }

    protected void subRegisterChildren() {
        this.registerChild(CHILD_PAGE_TITLE, CCPageTitle.class);
        this.registerChild(CHILD_DATA_TEXT, CCStaticTextField.class);
        this.registerChild(CHILD_TEST_RESULT_TABLE, CCActionTable.class);
        this.registerChild(CHILD_ANSWER_OPTIONS, CCDropDownMenu.class);
        this.registerChild(CHILD_ANSWER_BUTTON, CCButton.class);
        this.registerChild(CHILD_ANSWER_TEXT, CCStaticTextField.class);
        this.pageTitleModel.registerChildren((ContainerViewBase)this);
        this.testResultModel.registerChildren((ContainerViewBase)this);
    }

    protected View subCreateChild(String name) {
        if (name.equals(CHILD_PAGE_TITLE)) {
            String displayName = this.getDisplayName();
            if (displayName != null) {
                Object[] params = new String[]{displayName};
                if (this.cci18n == null) {
                    this.cci18n = new CCI18N(this.getRequestContext(), "com.sun.netstorage.mgmt.fm.storade.ui.resources.ApplicationResources");
                }
                String value = this.cci18n.getMessage(PAGE_TITLE, params);
                if (this.pageTitleModel != null) {
                    this.pageTitleModel.setPageTitleText(value);
                }
            }
            CCPageTitle child = new CCPageTitle((ContainerView)this, (CCPageTitleModelInterface)this.pageTitleModel, name);
            return child;
        }
        if (name.equals(CHILD_ABORT_BUTTON)) {
            CCButton child = new CCButton((ContainerView)this, name, (Object)"button.stop");
            DiagDetailsResultDocument.DiagDetailsResult result = this.getResult();
            if (DiagnosticsDataHelper.isRunning(result) || DiagnosticsDataHelper.isWaiting(result)) {
                child.setDisabled(false);
            } else {
                child.setDisabled(true);
            }
            if (!UserUtil.isPrivilegedRole(RequestManager.getRequestContext().getRequest())) {
                child.setDisabled(true);
            }
            return child;
        }
        if (name.equals(CHILD_DATA_TEXT)) {
            CCStaticTextField child = new CCStaticTextField((ContainerView)this, name, null);
            child.setEscape(false);
            String output = JobDetailsDataHelper.getDiagOutput(this.result);
            String error = JobDetailsDataHelper.getDiagError(this.result);
            String value = output;
            if (error != null) {
                value = value + error;
            }
            if (value != null) {
                child.setValue((Object)value);
            }
            return child;
        }
        if (name.equals(CHILD_TEST_RESULT_TABLE)) {
            CCActionTable child = new CCActionTable((ContainerView)this, (CCActionTableModelInterface)this.testResultModel, name);
            return child;
        }
        if (name.equals(CHILD_ANSWER_OPTIONS)) {
            CCDropDownMenu child = new CCDropDownMenu((ContainerView)this, name, null);
            return child;
        }
        if (name.equals(CHILD_ANSWER_BUTTON)) {
            CCButton child = new CCButton((ContainerView)this, name, (Object)"button.go");
            return child;
        }
        if (name.equals(CHILD_ANSWER_TEXT)) {
            CCStaticTextField child = new CCStaticTextField((ContainerView)this, name, (Object)"note.yourAnswer");
            return child;
        }
        if (this.pageTitleModel.isChildSupported(name)) {
            return this.pageTitleModel.createChild((View)this, name);
        }
        if (this.testResultModel.isChildSupported(name)) {
            return this.testResultModel.createChild((View)this, name);
        }
        return null;
    }

    private void initModel() {
        this.pageTitleModel.setValue(CHILD_ABORT_BUTTON, (Object)"button.stop");
        this.testResultModel.setActionValue("property", (Object)"table.header.property");
        this.testResultModel.setActionValue("value", (Object)"table.header.value");
        this.testResultModel.setActionValue("empty", (Object)" ");
    }

    private String getDisplayName() {
        if (this.displayName == null) {
            HttpServletRequest request = this.getRequestContext().getRequest();
            this.displayName = request.getParameter("displayName");
            if (this.displayName == null) {
                this.displayName = (String)this.getPageSessionAttribute("displayName");
            }
            this.setPageSessionAttribute("displayName", (Serializable)((Object)this.displayName));
        }
        return this.displayName;
    }

    private DiagDetailsResultDocument.DiagDetailsResult getResult() {
        String id;
        if (this.result == null && (id = this.getTestID()) != null) {
            this.result = com.sun.netstorage.mgmt.fm.storade.ui.viewbeans.jobs.Getter.getDiagDetails(id);
        }
        return this.result;
    }

    public void beginDisplay(DisplayEvent event) {
        HttpServletRequest request = RequestManager.getRequestContext().getRequest();
        Locale locale = request.getLocale();
        if (locale == null) {
            locale = Locale.getDefault();
        }
        String id = this.getTestID();
        Debug.println("TEST ID: " + id);
        if (id != null) {
            this.setPageSessionAttribute("id", (Serializable)((Object)id));
            try {
                DiagDetailsResultDocument.DiagDetailsResult result = this.getResult();
                this.setAlarmSummary(result.getAlarmSummary());
                DiagnosticsDataHelper.populateTestResultTable(result, (DefaultModel)this.testResultModel, locale);
                if (DiagnosticsDataHelper.isRunning(result)) {
                    this.doPageRefresh();
                    this.setInlineAlert("info", "summary.testResult", null, "info.testResult", null);
                }
                if (DiagnosticsDataHelper.isWaiting(result)) {
                    this.showAnswer = true;
                    String pid = null;
                    int i = id.lastIndexOf(58);
                    pid = id.substring(i + 1);
                    Debug.println("PID: " + pid);
                    GetQuestionResultDocument.GetQuestionResult qResult = Getter.getGetQuestionResult(pid);
                    Value[] values = qResult.getQUESTIONS().getVALUEArray();
                    if (values != null) {
                        CCOption[] options = new CCOption[values.length];
                        for (int k = 0; k < values.length; ++k) {
                            options[k] = new CCOption(values[k].getStringValue(), values[k].getID());
                        }
                        CCDropDownMenu child = (CCDropDownMenu)this.getChild(CHILD_ANSWER_OPTIONS);
                        child.setOptions(new OptionList((Option[])options));
                    }
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        super.beginDisplay(event);
    }

    protected String getPackageName() {
        return PACKAGE_NAME;
    }

    public boolean beginAnswerSectionDisplay(ChildDisplayEvent event) throws ModelControlException {
        return this.showAnswer;
    }

    public void handleAnswerButtonRequest(RequestInvocationEvent event) {
        String id = (String)this.getPageSessionAttribute("id");
        if (id != null) {
            String answer;
            String pid = null;
            int i = id.lastIndexOf(58);
            pid = id.substring(i + 1);
            AnswerQuestionResultDocument.AnswerQuestionResult result = Setter.answerQuestion(pid, answer = (String)this.getDisplayFieldValue(CHILD_ANSWER_OPTIONS));
            if (result != null) {
                this.setInlineAlert("info", "summary.answerQuestion", null, "info.answerQuestion", null);
            } else {
                this.setInlineAlert("error", "summary.answerQuestion", null, "error.internal", null);
            }
        }
        HttpServletRequest request = this.getRequestContext().getRequest();
        StringBuffer ub = request.getRequestURL();
        String url = ub.toString() + "?id=" + this.urlencode(id);
        Debug.println("url after answer: " + url);
        try {
            event.getRequestContext().getResponse().sendRedirect(url);
        }
        catch (Exception ioe) {
            ioe.printStackTrace();
        }
    }

    public void handleAbortButtonRequest(RequestInvocationEvent event) {
        String id = (String)this.getPageSessionAttribute("id");
        if (id != null) {
            String r;
            String pid = null;
            String hostname = null;
            int i = id.lastIndexOf(58);
            pid = id.substring(i + 1);
            i = id.indexOf(58);
            hostname = id.substring(0, i);
            Debug.println("PID: " + pid);
            Debug.println("hostname: " + hostname);
            if (pid != null && hostname != null && (r = Setter.abortDiag(pid, hostname)) != null) {
                if (r.indexOf(OK) != -1) {
                    this.setInlineAlert("info", "asset.test.testresult.abort.OK", null, null, null);
                } else if (r.indexOf(ALREADY_STOPPED) != -1) {
                    this.setInlineAlert("error", "asset.test.testresult.abort.already.stopped", null, null, null);
                } else {
                    this.setInlineAlert("error", "asset.test.testresult.abort.problem", null, null, null);
                }
            }
        }
        try {
            String page = this.getPackageName() + "/" + this.getPageName();
            page = page + "?id=" + URLEncoder.encode(id, "UTF-8");
            String displayName = this.getDisplayName();
            if (displayName != null) {
                page = page + "&displayName=" + URLEncoder.encode(displayName, "UTF-8");
            }
            String url = "/" + Connection.getAppName() + "/" + page;
            RequestContext requestContext = event.getRequestContext();
            requestContext.getResponse().sendRedirect(url);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private String getTestID() {
        HttpServletRequest request = this.getRequestContext().getRequest();
        String id = request.getParameter("id");
        if (id == null) {
            id = (String)this.getPageSessionAttribute("id");
        }
        return id;
    }
}

