/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.mgmt.fm.storade.ui.viewbeans.diagnostics;

import com.sun.netstorage.mgmt.fm.storade.ui.viewbeans.diagnostics.DiagnosticField;

public class TestParameterBean {
    private DiagnosticField diagnosticField;

    public void init(DiagnosticField diagnosticField) {
        this.diagnosticField = diagnosticField;
    }

    public String getField() {
        return TestParameterBean.buildField(this.diagnosticField);
    }

    public String getName() {
        return this.diagnosticField.getName();
    }

    private static String getValue(String s) {
        String value = s;
        int index = s.indexOf(61);
        if (index != -1) {
            value = s.substring(0, index);
        }
        return value;
    }

    private static String getText(String s) {
        String text = s;
        int index = s.indexOf(61);
        if (index != -1) {
            text = s.substring(index + 1);
        }
        return text;
    }

    public static String buildField(DiagnosticField diagnosticField) {
        String sectionName = diagnosticField.getSectionName();
        String name = diagnosticField.getName();
        String option = diagnosticField.getOption();
        String value = diagnosticField.getDefault();
        String type = diagnosticField.getType();
        StringBuffer buffer = new StringBuffer();
        if ("text".equals(type)) {
            if (value == null) {
                value = "";
            }
            buffer.append("<input type=text name=" + option + " size=32 maxlength=80 ");
            buffer.append("value= \"" + value + "\" >");
        } else if ("select".equals(type)) {
            buffer.append("<select name=" + option + ">");
            String[] values = diagnosticField.getValues();
            if (value != null) {
                buffer.append("<option value=\"" + TestParameterBean.getValue(value) + "\">" + TestParameterBean.getText(value) + "</option>");
            }
            for (int i = 0; i < values.length; ++i) {
                if (values[i].equals(value)) continue;
                buffer.append("<option value=\"" + TestParameterBean.getValue(values[i]) + "\">" + TestParameterBean.getText(values[i]) + "</option>");
            }
            buffer.append("</select>");
        } else if ("password".equals(type)) {
            if (value == null) {
                value = "";
            }
            buffer.append("<input type=password name=" + option + " size=32 maxlength=80 ");
            buffer.append("value= \"" + value + "\" >");
        } else if ("checkbox".equals(type)) {
            String checked = "";
            if ("1".equals(value)) {
                checked = "checked=checked";
            }
            buffer.append("<input type=checkbox " + checked + " name=" + option + " size=32 maxlength=80 ");
            buffer.append(" >");
        } else if ("radio".equals(type)) {
            String[] values = diagnosticField.getValues();
            for (int i = 0; i < values.length; ++i) {
                String checked = "";
                if (values[i].equals(diagnosticField.getDefault())) {
                    checked = "checked=checked";
                }
                buffer.append("<input type=radio " + checked + " name=" + option + " size=32 maxlength=80 ");
                buffer.append("value=" + values[i] + " >");
                buffer.append(values[i]);
            }
        } else {
            buffer.append("<input type=text name=" + option + " size=32 maxlength=80 ");
            buffer.append("value= \"" + value + "\" >");
        }
        return buffer.toString();
    }
}

