/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.mgmt.fm.storade.ui.viewbeans.diagnostics;

import com.sun.netstorage.mgmt.fm.storade.ui.util.Connection;
import com.sun.netstorage.mgmt.fm.storade.ui.util.Debug;
import com.sun.netstorage.mgmt.fm.storade.ui.viewbeans.diagnostics.DiagnosticField;
import java.io.BufferedReader;
import java.io.Reader;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.StringTokenizer;

public class DiagnosticDetails {
    private DiagnosticField[] diagnosticFields;

    public DiagnosticField[] getFields() {
        return this.diagnosticFields;
    }

    public static DiagnosticDetails get(String deviceKey, String diagName) throws Exception {
        String line;
        ArrayList<String[]> data = new ArrayList<String[]>();
        String index = null;
        String hostname = Connection.getHostname();
        String port = Connection.getPort();
        String s = "http://" + hostname + ":" + port + "/rashttp?GO=Client::Diag::list";
        s = s + "&key=" + URLEncoder.encode(deviceKey, "UTF-8");
        Reader reader = Connection.getReader(s);
        BufferedReader br = (BufferedReader)reader;
        while ((line = br.readLine()) != null) {
            int i = line.indexOf("\t");
            String name = null;
            String value = null;
            if (i != -1) {
                name = line.substring(0, i);
                value = line.substring(i + 1);
            }
            if (name == null || value == null) continue;
            data.add(new String[]{name, value});
            if (!name.startsWith("test") || !name.endsWith(".info.name") || !value.equals(diagName)) continue;
            index = name.substring(0, 6);
        }
        HashMap<String, DiagnosticField> map = new HashMap<String, DiagnosticField>();
        if (index != null) {
            for (int i = 0; i < data.size(); ++i) {
                int ii;
                String s2;
                String[] ss = (String[])data.get(i);
                String name = ss[0];
                String value = ss[1];
                if (!name.startsWith(index) || !(s2 = name.substring(index.length())).startsWith(".opt.")) continue;
                String s3 = s2.substring(".opt.".length());
                String s4 = s3.substring(0, ii = s3.indexOf("."));
                DiagnosticField df = (DiagnosticField)map.get(s4);
                if (df == null) {
                    df = new DiagnosticField();
                    map.put(s4, df);
                }
                if (name.endsWith(".name")) {
                    df.setName(value);
                    df.setIndex(Integer.parseInt(s4));
                    continue;
                }
                if (name.endsWith(".default")) {
                    df.setDefault(value);
                    continue;
                }
                if (name.endsWith(".size")) {
                    df.setSize(value);
                    continue;
                }
                if (name.endsWith(".opt")) {
                    df.setOption(value);
                    continue;
                }
                if (name.endsWith(".type")) {
                    df.setType(value);
                    continue;
                }
                if (name.endsWith(".desc")) {
                    df.setDescription(value);
                    continue;
                }
                if (!name.endsWith(".values")) continue;
                ArrayList<String> valueList = new ArrayList<String>();
                StringTokenizer st2 = new StringTokenizer(value, "|");
                while (st2.hasMoreTokens()) {
                    String token = st2.nextToken();
                    valueList.add(token);
                }
                String[] values = new String[valueList.size()];
                valueList.toArray(values);
                df.setValues(values);
            }
        }
        DiagnosticDetails diagnosticDetails = new DiagnosticDetails();
        diagnosticDetails.diagnosticFields = new DiagnosticField[map.size()];
        map.values().toArray(diagnosticDetails.diagnosticFields);
        Arrays.sort(diagnosticDetails.diagnosticFields);
        return diagnosticDetails;
    }

    public static void run(String deviceKey, String diagName, String[] opt, String[] values) throws Exception {
        String line;
        String s = "http://localhost:7654/rashttp?GO=Client::Diag::run";
        s = s + "&key=" + URLEncoder.encode(deviceKey, "UTF-8");
        s = s + "&test=" + URLEncoder.encode(diagName, "UTF-8");
        for (int i = 0; i < opt.length; ++i) {
            s = s + "&opt_" + opt[i] + "=" + URLEncoder.encode(values[i], "UTF-8");
        }
        Debug.println(s);
        Reader reader = Connection.getReader(s);
        BufferedReader br = (BufferedReader)reader;
        while ((line = br.readLine()) != null) {
            Debug.println(line);
        }
    }

    public String toString() {
        String s = "";
        if (this.diagnosticFields != null) {
            for (int i = 0; i < this.diagnosticFields.length; ++i) {
                s = s + this.diagnosticFields[i].toString();
                s = s + "\n";
            }
        }
        return s;
    }

    public static void main(String[] args) throws Exception {
        DiagnosticDetails d = DiagnosticDetails.get("switch2:100000c0dd006489", "Sun-2_gig_Switch");
        Debug.println(d);
    }
}

