/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.mgmt.fm.storade.ui.viewbeans.alarms;

import com.sun.netstorage.mgmt.fm.storade.schema.alarms.AckAlarmResultDocument;
import com.sun.netstorage.mgmt.fm.storade.schema.alarms.DeleteAlarmResultDocument;
import com.sun.netstorage.mgmt.fm.storade.schema.alarms.SetNoteResultDocument;
import com.sun.netstorage.mgmt.fm.storade.ui.util.Connection;
import com.sun.netstorage.mgmt.fm.storade.ui.util.Debug;
import com.sun.netstorage.mgmt.fm.storade.ui.util.XmlUtil;
import java.net.URLEncoder;
import java.util.StringTokenizer;

public class Setter {
    private Setter() {
    }

    public static AckAlarmResultDocument.AckAlarmResult ackAlarm(String alarmID, String userName, boolean isAck) {
        AckAlarmResultDocument.AckAlarmResult result = null;
        try {
            String deviceKey = "";
            String elementName = "";
            if (alarmID != null) {
                StringTokenizer st = new StringTokenizer(alarmID, ":");
                if (st.countTokens() == 3) {
                    deviceKey = st.nextToken() + ":" + st.nextToken();
                    elementName = st.nextToken();
                } else if (st.countTokens() == 2) {
                    deviceKey = st.nextToken() + ":" + st.nextToken();
                }
            }
            String s = "";
            s = isAck ? Connection.getComboHeader() + "?GO=Client::Alarm::ackAlarm" : Connection.getComboHeader() + "?GO=Client::Alarm::nackAlarm";
            s = s + "&key=" + URLEncoder.encode(deviceKey, "UTF-8");
            s = s + "&topic=" + URLEncoder.encode(elementName, "UTF-8");
            if (userName != null) {
                s = s + "&login=" + URLEncoder.encode(userName, "UTF-8");
            }
            String data = Connection.getData(s);
            data = XmlUtil.addHeader(data, "AckAlarmResult");
            Debug.println("setter: " + s);
            Debug.println("get data: " + data);
            AckAlarmResultDocument resultDoc = AckAlarmResultDocument.Factory.parse((String)data);
            result = resultDoc.getAckAlarmResult();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return result;
    }

    public static SetNoteResultDocument.SetNoteResult setNote(String alarmID, String note) {
        SetNoteResultDocument.SetNoteResult result = null;
        try {
            String deviceKey = "";
            String elementName = "";
            if (alarmID != null) {
                StringTokenizer st = new StringTokenizer(alarmID, ":");
                if (st.countTokens() == 3) {
                    deviceKey = st.nextToken() + ":" + st.nextToken();
                    elementName = st.nextToken();
                } else if (st.countTokens() == 2) {
                    deviceKey = st.nextToken() + ":" + st.nextToken();
                }
            }
            String s = Connection.getComboHeader() + "?GO=Client::Alarm::setNote";
            s = s + "&key=" + URLEncoder.encode(deviceKey, "UTF-8");
            s = s + "&topic=" + URLEncoder.encode(elementName, "UTF-8");
            s = s + "&note=" + URLEncoder.encode(note, "UTF-8");
            String data = Connection.getData(s);
            data = XmlUtil.addHeader(data, "SetNoteResult");
            Debug.println("setter: " + s);
            Debug.println("get data: " + data);
            SetNoteResultDocument resultDoc = SetNoteResultDocument.Factory.parse((String)data);
            result = resultDoc.getSetNoteResult();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return result;
    }

    public static DeleteAlarmResultDocument.DeleteAlarmResult deleteAlarm(String alarmID) {
        DeleteAlarmResultDocument.DeleteAlarmResult result = null;
        try {
            String deviceKey = "";
            String elementName = "";
            if (alarmID != null) {
                StringTokenizer st = new StringTokenizer(alarmID, ":");
                if (st.countTokens() == 3) {
                    deviceKey = st.nextToken() + ":" + st.nextToken();
                    elementName = st.nextToken();
                } else if (st.countTokens() == 2) {
                    deviceKey = st.nextToken() + ":" + st.nextToken();
                }
            }
            String s = Connection.getComboHeader() + "?GO=Client::Alarm::delAlarm";
            s = s + "&key=" + URLEncoder.encode(deviceKey, "UTF-8");
            s = s + "&topic=" + URLEncoder.encode(elementName, "UTF-8");
            String data = Connection.getData(s);
            data = XmlUtil.addHeader(data, "DeleteAlarmResult");
            Debug.println("setter: " + s);
            Debug.println("get data: " + data);
            DeleteAlarmResultDocument resultDoc = DeleteAlarmResultDocument.Factory.parse((String)data);
            result = resultDoc.getDeleteAlarmResult();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return result;
    }

    public static void generateStatisticsReports() {
        try {
            String s = Connection.getComboHeader();
            s = s + "?GO=Client::EventReport::generateReports";
            String data = Connection.getData(s);
            Debug.println("REQUEST: " + s);
            Debug.println("DATA: " + data);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }
}

