/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.mgmt.fm.storade.ui.viewbeans.alarms;

import com.iplanet.jato.model.DefaultModel;
import com.sun.netstorage.mgmt.fm.storade.schema.alarms.AlarmStatisticsListResultDocument;
import com.sun.netstorage.mgmt.fm.storade.schema.alarms.AlarmStatisticsReportGenerationResultDocument;
import com.sun.netstorage.mgmt.fm.storade.schema.alarms.Statistic;
import com.sun.netstorage.mgmt.fm.storade.ui.util.AbbreviationUtil;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;

public class AlarmStatisticsDataHelper {
    public static final String CHILD_EMBEDDED_ACTION_1 = "EmbeddedAction1";
    private static final String MONDAY = "1 Mon";
    private static final String TUESDAY = "2 Tue";
    private static final String WEDNESDAY = "3 Wed";
    private static final String THURSDAY = "4 Thu";
    private static final String FRIDAY = "5 Fri";
    private static final String SATURDAY = "6 Sat";
    private static final String SUNDAY = "0 Sun";

    private AlarmStatisticsDataHelper() {
    }

    public static void populateAlarmStatistics(AlarmStatisticsReportGenerationResultDocument.AlarmStatisticsReportGenerationResult result, DefaultModel alarmStatModel, Locale locale) throws IllegalArgumentException {
        String reportDate;
        Date date = null;
        if (result != null && (reportDate = result.getREPORTDATE()) != null && !reportDate.equals("")) {
            SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            try {
                date = formatter.parse(reportDate);
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        alarmStatModel.setValue("descriptionStr", (Object)"alarms.statistics.byMonth");
        alarmStatModel.setValue("dateStr", date);
        if (date != null) {
            alarmStatModel.setValue("EmbeddedActionText1", (Object)"alarms.statistics.view");
        } else {
            alarmStatModel.setValue("EmbeddedActionText1", null);
        }
        alarmStatModel.setValue(CHILD_EMBEDDED_ACTION_1, (Object)"0");
        alarmStatModel.appendRow();
        alarmStatModel.setValue("descriptionStr", (Object)"alarms.statistics.byWeek");
        alarmStatModel.setValue("dateStr", (Object)date);
        if (date != null) {
            alarmStatModel.setValue("EmbeddedActionText1", (Object)"alarms.statistics.view");
        } else {
            alarmStatModel.setValue("EmbeddedActionText1", null);
        }
        alarmStatModel.setValue(CHILD_EMBEDDED_ACTION_1, (Object)"1");
        alarmStatModel.appendRow();
        alarmStatModel.setValue("descriptionStr", (Object)"alarms.statistics.byDay");
        alarmStatModel.setValue("dateStr", (Object)date);
        if (date != null) {
            alarmStatModel.setValue("EmbeddedActionText1", (Object)"alarms.statistics.view");
        } else {
            alarmStatModel.setValue("EmbeddedActionText1", null);
        }
        alarmStatModel.setValue(CHILD_EMBEDDED_ACTION_1, (Object)"2");
    }

    public static void populateAlarmStatisticsYmd(AlarmStatisticsListResultDocument.AlarmStatisticsListResult result, DefaultModel tableModel, Locale locale) throws IllegalArgumentException {
        Statistic[] statistic = result.getSTATISTICS().getSTATISTICArray();
        if (statistic != null) {
            for (int i = 0; i < statistic.length; ++i) {
                if (i != 0) {
                    tableModel.appendRow();
                }
                SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM");
                Date timeObj = null;
                try {
                    timeObj = formatter.parse(statistic[i].getDATE());
                }
                catch (ParseException ex) {
                    ex.printStackTrace();
                }
                tableModel.setValue("devType", (Object)AbbreviationUtil.getAbbreviation(statistic[i].getTYPE(), 2, locale));
                tableModel.setValue("dateStr", (Object)timeObj);
                tableModel.setValue("minorAlarms", (Object)new Integer(statistic[i].getMINOR()));
                tableModel.setValue("majorAlarms", (Object)new Integer(statistic[i].getMAJOR()));
                tableModel.setValue("criticalAlarms", (Object)new Integer(statistic[i].getCRITICAL()));
                tableModel.setValue("downAlarms", (Object)new Integer(statistic[i].getDOWN()));
            }
        }
    }

    public static void populateAlarmStatisticsWeek(AlarmStatisticsListResultDocument.AlarmStatisticsListResult result, DefaultModel tableModel, Locale locale) throws IllegalArgumentException {
        Statistic[] statistic = result.getSTATISTICS().getSTATISTICArray();
        if (statistic != null) {
            for (int i = 0; i < statistic.length; ++i) {
                if (i != 0) {
                    tableModel.appendRow();
                }
                SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd");
                Date timeObj = null;
                try {
                    timeObj = formatter.parse(statistic[i].getDATE());
                }
                catch (ParseException ex) {
                    ex.printStackTrace();
                }
                tableModel.setValue("devType", (Object)AbbreviationUtil.getAbbreviation(statistic[i].getTYPE(), 2, locale));
                tableModel.setValue("dateStr", (Object)timeObj);
                tableModel.setValue("minorAlarms", (Object)new Integer(statistic[i].getMINOR()));
                tableModel.setValue("majorAlarms", (Object)new Integer(statistic[i].getMAJOR()));
                tableModel.setValue("criticalAlarms", (Object)new Integer(statistic[i].getCRITICAL()));
                tableModel.setValue("downAlarms", (Object)new Integer(statistic[i].getDOWN()));
            }
        }
    }

    public static void populateAlarmStatisticsDay(AlarmStatisticsListResultDocument.AlarmStatisticsListResult result, DefaultModel tableModel, Locale locale) throws IllegalArgumentException {
        Statistic[] statistic = result.getSTATISTICS().getSTATISTICArray();
        if (statistic != null) {
            for (int i = 0; i < statistic.length; ++i) {
                if (i != 0) {
                    tableModel.appendRow();
                }
                String timeObj = statistic[i].getDATE();
                String timeStr = null;
                String timeNum = null;
                if (MONDAY.equals(timeObj)) {
                    timeStr = "day.monday";
                    timeNum = "1";
                } else if (TUESDAY.equals(timeObj)) {
                    timeStr = "day.tuesday";
                    timeNum = "2";
                } else if (WEDNESDAY.equals(timeObj)) {
                    timeStr = "day.wednesday";
                    timeNum = "3";
                } else if (THURSDAY.equals(timeObj)) {
                    timeStr = "day.thursday";
                    timeNum = "4";
                } else if (FRIDAY.equals(timeObj)) {
                    timeStr = "day.friday";
                    timeNum = "5";
                } else if (SATURDAY.equals(timeObj)) {
                    timeStr = "day.saturday";
                    timeNum = "6";
                } else if (SUNDAY.equals(timeObj)) {
                    timeStr = "day.sunday";
                    timeNum = "0";
                }
                tableModel.setValue("devType", (Object)AbbreviationUtil.getAbbreviation(statistic[i].getTYPE(), 2, locale));
                tableModel.setValue("dateStr", (Object)timeStr);
                tableModel.setValue("dateNum", (Object)timeNum);
                tableModel.setValue("minorAlarms", (Object)new Integer(statistic[i].getMINOR()));
                tableModel.setValue("majorAlarms", (Object)new Integer(statistic[i].getMAJOR()));
                tableModel.setValue("criticalAlarms", (Object)new Integer(statistic[i].getCRITICAL()));
                tableModel.setValue("downAlarms", (Object)new Integer(statistic[i].getDOWN()));
            }
        }
    }

    static int getDownAlarms(AlarmStatisticsListResultDocument.AlarmStatisticsListResult result) {
        int down = 0;
        if (result != null) {
            try {
                down = Integer.parseInt(result.getSTATISTICS().getTOTAL().getDOWN());
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        return down;
    }

    static int getCriticalAlarms(AlarmStatisticsListResultDocument.AlarmStatisticsListResult result) {
        int critical = 0;
        if (result != null) {
            try {
                critical = Integer.parseInt(result.getSTATISTICS().getTOTAL().getCRITICAL());
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        return critical;
    }

    static int getMajorAlarms(AlarmStatisticsListResultDocument.AlarmStatisticsListResult result) {
        int major = 0;
        if (result != null) {
            try {
                major = Integer.parseInt(result.getSTATISTICS().getTOTAL().getMAJOR());
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        return major;
    }

    static int getMinorAlarms(AlarmStatisticsListResultDocument.AlarmStatisticsListResult result) {
        int minor = 0;
        if (result != null) {
            try {
                minor = Integer.parseInt(result.getSTATISTICS().getTOTAL().getMINOR());
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        return minor;
    }

    static String getReportDate(AlarmStatisticsListResultDocument.AlarmStatisticsListResult result) {
        String reportDate = "";
        if (result != null) {
            reportDate = result.getSTATISTICS().getREPORTDATE();
        }
        return reportDate;
    }
}

