/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.mgmt.fm.storade.ui.viewbeans.admin;

import com.iplanet.jato.RequestContext;
import com.iplanet.jato.RequestManager;
import com.iplanet.jato.view.ContainerView;
import com.iplanet.jato.view.ContainerViewBase;
import com.iplanet.jato.view.View;
import com.iplanet.jato.view.event.ChildDisplayEvent;
import com.iplanet.jato.view.event.DisplayEvent;
import com.iplanet.jato.view.event.RequestInvocationEvent;
import com.sun.netstorage.mgmt.fm.storade.schema.admin.CommandResultDocument;
import com.sun.netstorage.mgmt.fm.storade.schema.admin.DeleteCoreResultDocument;
import com.sun.netstorage.mgmt.fm.storade.schema.admin.DeleteExtractResultDocument;
import com.sun.netstorage.mgmt.fm.storade.schema.admin.ExportConfigResultDocument;
import com.sun.netstorage.mgmt.fm.storade.schema.admin.RunAgentResultDocument;
import com.sun.netstorage.mgmt.fm.storade.schema.admin.StartExtractResultDocument;
import com.sun.netstorage.mgmt.fm.storade.schema.admin.UtilitiesResultDocument;
import com.sun.netstorage.mgmt.fm.storade.ui.common.UIMastHeadViewBeanBase;
import com.sun.netstorage.mgmt.fm.storade.ui.model.ActionTableModel;
import com.sun.netstorage.mgmt.fm.storade.ui.util.Connection;
import com.sun.netstorage.mgmt.fm.storade.ui.util.DateUtil;
import com.sun.netstorage.mgmt.fm.storade.ui.util.Debug;
import com.sun.netstorage.mgmt.fm.storade.ui.util.LocalizeUtil;
import com.sun.netstorage.mgmt.fm.storade.ui.viewbeans.admin.Getter;
import com.sun.netstorage.mgmt.fm.storade.ui.viewbeans.admin.Setter;
import com.sun.netstorage.mgmt.fm.storade.ui.viewbeans.admin.UtilitiesDataHelper;
import com.sun.web.ui.model.CCActionTableModel;
import com.sun.web.ui.model.CCPropertySheetModel;
import com.sun.web.ui.model.CCPropertySheetModelInterface;
import com.sun.web.ui.view.html.CCStaticTextField;
import com.sun.web.ui.view.propertysheet.CCPropertySheet;
import com.sun.web.ui.view.table.CCActionTable;
import java.io.Serializable;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.Locale;
import javax.servlet.http.HttpServletRequest;

public class UtilitiesViewBean
extends UIMastHeadViewBeanBase {
    public static final String PAGE_NAME = "Utilities";
    public static final String DEFAULT_DISPLAY_URL = "/jsp/admin/Utilities.jsp";
    public static final String CHILD_PROPERTYSHEET = "UtilitiesPropertySheet";
    public static final String CHILD_HEADER = "Header";
    public static final String CHILD_EXTRACTS_TABLE = "solutionExtractTable";
    public static final String CHILD_CORES_TABLE = "coreFilesTable";
    public static final String CHILD_CORE_TIME = "coreTimeStr";
    private static final String PAGESESSION_CORESTABLE_KEYS = "coreFilesTableKeys";
    private static final String PAGESESSION_EXTRACTSTABLE_KEYS = "solutionExtractTableKeys";
    private CCPropertySheetModel propertySheetModel = new CCPropertySheetModel(RequestManager.getRequestContext().getServletContext(), "/xml/propertysheet/UtilitiesPropertySheet.xml");
    private ActionTableModel coreFilesTableModel = new ActionTableModel(RequestManager.getRequestContext().getServletContext(), "/xml/table/CoreFilesTable.xml");
    private ActionTableModel solutionExtractTableModel = new ActionTableModel(RequestManager.getRequestContext().getServletContext(), "/xml/table/SolutionExtractTable.xml");
    public static final String sccs_id = "%Z%%M% %I%     %E% SMI";

    public UtilitiesViewBean() {
        super(PAGE_NAME, DEFAULT_DISPLAY_URL);
        this.initModel();
    }

    public void setRequestContext(RequestContext ctx) {
        super.setRequestContext(ctx);
    }

    protected void subRegisterChildren() {
        this.registerChild(CHILD_PROPERTYSHEET, CCPropertySheet.class);
        this.propertySheetModel.registerChildren((ContainerViewBase)this);
        this.registerChild(CHILD_HEADER, CCStaticTextField.class);
    }

    protected View subCreateChild(String name) {
        if (name.equals(CHILD_PROPERTYSHEET)) {
            CCPropertySheet child = new CCPropertySheet((ContainerView)this, (CCPropertySheetModelInterface)this.propertySheetModel, name);
            return child;
        }
        if (name.equals(CHILD_HEADER)) {
            String hostname = Connection.getHostname();
            try {
                InetAddress iaddr = null;
                iaddr = "localhost".equals(hostname) ? InetAddress.getLocalHost() : InetAddress.getByName(hostname);
                hostname = iaddr.getHostAddress();
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
            String header = Connection.getProtocol() + "://" + hostname + ":" + Connection.getPort();
            CCStaticTextField child = new CCStaticTextField((ContainerView)this, name, (Object)header);
            return child;
        }
        if (this.propertySheetModel.isChildSupported(name)) {
            return this.propertySheetModel.createChild((View)this, name);
        }
        return null;
    }

    private void initModel() {
        this.propertySheetModel.setModel(CHILD_CORES_TABLE, (Object)this.coreFilesTableModel);
        this.coreFilesTableModel.setActionValue("deleteCoreButton", "button.delete");
        this.coreFilesTableModel.setActionValue("deviceCol", "table.header.device");
        this.coreFilesTableModel.setActionValue("fileCol", "table.header.file");
        this.coreFilesTableModel.setActionValue("timeCol", "table.header.time");
        this.propertySheetModel.setModel(CHILD_EXTRACTS_TABLE, (Object)this.solutionExtractTableModel);
        this.solutionExtractTableModel.setActionValue("deleteExtractButton", "button.delete");
        this.solutionExtractTableModel.setActionValue("fileSizeCol", "table.header.fileSize");
        this.solutionExtractTableModel.setActionValue("timeCol", "table.header.time");
        this.solutionExtractTableModel.setActionValue("actionCol", "table.header.actions");
        HttpServletRequest request = RequestManager.getRequestContext().getRequest();
        Locale locale = request.getLocale();
        if (locale == null) {
            locale = Locale.getDefault();
        }
        UtilitiesResultDocument.UtilitiesResult result = Getter.getUtilitiesResultDocument().getUtilitiesResult();
        this.setAlarmSummary(result.getAlarmSummary());
        UtilitiesDataHelper.populateCoreFilesTableModel(result, this.coreFilesTableModel, locale);
        UtilitiesDataHelper.populateExtractsTableModel(result, this.solutionExtractTableModel, locale);
        this.setPageSessionAttribute(PAGESESSION_CORESTABLE_KEYS, (Serializable)this.coreFilesTableModel.getKeys());
        this.setPageSessionAttribute(PAGESESSION_EXTRACTSTABLE_KEYS, (Serializable)this.solutionExtractTableModel.getKeys());
    }

    public boolean beginChildDisplay(ChildDisplayEvent event) {
        String childName;
        HttpServletRequest request = RequestManager.getRequestContext().getRequest();
        Locale locale = request.getLocale();
        if (locale == null) {
            locale = Locale.getDefault();
        }
        if (CHILD_CORE_TIME.equals(childName = event.getChildName())) {
            CCStaticTextField textField = (CCStaticTextField)this.getChild(childName);
            String formatMask = DateUtil.getMediumFormatMask(locale);
            textField.setFormatMask(formatMask);
        }
        return true;
    }

    public void beginDisplay(DisplayEvent event) {
        this.loadPropertySheetModel(this.propertySheetModel);
        try {
            super.beginDisplay(event);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private void loadPropertySheetModel(CCPropertySheetModel model) {
        model.clear();
        model.setValue("extractButton", (Object)"button.extract");
        model.setValue("ejectButton", (Object)"button.eject");
        model.setValue("runAgentButton", (Object)"button.run");
        model.setValue("exportButton", (Object)"button.export");
    }

    public void handleEjectButtonRequest(RequestInvocationEvent event) {
        try {
            CommandResultDocument.CommandResult result = Getter.ejectCDAction().getCommandResult();
            String resultStr = result.getCOMMAND().getRESULT();
            this.setInlineAlert("info", "summary.ejectCDResult", null, resultStr, null);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        this.forwardTo(this.getRequestContext());
    }

    public void handleExportButtonRequest(RequestInvocationEvent event) {
        HttpServletRequest request = RequestManager.getRequestContext().getRequest();
        Locale locale = request.getLocale();
        String emailAddress = (String)this.propertySheetModel.getValue("exportConfigTargetEmailValue");
        String message = (String)this.propertySheetModel.getValue("exportConfigTargetMessageValue");
        Debug.println("EMAIL ADDRESS: " + emailAddress);
        Debug.println("MESSAGE:       " + message);
        try {
            ExportConfigResultDocument.ExportConfigResult result = Setter.exportConfig(emailAddress, message, locale);
            this.setInlineAlert("info", "summary.exportConfig", null, "summary.exportConfig.OK", null);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            this.setInlineAlert("error", "summary.exportConfig", null, "summary.exportConfig.Error", null);
        }
        this.forwardTo(this.getRequestContext());
    }

    public void handleRunAgentButtonRequest(RequestInvocationEvent event) {
        try {
            RunAgentResultDocument.RunAgentResult result = Setter.runAgent("");
            if (result == null) {
                this.setInlineAlert("error", "summary.runAgent", null, "error.internal", null);
            } else if (result.getERROR() != null) {
                this.setInlineAlert("error", "summary.runAgent", null, result.getERROR().getStringValue(), null);
            } else {
                this.setInlineAlert("info", "summary.runAgent", null, "info.runAgent", new String[]{result.getRUNAGENT()});
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        this.forwardTo(this.getRequestContext());
    }

    public void handleDeleteExtractButtonRequest(RequestInvocationEvent event) {
        try {
            RequestContext requestContext = event.getRequestContext();
            HttpServletRequest request = requestContext.getRequest();
            CCActionTable child = (CCActionTable)this.getChild(CHILD_EXTRACTS_TABLE);
            CCActionTableModel model = (CCActionTableModel)child.getModel();
            String[] keys = (String[])this.getPageSessionAttribute(PAGESESSION_EXTRACTSTABLE_KEYS);
            child.restoreStateData();
            Integer[] selectedRows = model.getSelectedRows();
            ArrayList<String> selectedKeys = new ArrayList<String>();
            for (int i = 0; i < selectedRows.length; ++i) {
                selectedKeys.add(keys[selectedRows[i]]);
            }
            Locale locale = request.getLocale();
            if (locale == null) {
                locale = Locale.getDefault();
            }
            boolean hasFail = false;
            String display = "";
            for (int i = 0; i < selectedKeys.size(); ++i) {
                String key = (String)selectedKeys.get(i);
                DeleteExtractResultDocument.DeleteExtractResult result = Setter.deleteExtract(key);
                if (result == null) {
                    hasFail = true;
                    display = display + key + ": " + LocalizeUtil.getLocalizedString("error.internal", locale) + "<br>";
                    continue;
                }
                if (result.getERROR() != null) {
                    hasFail = true;
                    display = display + key + ": " + result.getERROR().getStringValue() + "<br>";
                    continue;
                }
                display = display + key + ": " + LocalizeUtil.getLocalizedString("info.deleteExtract", locale) + "<br>";
            }
            if (hasFail) {
                this.setInlineAlert("error", "summary.deleteExtract", null, display, null);
            } else {
                this.setInlineAlert("info", "summary.deleteExtract", null, display, null);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        this.forwardTo(this.getRequestContext());
    }

    public void handleExtractButtonRequest(RequestInvocationEvent event) {
        try {
            StartExtractResultDocument.StartExtractResult result = Setter.startExtract();
            if (result == null) {
                this.setInlineAlert("error", "summary.startExtract", null, "error.internal", null);
            } else if (result.getERROR() != null) {
                this.setInlineAlert("error", "summary.startExtract", null, result.getERROR().getStringValue(), null);
            } else {
                this.setInlineAlert("info", "summary.startExtract", null, "info.startExtract", null);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        this.forwardTo(this.getRequestContext());
    }

    public void handleDownloadHREFRequest(RequestInvocationEvent event) {
        try {
            String id = (String)this.getDisplayFieldValue("downloadHREF");
            String url = "/" + Connection.getAppName() + id;
            event.getRequestContext().getResponse().sendRedirect(url);
            return;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            this.forwardTo(this.getRequestContext());
            return;
        }
    }

    public void handleDeleteCoreButtonRequest(RequestInvocationEvent event) {
        try {
            RequestContext requestContext = event.getRequestContext();
            HttpServletRequest request = requestContext.getRequest();
            CCActionTable child = (CCActionTable)this.getChild(CHILD_CORES_TABLE);
            CCActionTableModel model = (CCActionTableModel)child.getModel();
            String[] keys = (String[])this.getPageSessionAttribute(PAGESESSION_CORESTABLE_KEYS);
            child.restoreStateData();
            Integer[] selectedRows = model.getSelectedRows();
            ArrayList<String> selectedKeys = new ArrayList<String>();
            for (int i = 0; i < selectedRows.length; ++i) {
                selectedKeys.add(keys[selectedRows[i]]);
            }
            Locale locale = request.getLocale();
            if (locale == null) {
                locale = Locale.getDefault();
            }
            boolean hasFail = false;
            String display = "";
            for (int i = 0; i < selectedKeys.size(); ++i) {
                String key = (String)selectedKeys.get(i);
                DeleteCoreResultDocument.DeleteCoreResult result = Setter.deleteCore(key);
                if (result == null) {
                    hasFail = true;
                    display = display + key + ": " + LocalizeUtil.getLocalizedString("error.internal", locale) + "<br>";
                    continue;
                }
                if (result.getERROR() != null) {
                    hasFail = true;
                    display = display + key + ": " + result.getERROR().getStringValue() + "<br>";
                    continue;
                }
                display = display + key + ": " + LocalizeUtil.getLocalizedString("info.deleteCore", locale) + "<br>";
            }
            if (hasFail) {
                this.setInlineAlert("error", "summary.deleteCore", null, display, null);
            } else {
                this.setInlineAlert("info", "summary.deleteCore", null, display, null);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        try {
            String page = "admin/Utilities";
            String url = "/" + Connection.getAppName() + "/" + page;
            RequestContext requestContext = event.getRequestContext();
            requestContext.getResponse().sendRedirect(url);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }
}

