/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.mgmt.fm.storade.ui.viewbeans.admin;

import com.sun.netstorage.mgmt.fm.storade.schema.admin.CoreFile;
import com.sun.netstorage.mgmt.fm.storade.schema.admin.Extract;
import com.sun.netstorage.mgmt.fm.storade.schema.admin.UtilitiesResultDocument;
import com.sun.netstorage.mgmt.fm.storade.ui.model.ActionTableModel;
import com.sun.netstorage.mgmt.fm.storade.ui.util.DateUtil;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Locale;

public class UtilitiesDataHelper {
    public static final String sccs_id = "%Z%%M% %I%     %E% SMI";

    public static void populateCoreFilesTableModel(UtilitiesResultDocument.UtilitiesResult result, ActionTableModel coreFilesTableModel, Locale locale) throws IllegalArgumentException {
        if (result == null || locale == null || coreFilesTableModel == null) {
            throw new IllegalArgumentException("at least one parameter is null");
        }
        CoreFile[] cores = new CoreFile[]{};
        try {
            cores = result.getCOREFILES().getCOREArray();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        ArrayList<String> keys = new ArrayList<String>();
        for (int i = 0; i < cores.length; ++i) {
            CoreFile core = cores[i];
            if (i != 0) {
                coreFilesTableModel.appendRow();
            }
            String coreFileName = core.getNAME();
            String coreLink = core.getRELATIVE();
            coreLink = "/Crash" + coreLink;
            coreFilesTableModel.setValue("coreFileStr", coreFileName);
            coreFilesTableModel.setValue("coreTimeStr", DateUtil.toDate1(core.getTIME()));
            coreFilesTableModel.setValue("coreDeviceStr", core.getDEVICE());
            coreFilesTableModel.setValue("downloadStr", "action.download");
            coreFilesTableModel.setValue("downloadHREF", coreLink);
            keys.add(core.getFILE());
        }
        String[] keysArr = new String[keys.size()];
        keys.toArray(keysArr);
        coreFilesTableModel.setKeys(keysArr);
    }

    public static void populateExtractsTableModel(UtilitiesResultDocument.UtilitiesResult result, ActionTableModel extractsTableModel, Locale locale) throws IllegalArgumentException {
        if (result == null || locale == null || extractsTableModel == null) {
            throw new IllegalArgumentException("at least one parameter is null");
        }
        Extract[] extracts = new Extract[]{};
        try {
            extracts = result.getEXTRACTS().getEXTRACTArray();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        ArrayList<String> keys = new ArrayList<String>();
        for (int i = 0; i < extracts.length; ++i) {
            Extract extract = extracts[i];
            if (i != 0) {
                extractsTableModel.appendRow();
            }
            String dateStr = extract.getDate();
            SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd_HH:mm:ss");
            Date timeObj = new Date();
            try {
                timeObj = formatter.parse(dateStr);
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
            extractsTableModel.setValue("fileSizeStr", extract.getSize());
            extractsTableModel.setValue("dateStr", timeObj);
            extractsTableModel.setValue("viewLogStr", "action.viewLog");
            extractsTableModel.setValue("downloadStr", "action.download");
            extractsTableModel.setValue("downloadHREF", extract.getDownloadUrl());
            extractsTableModel.setValue("viewLogHREF", extract.getLog());
            extractsTableModel.setValue("viewContentHREF", extract.getDownloadUrl());
            extractsTableModel.setValue("viewContentStr", "action.viewContent");
            keys.add(extract.getDownloadUrl());
        }
        String[] keysArr = new String[keys.size()];
        keys.toArray(keysArr);
        extractsTableModel.setKeys(keysArr);
    }
}

