/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.mgmt.fm.storade.ui.viewbeans.admin;

import com.iplanet.jato.RequestContext;
import com.iplanet.jato.RequestManager;
import com.iplanet.jato.view.ContainerView;
import com.iplanet.jato.view.ContainerViewBase;
import com.iplanet.jato.view.View;
import com.iplanet.jato.view.event.DisplayEvent;
import com.iplanet.jato.view.event.RequestInvocationEvent;
import com.iplanet.jato.view.html.Option;
import com.iplanet.jato.view.html.OptionList;
import com.iplanet.jato.view.html.SelectableGroup;
import com.sun.netstorage.mgmt.fm.storade.schema.Value;
import com.sun.netstorage.mgmt.fm.storade.schema.admin.AddHostResultDocument;
import com.sun.netstorage.mgmt.fm.storade.schema.admin.AgentsResultDocument;
import com.sun.netstorage.mgmt.fm.storade.schema.admin.Host;
import com.sun.netstorage.mgmt.fm.storade.schema.admin.HostDetailsResultDocument;
import com.sun.netstorage.mgmt.fm.storade.schema.admin.UpdateHostResultDocument;
import com.sun.netstorage.mgmt.fm.storade.ui.common.UIMastHeadViewBeanBase;
import com.sun.netstorage.mgmt.fm.storade.ui.util.AbbreviationUtil;
import com.sun.netstorage.mgmt.fm.storade.ui.util.Connection;
import com.sun.netstorage.mgmt.fm.storade.ui.viewbeans.admin.Getter;
import com.sun.netstorage.mgmt.fm.storade.ui.viewbeans.admin.Setter;
import com.sun.web.ui.model.CCPageTitleModel;
import com.sun.web.ui.model.CCPageTitleModelInterface;
import com.sun.web.ui.model.CCPropertySheetModel;
import com.sun.web.ui.model.CCPropertySheetModelInterface;
import com.sun.web.ui.view.html.CCOption;
import com.sun.web.ui.view.html.CCTextField;
import com.sun.web.ui.view.pagetitle.CCPageTitle;
import com.sun.web.ui.view.propertysheet.CCPropertySheet;
import java.io.Serializable;
import java.util.Locale;
import java.util.StringTokenizer;
import javax.servlet.http.HttpServletRequest;

public class SlaveAdditionViewBean
extends UIMastHeadViewBeanBase {
    public static final String PAGE_NAME = "SlaveAddition";
    public static final String DEFAULT_DISPLAY_URL = "/jsp/admin/SlaveAddition.jsp";
    public static final String CHILD_PROPERTYSHEET = "PropertySheet";
    public static final String CHILD_PAGETITLE = "PageTitle";
    private CCPropertySheetModel propertySheetModel = new CCPropertySheetModel(RequestManager.getRequestContext().getServletContext(), "/xml/propertysheet/SlaveAdditionPropertySheet.xml");
    private CCPageTitleModel pageTitleModel = new CCPageTitleModel(RequestManager.getRequestContext().getServletContext(), "/xml/pagetitle/SlaveAdditionPageTitle.xml");
    public static final String HOSTID_KEY = "hostID";
    private OptionList monitorCategories = new OptionList();
    public static final String sccs_id = "%Z%%M% %I%     %E% SMI";

    public SlaveAdditionViewBean() {
        super(PAGE_NAME, DEFAULT_DISPLAY_URL);
    }

    public void setRequestContext(RequestContext ctx) {
        super.setRequestContext(ctx);
        this.initModel();
    }

    protected void subRegisterChildren() {
        this.registerChild(CHILD_PROPERTYSHEET, CCPropertySheet.class);
        this.propertySheetModel.registerChildren((ContainerViewBase)this);
        this.registerChild(CHILD_PAGETITLE, CCPageTitle.class);
        this.pageTitleModel.registerChildren((ContainerViewBase)this);
    }

    protected View subCreateChild(String name) {
        if (name.equals(CHILD_PROPERTYSHEET)) {
            CCPropertySheet child = new CCPropertySheet((ContainerView)this, (CCPropertySheetModelInterface)this.propertySheetModel, name);
            return child;
        }
        if (name.equals(CHILD_PAGETITLE)) {
            CCPageTitle child = new CCPageTitle((ContainerView)this, (CCPageTitleModelInterface)this.pageTitleModel, name);
            return child;
        }
        if (this.propertySheetModel.isChildSupported(name)) {
            if ("MonitorCategoryValue".equals(name)) {
                SelectableGroup list = (SelectableGroup)this.propertySheetModel.createChild((View)this, name);
                list.setOptions(this.monitorCategories);
                return list;
            }
            return this.propertySheetModel.createChild((View)this, name);
        }
        if (this.pageTitleModel.isChildSupported(name)) {
            return this.pageTitleModel.createChild((View)this, name);
        }
        return null;
    }

    private void initModel() {
    }

    private void setMonitorCategories(Value[] values, Locale locale) {
        CCOption[] options = new CCOption[values.length + 1];
        options[0] = new CCOption("monitorCategory.all", "*");
        for (int i = 0; i < values.length; ++i) {
            options[i + 1] = new CCOption(AbbreviationUtil.getAbbreviation(values[i].getID(), 2, locale), values[i].getID());
        }
        this.monitorCategories = new OptionList((Option[])options);
    }

    private String bt(String in) {
        if ("Y".equals(in) || "1".equals(in)) {
            return "true";
        }
        return "false";
    }

    private void loadPropertySheetModel(CCPropertySheetModel model, String hostID, Locale locale) {
        model.clear();
        model.setValue("MonitoringFrequencyUnit", (Object)"unit.minutes");
        model.setValue("MessageLogValue", (Object)"/var/adm/messages");
        if (hostID == null) {
            AgentsResultDocument.AgentsResult result = Getter.getAgentsResultDocument().getAgentsResult();
            this.setAlarmSummary(result.getAlarmSummary());
            Value[] values = result.getAGENTS().getVALUEArray();
            this.setMonitorCategories(values, locale);
            model.setValue("MonitoringFrequencyValue", (Object)"5");
            model.setValue("MonitorCategoryValue", (Object)"*");
        } else {
            HostDetailsResultDocument.HostDetailsResult result = Getter.getHostDetailsResultDocument(hostID).getHostDetailsResult();
            this.setAlarmSummary(result.getAlarmSummary());
            Value[] values = result.getAGENTS().getVALUEArray();
            this.setMonitorCategories(values, locale);
            Host[] hosts = result.getHOSTS().getHOSTArray();
            if (hosts.length > 0) {
                Host host = hosts[0];
                model.setValue("MonitoringFrequencyValue", (Object)host.getFREQUENCY());
                model.setValue("HostIDValue", (Object)host.getID());
                model.setValue("HostNameValue", (Object)host.getNAME());
                model.setValue("SpecialContractValue", (Object)host.getCONTRACT());
                if ("AM".equals(host.getTYPE())) {
                    model.setValue("AlternateMasterValue", (Object)"true");
                }
                if ("1".equals(host.getSKIPLUXADM())) {
                    model.setValue("SkipLuxadmLabelValue", (Object)"true");
                }
                if ("Y".equals(host.getSHOWMONITOREDONLY())) {
                    model.setValue("ShowMonitoredOnlyValue", (Object)"true");
                }
                model.setValue("StorageLogValue", (Object)host.getT300LOGFILE());
                if (host.getCATEGORIES() != null) {
                    boolean allFound = true;
                    for (int i = 0; i < values.length; ++i) {
                        if (host.getCATEGORIES().indexOf(values[i].getID() + "|") != -1) continue;
                        allFound = false;
                        break;
                    }
                    if (allFound) {
                        model.setValue("MonitorCategoryValue", (Object)"*");
                    } else {
                        StringTokenizer st = new StringTokenizer(host.getCATEGORIES(), "|");
                        Object[] cs = new String[st.countTokens()];
                        int k = 0;
                        while (st.hasMoreTokens()) {
                            String s = st.nextToken();
                            cs[k] = s;
                            ++k;
                        }
                        model.setValues("MonitorCategoryValue", cs);
                    }
                }
            }
        }
    }

    public void setPageInfo() {
        String hostID = this.getHostID();
        this.pageTitleModel.setValue("PageButtonReset", (Object)"button.reset");
        this.pageTitleModel.setValue("PageButtonCancel", (Object)"button.cancel");
        if (hostID == null) {
            this.setPageName(PAGE_NAME);
            this.pageTitleModel.setPageTitleText("page.title.slaveAddition");
            this.pageTitleModel.setValue("PageButtonSave", (Object)"button.add");
        } else {
            this.setPageName("HostDetails");
            this.pageTitleModel.setPageTitleText("page.title.hostDetails");
            this.pageTitleModel.setValue("PageButtonSave", (Object)"button.save");
        }
    }

    public void beginDisplay(DisplayEvent event) {
        HttpServletRequest request = RequestManager.getRequestContext().getRequest();
        Locale locale = request.getLocale();
        String hostID = this.getHostID();
        this.loadPropertySheetModel(this.propertySheetModel, hostID, locale);
        if (hostID != null) {
            this.setPageSessionAttribute(HOSTID_KEY, (Serializable)((Object)hostID));
            ((CCTextField)this.getChild("HostIDValue")).setDisabled(true);
            ((CCTextField)this.getChild("HostNameValue")).setDisabled(true);
        }
        try {
            super.beginDisplay(event);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public void handlePageButtonResetRequest(RequestInvocationEvent event) {
        String hostID = this.getHostID();
        String url = "/" + Connection.getAppName() + "/admin/SlaveAddition";
        if (hostID != null) {
            url = url + "?" + HOSTID_KEY + "=" + this.urlencode(hostID);
        }
        try {
            this.getRequestContext().getResponse().sendRedirect(url);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public void handlePageButtonCancelRequest(RequestInvocationEvent event) {
        String url = "/" + Connection.getAppName() + "/admin/Agents";
        try {
            this.getRequestContext().getResponse().sendRedirect(url);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public void handlePageButtonSaveRequest(RequestInvocationEvent event) {
        HttpServletRequest request = RequestManager.getRequestContext().getRequest();
        String hostID = this.getHostID();
        String hostid = (String)this.getDisplayFieldValue("HostIDValue");
        String hostname = (String)this.getDisplayFieldValue("HostNameValue");
        String specialContract = (String)this.getDisplayFieldValue("SpecialContractValue");
        String[] categories = request.getParameterValues("SlaveAddition.MonitorCategoryValue");
        String frequency = (String)this.getDisplayFieldValue("MonitoringFrequencyValue");
        String am = (String)this.getDisplayFieldValue("AlternateMasterValue");
        String skipLuxadmin = (String)this.getDisplayFieldValue("SkipLuxadmLabelValue");
        String showMonitoredOnly = (String)this.getDisplayFieldValue("ShowMonitoredOnlyValue");
        String stroageLogLocation = (String)this.getDisplayFieldValue("StorageLogValue");
        if (stroageLogLocation != null) {
            stroageLogLocation = stroageLogLocation.trim();
        }
        String sc = "contract=" + this.urlencode(specialContract);
        if (hostID == null) {
            sc = sc + "&hostname=" + this.urlencode(hostname);
            if (hostid != null && !"".equals(hostid.trim())) {
                sc = sc + "&hostid=" + this.urlencode(hostid);
            }
        }
        if (categories != null) {
            for (int i = 0; i < categories.length; ++i) {
                sc = "*".equals(categories[i]) ? sc + "&allCategories=true" : sc + "&" + categories[i] + "=1";
            }
        }
        sc = sc + "&frequency=" + frequency;
        if ("true".equals(am)) {
            sc = sc + "&role=AM";
        }
        if ("true".equals(skipLuxadmin)) {
            sc = sc + "&skip_luxadm=1";
        }
        if ("true".equals(showMonitoredOnly)) {
            sc = sc + "&show_monitored_only=Y";
        }
        if (stroageLogLocation != null && !"".equals(stroageLogLocation.trim())) {
            sc = sc + "&t300logfile=" + this.urlencode(stroageLogLocation);
        }
        try {
            if (hostID == null) {
                AddHostResultDocument.AddHostResult result = Setter.addHost(sc);
                if (result == null) {
                    this.setInlineAlert("error", "summary.addHost", null, "error.internal", null);
                    String url = "/" + Connection.getAppName() + "/admin/SlaveAddition";
                    event.getRequestContext().getResponse().sendRedirect(url);
                } else if (result.getERROR() != null) {
                    if ("707".equals(result.getERROR().getNo()) || "708".equals(result.getERROR().getNo())) {
                        this.setInlineAlert("warning", "summary.addHost", null, "error." + result.getERROR().getNo(), new String[]{result.getERROR().getStringValue()});
                    } else {
                        this.setInlineAlert("error", "summary.addHost", null, "error." + result.getERROR().getNo(), new String[]{result.getERROR().getStringValue()});
                    }
                    String url = "/" + Connection.getAppName() + "/admin/SlaveAddition";
                    event.getRequestContext().getResponse().sendRedirect(url);
                } else {
                    this.setInlineAlert("info", "summary.addHost", null, "info.addHost", null);
                    String url = "/" + Connection.getAppName() + "/admin/Agents";
                    event.getRequestContext().getResponse().sendRedirect(url);
                }
            } else {
                UpdateHostResultDocument.UpdateHostResult result = Setter.updateHost(sc = sc + "&ipno=" + this.urlencode(hostID));
                if (result == null) {
                    this.setInlineAlert("error", "summary.updateHost", null, "error.internal", null);
                    String url = "/" + Connection.getAppName() + "/admin/SlaveAddition?hostID=" + this.urlencode(hostID);
                    event.getRequestContext().getResponse().sendRedirect(url);
                } else if (result.getERROR() != null) {
                    this.setInlineAlert("error", "summary.updateHost", null, "error." + result.getERROR().getNo(), new String[]{result.getERROR().getStringValue()});
                    String url = "/" + Connection.getAppName() + "/admin/SlaveAddition?hostID=" + this.urlencode(hostID);
                    event.getRequestContext().getResponse().sendRedirect(url);
                } else {
                    this.setInlineAlert("info", "summary.updateHost", null, "info.updateHost", null);
                    String url = "/" + Connection.getAppName() + "/admin/Agents";
                    event.getRequestContext().getResponse().sendRedirect(url);
                }
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private String getHostID() {
        HttpServletRequest request = RequestManager.getRequestContext().getRequest();
        String hostID = request.getParameter(HOSTID_KEY);
        if (hostID == null) {
            hostID = (String)this.getPageSessionAttribute(HOSTID_KEY);
        }
        return hostID;
    }
}

