/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.mgmt.fm.storade.ui.viewbeans.admin;

import com.iplanet.jato.RequestContext;
import com.iplanet.jato.RequestManager;
import com.iplanet.jato.view.ContainerView;
import com.iplanet.jato.view.ContainerViewBase;
import com.iplanet.jato.view.View;
import com.iplanet.jato.view.event.DisplayEvent;
import com.iplanet.jato.view.event.RequestInvocationEvent;
import com.sun.netstorage.mgmt.fm.storade.schema.admin.RenvResultDocument;
import com.sun.netstorage.mgmt.fm.storade.ui.common.UIMastHeadViewBeanBase;
import com.sun.netstorage.mgmt.fm.storade.ui.model.ActionTableModel;
import com.sun.netstorage.mgmt.fm.storade.ui.util.Connection;
import com.sun.netstorage.mgmt.fm.storade.ui.util.Debug;
import com.sun.netstorage.mgmt.fm.storade.ui.util.UserUtil;
import com.sun.netstorage.mgmt.fm.storade.ui.view.ActionTable;
import com.sun.netstorage.mgmt.fm.storade.ui.view.ActionTableInterface;
import com.sun.netstorage.mgmt.fm.storade.ui.viewbeans.admin.Getter;
import com.sun.netstorage.mgmt.fm.storade.ui.viewbeans.admin.NotificationDataHelper;
import com.sun.netstorage.mgmt.fm.storade.ui.viewbeans.admin.SNMPContract;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Locale;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;

public class SNMPNotificationViewBean
extends UIMastHeadViewBeanBase {
    public static final String PAGE_NAME = "SNMPNotification";
    public static final String DEFAULT_DISPLAY_URL = "/jsp/admin/SNMPNotification.jsp";
    public static final String CHILD_SNMPS_TABLE = "SNMPContractsTable";
    private ActionTableModel snmpsModel = new ActionTableModel(RequestManager.getRequestContext().getServletContext(), "/xml/table/SNMPContractsTable.xml");
    public static final String sccs_id = "%Z%%M% %I%     %E% SMI";

    public SNMPNotificationViewBean() {
        super(PAGE_NAME, DEFAULT_DISPLAY_URL);
    }

    public void setRequestContext(RequestContext ctx) {
        super.setRequestContext(ctx);
        this.initModel();
    }

    protected void subRegisterChildren() {
        this.registerChild(CHILD_SNMPS_TABLE, ActionTable.class);
        this.snmpsModel.registerChildren((ContainerViewBase)this);
    }

    protected View subCreateChild(String name) {
        if (name.equals(CHILD_SNMPS_TABLE)) {
            ActionTable child = new ActionTable((ContainerView)this, this.snmpsModel, name);
            return child;
        }
        if (this.snmpsModel.isChildSupported(name)) {
            View view = this.snmpsModel.createChild((View)this, name);
            this.disableButtonIfNotPrivilege(view);
            return view;
        }
        return null;
    }

    private void initModel() {
        this.snmpsModel.setActionValue("hostCol", "table.header.ipAddress");
        this.snmpsModel.setActionValue("portCol", "table.header.port");
        this.snmpsModel.setActionValue("minAlertLevelCol", "table.header.minAlertLevel");
        this.snmpsModel.setActionValue("addNotificationButton", "button.addNotification");
        this.snmpsModel.setActionValue("deleteButton", "button.delete");
        this.snmpsModel.setActionValue("modifyButton", "button.modify");
    }

    public void beginDisplay(DisplayEvent event) {
        HttpServletRequest request = RequestManager.getRequestContext().getRequest();
        HttpSession session = this.getRequestContext().getRequest().getSession();
        session.setAttribute("storade.privilegedRole", (Object)new Boolean(UserUtil.isPrivilegedRole(request)).toString());
        Locale locale = request.getLocale();
        if (locale == null) {
            locale = Locale.getDefault();
        }
        try {
            RenvResultDocument.RenvResult result = Getter.getRenvResultDocument().getRenvResult();
            this.setAlarmSummary(result.getAlarmSummary());
            NotificationDataHelper.populateSNMPContractsTableModel(result, this.snmpsModel, locale);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        try {
            super.beginDisplay(event);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public void handleAddNotificationButtonRequest(RequestInvocationEvent event) {
        String url = "/" + Connection.getAppName() + "/admin/SNMPAddition";
        try {
            event.getRequestContext().getResponse().sendRedirect(url);
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
    }

    public void handleModifyButtonRequest(RequestInvocationEvent event) {
        ActionTableInterface child = (ActionTableInterface)this.getChild(CHILD_SNMPS_TABLE);
        ArrayList keys = child.getSelectedKeysForCurrentPage();
        ArrayList snmpList = new ArrayList();
        String key = (String)keys.get(0);
        String url = "/" + Connection.getAppName() + "/admin/SNMPAddition?modifyKey=" + key;
        try {
            event.getRequestContext().getResponse().sendRedirect(url);
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
    }

    public void handleDeleteButtonRequest(RequestInvocationEvent event) {
        ActionTableInterface child = (ActionTableInterface)this.getChild(CHILD_SNMPS_TABLE);
        ArrayList keys = child.getSelectedKeysForCurrentPage();
        ArrayList<SNMPContract> snmpList = new ArrayList<SNMPContract>();
        for (int i = 0; i < keys.size(); ++i) {
            String key = (String)keys.get(i);
            Debug.println(key);
            SNMPContract sc = SNMPContract.rebuildSNMPContract(key);
            if (sc == null) continue;
            snmpList.add(sc);
        }
        if (snmpList.size() != 0) {
            SNMPContract[] snmpArray = new SNMPContract[snmpList.size()];
            snmpList.toArray(snmpArray);
            int ret = NotificationDataHelper.SNMPNotificationAction(snmpArray, "delete");
            if (ret == -999) {
                this.setInlineAlert("error", "summary.deleteSNMP", null, "error.internal", null);
            } else if (ret == 0) {
                this.setInlineAlert("info", "summary.deleteSNMP", null, "info.deleteSNMP", null);
            }
        }
        String url = "/" + Connection.getAppName() + "/admin/SNMPNotification";
        try {
            event.getRequestContext().getResponse().sendRedirect(url);
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
    }
}

