/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.mgmt.fm.storade.ui.viewbeans.admin;

import com.iplanet.jato.RequestContext;
import com.iplanet.jato.RequestManager;
import com.iplanet.jato.view.ContainerView;
import com.iplanet.jato.view.ContainerViewBase;
import com.iplanet.jato.view.View;
import com.iplanet.jato.view.event.DisplayEvent;
import com.iplanet.jato.view.event.RequestInvocationEvent;
import com.sun.netstorage.mgmt.fm.storade.schema.Value;
import com.sun.netstorage.mgmt.fm.storade.schema.admin.RenvResultDocument;
import com.sun.netstorage.mgmt.fm.storade.ui.common.UIMastHeadViewBeanBase;
import com.sun.netstorage.mgmt.fm.storade.ui.util.Connection;
import com.sun.netstorage.mgmt.fm.storade.ui.util.LocalizeUtil;
import com.sun.netstorage.mgmt.fm.storade.ui.util.SystemUtil;
import com.sun.netstorage.mgmt.fm.storade.ui.viewbeans.admin.Getter;
import com.sun.netstorage.mgmt.fm.storade.ui.viewbeans.admin.Setter;
import com.sun.web.ui.model.CCPageTitleModel;
import com.sun.web.ui.model.CCPageTitleModelInterface;
import com.sun.web.ui.model.CCPropertySheetModel;
import com.sun.web.ui.model.CCPropertySheetModelInterface;
import com.sun.web.ui.view.pagetitle.CCPageTitle;
import com.sun.web.ui.view.propertysheet.CCPropertySheet;
import java.net.URLEncoder;
import java.util.Locale;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;

public class NotificationSetupViewBean
extends UIMastHeadViewBeanBase {
    public static final String PAGE_NAME = "NotificationSetup";
    public static final String DEFAULT_DISPLAY_URL = "/jsp/admin/NotificationSetup.jsp";
    public static final String CHILD_PROPERTYSHEET = "NotificationSetupPropertySheet";
    public static final String CHILD_PAGETITLE = "PageTitle";
    private CCPropertySheetModel propertySheetModel;
    private CCPageTitleModel pageTitleModel = new CCPageTitleModel(RequestManager.getRequestContext().getServletContext(), "/xml/pagetitle/NotificationSetupPageTitle.xml");
    private static final String SUN_MC_ERROR_KEY = "notification.sunMCErrorMsg";
    public static final String sccs_id = "%Z%%M% %I%     %E% SMI";

    public NotificationSetupViewBean() {
        super(PAGE_NAME, DEFAULT_DISPLAY_URL);
        this.initModel();
    }

    public void setRequestContext(RequestContext ctx) {
        super.setRequestContext(ctx);
    }

    protected void subRegisterChildren() {
        this.registerChild(CHILD_PROPERTYSHEET, CCPropertySheet.class);
        this.propertySheetModel.registerChildren((ContainerViewBase)this);
        this.registerChild(CHILD_PAGETITLE, CCPageTitle.class);
        this.pageTitleModel.registerChildren((ContainerViewBase)this);
    }

    protected View subCreateChild(String name) {
        if (name.equals(CHILD_PROPERTYSHEET)) {
            CCPropertySheet child = new CCPropertySheet((ContainerView)this, (CCPropertySheetModelInterface)this.propertySheetModel, name);
            return child;
        }
        if (name.equals(CHILD_PAGETITLE)) {
            CCPageTitle child = new CCPageTitle((ContainerView)this, (CCPageTitleModelInterface)this.pageTitleModel, name);
            return child;
        }
        if (this.propertySheetModel.isChildSupported(name)) {
            return this.propertySheetModel.createChild((View)this, name);
        }
        if (this.pageTitleModel.isChildSupported(name)) {
            View view = this.pageTitleModel.createChild((View)this, name);
            this.disableButtonIfNotPrivilege(view);
            return view;
        }
        return null;
    }

    private void initModel() {
        this.propertySheetModel = SystemUtil.isSystemEdition() ? new CCPropertySheetModel(RequestManager.getRequestContext().getServletContext(), "/xml/propertysheet/NotificationSetupPropertySheet_SE.xml") : new CCPropertySheetModel(RequestManager.getRequestContext().getServletContext(), "/xml/propertysheet/NotificationSetupPropertySheet.xml");
        this.pageTitleModel.setValue("PageButtonSave", (Object)"button.save");
        this.pageTitleModel.setValue("PageButtonReset", (Object)"button.reset");
    }

    public void beginDisplay(DisplayEvent event) {
        HttpServletRequest request = RequestManager.getRequestContext().getRequest();
        Locale locale = request.getLocale();
        if (locale == null) {
            locale = Locale.getDefault();
        }
        String sunMCErrorMsg = LocalizeUtil.getLocalizedString("com.sun.netstorage.mgmt.fm.storade.ui.resources.ApplicationResources", SUN_MC_ERROR_KEY, locale);
        HttpSession session = this.getRequestContext().getRequest().getSession();
        session.setAttribute("sunMCErrorMsg", (Object)sunMCErrorMsg);
        try {
            super.beginDisplay(event);
            this.loadPropertySheetModel(this.propertySheetModel);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private void loadPropertySheetModel(CCPropertySheetModel model) {
        model.clear();
        model.setValue("maxEmailSizeUnit", (Object)"unit.MB");
        model.setValue("testEmailButton", (Object)"button.testEmail");
        model.setValue("maxSizeUnit", (Object)"unit.Kbytes");
        model.setValue("heartBeatUnit", (Object)"unit.hour");
        RenvResultDocument.RenvResult result = Getter.getRenvResultDocument().getRenvResult();
        this.setAlarmSummary(result.getAlarmSummary());
        Value[] values = result.getENV().getVALUEArray();
        for (int i = 0; i < values.length; ++i) {
            Value v = values[i];
            if ("sendmail_server".equals(v.getID())) {
                model.setValue("SMTPServerValue", (Object)v.getStringValue());
                continue;
            }
            if ("email_from".equals(v.getID())) {
                model.setValue("fromAddressValue", (Object)v.getStringValue());
                continue;
            }
            if ("max_email_size".equals(v.getID())) {
                model.setValue("maxEmailSizeValue", (Object)v.getStringValue());
                continue;
            }
            if ("mailer".equals(v.getID())) {
                model.setValue("emailProgramPathValue", (Object)v.getStringValue());
                continue;
            }
            if ("pro.nscc_email.active".equals(v.getID())) {
                model.setValue("NSCCActiveValue", (Object)this.translator(v.getStringValue()));
                continue;
            }
            if ("pro.ssrr.active".equals(v.getID())) {
                model.setValue("SSRRActiveValue", (Object)this.translator(v.getStringValue()));
                continue;
            }
            if ("pro.ssrr.frequency".equals(v.getID())) {
                model.setValue("SSRRHeartBeatFrequencyValue", (Object)v.getStringValue());
                continue;
            }
            if ("pro.trap.active".equals(v.getID())) {
                model.setValue("SNMPActiveValue", (Object)this.translator(v.getStringValue()));
                continue;
            }
            if ("pro.nscc_email.encrypt".equals(v.getID())) {
                model.setValue("doEncryptValue", (Object)v.getStringValue());
                continue;
            }
            if ("pro.netconnect.active".equals(v.getID())) {
                model.setValue("NetConnectActiveValue", (Object)this.translator(v.getStringValue()));
                continue;
            }
            if ("pro.netconnect.maxsize".equals(v.getID())) {
                model.setValue("maxSizeValue", (Object)v.getStringValue());
                continue;
            }
            if ("pro.netconnect.version".equals(v.getID())) {
                model.setValue("transportMethodValue", (Object)v.getStringValue());
                continue;
            }
            if ("pro.sunmc.active".equals(v.getID())) {
                model.setValue("SunMCActiveValue", (Object)this.translator(v.getStringValue()));
                continue;
            }
            if ("pro.sunmc.ip".equals(v.getID())) {
                model.setValue("ipAddressValue", (Object)v.getStringValue());
                continue;
            }
            if (!"pro.sunmc.frequency".equals(v.getID())) continue;
            model.setValue("heartBeatValue", (Object)v.getStringValue());
        }
    }

    public void handlePageButtonSaveRequest(RequestInvocationEvent event) {
        String SMTPServerValue = (String)this.getDisplayFieldValue("SMTPServerValue");
        String fromAddressValue = (String)this.getDisplayFieldValue("fromAddressValue");
        String maxEmailSizeValue = (String)this.getDisplayFieldValue("maxEmailSizeValue");
        String emailProgramPathValue = (String)this.getDisplayFieldValue("emailProgramPathValue");
        String NSCCActiveValue = this.translator((String)this.getDisplayFieldValue("NSCCActiveValue"));
        String SNMPActiveValue = this.translator((String)this.getDisplayFieldValue("SNMPActiveValue"));
        String doEncryptValue = (String)this.getDisplayFieldValue("doEncryptValue");
        String SSRRActiveValue = "";
        String SSRRHeartBeatFrequency = "";
        String NetConnectActiveValue = "";
        String maxSizeValue = "";
        String transportMethodValue = "";
        String SunMCActiveValue = "";
        String ipAddressValue = "";
        String heartBeatValue = "";
        if (SMTPServerValue == null || "".equals(SMTPServerValue)) {
            SMTPServerValue = "localhost";
        }
        if (ipAddressValue == null || "".equals(ipAddressValue)) {
            ipAddressValue = "localhost:18055";
        }
        if (SystemUtil.isSystemEdition()) {
            SSRRActiveValue = this.translator((String)this.getDisplayFieldValue("SSRRActiveValue"));
            SSRRHeartBeatFrequency = (String)this.getDisplayFieldValue("SSRRHeartBeatFrequencyValue");
        } else {
            NetConnectActiveValue = this.translator((String)this.getDisplayFieldValue("NetConnectActiveValue"));
            maxSizeValue = (String)this.getDisplayFieldValue("maxSizeValue");
            transportMethodValue = (String)this.getDisplayFieldValue("transportMethodValue");
            SunMCActiveValue = this.translator((String)this.getDisplayFieldValue("SunMCActiveValue"));
            ipAddressValue = (String)this.getDisplayFieldValue("ipAddressValue");
            heartBeatValue = (String)this.getDisplayFieldValue("heartBeatValue");
        }
        String setterCommand = "sendmail_server=" + this.encodeValue(SMTPServerValue) + "&" + "email_from" + "=" + this.encodeValue(fromAddressValue) + "&" + "max_email_size" + "=" + this.encodeValue(maxEmailSizeValue) + "&" + "mailer" + "=" + this.encodeValue(emailProgramPathValue) + "&" + "pro.nscc_email.active" + "=" + this.encodeValue(NSCCActiveValue) + "&" + "pro.trap.active" + "=" + this.encodeValue(SNMPActiveValue) + "&" + "pro.nscc_email.encrypt" + "=" + this.encodeValue(doEncryptValue);
        setterCommand = SystemUtil.isSystemEdition() ? setterCommand + "&" + "pro.ssrr.active" + "=" + this.encodeValue(SSRRActiveValue) + "&" + "pro.ssrr.frequency" + "=" + this.encodeValue(SSRRHeartBeatFrequency) : setterCommand + "&" + "pro.netconnect.active" + "=" + this.encodeValue(NetConnectActiveValue) + "&" + "pro.netconnect.maxsize" + "=" + this.encodeValue(maxSizeValue) + "&" + "pro.netconnect.version" + "=" + this.encodeValue(transportMethodValue) + "&" + "pro.sunmc.active" + "=" + this.encodeValue(SunMCActiveValue) + "&" + "pro.sunmc.ip" + "=" + this.encodeValue(ipAddressValue) + "&" + "pro.sunmc.frequency" + "=" + this.encodeValue(heartBeatValue);
        boolean ret = Setter.setRenv(setterCommand);
        if (ret) {
            boolean pkg;
            int err;
            this.setInlineAlert("info", "summary.notificationSetup", null, "info.notificationSetup", null);
            if ("Y".equals(SSRRActiveValue) && (err = Setter.checkSSRRPkg()) != 0) {
                err = 898;
                String msg = "error.notificationSetup.ssrrpkg1";
                if (err == 897) {
                    msg = "error.notificationSetup.ssrrpkg2";
                }
                this.setInlineAlert("error", "summary.notificationSetup", null, msg, null);
            }
            if ("Y".equals(NetConnectActiveValue) && !(pkg = Setter.checkNCPkg())) {
                this.setInlineAlert("error", "summary.notificationSetup", null, "error.notificationSetup.ncpkg", null);
            }
        } else {
            this.setInlineAlert("error", "summary.notificationSetup", null, "error.internal", null);
        }
        this.forwardTo(this.getRequestContext());
    }

    public void handlePageButtonResetRequest(RequestInvocationEvent event) {
        String url = "/" + Connection.getAppName() + "/admin/NotificationSetup";
        try {
            this.getRequestContext().getResponse().sendRedirect(url);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private String encodeValue(String in) {
        if (in == null) {
            return null;
        }
        return URLEncoder.encode(in);
    }

    private String translator(String in) {
        String out = null;
        if ("N".equals(in)) {
            out = "false";
        } else if ("Y".equals(in)) {
            out = "true";
        } else if ("false".equals(in)) {
            out = "N";
        } else if ("true".equals(in)) {
            out = "Y";
        }
        return out;
    }
}

