/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.mgmt.fm.storade.ui.viewbeans.admin;

import com.iplanet.jato.model.DefaultModel;
import com.sun.netstorage.mgmt.fm.storade.schema.Value;
import com.sun.netstorage.mgmt.fm.storade.schema.admin.EmailContract;
import com.sun.netstorage.mgmt.fm.storade.schema.admin.EmailContractListResultDocument;
import com.sun.netstorage.mgmt.fm.storade.schema.admin.Filter;
import com.sun.netstorage.mgmt.fm.storade.schema.admin.FiltersResultDocument;
import com.sun.netstorage.mgmt.fm.storade.schema.admin.RenvResultDocument;
import com.sun.netstorage.mgmt.fm.storade.ui.common.AlarmConstants;
import com.sun.netstorage.mgmt.fm.storade.ui.model.ActionTableModel;
import com.sun.netstorage.mgmt.fm.storade.ui.util.AbbreviationUtil;
import com.sun.netstorage.mgmt.fm.storade.ui.util.Debug;
import com.sun.netstorage.mgmt.fm.storade.ui.util.LocalizeUtil;
import com.sun.netstorage.mgmt.fm.storade.ui.viewbeans.admin.Getter;
import com.sun.netstorage.mgmt.fm.storade.ui.viewbeans.admin.SNMPContract;
import com.sun.netstorage.mgmt.fm.storade.ui.viewbeans.admin.Setter;
import java.util.ArrayList;
import java.util.Locale;
import java.util.Properties;
import java.util.StringTokenizer;

public class NotificationDataHelper {
    public static final int ERROR_INTERNAL = -999;
    public static final int ERROR_ADD_CONTRACTEXIST = -1;
    public static final int ERROR_MODIFY_CONTRACTNOTEXIST = -2;
    public static final int NO_ERROR = 0;
    public static final String SNMPACTION_ADD = "add";
    public static final String SNMPACTION_DELETE = "delete";
    public static final String SNMPACTION_MODIFY = "modify";
    public static final String sccs_id = "%Z%%M% %I%     %E% SMI";

    public static void populateEmailsTableModel(EmailContractListResultDocument.EmailContractListResult result, ActionTableModel emailsModel, Locale locale) throws IllegalArgumentException {
        if (result == null || locale == null || emailsModel == null) {
            throw new IllegalArgumentException("at least one parameter is null");
        }
        EmailContract[] emails = new EmailContract[]{};
        try {
            emails = result.getNOTIFICATION().getNOTIFArray();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        ArrayList<String> keys = new ArrayList<String>();
        for (int i = 0; i < emails.length; ++i) {
            EmailContract email = emails[i];
            if (i != 0) {
                emailsModel.appendRow();
            }
            Value[] values = email.getVALUEArray();
            String active = "Y";
            for (int j = 0; j < values.length; ++j) {
                Value value = values[j];
                if ("device".equals(value.getID())) {
                    if ("*".equals(value.getStringValue())) {
                        emailsModel.setValue("eventCategoryStr", "eventCategory.all");
                        continue;
                    }
                    emailsModel.setValue("eventCategoryStr", value.getStringValue());
                    continue;
                }
                if ("email".equals(value.getID())) {
                    emailsModel.setValue("addressStr", value.getStringValue());
                    continue;
                }
                if ("priority".equals(value.getID())) {
                    emailsModel.setValue("priorityStr", "priority." + value.getStringValue());
                    continue;
                }
                if (!"active".equals(value.getID())) continue;
                active = value.getStringValue();
            }
            if ("Y".equals(active)) {
                emailsModel.setValue("activeStr", "boolean.yes");
            } else {
                emailsModel.setValue("activeStr", "boolean.no");
            }
            emailsModel.setValue("EmailDetailsStoradeHREF", email.getID());
            emailsModel.setValue("viewEmailDetailsStr", "email.viewDetails");
            keys.add(email.getID());
        }
        String[] keysArr = new String[keys.size()];
        keys.toArray(keysArr);
        emailsModel.setKeys(keysArr);
    }

    public static void populateEmailDetailsTableModel(DefaultModel emailDetailsModel, String emailID, Locale locale) throws IllegalArgumentException {
        if (emailID == null || locale == null || emailDetailsModel == null) {
            throw new IllegalArgumentException("at least one parameter is null");
        }
        int size = 1;
        for (int i = 0; i < size; ++i) {
            if (i != 0) {
                emailDetailsModel.appendRow();
            }
            emailDetailsModel.setValue("propertyName", (Object)"table.header.emailAddress");
            emailDetailsModel.setValue("propertyValue", (Object)emailID);
        }
    }

    public static void populateSNMPContractsTableModel(RenvResultDocument.RenvResult result, ActionTableModel snmpsModel, Locale locale) throws IllegalArgumentException {
        if (result == null || locale == null || snmpsModel == null) {
            throw new IllegalArgumentException("at least one parameter is null");
        }
        Value[] values = result.getENV().getVALUEArray();
        Properties p = new Properties();
        for (int i = 0; i < values.length; ++i) {
            Value v = values[i];
            p.setProperty(v.getID(), v.getStringValue());
        }
        String total = p.getProperty("pro.trap.total");
        int totalInt = 0;
        if (total != null) {
            try {
                totalInt = new Integer(total);
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        ArrayList<String> keys = new ArrayList<String>();
        for (int i = 1; i < totalInt + 1; ++i) {
            String ipKey = "pro.trap" + i + ".ip";
            String portKey = "pro.trap" + i + ".port";
            String levelKey = "pro.trap" + i + ".level";
            String ipValue = p.getProperty(ipKey);
            Object portValue = p.getProperty(portKey);
            try {
                portValue = Integer.valueOf((String)portValue);
            }
            catch (Exception ex) {
                // empty catch block
            }
            String levelValue = p.getProperty(levelKey);
            String levelString = "";
            int levelValueInt = -999;
            try {
                levelValueInt = new Integer(levelValue);
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
            levelString = levelValueInt == 0 ? "severity.notice" : AlarmConstants.getSeverityString(levelValueInt);
            if (i != 0) {
                snmpsModel.appendRow();
            }
            snmpsModel.setValue("hostStr", ipValue);
            snmpsModel.setValue("portStr", portValue);
            snmpsModel.setValue("minAlertLevelStr", levelString);
            keys.add(ipValue + "|" + portValue + "|" + levelValue);
        }
        String[] keysArr = new String[keys.size()];
        keys.toArray(keysArr);
        snmpsModel.setKeys(keysArr);
    }

    public static synchronized int SNMPNotificationAction(SNMPContract[] snmps, String actionName) {
        int i;
        if (snmps == null || actionName == null) {
            return -999;
        }
        ArrayList<SNMPContract> snmpList = new ArrayList<SNMPContract>();
        RenvResultDocument resultDoc = Getter.getRenvResultDocument();
        if (resultDoc == null) {
            return -999;
        }
        RenvResultDocument.RenvResult result = resultDoc.getRenvResult();
        Value[] values = result.getENV().getVALUEArray();
        Properties p = new Properties();
        for (int i2 = 0; i2 < values.length; ++i2) {
            Value v = values[i2];
            p.setProperty(v.getID(), v.getStringValue());
        }
        String total = p.getProperty("pro.trap.total");
        int totalInt = 0;
        if (total != null) {
            try {
                totalInt = new Integer(total);
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        for (i = 1; i < totalInt + 1; ++i) {
            String ipKey = "pro.trap" + i + ".ip";
            String portKey = "pro.trap" + i + ".port";
            String levelKey = "pro.trap" + i + ".level";
            String ipValue = p.getProperty(ipKey);
            String portValue = p.getProperty(portKey);
            String levelValue = p.getProperty(levelKey);
            snmpList.add(new SNMPContract(ipValue, portValue, levelValue));
        }
        if (SNMPACTION_ADD.equals(actionName)) {
            if (snmps.length != 1) {
                return -999;
            }
            if (snmpList.contains(snmps[0])) {
                return -1;
            }
            snmpList.add(snmps[0]);
        }
        if (SNMPACTION_DELETE.equals(actionName)) {
            for (i = 0; i < snmps.length; ++i) {
                snmpList.remove(snmps[i]);
            }
        }
        if (SNMPACTION_MODIFY.equals(actionName)) {
            if (snmps.length != 2) {
                return -999;
            }
            int pos = snmpList.indexOf(snmps[0]);
            if (pos == -1) {
                return -2;
            }
            snmpList.remove(pos);
            snmpList.add(pos, snmps[1]);
        }
        String setterCommand = "pro.trap.total=" + snmpList.size();
        for (int i3 = 0; i3 < snmpList.size(); ++i3) {
            int ii = i3 + 1;
            SNMPContract sc = (SNMPContract)snmpList.get(i3);
            String ipKey = "pro.trap" + ii + ".ip";
            String portKey = "pro.trap" + ii + ".port";
            String levelKey = "pro.trap" + ii + ".level";
            setterCommand = setterCommand + "&" + ipKey + "=" + sc.getIpAddress() + "&" + portKey + "=" + sc.getPort() + "&" + levelKey + "=" + sc.getMinAlertLevel();
        }
        Debug.println("setterCommand : " + setterCommand);
        Setter.setRenv(setterCommand);
        return 0;
    }

    public static void populateFiltersTableModel(FiltersResultDocument.FiltersResult result, ActionTableModel filtersModel, Locale locale) throws IllegalArgumentException {
        if (result == null || locale == null || filtersModel == null) {
            throw new IllegalArgumentException("at least one parameter is null");
        }
        Filter[] filters = new Filter[]{};
        try {
            filters = result.getFILTERS().getFILTERArray();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        ArrayList<String> keys = new ArrayList<String>();
        for (int i = 0; i < filters.length; ++i) {
            Filter filter = filters[i];
            if (i != 0) {
                filtersModel.appendRow();
            }
            Value[] values = filter.getVALUEArray();
            String deviceType = "";
            String eventCode = "";
            String dayFilter = "";
            String descrPattern = "";
            String newSeverity = "";
            for (int j = 0; j < values.length; ++j) {
                Value value = values[j];
                if ("type".equals(value.getID())) {
                    deviceType = value.getStringValue();
                    if (!"".equals(deviceType)) continue;
                    deviceType = "filter.deviceType.all";
                    continue;
                }
                if ("code".equals(value.getID())) {
                    eventCode = value.getStringValue();
                    continue;
                }
                if ("pattern".equals(value.getID())) {
                    descrPattern = value.getStringValue();
                    continue;
                }
                if ("days".equals(value.getID())) {
                    dayFilter = value.getStringValue();
                    continue;
                }
                if (!"severity".equals(value.getID())) continue;
                newSeverity = value.getStringValue();
            }
            filtersModel.setValue("filterIDStr", filter.getID());
            filtersModel.setValue("deviceTypeStr", AbbreviationUtil.getAbbreviation(deviceType, 2, locale));
            filtersModel.setValue("eventCodeStr", eventCode);
            filtersModel.setValue("dayFilterStr", NotificationDataHelper.getLocalizedDayFilter(dayFilter, locale));
            filtersModel.setValue("descrPatternStr", descrPattern);
            filtersModel.setValue("newSeverityStr", LocalizeUtil.getLocalizedString("filter.severity." + newSeverity, locale));
            keys.add(filter.getID());
        }
        String[] keysArr = new String[keys.size()];
        keys.toArray(keysArr);
        filtersModel.setKeys(keysArr);
    }

    private static String getLocalizedDayFilter(String dayFilter, Locale locale) {
        if (dayFilter == null || "".equals(dayFilter)) {
            return "";
        }
        String ret = "";
        StringTokenizer st = new StringTokenizer(dayFilter);
        int k = 0;
        while (st.hasMoreTokens()) {
            if (k % 3 == 0 && k != 0) {
                ret = ret + "<br>";
            }
            String s = st.nextToken();
            ret = ret + LocalizeUtil.getLocalizedString("dayFilter." + s, locale) + ", ";
            ++k;
        }
        if (ret.length() > 0) {
            ret = ret.substring(0, ret.length() - 2);
        }
        return ret;
    }
}

