/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.mgmt.fm.storade.ui.viewbeans.admin;

import com.iplanet.jato.RequestContext;
import com.iplanet.jato.RequestManager;
import com.iplanet.jato.view.ContainerView;
import com.iplanet.jato.view.ContainerViewBase;
import com.iplanet.jato.view.View;
import com.iplanet.jato.view.event.DisplayEvent;
import com.iplanet.jato.view.event.RequestInvocationEvent;
import com.sun.netstorage.mgmt.fm.storade.schema.Value;
import com.sun.netstorage.mgmt.fm.storade.schema.admin.EmailActionResultDocument;
import com.sun.netstorage.mgmt.fm.storade.schema.admin.EmailContractListResultDocument;
import com.sun.netstorage.mgmt.fm.storade.ui.common.UIMastHeadViewBeanBase;
import com.sun.netstorage.mgmt.fm.storade.ui.model.ActionTableModel;
import com.sun.netstorage.mgmt.fm.storade.ui.util.Connection;
import com.sun.netstorage.mgmt.fm.storade.ui.util.LocalizeUtil;
import com.sun.netstorage.mgmt.fm.storade.ui.util.UserUtil;
import com.sun.netstorage.mgmt.fm.storade.ui.view.ActionTable;
import com.sun.netstorage.mgmt.fm.storade.ui.view.ActionTableInterface;
import com.sun.netstorage.mgmt.fm.storade.ui.viewbeans.admin.Getter;
import com.sun.netstorage.mgmt.fm.storade.ui.viewbeans.admin.NotificationDataHelper;
import com.sun.netstorage.mgmt.fm.storade.ui.viewbeans.admin.Setter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Locale;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;

public class EmailNotificationViewBean
extends UIMastHeadViewBeanBase {
    public static final String PAGE_NAME = "EmailNotification";
    public static final String DEFAULT_DISPLAY_URL = "/jsp/admin/EmailNotification.jsp";
    public static final String CHILD_EMAILS_TABLE = "EmailsTable";
    public static final String CHILD_EMAILSETUP_HREF = "EmailSetupHREF";
    private ActionTableModel emailsModel = new ActionTableModel(RequestManager.getRequestContext().getServletContext(), "/xml/table/EmailsTable.xml");
    public static final String sccs_id = "%Z%%M% %I%     %E% SMI";

    public EmailNotificationViewBean() {
        super(PAGE_NAME, DEFAULT_DISPLAY_URL);
    }

    public void setRequestContext(RequestContext ctx) {
        super.setRequestContext(ctx);
        this.initModel();
    }

    protected void subRegisterChildren() {
        this.registerChild(CHILD_EMAILS_TABLE, ActionTable.class);
        this.emailsModel.registerChildren((ContainerViewBase)this);
    }

    protected View subCreateChild(String name) {
        if (name.equals(CHILD_EMAILS_TABLE)) {
            ActionTable child = new ActionTable((ContainerView)this, this.emailsModel, name);
            return child;
        }
        if (this.emailsModel.isChildSupported(name)) {
            View view = this.emailsModel.createChild((View)this, name);
            this.disableButtonIfNotPrivilege(view);
            return view;
        }
        return null;
    }

    private void initModel() {
        this.emailsModel.setActionValue("addressCol", "table.header.emailAddress");
        this.emailsModel.setActionValue("activeCol", "table.header.active");
        this.emailsModel.setActionValue("eventCategoryCol", "table.header.eventCategory");
        this.emailsModel.setActionValue("priorityCol", "table.header.priority");
        this.emailsModel.setActionValue("adminGroupCol", "table.header.adminGroup");
        this.emailsModel.setActionValue("addNotificationButton", "button.addNotification");
        this.emailsModel.setActionValue("deleteButton", "button.delete");
        this.emailsModel.setActionValue("modifyButton", "button.modify");
        this.emailsModel.setActionValue("actionCol", "table.header.emailDetails");
    }

    public void beginDisplay(DisplayEvent event) {
        HttpServletRequest request = RequestManager.getRequestContext().getRequest();
        HttpSession session = this.getRequestContext().getRequest().getSession();
        session.setAttribute("storade.privilegedRole", (Object)new Boolean(UserUtil.isPrivilegedRole(request)).toString());
        Locale locale = request.getLocale();
        if (locale == null) {
            locale = Locale.getDefault();
        }
        ArrayList keys = new ArrayList();
        try {
            EmailContractListResultDocument.EmailContractListResult result = Getter.getEmailContractListResultDocument().getEmailContractListResult();
            this.setAlarmSummary(result.getAlarmSummary());
            NotificationDataHelper.populateEmailsTableModel(result, this.emailsModel, locale);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        try {
            super.beginDisplay(event);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public void handleModifyButtonRequest(RequestInvocationEvent event) {
        RequestContext requestContext = event.getRequestContext();
        HttpServletRequest request = requestContext.getRequest();
        Locale locale = request.getLocale();
        ActionTableInterface child = (ActionTableInterface)this.getChild(CHILD_EMAILS_TABLE);
        ArrayList selectedKeys = child.getSelectedKeysForCurrentPage();
        boolean hasFail = false;
        String display = "";
        String key = (String)selectedKeys.get(0);
        String url = "/" + Connection.getAppName() + "/admin/EmailAddition?emailID=" + this.urlencode(key);
        try {
            this.getRequestContext().getResponse().sendRedirect(url);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public void handleDeleteButtonRequest(RequestInvocationEvent event) {
        RequestContext requestContext = event.getRequestContext();
        HttpServletRequest request = requestContext.getRequest();
        Locale locale = request.getLocale();
        ActionTableInterface child = (ActionTableInterface)this.getChild(CHILD_EMAILS_TABLE);
        ArrayList selectedKeys = child.getSelectedKeysForCurrentPage();
        boolean hasFail = false;
        String display = "";
        for (int i = 0; i < selectedKeys.size(); ++i) {
            String key = (String)selectedKeys.get(i);
            EmailActionResultDocument.EmailActionResult result = Setter.deleteEmail(key);
            Value[] values = result.getNOTIFICATION().getVALUEArray();
            if (values.length == 0 || !"deleted".equals(values[0].getStringValue())) {
                hasFail = true;
                display = display + key + ": " + LocalizeUtil.getLocalizedString("error.deleteEmail", locale) + "<br>";
                continue;
            }
            display = display + key + ": " + LocalizeUtil.getLocalizedString("info.deleteEmail", locale) + "<br>";
        }
        if (hasFail) {
            this.setInlineAlert("error", "summary.deleteEmail", null, display, null);
        } else {
            this.setInlineAlert("info", "summary.deleteEmail", null, display, null);
        }
        String url = "/" + Connection.getAppName() + "/admin/EmailNotification";
        try {
            this.getRequestContext().getResponse().sendRedirect(url);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public void handleAddNotificationButtonRequest(RequestInvocationEvent event) {
        String url = "/" + Connection.getAppName() + "/admin/EmailAddition";
        try {
            event.getRequestContext().getResponse().sendRedirect(url);
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
    }
}

