/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.mgmt.fm.storade.ui.viewbeans.admin;

import com.iplanet.jato.RequestContext;
import com.iplanet.jato.RequestManager;
import com.iplanet.jato.view.ContainerView;
import com.iplanet.jato.view.ContainerViewBase;
import com.iplanet.jato.view.View;
import com.iplanet.jato.view.event.DisplayEvent;
import com.iplanet.jato.view.event.RequestInvocationEvent;
import com.sun.netstorage.mgmt.fm.storade.schema.admin.ActivateHostResultDocument;
import com.sun.netstorage.mgmt.fm.storade.schema.admin.DeleteHostResultDocument;
import com.sun.netstorage.mgmt.fm.storade.schema.admin.HostListResultDocument;
import com.sun.netstorage.mgmt.fm.storade.schema.admin.RunAgentResultDocument;
import com.sun.netstorage.mgmt.fm.storade.ui.common.UIMastHeadViewBeanBase;
import com.sun.netstorage.mgmt.fm.storade.ui.model.ActionTableModel;
import com.sun.netstorage.mgmt.fm.storade.ui.util.Connection;
import com.sun.netstorage.mgmt.fm.storade.ui.util.LocalizeUtil;
import com.sun.netstorage.mgmt.fm.storade.ui.util.UserUtil;
import com.sun.netstorage.mgmt.fm.storade.ui.view.ActionTable;
import com.sun.netstorage.mgmt.fm.storade.ui.view.ActionTableInterface;
import com.sun.netstorage.mgmt.fm.storade.ui.viewbeans.admin.AgentsDataHelper;
import com.sun.netstorage.mgmt.fm.storade.ui.viewbeans.admin.Getter;
import com.sun.netstorage.mgmt.fm.storade.ui.viewbeans.admin.Setter;
import com.sun.web.ui.view.html.CCHref;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Locale;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;

public class AgentsViewBean
extends UIMastHeadViewBeanBase {
    public static final String PAGE_NAME = "Agents";
    public static final String DEFAULT_DISPLAY_URL = "/jsp/admin/Agents.jsp";
    public static final String CHILD_AGENTS_TABLE = "AgentsTable";
    public static final String CHILD_ACTIONMENU_HREF = "ActionMenuHref";
    public static final String CHILD_ACTIONMENU = "actionMenu";
    private ActionTableModel agentsModel = new ActionTableModel(RequestManager.getRequestContext().getServletContext(), "/xml/table/AgentsTable.xml");
    public static final String sccs_id = "%Z%%M% %I%     %E% SMI";

    public AgentsViewBean() {
        super(PAGE_NAME, DEFAULT_DISPLAY_URL);
    }

    public void setRequestContext(RequestContext ctx) {
        super.setRequestContext(ctx);
        this.initModel();
    }

    protected void subRegisterChildren() {
        this.registerChild(CHILD_AGENTS_TABLE, ActionTable.class);
        this.registerChild(CHILD_ACTIONMENU_HREF, CCHref.class);
        this.agentsModel.registerChildren((ContainerViewBase)this);
    }

    protected View subCreateChild(String name) {
        if (name.equals(CHILD_AGENTS_TABLE)) {
            ActionTable child = new ActionTable((ContainerView)this, this.agentsModel, name);
            return child;
        }
        if (name.equals(CHILD_ACTIONMENU_HREF)) {
            CCHref child = new CCHref((ContainerView)this, name, null);
            return child;
        }
        if (this.agentsModel.isChildSupported(name)) {
            View child = this.agentsModel.createChild((View)this, name);
            this.disableButtonIfNotPrivilege(child);
            return child;
        }
        return null;
    }

    private void initModel() {
        this.agentsModel.setActionValue("ipaddressCol", "table.header.hostIP");
        this.agentsModel.setActionValue("activeCol", "table.header.monitoring");
        this.agentsModel.setActionValue("typeCol", "table.header.type");
        this.agentsModel.setActionValue("nameCol", "table.header.hostName");
        this.agentsModel.setActionValue("idCol", "table.header.hostID");
        this.agentsModel.setActionValue("numDeviceCol", "table.header.numDevice");
        this.agentsModel.setActionValue("actionCol", "table.header.maintenance");
        this.agentsModel.setActionValue("activateButton", "button.activate");
        this.agentsModel.setActionValue("deactivateButton", "button.deactivate");
        this.agentsModel.setActionValue("addSlaveButton", "button.addSlave");
        this.agentsModel.setActionValue("deleteButton", "button.delete");
        this.agentsModel.setActionValue("modifyButton", "button.modify");
        this.agentsModel.setActionValue("runAgentButton", "button.runAgent");
    }

    public void beginDisplay(DisplayEvent event) {
        HttpServletRequest request = RequestManager.getRequestContext().getRequest();
        HttpSession session = this.getRequestContext().getRequest().getSession();
        session.setAttribute("storade.privilegedRole", (Object)new Boolean(UserUtil.isPrivilegedRole(request)).toString());
        Locale locale = request.getLocale();
        if (locale == null) {
            locale = Locale.getDefault();
        }
        try {
            HostListResultDocument.HostListResult result = Getter.getHostListResultDocument().getHostListResult();
            this.setAlarmSummary(result.getAlarmSummary());
            AgentsDataHelper.populateAgentsTableModel(result, this.agentsModel, locale);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        try {
            super.beginDisplay(event);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public void handleModifyButtonRequest(RequestInvocationEvent event) {
        RequestContext requestContext = event.getRequestContext();
        HttpServletRequest request = requestContext.getRequest();
        Locale locale = request.getLocale();
        ActionTableInterface child = (ActionTableInterface)this.getChild(CHILD_AGENTS_TABLE);
        ArrayList selectedKeys = child.getSelectedKeysForCurrentPage();
        String key = (String)selectedKeys.get(0);
        String url = "/" + Connection.getAppName() + "/admin/SlaveAddition?hostID=" + this.urlencode(key);
        try {
            event.getRequestContext().getResponse().sendRedirect(url);
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
    }

    public void handleRunAgentButtonRequest(RequestInvocationEvent event) {
        RequestContext requestContext = event.getRequestContext();
        HttpServletRequest request = requestContext.getRequest();
        Locale locale = request.getLocale();
        ActionTableInterface child = (ActionTableInterface)this.getChild(CHILD_AGENTS_TABLE);
        ArrayList selectedKeys = child.getSelectedKeysForCurrentPage();
        String key = (String)selectedKeys.get(0);
        String setterCommand = "hostID=" + this.urlencode(key);
        String url = "";
        RunAgentResultDocument.RunAgentResult result = Setter.runAgent(setterCommand);
        if (result.getERROR() != null) {
            this.setInlineAlert("error", "summary.runAgent", null, "error." + result.getERROR().getNo(), null);
            url = "/" + Connection.getAppName() + "/admin/Agents";
        } else {
            url = "/" + Connection.getAppName() + "/admin/RunAgentResult?hostID=" + this.urlencode(key);
        }
        try {
            event.getRequestContext().getResponse().sendRedirect(url);
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
    }

    public void handleAddSlaveButtonRequest(RequestInvocationEvent event) {
        String url = "/" + Connection.getAppName() + "/admin/SlaveAddition";
        try {
            event.getRequestContext().getResponse().sendRedirect(url);
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
    }

    public void handleActionMenuHrefRequest(RequestInvocationEvent event) {
        String action = (String)this.getDisplayFieldValue(CHILD_ACTIONMENU);
        if ("activate".equals(action)) {
            this.handleActivateButtonRequest(event);
        } else if ("deactivate".equals(action)) {
            this.handleDeactivateButtonRequest(event);
        } else if ("delete".equals(action)) {
            this.handleDeleteButtonRequest(event);
        }
    }

    public void handleDeleteButtonRequest(RequestInvocationEvent event) {
        RequestContext requestContext = event.getRequestContext();
        HttpServletRequest request = requestContext.getRequest();
        Locale locale = request.getLocale();
        ActionTableInterface child = (ActionTableInterface)this.getChild(CHILD_AGENTS_TABLE);
        ArrayList selectedKeys = child.getSelectedKeysForCurrentPage();
        boolean hasFail = false;
        String display = "";
        for (int i = 0; i < selectedKeys.size(); ++i) {
            String key = (String)selectedKeys.get(i);
            DeleteHostResultDocument.DeleteHostResult result = Setter.deleteHost(key);
            if (result == null) {
                display = display + key + ": " + LocalizeUtil.getLocalizedString("error.deleteHost.internal", locale) + "<br>";
                hasFail = true;
                continue;
            }
            if (result.getERROR() != null) {
                display = display + key + ": " + LocalizeUtil.getLocalizedString("error.deleteHost." + result.getERROR().getNo(), locale) + "<br>";
                hasFail = true;
                continue;
            }
            display = display + key + ": " + LocalizeUtil.getLocalizedString("info.deleteHost", locale) + "<br>";
        }
        if (hasFail) {
            this.setInlineAlert("error", "summary.deleteHost", null, display, null);
        } else {
            this.setInlineAlert("info", "summary.deleteHost", null, display, null);
        }
        String url = "/" + Connection.getAppName() + "/admin/Agents";
        try {
            event.getRequestContext().getResponse().sendRedirect(url);
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
    }

    public void handleActivateButtonRequest(RequestInvocationEvent event) {
        RequestContext requestContext = event.getRequestContext();
        HttpServletRequest request = requestContext.getRequest();
        Locale locale = request.getLocale();
        ActionTableInterface child = (ActionTableInterface)this.getChild(CHILD_AGENTS_TABLE);
        ArrayList selectedKeys = child.getSelectedKeysForCurrentPage();
        boolean hasFail = false;
        String display = "";
        for (int i = 0; i < selectedKeys.size(); ++i) {
            String key = (String)selectedKeys.get(i);
            ActivateHostResultDocument.ActivateHostResult result = Setter.activateHost(key, true);
            if (result == null) {
                display = display + key + ": " + LocalizeUtil.getLocalizedString("error.activateHost.internal", locale) + "<br>";
                hasFail = true;
                continue;
            }
            if (result.getERROR() != null) {
                display = display + key + ": " + LocalizeUtil.getLocalizedString("error.activateHost." + result.getERROR().getNo(), locale) + "<br>";
                hasFail = true;
                continue;
            }
            display = display + key + ": " + LocalizeUtil.getLocalizedString("info.activateHost", locale) + "<br>";
        }
        if (hasFail) {
            this.setInlineAlert("error", "summary.activateHost", null, display, null);
        } else {
            this.setInlineAlert("info", "summary.activateHost", null, display, null);
        }
        String url = "/" + Connection.getAppName() + "/admin/Agents";
        try {
            event.getRequestContext().getResponse().sendRedirect(url);
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
    }

    public void handleDeactivateButtonRequest(RequestInvocationEvent event) {
        RequestContext requestContext = event.getRequestContext();
        HttpServletRequest request = requestContext.getRequest();
        Locale locale = request.getLocale();
        ActionTableInterface child = (ActionTableInterface)this.getChild(CHILD_AGENTS_TABLE);
        ArrayList selectedKeys = child.getSelectedKeysForCurrentPage();
        boolean hasFail = false;
        String display = "";
        for (int i = 0; i < selectedKeys.size(); ++i) {
            String key = (String)selectedKeys.get(i);
            ActivateHostResultDocument.ActivateHostResult result = Setter.activateHost(key, false);
            if (result == null) {
                display = display + key + ": " + LocalizeUtil.getLocalizedString("error.deactivateHost.internal", locale) + "<br>";
                hasFail = true;
                continue;
            }
            if (result.getERROR() != null) {
                display = display + key + ": " + LocalizeUtil.getLocalizedString("error.deactivateHost." + result.getERROR().getNo(), locale) + "<br>";
                hasFail = true;
                continue;
            }
            display = display + key + ": " + LocalizeUtil.getLocalizedString("info.deactivateHost", locale) + "<br>";
        }
        if (hasFail) {
            this.setInlineAlert("error", "summary.deactivateHost", null, display, null);
        } else {
            this.setInlineAlert("info", "summary.deactivateHost", null, display, null);
        }
        String url = "/" + Connection.getAppName() + "/admin/Agents";
        try {
            event.getRequestContext().getResponse().sendRedirect(url);
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
    }
}

