/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.mgmt.fm.storade.ui.viewbeans.admin;

import com.sun.netstorage.mgmt.fm.storade.schema.admin.AgentStatistic;
import com.sun.netstorage.mgmt.fm.storade.schema.admin.AgentStatisticsResultDocument;
import com.sun.netstorage.mgmt.fm.storade.ui.model.ActionTableModel;
import com.sun.netstorage.mgmt.fm.storade.ui.util.AgentUtil;
import com.sun.netstorage.mgmt.fm.storade.ui.util.DeviceUtil;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;

public class AgentStatisticsDataHelper {
    private AgentStatisticsDataHelper() {
    }

    public static void populateStatistics(AgentStatisticsResultDocument.AgentStatisticsResult result, ActionTableModel tableModel) {
        AgentStatistic[] elements;
        if (result != null && result.getAGENTSTATS() != null && (elements = result.getAGENTSTATS().getAGENTSTATArray()) != null) {
            ArrayList<String> hosts = new ArrayList<String>();
            for (int i = 0; i < elements.length; ++i) {
                hosts.add(elements[i].getHOST());
            }
            boolean unique = AgentUtil.unique(hosts);
            for (int i = 0; i < elements.length; ++i) {
                if (i != 0) {
                    tableModel.appendRow();
                }
                SimpleDateFormat formatter = new SimpleDateFormat("mm:ss");
                SimpleDateFormat formatter2 = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                Date lastRunDate = new Date();
                Date lastDuration = new Date();
                Date maxDuration = new Date();
                Date maxDurationDate = new Date();
                Date average = new Date();
                Object nbrRuns = elements[i].getNUMBEROFRUNS();
                try {
                    lastRunDate = formatter2.parse(elements[i].getLASTRUNDATE());
                    lastDuration = formatter.parse(elements[i].getLASTDURATION());
                    maxDuration = formatter.parse(elements[i].getMAXDURATION());
                    maxDurationDate = formatter2.parse(elements[i].getMAXDURATIONDATE());
                    average = formatter.parse(elements[i].getAVERAGE());
                    nbrRuns = Integer.valueOf((String)nbrRuns);
                }
                catch (ParseException ex) {
                    ex.printStackTrace();
                }
                String hostName = elements[i].getHOST();
                if (unique) {
                    hostName = AgentUtil.getShortName(hostName);
                }
                String device = DeviceUtil.getDeviceName(elements[i].getDEVICE());
                tableModel.setValue("agent", hostName);
                tableModel.setValue("device", device);
                tableModel.setValue("nbrRuns", nbrRuns);
                tableModel.setValue("lastRun", lastRunDate);
                tableModel.setValue("lastDuration", lastDuration);
                tableModel.setValue("maxDuration", maxDuration);
                tableModel.setValue("maxDurationDate", maxDurationDate);
                tableModel.setValue("average", average);
            }
        }
    }
}

