/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.mgmt.fm.storade.ui.util;

import com.iplanet.sso.SSOToken;
import com.iplanet.sso.SSOTokenManager;
import com.sun.management.services.authentication.UserRolePrincipal;
import com.sun.netstorage.mgmt.fm.storade.ui.util.EMUtil;
import com.sun.netstorage.mgmt.fm.storade.ui.util.SystemUtil;
import javax.servlet.http.HttpServletRequest;

public class UserUtil {
    private static String STORAGE_USER = "storage";
    private static String ADMIN_USER = "admin";
    private static String ROOT_USER = "root";

    public static String getUserName(HttpServletRequest request) {
        String userName = null;
        UserRolePrincipal principal1 = null;
        try {
            SSOTokenManager tm = SSOTokenManager.getInstance();
            SSOToken token = tm.createSSOToken(request);
            principal1 = (UserRolePrincipal)token.getPrincipal();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        if (principal1 != null) {
            userName = principal1.getName();
        }
        return userName;
    }

    public static String getRoleName(HttpServletRequest request) {
        String roleName = null;
        UserRolePrincipal principal1 = null;
        try {
            SSOTokenManager tm = SSOTokenManager.getInstance();
            SSOToken token = tm.createSSOToken(request);
            principal1 = (UserRolePrincipal)token.getPrincipal();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        if (principal1 != null) {
            roleName = principal1.getRoleName();
        }
        return roleName;
    }

    public static boolean isPrivilegedRoleSE(HttpServletRequest request) {
        boolean isPrivilegeRole = false;
        String userName = UserUtil.getUserName(request);
        if (STORAGE_USER.equals(userName) || ADMIN_USER.equals(userName) || ROOT_USER.equals(userName)) {
            isPrivilegeRole = true;
        }
        return isPrivilegeRole;
    }

    public static boolean isPrivilegedRoleEE(HttpServletRequest request) {
        boolean isPrivilegeRole = false;
        String roleName = UserUtil.getRoleName(request);
        String pRole = System.getProperty("storade.privilegedRole");
        if (pRole == null) {
            isPrivilegeRole = true;
        } else if (roleName != null && roleName.equals(pRole)) {
            isPrivilegeRole = true;
        } else if (EMUtil.isEMPrivilegeRole(UserUtil.getUserName(request), request)) {
            isPrivilegeRole = true;
        }
        return isPrivilegeRole;
    }

    public static boolean isPrivilegedRole(HttpServletRequest request) {
        if (SystemUtil.isSystemEdition()) {
            return UserUtil.isPrivilegedRoleSE(request);
        }
        return UserUtil.isPrivilegedRoleEE(request);
    }
}

