/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.mgmt.fm.storade.ui.util;

public class PropertySheetUtil {
    private static final String HEADER = "<?xml version=\"1.0\" encoding=\"ISO-8859-1\"?>\n<!DOCTYPE propertysheet SYSTEM \"tags/dtd/propertysheet.dtd\">\n<propertysheet>\n";
    private static final String FOOTER = "</propertysheet>";
    private static final String SECTION_END = "</section>\n";
    private static final String PROP_END = "</property>\n";
    private static final String TEXT_FIELD = "com.sun.web.ui.taglib.html.CCTextFieldTag";
    private static final String STATIC_FIELD = "com.sun.web.ui.taglib.html.CCStaticTextFieldTag";
    private static final String HIDDEN_FIELD = "com.sun.web.ui.taglib.html.CCHiddenTag";
    private static final String PASSWORD = "com.sun.web.ui.taglib.html.CCPasswordTag";
    private static final String CHECK_BOX = "com.sun.web.ui.taglib.html.CCCheckBoxTag";
    private static final String DROP_DOWN = "com.sun.web.ui.taglib.html.CCDropDownMenuTag";
    private static final String RADIO = "com.sun.web.ui.taglib.html.CCRadioButtonTag";

    private PropertySheetUtil() {
    }

    public static String addPropSheetHeader() {
        return HEADER;
    }

    public static String addPropSheetFooter() {
        return FOOTER;
    }

    public static String addSectionHeader(String name) {
        String s = "<section name=\"" + name + "\" defaultValue = \"" + name + "\" >\n";
        return s;
    }

    public static String addGenericSectionHeader() {
        String s = "<section name=\"HEADER\" defaultValue = \"\" >\n";
        return s;
    }

    public static String addSectionFooter() {
        return SECTION_END;
    }

    private static String strip(String name) {
        String strippedName = name;
        if (name != null) {
            strippedName = name.replaceAll("/", "");
        }
        return strippedName;
    }

    public static String addInputText(String name, String opt, String value) {
        StringBuffer buf = new StringBuffer();
        buf.append("<property name=\"" + name + "\">");
        buf.append("<label name=\"" + PropertySheetUtil.strip(name) + "Label\"" + " defaultValue=\"" + name + "\"/>\n");
        buf.append("<cc name=\"" + opt + "\"" + " tagclass=\"" + TEXT_FIELD + "\" >\n");
        if (value != null) {
            buf.append("<attribute name=\"defaultValue\" value=\"" + value + "\" />\n");
        }
        buf.append("</cc>\n");
        buf.append(PROP_END);
        return buf.toString();
    }

    public static String addStaticText(String name, String opt, String value) {
        StringBuffer buf = new StringBuffer();
        buf.append("<property name=\"" + name + "\">");
        buf.append("<label name=\"" + PropertySheetUtil.strip(name) + "Label\"" + " defaultValue=\"" + name + "\"/>\n");
        buf.append("<cc name=\"" + opt + "\"" + " tagclass=\"" + STATIC_FIELD + "\" >\n");
        if (value != null) {
            buf.append("<attribute name=\"defaultValue\" value=\"" + value + "\" />\n");
        }
        buf.append("</cc>\n");
        buf.append(PROP_END);
        return buf.toString();
    }

    public static String addStaticTextWithHidden(String name, String opt, String value) {
        StringBuffer buf = new StringBuffer();
        buf.append("<property name=\"" + name + "\">");
        buf.append("<label name=\"" + PropertySheetUtil.strip(name) + "Label\"" + " defaultValue=\"" + name + "\"/>\n");
        buf.append("<cc name=\"" + opt + "\"" + " tagclass=\"" + STATIC_FIELD + "\" >\n");
        if (value != null) {
            buf.append("<attribute name=\"defaultValue\" value=\"" + value + "\" />\n");
        }
        buf.append("</cc>\n");
        buf.append("<cc name=\"" + opt + "\"" + " tagclass=\"" + HIDDEN_FIELD + "\" >\n");
        if (value != null) {
            buf.append("<attribute name=\"defaultValue\" value=\"" + value + "\" />\n");
        }
        buf.append("</cc>\n");
        buf.append(PROP_END);
        return buf.toString();
    }

    public static String addPassword(String name, String opt, String value) {
        StringBuffer buf = new StringBuffer();
        buf.append("<property name=\"" + name + "\">");
        buf.append("<label name=\"" + PropertySheetUtil.strip(name) + "Label\"" + " defaultValue=\"" + name + "\"/>\n");
        buf.append("<cc name=\"" + opt + "\"" + " tagclass=\"" + PASSWORD + "\" >\n");
        if (value != null) {
            buf.append("<attribute name=\"defaultValue\" value=\"" + value + "\" />\n");
        }
        buf.append("</cc>\n");
        buf.append(PROP_END);
        return buf.toString();
    }

    public static String addCheckBox(String name, String opt, boolean selected) {
        StringBuffer buf = new StringBuffer();
        buf.append("<property name=\"" + name + "\">");
        buf.append("<label name=\"" + PropertySheetUtil.strip(name) + "Label\"" + " defaultValue=\"" + name + "\"/>\n");
        buf.append("<cc name=\"" + opt + "\"" + " tagclass=\"" + CHECK_BOX + "\" >\n");
        if (selected) {
            buf.append("<attribute name=\"checkedValue\" value=\"" + opt + "Value\" />\n");
        }
        buf.append("</cc>\n");
        buf.append(PROP_END);
        return buf.toString();
    }

    public static String addDropDown(String name, String opt, String value, String[] optionsName, String[] optionsValue) {
        StringBuffer buf = new StringBuffer();
        buf.append("<property name=\"" + name + "\">");
        buf.append("<label name=\"" + PropertySheetUtil.strip(name) + "Label\"" + " defaultValue=\"" + name + "\"/>\n");
        buf.append("<cc name=\"" + opt + "\"" + " tagclass=\"" + DROP_DOWN + "\" >\n");
        if (optionsName != null) {
            for (int i = 0; i < optionsName.length; ++i) {
                buf.append("<option label=\"" + optionsName[i] + "\" value=\"" + optionsValue[i] + "\" />\n");
            }
        }
        buf.append("</cc>\n");
        buf.append(PROP_END);
        return buf.toString();
    }

    public static String addRadio(String name, String opt, String[] optionsName, String[] optionsValue) {
        StringBuffer buf = new StringBuffer();
        buf.append("<property name=\"" + name + "\">");
        buf.append("<label name=\"" + PropertySheetUtil.strip(name) + "Label\"" + " defaultValue=\"" + name + "\"/>\n");
        buf.append("<cc name=\"" + opt + "\"" + " tagclass=\"" + RADIO + "\" >\n");
        if (optionsName != null) {
            for (int i = 0; i < optionsName.length; ++i) {
                buf.append("<option label=\"" + optionsName[i] + "\" value=\"" + optionsValue[i] + "\" />\n");
            }
        }
        buf.append("</cc>\n");
        buf.append(PROP_END);
        return buf.toString();
    }
}

