/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.mgmt.fm.storade.ui.util;

import com.sun.netstorage.mgmt.fm.storade.ui.util.Page;
import java.io.FileReader;
import java.util.ArrayList;
import java.util.HashMap;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

public class PagesParser {
    private static String PAGE = "page";
    private static String PAGEID = "pageID";
    private static String PARENT_PAGEID = "parentPageID";
    private static String SCOPE = "scope";
    private static String TITLE = "title";
    private static String HELP = "help";
    private static String ROLE = "role";
    private static String TABNAME = "tabName";
    private static String SUB_TABNAME = "subTabName";
    private static String THIRD_TABNAME = "thirdTabName";
    private static String AMP = "amp";
    private static String LT = "lt";
    private static String GT = "gt";
    private static String QUOT = "\"";
    public static final String sccs_id = "@(#)PagesParser.java\t1.3 04/21/03 SMI";

    private String getText(Node node) {
        NodeList nodeList = node.getChildNodes();
        String text = null;
        block7: for (int i = 0; i < nodeList.getLength(); ++i) {
            Node cnode = nodeList.item(i);
            switch (cnode.getNodeType()) {
                case 1: {
                    continue block7;
                }
                case 3: {
                    if (text == null) {
                        text = cnode.getNodeValue().trim();
                        continue block7;
                    }
                    text = text + cnode.getNodeValue().trim();
                }
                case 4: {
                    continue block7;
                }
                case 2: {
                    continue block7;
                }
                case 5: {
                    if (AMP.equals(cnode.getNodeName())) {
                        text = text + '&';
                        continue block7;
                    }
                    if (LT.equals(cnode.getNodeName())) {
                        text = text + '<';
                        continue block7;
                    }
                    if (GT.equals(cnode.getNodeName())) {
                        text = text + '>';
                        continue block7;
                    }
                    if (!QUOT.equals(cnode.getNodeName())) continue block7;
                    text = text + '\"';
                }
            }
        }
        return text;
    }

    private Page parsePage(Node node) {
        Page page = new Page();
        ArrayList<String> scopes = new ArrayList<String>();
        ArrayList<String> roles = new ArrayList<String>();
        NodeList children = node.getChildNodes();
        block5: for (int j = 0; j < children.getLength(); ++j) {
            Node cnode = children.item(j);
            switch (cnode.getNodeType()) {
                case 1: {
                    String n = cnode.getNodeName();
                    if (PAGEID.equalsIgnoreCase(n)) {
                        page.pageID = this.getText(cnode);
                        continue block5;
                    }
                    if (PARENT_PAGEID.equalsIgnoreCase(n)) {
                        page.parentPageID = this.getText(cnode);
                        continue block5;
                    }
                    if (HELP.equalsIgnoreCase(n)) {
                        page.help = this.getText(cnode);
                        continue block5;
                    }
                    if (TITLE.equalsIgnoreCase(n)) {
                        page.title = this.getText(cnode);
                        continue block5;
                    }
                    if (TABNAME.equalsIgnoreCase(n)) {
                        page.tabName = this.getText(cnode);
                        continue block5;
                    }
                    if (SUB_TABNAME.equalsIgnoreCase(n)) {
                        page.subTabName = this.getText(cnode);
                        continue block5;
                    }
                    if (ROLE.equalsIgnoreCase(n)) {
                        roles.add(this.getText(cnode));
                        continue block5;
                    }
                    if (SCOPE.equalsIgnoreCase(n)) {
                        scopes.add(this.getText(cnode));
                        continue block5;
                    }
                    if (!THIRD_TABNAME.equalsIgnoreCase(n)) continue block5;
                    page.thirdTabName = this.getText(cnode);
                    continue block5;
                }
                case 3: {
                    continue block5;
                }
                case 4: {
                    continue block5;
                }
            }
        }
        String[] _scopes = new String[scopes.size()];
        scopes.toArray(_scopes);
        page.scopes = _scopes;
        String[] _roles = new String[roles.size()];
        roles.toArray(_roles);
        page.roles = _roles;
        return page;
    }

    public HashMap parse(String fileName) throws Exception {
        HashMap<String, Page> pagesMap = new HashMap<String, Page>();
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        dbf.setValidating(false);
        DocumentBuilder db = dbf.newDocumentBuilder();
        Document doc = db.parse(new InputSource(new FileReader(fileName)));
        Element node = doc.getDocumentElement();
        if ("pages".equalsIgnoreCase(node.getNodeName())) {
            NodeList children = node.getChildNodes();
            for (int j = 0; j < children.getLength(); ++j) {
                Node cnode = children.item(j);
                if (!PAGE.equalsIgnoreCase(cnode.getNodeName())) continue;
                Page page = this.parsePage(cnode);
                pagesMap.put(page.pageID, page);
            }
        }
        return pagesMap;
    }
}

