/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.mgmt.fm.storade.ui.util;

import com.sun.netstorage.mgmt.fm.storade.ui.util.Connection;
import com.sun.netstorage.mgmt.fm.storade.ui.util.Debug;
import java.net.URLEncoder;
import java.util.ResourceBundle;
import java.util.StringTokenizer;

public class NavUtil {
    public static final String NONEED = "NavUtil.JustIgnoreIt";
    private static final String NOVALUE = "NavUti.NoValue";
    private static final String STORADE = "/storade";
    private static final String DELIM = ":";
    private static final String DELIM_RESOURCES = "com.sun.netstorage.mgmt.fm.storade.ui.util.Nav";
    private static ResourceBundle rb;
    private static final String TARGET_KEY = ".target";
    private static final String FORMAT_KEY = ".format";

    private NavUtil() {
    }

    public static final String compose(String[] values) {
        if (values == null) {
            return null;
        }
        String ret = "";
        for (int i = 0; i < values.length; ++i) {
            String s = values[i];
            if (s == null || "".equals(s)) {
                s = NOVALUE;
            }
            try {
                s = URLEncoder.encode(s, "UTF-8");
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
            ret = ret + s + DELIM;
        }
        return ret;
    }

    public static final String getURL(String key, String value) {
        try {
            if (key == null || value == null) {
                return null;
            }
            if (rb == null) {
                try {
                    rb = ResourceBundle.getBundle(DELIM_RESOURCES);
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
            String target = rb.getString(key + TARGET_KEY);
            String nameFormat = rb.getString(key + FORMAT_KEY);
            if (target != null && target.startsWith(STORADE)) {
                target = target.substring(STORADE.length());
                target = "/" + Connection.getAppName() + target;
            }
            StringTokenizer value_st = new StringTokenizer(value, DELIM);
            StringTokenizer name_st = new StringTokenizer(nameFormat, DELIM);
            String para = "";
            if (name_st.countTokens() != value_st.countTokens()) {
                Debug.println("NavUtil Error: the size of name and value not match " + name_st.countTokens() + " " + value_st.countTokens());
            } else {
                int urlMarker = 63;
                while (name_st.hasMoreTokens()) {
                    String t_name = name_st.nextToken();
                    String t_value = value_st.nextToken();
                    if (NOVALUE.equals(t_value)) {
                        t_value = "";
                    }
                    if (NONEED.equals(t_value)) continue;
                    para = para + (char)urlMarker + t_name + "=" + t_value;
                    urlMarker = 38;
                }
            }
            String url = target + para;
            return url;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return null;
        }
    }

    public static void main(String[] args) {
        String toTableStr = NavUtil.compose(new String[]{"1234", "dsp1", "2"});
        System.out.println(toTableStr);
        String url = NavUtil.getURL("TestStoradeHREF", toTableStr);
        System.out.println(url);
    }
}

