/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.mgmt.fm.storade.ui.util;

import com.sun.netstorage.mgmt.fm.storade.ui.util.DateUtil;
import com.sun.netstorage.mgmt.fm.storade.ui.util.LocalizeUtil;
import java.util.Locale;
import java.util.ResourceBundle;

public class DeviceUtil {
    private static final String NON_DISPLAYABLE_PROPERTY = "***";
    private static final String FORMAT_DATE_FULL = "date:full|full";
    private static final String FORMAT_DATE_FULL_TIMEZONE = "date:full-timezone|full-timezone";
    private static final String FORMAT_FILE = "file";

    private DeviceUtil() {
    }

    public static String getType(String comp) {
        if (comp == null) {
            return null;
        }
        String type = "";
        int i = comp.indexOf(46);
        if (i != -1) {
            type = comp.substring(0, i);
        }
        return type;
    }

    public static String getComponent(String comp) {
        if (comp == null) {
            return null;
        }
        String component = "";
        int i = comp.indexOf(46);
        if (i != -1) {
            component = comp.substring(i + 1);
        }
        return component;
    }

    public static boolean isHost(String name) {
        boolean isHost = false;
        if (name != null && name.startsWith("host:")) {
            isHost = true;
        }
        return isHost;
    }

    public static boolean isSP(String name) {
        boolean isSP = false;
        if (name != null && name.startsWith("sp:")) {
            isSP = true;
        }
        return isSP;
    }

    public static boolean isDSP(String name) {
        boolean isDSP = false;
        if (name != null && name.startsWith("dsp:")) {
            isDSP = true;
        }
        return isDSP;
    }

    public static boolean isRack(String name) {
        boolean isRack = false;
        if (name != null && name.startsWith("se2:")) {
            isRack = true;
        }
        return isRack;
    }

    public static boolean isInBandDiscovered(String name) {
        boolean isInBand = false;
        if (name != null && (name.startsWith("hbastorage:") || name.startsWith("hbaswitch:"))) {
            isInBand = true;
        }
        return isInBand;
    }

    public static String getDeviceName(String name) {
        if (name == null) {
            return null;
        }
        String result = name;
        int index = name.indexOf(58);
        if (index != -1) {
            result = name.substring(index + 1);
        }
        return result;
    }

    public static String getDeviceType(String name) {
        if (name == null) {
            return null;
        }
        String result = name;
        int index = name.indexOf(58);
        if (index != -1) {
            result = name.substring(0, index);
        }
        return result;
    }

    public static String getPropertyName(String value) {
        if (value == null) {
            return null;
        }
        String result = value;
        int i = result.indexOf(46);
        if (i != -1) {
            result = result.substring(i + 1);
        }
        if ((i = result.indexOf(46)) != -1) {
            result = result.substring(i + 1);
        }
        return result;
    }

    public static boolean isDisplayableProperty(String value) {
        boolean r = true;
        if (NON_DISPLAYABLE_PROPERTY.equals(value)) {
            r = false;
        }
        return r;
    }

    public static String getLocalizedKey(String type, String key, Locale locale) {
        if (key == null) {
            return null;
        }
        String r = key;
        String FREE_SPACE = "freeSpace";
        try {
            String resource = "com.sun.netstorage.mgmt.fm.storade.ui.resources." + type + "_resources";
            if (key.startsWith(FREE_SPACE)) {
                r = LocalizeUtil.getLocalizedString(resource, FREE_SPACE, new String[]{key.substring(FREE_SPACE.length())}, locale);
            } else {
                key = key.replace(' ', '_');
                r = LocalizeUtil.getLocalizedString(resource, key, locale);
            }
        }
        catch (Exception ex) {
            // empty catch block
        }
        return r;
    }

    public static String getLocalizedKeyForInbandDevice(String key, Locale locale) {
        if (key == null) {
            return null;
        }
        String type = "host";
        String r = key;
        try {
            String resource = "com.sun.netstorage.mgmt.fm.storade.ui.resources." + type + "_resources";
            if (key.startsWith("fcport.")) {
                int pos1 = key.indexOf(".");
                int pos2 = key.indexOf(".", pos1 + 1);
                if (pos2 != -1) {
                    String portNumStr = key.substring(pos1 + 1, pos2);
                    r = LocalizeUtil.getLocalizedString(resource, "fcport." + key.substring(pos2 + 1), new String[]{portNumStr}, locale);
                } else {
                    r = LocalizeUtil.getLocalizedString(resource, key, locale);
                }
            } else {
                r = LocalizeUtil.getLocalizedString(resource, key, locale);
            }
        }
        catch (Exception ex) {
            // empty catch block
        }
        return r;
    }

    public static String getLocalizedValue(String type, String key, String value, Locale locale) {
        String r = value;
        try {
            String resource = "com.sun.netstorage.mgmt.fm.storade.ui.resources." + type + "_resources";
            ResourceBundle rb = ResourceBundle.getBundle(resource, locale);
            String format = rb.getString(key + ".format");
            if (format != null) {
                if (FORMAT_DATE_FULL_TIMEZONE.equals(format)) {
                    r = DateUtil.toString2(DateUtil.toDate2(r), locale);
                } else if (FORMAT_DATE_FULL.equals(format)) {
                    r = DateUtil.toString3(DateUtil.toDate3(r), locale);
                } else if (FORMAT_FILE.equals(format)) {
                    r = LocalizeUtil.getLocalizedString(resource, value, locale);
                }
            }
        }
        catch (Exception ex) {
            // empty catch block
        }
        return r;
    }
}

