/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.mgmt.fm.storade.ui.util;

import com.sun.netstorage.mgmt.fm.storade.ui.util.ChartData;
import com.sun.netstorage.mgmt.fm.storade.ui.util.ChartDataCollection;
import com.sun.netstorage.mgmt.fm.storade.ui.util.DateUtil;
import com.sun.netstorage.mgmt.fm.storade.ui.util.HourlyChartData;
import com.sun.netstorage.mgmt.fm.storade.ui.util.HourlyChartDataCollection;
import java.awt.Color;
import java.awt.Paint;
import java.io.File;
import java.util.HashMap;
import java.util.Iterator;
import javax.servlet.http.HttpSession;
import org.jfree.chart.ChartUtilities;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.CategoryAxis;
import org.jfree.chart.axis.CategoryLabelPositions;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.labels.CategoryLabelGenerator;
import org.jfree.chart.labels.StandardCategoryLabelGenerator;
import org.jfree.chart.plot.CategoryPlot;
import org.jfree.chart.plot.CombinedDomainCategoryPlot;
import org.jfree.chart.plot.Plot;
import org.jfree.chart.renderer.category.BarRenderer;
import org.jfree.chart.renderer.category.CategoryItemRenderer;
import org.jfree.chart.renderer.category.LineAndShapeRenderer;
import org.jfree.data.category.CategoryDataset;
import org.jfree.data.category.DefaultCategoryDataset;

public class ChartGenerator {
    public static String generateBarChart(HashMap chartDataCollection, HttpSession session, String chartName, String xAxisLabel, String yAxisLabel, String fileNameToSave, boolean withDevice) {
        String filename = null;
        try {
            DefaultCategoryDataset dataset = new DefaultCategoryDataset();
            Iterator chartHrDataIter = chartDataCollection.keySet().iterator();
            while (chartHrDataIter.hasNext()) {
                String deviceName = (String)chartHrDataIter.next();
                HourlyChartDataCollection hs = (HourlyChartDataCollection)chartDataCollection.get(deviceName);
                Iterator keyIter = hs.getHours();
                while (keyIter.hasNext()) {
                    String key = (String)keyIter.next();
                    HourlyChartData hcd = hs.getHourlyChartData(key);
                    Iterator chrtDataIter = hcd.getHourlyChartData(key);
                    while (chrtDataIter.hasNext()) {
                        ChartData chrtData = (ChartData)chrtDataIter.next();
                        String xAxisName = chrtData.getUnitName();
                        String yAxisName = chrtData.getUnitMetric();
                        Float readdata = (Float)chrtData.getUnitReadValue();
                        Float writedata = (Float)chrtData.getUnitWriteValue();
                        String legendStr1 = "Read";
                        String legendStr2 = "Write";
                        if ("Megabytes".equalsIgnoreCase(yAxisLabel)) {
                            legendStr1 = "Queue Depth";
                            legendStr2 = "Queue Size";
                        }
                        dataset.addValue((Number)readdata, (Comparable)((Object)legendStr1), (Comparable)((Object)xAxisName));
                        dataset.addValue((Number)writedata, (Comparable)((Object)legendStr2), (Comparable)((Object)xAxisName));
                    }
                }
            }
            CategoryAxis xAxis = new CategoryAxis(xAxisLabel);
            xAxis.setCategoryLabelPositions(CategoryLabelPositions.UP_45);
            NumberAxis yAxis = new NumberAxis(yAxisLabel);
            BarRenderer renderer = new BarRenderer();
            renderer.setItemMargin(0.0);
            renderer.setMaxBarWidth(0.05);
            StandardCategoryLabelGenerator scig = new StandardCategoryLabelGenerator();
            scig.generateLabel((CategoryDataset)dataset, 0, 0);
            renderer.setBaseLabelGenerator((CategoryLabelGenerator)scig);
            renderer.setItemLabelsVisible(true);
            CategoryPlot plot = new CategoryPlot((CategoryDataset)dataset, xAxis, (ValueAxis)yAxis, (CategoryItemRenderer)renderer);
            JFreeChart chart = new JFreeChart(chartName, JFreeChart.DEFAULT_TITLE_FONT, (Plot)plot, true);
            chart.setBackgroundPaint((Paint)Color.white);
            File f = new File(fileNameToSave);
            ChartUtilities.saveChartAsPNG((File)f, (JFreeChart)chart, (int)1200, (int)400);
        }
        catch (Exception e) {
            System.out.println("Exception - " + e.toString());
            e.printStackTrace(System.out);
            filename = "public_error_500x300.png";
        }
        return filename;
    }

    public static String generateLineChart(HashMap chartDataCollection, HttpSession session, String chartName, String xAxisLabel, String yAxisLabel, String fileNameToSave) {
        String filename = null;
        try {
            String legendStr1 = "Read";
            String legendStr2 = "Write";
            if ("Megabytes".equalsIgnoreCase(yAxisLabel)) {
                legendStr1 = "Queue Depth";
                legendStr2 = "Queue Size";
            }
            NumberAxis readAxis = new NumberAxis(yAxisLabel + " (" + legendStr1 + ")");
            NumberAxis writeAxis = new NumberAxis(yAxisLabel + " (" + legendStr2 + ")");
            CategoryAxis categoryAxis = new CategoryAxis(xAxisLabel);
            CombinedDomainCategoryPlot plot = new CombinedDomainCategoryPlot(categoryAxis);
            DefaultCategoryDataset readset = new DefaultCategoryDataset();
            DefaultCategoryDataset writeset = new DefaultCategoryDataset();
            Iterator chartHrDataIter = chartDataCollection.keySet().iterator();
            while (chartHrDataIter.hasNext()) {
                String deviceName = (String)chartHrDataIter.next();
                HourlyChartDataCollection hs = (HourlyChartDataCollection)chartDataCollection.get(deviceName);
                Iterator keyIter = hs.getHours();
                while (keyIter.hasNext()) {
                    String key = (String)keyIter.next();
                    HourlyChartData hcd = hs.getHourlyChartData(key);
                    Iterator chrtDataIter = hcd.getHourlyChartData(key);
                    while (chrtDataIter.hasNext()) {
                        ChartData chrtData = (ChartData)chrtDataIter.next();
                        String xAxisName = chrtData.getUnitName();
                        String yAxisName = chrtData.getUnitMetric();
                        Float readdata = (Float)chrtData.getUnitReadValue();
                        Float writedata = (Float)chrtData.getUnitWriteValue();
                        int hours = DateUtil.toDate4(key).getHours();
                        String hoursS = null;
                        hoursS = hours > 12 ? (hours %= 12) + " PM" : (hours == 0 ? "12 PM" : hours + " AM");
                        readset.addValue((Number)readdata, (Comparable)((Object)(xAxisName + " (" + legendStr1 + ")")), (Comparable)((Object)hoursS));
                        writeset.addValue((Number)writedata, (Comparable)((Object)(xAxisName + " (" + legendStr2 + ")")), (Comparable)((Object)hoursS));
                    }
                }
            }
            LineAndShapeRenderer readrenderer = new LineAndShapeRenderer();
            LineAndShapeRenderer writerenderer = new LineAndShapeRenderer();
            CategoryPlot readplot = new CategoryPlot((CategoryDataset)readset, categoryAxis, (ValueAxis)readAxis, (CategoryItemRenderer)readrenderer);
            CategoryPlot writeplot = new CategoryPlot((CategoryDataset)writeset, categoryAxis, (ValueAxis)writeAxis, (CategoryItemRenderer)writerenderer);
            plot.add(readplot);
            plot.add(writeplot);
            JFreeChart chart = new JFreeChart(chartName, JFreeChart.DEFAULT_TITLE_FONT, (Plot)plot, true);
            chart.setBackgroundPaint((Paint)Color.white);
            File f = new File(fileNameToSave);
            ChartUtilities.saveChartAsPNG((File)f, (JFreeChart)chart, (int)1200, (int)400);
        }
        catch (Exception e) {
            System.out.println("Exception - " + e.toString());
            e.printStackTrace(System.out);
            filename = "public_error_500x300.png";
        }
        return filename;
    }

    public static void main(String[] args) {
        try {
            HashMap<String, HourlyChartDataCollection> deviceMap = new HashMap<String, HourlyChartDataCollection>();
            String deviceName = "t3";
            for (int i = 1; i <= 1; ++i) {
                deviceName = deviceName + i;
                HourlyChartDataCollection hcdc = new HourlyChartDataCollection(deviceName, "Hours", "I/O");
                for (int j = 1; j <= 24; ++j) {
                    String hr = new String(j + " Hr");
                    ChartDataCollection cdc = new ChartDataCollection(hr.toString(), "Port", "I/O");
                    for (int k = 1; k <= 16; ++k) {
                        String portid = "m1p" + k;
                        ChartData c1 = new ChartData(portid, "i/o", hr);
                        double Xval = 10.0 * Math.random();
                        c1.setData(new Float(10.0 + (double)i * Xval * (double)j * (double)k), new Float(1.0 + (double)i * Xval * (double)j * (double)k));
                        cdc.setChartData(c1);
                    }
                    HourlyChartData hcd = new HourlyChartData(hr);
                    hcd.setData(cdc);
                    hcdc.setHourlyChartData(hcd);
                }
                deviceMap.put(deviceName, hcdc);
            }
            String string = ChartGenerator.generateLineChart(deviceMap, null, deviceName, "Hours", "I/O", "/tmp/chart.png");
        }
        catch (Exception e) {
            System.out.println("Exception - " + e.toString());
            e.printStackTrace();
        }
    }
}

