/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.mgmt.fm.storade.ui.util;

import com.sun.netstorage.mgmt.fm.storade.ui.util.App;
import com.sun.netstorage.mgmt.fm.storade.ui.util.Debug;
import com.sun.netstorage.mgmt.fm.storade.ui.util.Nav;
import com.sun.netstorage.mgmt.fm.storade.ui.util.NavMap;
import com.sun.netstorage.mgmt.fm.storade.ui.util.SubTask;
import com.sun.netstorage.mgmt.fm.storade.ui.util.Task;
import java.io.FileReader;
import java.util.ArrayList;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

public class ApplicationsParser {
    private static String APP = "app";
    private static String NAME = "name";
    private static String TASK = "task";
    private static String SUBTASK = "subTask";
    private static String NAVMAP = "navMap";
    private static String NAV = "nav";
    private static String KEY = "key";
    private static String TARGET = "target";
    private static String DEFAULTTARGET = "defaultTarget";
    private static String DEFAULTPAGENAME = "defaultPageName";
    private static String USECONTEXT = "useContext";
    private static String CHECKPASSWORD = "checkPassword";
    private static String AMP = "amp";
    private static String LT = "lt";
    private static String GT = "gt";
    private static String QUOT = "\"";

    private String getText(Node node) {
        NodeList nodeList = node.getChildNodes();
        String text = null;
        block7: for (int i = 0; i < nodeList.getLength(); ++i) {
            Node cnode = nodeList.item(i);
            switch (cnode.getNodeType()) {
                case 1: {
                    continue block7;
                }
                case 3: {
                    if (text == null) {
                        text = cnode.getNodeValue().trim();
                        continue block7;
                    }
                    text = text + cnode.getNodeValue().trim();
                }
                case 4: {
                    continue block7;
                }
                case 2: {
                    continue block7;
                }
                case 5: {
                    if (AMP.equals(cnode.getNodeName())) {
                        text = text + '&';
                        continue block7;
                    }
                    if (LT.equals(cnode.getNodeName())) {
                        text = text + '<';
                        continue block7;
                    }
                    if (GT.equals(cnode.getNodeName())) {
                        text = text + '>';
                        continue block7;
                    }
                    if (!QUOT.equals(cnode.getNodeName())) continue block7;
                    text = text + '\"';
                }
            }
        }
        return text;
    }

    private NavMap parseNavMap(Node node) {
        Node defaultPageName;
        NavMap navMap = new NavMap();
        NamedNodeMap attributes = node.getAttributes();
        Node defaultTarget = attributes.getNamedItem(DEFAULTTARGET);
        if (defaultTarget != null) {
            navMap.defaultTarget = defaultTarget.getNodeValue().trim();
        }
        if ((defaultPageName = attributes.getNamedItem(DEFAULTPAGENAME)) != null) {
            navMap.defaultPageName = defaultPageName.getNodeValue().trim();
        }
        NodeList children = node.getChildNodes();
        block5: for (int j = 0; j < children.getLength(); ++j) {
            Node cnode = children.item(j);
            switch (cnode.getNodeType()) {
                case 1: {
                    String n = cnode.getNodeName();
                    if (!NAV.equalsIgnoreCase(n)) continue block5;
                    Nav nav = this.parseNav(cnode);
                    navMap.navs.add(nav);
                    continue block5;
                }
                case 3: {
                    continue block5;
                }
                case 4: {
                    continue block5;
                }
            }
        }
        return navMap;
    }

    private Nav parseNav(Node node) {
        Nav nav = new Nav();
        NodeList children = node.getChildNodes();
        block5: for (int j = 0; j < children.getLength(); ++j) {
            Node cnode = children.item(j);
            switch (cnode.getNodeType()) {
                case 1: {
                    String n = cnode.getNodeName().trim();
                    if (KEY.equalsIgnoreCase(n)) {
                        nav.key = this.getText(cnode);
                        continue block5;
                    }
                    if (!TARGET.equalsIgnoreCase(n)) continue block5;
                    nav.target = this.getText(cnode);
                    continue block5;
                }
                case 3: {
                    continue block5;
                }
                case 4: {
                    continue block5;
                }
            }
        }
        return nav;
    }

    private SubTask parseSubTask(Node node) {
        SubTask subTask = new SubTask();
        NodeList children = node.getChildNodes();
        block5: for (int j = 0; j < children.getLength(); ++j) {
            Node cnode = children.item(j);
            switch (cnode.getNodeType()) {
                case 1: {
                    String n = cnode.getNodeName().trim();
                    if (NAME.equalsIgnoreCase(n)) {
                        subTask.name = this.getText(cnode);
                        continue block5;
                    }
                    if (NAVMAP.equalsIgnoreCase(n)) {
                        subTask.navMap = this.parseNavMap(cnode);
                        continue block5;
                    }
                    if (USECONTEXT.equalsIgnoreCase(n)) {
                        subTask.useContext = this.getText(cnode);
                        continue block5;
                    }
                    if (!CHECKPASSWORD.equalsIgnoreCase(n)) continue block5;
                    subTask.checkPassword = this.getText(cnode);
                    continue block5;
                }
                case 3: {
                    continue block5;
                }
                case 4: {
                    continue block5;
                }
            }
        }
        return subTask;
    }

    private Task parseTask(Node node) {
        Task task = new Task();
        NodeList children = node.getChildNodes();
        block5: for (int j = 0; j < children.getLength(); ++j) {
            Node cnode = children.item(j);
            switch (cnode.getNodeType()) {
                case 1: {
                    String n = cnode.getNodeName().trim();
                    if (NAME.equalsIgnoreCase(n)) {
                        task.name = this.getText(cnode);
                        continue block5;
                    }
                    if (SUBTASK.equalsIgnoreCase(n)) {
                        SubTask subTask = this.parseSubTask(cnode);
                        task.subTasks.add(subTask);
                        continue block5;
                    }
                    if (NAVMAP.equalsIgnoreCase(n)) {
                        task.navMap = this.parseNavMap(cnode);
                        continue block5;
                    }
                    if (USECONTEXT.equalsIgnoreCase(n)) {
                        task.useContext = this.getText(cnode);
                        continue block5;
                    }
                    if (!CHECKPASSWORD.equalsIgnoreCase(n)) continue block5;
                    task.checkPassword = this.getText(cnode);
                    continue block5;
                }
                case 3: {
                    continue block5;
                }
                case 4: {
                    continue block5;
                }
            }
        }
        return task;
    }

    private App parseApp(Node node) {
        App app = new App();
        NodeList children = node.getChildNodes();
        block5: for (int j = 0; j < children.getLength(); ++j) {
            Node cnode = children.item(j);
            switch (cnode.getNodeType()) {
                case 1: {
                    String n = cnode.getNodeName();
                    if (NAME.equalsIgnoreCase(n)) {
                        app.name = this.getText(cnode);
                        continue block5;
                    }
                    if (TASK.equalsIgnoreCase(n)) {
                        Task task = this.parseTask(cnode);
                        app.tasks.add(task);
                        continue block5;
                    }
                    if (NAVMAP.equalsIgnoreCase(n)) {
                        app.navMap = this.parseNavMap(cnode);
                        continue block5;
                    }
                    if (USECONTEXT.equalsIgnoreCase(n)) {
                        app.useContext = this.getText(cnode);
                        continue block5;
                    }
                    if (!CHECKPASSWORD.equalsIgnoreCase(n)) continue block5;
                    app.checkPassword = this.getText(cnode);
                    continue block5;
                }
                case 3: {
                    continue block5;
                }
                case 4: {
                    continue block5;
                }
            }
        }
        return app;
    }

    public ArrayList parse(String fileName) throws Exception {
        ArrayList<App> applications = new ArrayList<App>();
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        dbf.setValidating(false);
        DocumentBuilder db = dbf.newDocumentBuilder();
        Document doc = db.parse(new InputSource(new FileReader(fileName)));
        Element node = doc.getDocumentElement();
        if ("applications".equalsIgnoreCase(node.getNodeName())) {
            NodeList children = node.getChildNodes();
            for (int j = 0; j < children.getLength(); ++j) {
                Node cnode = children.item(j);
                if (!APP.equalsIgnoreCase(cnode.getNodeName())) continue;
                App app = this.parseApp(cnode);
                applications.add(app);
            }
        }
        return applications;
    }

    public static void main(String[] args) throws Exception {
        ApplicationsParser p = new ApplicationsParser();
        ArrayList l = p.parse(args[0]);
        for (int i = 0; i < l.size(); ++i) {
            App app = (App)l.get(i);
            Debug.println("APP NAME: " + app.name);
            Debug.println("APP Default Target:  " + app.navMap.defaultTarget);
            Debug.println("APP Default Page Name:  " + app.navMap.defaultPageName);
            for (int e = 0; e < app.navMap.navs.size(); ++e) {
                Nav nav = (Nav)app.navMap.navs.get(e);
                Debug.println("APP Targets:  " + nav.key + " " + nav.target);
            }
            for (int j = 0; j < app.tasks.size(); ++j) {
                Task task = (Task)app.tasks.get(j);
                Debug.println("  TASK NAME: " + task.name);
                Debug.println("  TASK Default Target:  " + task.navMap.defaultTarget);
                Debug.println(" TASK Default Page Name:  " + task.navMap.defaultPageName);
                for (int f = 0; f < task.navMap.navs.size(); ++f) {
                    Nav nav = (Nav)task.navMap.navs.get(f);
                    Debug.println("  TASK Targets:  " + nav.key + " " + nav.target);
                }
                for (int k = 0; k < task.subTasks.size(); ++k) {
                    SubTask subTask = (SubTask)task.subTasks.get(k);
                    Debug.println("     SUBTASK NAME: " + subTask.name);
                    Debug.println("     SUBTASK Default Target:  " + subTask.navMap.defaultTarget);
                    Debug.println("     SUBTASK Default Page Name:  " + subTask.navMap.defaultPageName);
                    for (int m = 0; m < subTask.navMap.navs.size(); ++m) {
                        Nav nav = (Nav)subTask.navMap.navs.get(m);
                        Debug.println("       SUBTASK Targets:  " + nav.key + " " + nav.target);
                    }
                }
            }
        }
    }
}

