/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.mgmt.fm.storade.ui.common;

import com.sun.netstorage.mgmt.fm.storade.schema.Value;
import com.sun.netstorage.mgmt.fm.storade.schema.admin.RenvResultDocument;
import com.sun.netstorage.mgmt.fm.storade.ui.util.Connection;
import com.sun.netstorage.mgmt.fm.storade.ui.util.Debug;
import com.sun.netstorage.mgmt.fm.storade.ui.util.SystemUtil;
import com.sun.netstorage.mgmt.fm.storade.ui.viewbeans.admin.Getter;
import com.sun.netstorage.mgmt.fm.storade.ui.viewbeans.admin.Setter;
import com.sun.netstorage.mgmt.fm.storade.ui.viewbeans.reports.RackDataHelper;
import java.io.FileInputStream;
import java.util.Enumeration;
import java.util.Properties;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;

public class InstallerServlet
extends HttpServlet {
    public static final String JOB_REFRESHRATE_KEY = "storade.jobRefreshRate";
    public static final String DEFAULT_JOB_REFRESHRATE = "10";
    public static final int DEFAULT_JOB_REFRESHRATE_INT = 10;
    public static final String IS_SITEINFO_READY_KEY = "storade.isSiteInfoReady";
    public static final String IS_SITEINFO_READY_TRUE = "true";
    public static final String IS_SITEINFO_READY_FALSE = "false";
    public static final String IS_BASE_INITIALIZED_KEY = "storade.isBaseInitialized";
    public static final String IS_BASE_INITIALIZED_TRUE = "true";
    public static final String IS_BASE_INITIALIZED_FALSE = "false";
    public static final String TOPOLOGY_LABEL_KEY = "storade.topologyLabel";
    public static final String TOPOLOGY_LABEL_DEFAULT = "deviceName";
    public static final String TOPOLOGY_TOOLTIP_KEY = "storade.topologyTooltip";
    public static final String TOPOLOGY_TOOLTIP_DEFAULT = "vendorModel";
    public static final String TOPOLOGY_SCALING_KEY = "storade.topologyScaling";
    public static final String TOPOLOGY_SCALING_DEFAULT = "doNestedGrouping";
    public static final String TOPOLOGY_VIEWTYPE_KEY = "storade.topologyViewType";
    public static final String TOPOLOGY_VIEWTYPE_DEFAULT = "topology.view.graphical";
    public static final String REPORT_VIEWTYPE_KEY = "storade.reportViewType";
    public static final String REPORT_VIEWTYPE_DEFAULT = "asset.details.view.summary";
    public static final String FULL_HOSTNAME_KEY = "storade.fullHostName";
    public static final String SYSTEM_PROPERTIES_LOCATION = "/WEB-INF/system.properties";
    public static final String sccs_id = "@(#)InstallerServlet.java\t1.3 06/11/03 SMI";

    public void init() throws ServletException {
        this.initSystemProperties();
        try {
            InstallerServlet.initBaseProperties(this.getServletContext());
        }
        catch (Exception ex) {
            ex.printStackTrace();
            this.getServletContext().setAttribute(JOB_REFRESHRATE_KEY, (Object)DEFAULT_JOB_REFRESHRATE);
            this.getServletContext().setAttribute(IS_SITEINFO_READY_KEY, (Object)"false");
        }
        if (SystemUtil.isSystemEdition()) {
            this.initSystemID();
            this.initSystem();
        }
    }

    public static void initBaseProperties(ServletContext context) {
        RenvResultDocument.RenvResult result = null;
        try {
            result = Getter.getRenvResultDocument().getRenvResult();
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (result != null) {
            InstallerServlet.initJobRefreshRate(result, context);
            InstallerServlet.initFullHostname(result, context);
            InstallerServlet.initIsSiteInfoReady(result, context);
            InstallerServlet.initPreference(result, context);
            context.setAttribute(IS_BASE_INITIALIZED_KEY, (Object)"true");
            Debug.println("the properties from base pkg has been inited");
        }
    }

    private void initSystemProperties() {
        String fullPath = SYSTEM_PROPERTIES_LOCATION;
        String value = this.getServletContext().getRealPath(SYSTEM_PROPERTIES_LOCATION);
        if (value != null) {
            fullPath = value;
        }
        try {
            Properties p = new Properties();
            p.load(new FileInputStream(fullPath));
            Enumeration<?> e = p.propertyNames();
            while (e.hasMoreElements()) {
                String key = (String)e.nextElement();
                System.setProperty(key, p.getProperty(key));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void initSystemID() {
        try {
            RackDataHelper.getSystemID();
        }
        catch (Exception ex) {
            Debug.println("Unable to get rack information");
            Debug.println("Possibly unable to contact middle tier or middle tier is down");
            ex.printStackTrace();
        }
    }

    private void initSystem() {
        Setter.initSystemEdition();
    }

    private static void initFullHostname(RenvResultDocument.RenvResult result, ServletContext context) {
        Value[] values = result.getENV().getVALUEArray();
        String fullHostname = null;
        for (int i = 0; i < values.length; ++i) {
            Value v = values[i];
            if (!"hostname".equals(v.getID())) continue;
            fullHostname = v.getStringValue();
            Debug.println("get fully qualified hostname: " + fullHostname);
            break;
        }
        if (fullHostname != null) {
            Debug.println("set fully qualified hostname: " + fullHostname);
            context.setAttribute(FULL_HOSTNAME_KEY, (Object)fullHostname);
            Connection.setFullyQualifiedHostname(fullHostname);
        }
    }

    private static void initJobRefreshRate(RenvResultDocument.RenvResult result, ServletContext context) {
        Value[] values = result.getENV().getVALUEArray();
        String jobRefreshRate = null;
        for (int i = 0; i < values.length; ++i) {
            Value v = values[i];
            if (!"test.refresh_rate".equals(v.getID())) continue;
            jobRefreshRate = v.getStringValue();
            Debug.println("get job refresh rate: " + jobRefreshRate);
            break;
        }
        if (jobRefreshRate == null || jobRefreshRate.trim().equals("")) {
            jobRefreshRate = DEFAULT_JOB_REFRESHRATE;
        }
        Debug.println("set job refresh rate: " + jobRefreshRate);
        context.setAttribute(JOB_REFRESHRATE_KEY, (Object)jobRefreshRate);
    }

    private static void initIsSiteInfoReady(RenvResultDocument.RenvResult result, ServletContext context) {
        boolean isReady = InstallerServlet.isRequiredSiteInfoIn(result);
        if (isReady) {
            context.setAttribute(IS_SITEINFO_READY_KEY, (Object)"true");
        } else {
            context.setAttribute(IS_SITEINFO_READY_KEY, (Object)"false");
        }
    }

    private static void initPreference(RenvResultDocument.RenvResult result, ServletContext context) {
        Value[] values = result.getENV().getVALUEArray();
        String topoObjLabel = null;
        String topoObjTooltip = null;
        String topoScalingBehavior = null;
        String topoViewType = null;
        String reportViewType = null;
        for (int i = 0; i < values.length; ++i) {
            Value v = values[i];
            if ("topology.object_label".equals(v.getID())) {
                topoObjLabel = v.getStringValue();
                continue;
            }
            if ("topology.object_tooltip".equals(v.getID())) {
                topoObjTooltip = v.getStringValue();
                continue;
            }
            if ("topology.scaling_behavior".equals(v.getID())) {
                topoScalingBehavior = v.getStringValue();
                continue;
            }
            if ("topology.view_type".equals(v.getID())) {
                topoViewType = v.getStringValue();
                continue;
            }
            if (!"report.view_type".equals(v.getID())) continue;
            reportViewType = v.getStringValue();
        }
        if (topoObjLabel == null || topoObjLabel.trim().equals("")) {
            topoObjLabel = TOPOLOGY_LABEL_DEFAULT;
        }
        if (topoObjTooltip == null || topoObjTooltip.trim().equals("")) {
            topoObjTooltip = TOPOLOGY_TOOLTIP_DEFAULT;
        }
        if (topoScalingBehavior == null || topoScalingBehavior.trim().equals("")) {
            topoScalingBehavior = TOPOLOGY_SCALING_DEFAULT;
        }
        if (topoViewType == null || topoViewType.trim().equals("")) {
            topoViewType = TOPOLOGY_VIEWTYPE_DEFAULT;
        }
        if (reportViewType == null || reportViewType.trim().equals("")) {
            reportViewType = REPORT_VIEWTYPE_DEFAULT;
        }
        context.setAttribute(TOPOLOGY_LABEL_KEY, (Object)topoObjLabel);
        context.setAttribute(TOPOLOGY_TOOLTIP_KEY, (Object)topoObjTooltip);
        context.setAttribute(TOPOLOGY_SCALING_KEY, (Object)topoScalingBehavior);
        context.setAttribute(TOPOLOGY_VIEWTYPE_KEY, (Object)topoViewType);
        context.setAttribute(REPORT_VIEWTYPE_KEY, (Object)reportViewType);
    }

    public static boolean isRequiredSiteInfoIn(RenvResultDocument.RenvResult result) {
        try {
            if (result == null) {
                result = Getter.getRenvResultDocument().getRenvResult();
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        if (result == null) {
            return false;
        }
        boolean isReady = true;
        String customer = null;
        String siteName = null;
        String city = null;
        String state = null;
        String country = null;
        String contact = null;
        String email = null;
        Value[] values = result.getENV().getVALUEArray();
        for (int i = 0; i < values.length; ++i) {
            Value v = values[i];
            if ("customer".equals(v.getID())) {
                customer = v.getStringValue().trim();
                continue;
            }
            if ("site_name".equals(v.getID())) {
                siteName = v.getStringValue().trim();
                continue;
            }
            if ("site_city".equals(v.getID())) {
                city = v.getStringValue().trim();
                continue;
            }
            if ("site_state".equals(v.getID())) {
                state = v.getStringValue().trim();
                continue;
            }
            if ("site_country".equals(v.getID())) {
                country = v.getStringValue().trim();
                continue;
            }
            if ("site_contact".equals(v.getID())) {
                contact = v.getStringValue().trim();
                continue;
            }
            if (!"site_email".equals(v.getID())) continue;
            email = v.getStringValue().trim();
        }
        if (customer == null || "".equals(customer) || siteName == null || "".equals(siteName) || city == null || "".equals(city) || country == null || "".equals(country) || contact == null || "".equals(contact) || email == null || "".equals(email)) {
            isReady = false;
        }
        return isReady;
    }
}

