/*
 * Decompiled with CFR 0.152.
 */
package devmgr.versioned.symbol;

import devmgr.versioned.jrpc.RPCError;
import devmgr.versioned.jrpc.XDRInputStream;
import devmgr.versioned.jrpc.XDROutputStream;
import devmgr.versioned.jrpc.XDRType;
import devmgr.versioned.symbol.AbstractVolRef;
import devmgr.versioned.symbol.SYMbolAPIConstants;
import devmgr.versioned.symbol.VolumeScanPriority;

public class VolumeScanDescriptor
implements XDRType,
SYMbolAPIConstants {
    private AbstractVolRef volumeRef = new AbstractVolRef();
    private long startingLBA;
    private long endingLBA;
    private boolean repairMedia;
    private boolean repairParity;
    private VolumeScanPriority priority = new VolumeScanPriority();
    private int timeout;

    public VolumeScanDescriptor() {
    }

    public VolumeScanDescriptor(VolumeScanDescriptor volumeScanDescriptor) {
        this.volumeRef = volumeScanDescriptor.volumeRef;
        this.startingLBA = volumeScanDescriptor.startingLBA;
        this.endingLBA = volumeScanDescriptor.endingLBA;
        this.repairMedia = volumeScanDescriptor.repairMedia;
        this.repairParity = volumeScanDescriptor.repairParity;
        this.priority = volumeScanDescriptor.priority;
        this.timeout = volumeScanDescriptor.timeout;
    }

    public long getEndingLBA() {
        return this.endingLBA;
    }

    public VolumeScanPriority getPriority() {
        return this.priority;
    }

    public boolean getRepairMedia() {
        return this.repairMedia;
    }

    public boolean getRepairParity() {
        return this.repairParity;
    }

    public long getStartingLBA() {
        return this.startingLBA;
    }

    public int getTimeout() {
        return this.timeout;
    }

    public AbstractVolRef getVolumeRef() {
        return this.volumeRef;
    }

    public void setEndingLBA(long l) {
        this.endingLBA = l;
    }

    public void setPriority(VolumeScanPriority volumeScanPriority) {
        this.priority = volumeScanPriority;
    }

    public void setRepairMedia(boolean bl) {
        this.repairMedia = bl;
    }

    public void setRepairParity(boolean bl) {
        this.repairParity = bl;
    }

    public void setStartingLBA(long l) {
        this.startingLBA = l;
    }

    public void setTimeout(int n) {
        this.timeout = n;
    }

    public void setVolumeRef(AbstractVolRef abstractVolRef) {
        this.volumeRef = abstractVolRef;
    }

    public void xdrDecode(XDRInputStream xDRInputStream) throws RPCError {
        int n = xDRInputStream.getInt() + xDRInputStream.getPosition();
        if (xDRInputStream.getPosition() < n) {
            this.volumeRef.xdrDecode(xDRInputStream);
        }
        if (xDRInputStream.getPosition() < n) {
            this.startingLBA = xDRInputStream.getLong();
        }
        if (xDRInputStream.getPosition() < n) {
            this.endingLBA = xDRInputStream.getLong();
        }
        if (xDRInputStream.getPosition() < n) {
            this.repairMedia = xDRInputStream.getBoolean();
        }
        if (xDRInputStream.getPosition() < n) {
            this.repairParity = xDRInputStream.getBoolean();
        }
        if (xDRInputStream.getPosition() < n) {
            this.priority.xdrDecode(xDRInputStream);
        }
        if (xDRInputStream.getPosition() < n) {
            this.timeout = xDRInputStream.getInt();
        }
        xDRInputStream.skip(n - xDRInputStream.getPosition());
    }

    public void xdrEncode(XDROutputStream xDROutputStream) throws RPCError {
        int n = xDROutputStream.prepareLength();
        this.volumeRef.xdrEncode(xDROutputStream);
        xDROutputStream.putLong(this.startingLBA);
        xDROutputStream.putLong(this.endingLBA);
        xDROutputStream.putBoolean(this.repairMedia);
        xDROutputStream.putBoolean(this.repairParity);
        this.priority.xdrEncode(xDROutputStream);
        xDROutputStream.putInt(this.timeout);
        xDROutputStream.setLength(n);
    }
}

