/*
 * Decompiled with CFR 0.152.
 */
package devmgr.versioned.symbol;

import devmgr.versioned.jrpc.RPCError;
import devmgr.versioned.jrpc.XDRInputStream;
import devmgr.versioned.jrpc.XDROutputStream;
import devmgr.versioned.jrpc.XDRType;
import devmgr.versioned.symbol.SCSIDriverType;
import devmgr.versioned.symbol.SYMbolAPIConstants;

public class SCSIInterface
implements XDRType,
SYMbolAPIConstants {
    private int channel;
    private int scsiID;
    private int speed;
    private SCSIDriverType scsiType = new SCSIDriverType();
    private int width;
    private String part;
    private int revision;
    private byte[] reserved1;
    private byte[] reserved2;

    public SCSIInterface() {
    }

    public SCSIInterface(SCSIInterface sCSIInterface) {
        this.channel = sCSIInterface.channel;
        this.scsiID = sCSIInterface.scsiID;
        this.speed = sCSIInterface.speed;
        this.scsiType = sCSIInterface.scsiType;
        this.width = sCSIInterface.width;
        this.part = sCSIInterface.part;
        this.revision = sCSIInterface.revision;
        this.reserved1 = sCSIInterface.reserved1;
        this.reserved2 = sCSIInterface.reserved2;
    }

    public int getChannel() {
        return this.channel;
    }

    public String getPart() {
        return this.part;
    }

    public byte[] getReserved1() {
        return this.reserved1;
    }

    public byte[] getReserved2() {
        return this.reserved2;
    }

    public int getRevision() {
        return this.revision;
    }

    public int getScsiID() {
        return this.scsiID;
    }

    public SCSIDriverType getScsiType() {
        return this.scsiType;
    }

    public int getSpeed() {
        return this.speed;
    }

    public int getWidth() {
        return this.width;
    }

    public void setChannel(int n) {
        this.channel = n;
    }

    public void setPart(String string) {
        this.part = string;
    }

    public void setReserved1(byte[] byArray) {
        this.reserved1 = byArray;
    }

    public void setReserved2(byte[] byArray) {
        this.reserved2 = byArray;
    }

    public void setRevision(int n) {
        this.revision = n;
    }

    public void setScsiID(int n) {
        this.scsiID = n;
    }

    public void setScsiType(SCSIDriverType sCSIDriverType) {
        this.scsiType = sCSIDriverType;
    }

    public void setSpeed(int n) {
        this.speed = n;
    }

    public void setWidth(int n) {
        this.width = n;
    }

    public void xdrDecode(XDRInputStream xDRInputStream) throws RPCError {
        int n = xDRInputStream.getInt() + xDRInputStream.getPosition();
        if (xDRInputStream.getPosition() < n) {
            this.channel = xDRInputStream.getInt();
        }
        if (xDRInputStream.getPosition() < n) {
            this.scsiID = xDRInputStream.getInt();
        }
        if (xDRInputStream.getPosition() < n) {
            this.speed = xDRInputStream.getInt();
        }
        if (xDRInputStream.getPosition() < n) {
            this.scsiType.xdrDecode(xDRInputStream);
        }
        if (xDRInputStream.getPosition() < n) {
            this.width = xDRInputStream.getInt();
        }
        if (xDRInputStream.getPosition() < n) {
            this.part = xDRInputStream.getString();
        }
        if (xDRInputStream.getPosition() < n) {
            this.revision = xDRInputStream.getInt();
        }
        if (xDRInputStream.getPosition() < n) {
            this.reserved1 = xDRInputStream.getFixedOpaque(12);
        }
        if (xDRInputStream.getPosition() < n) {
            this.reserved2 = xDRInputStream.getVariableOpaque();
        }
        xDRInputStream.skip(n - xDRInputStream.getPosition());
    }

    public void xdrEncode(XDROutputStream xDROutputStream) throws RPCError {
        int n = xDROutputStream.prepareLength();
        xDROutputStream.putInt(this.channel);
        xDROutputStream.putInt(this.scsiID);
        xDROutputStream.putInt(this.speed);
        this.scsiType.xdrEncode(xDROutputStream);
        xDROutputStream.putInt(this.width);
        xDROutputStream.putString(this.part);
        xDROutputStream.putInt(this.revision);
        xDROutputStream.putFixedOpaque(this.reserved1, 12);
        xDROutputStream.putVariableOpaque(this.reserved2);
        xDROutputStream.setLength(n);
    }
}

