/*
 * Decompiled with CFR 0.152.
 */
package devmgr.versioned.symbol;

import devmgr.versioned.jrpc.RPCError;
import devmgr.versioned.jrpc.XDRInputStream;
import devmgr.versioned.jrpc.XDROutputStream;
import devmgr.versioned.jrpc.XDRType;
import devmgr.versioned.symbol.SYMbolAPIConstants;
import devmgr.versioned.symbol.SnapshotRef;

public class RepositoryUtilization
implements XDRType,
SYMbolAPIConstants {
    private long repositoryUsage;
    private SnapshotRef snapRef = new SnapshotRef();

    public RepositoryUtilization() {
    }

    public RepositoryUtilization(RepositoryUtilization repositoryUtilization) {
        this.repositoryUsage = repositoryUtilization.repositoryUsage;
        this.snapRef = repositoryUtilization.snapRef;
    }

    public long getRepositoryUsage() {
        return this.repositoryUsage;
    }

    public SnapshotRef getSnapRef() {
        return this.snapRef;
    }

    public void setRepositoryUsage(long l) {
        this.repositoryUsage = l;
    }

    public void setSnapRef(SnapshotRef snapshotRef) {
        this.snapRef = snapshotRef;
    }

    public void xdrDecode(XDRInputStream xDRInputStream) throws RPCError {
        int n = xDRInputStream.getInt() + xDRInputStream.getPosition();
        if (xDRInputStream.getPosition() < n) {
            this.repositoryUsage = xDRInputStream.getLong();
        }
        if (xDRInputStream.getPosition() < n) {
            this.snapRef.xdrDecode(xDRInputStream);
        }
        xDRInputStream.skip(n - xDRInputStream.getPosition());
    }

    public void xdrEncode(XDROutputStream xDROutputStream) throws RPCError {
        int n = xDROutputStream.prepareLength();
        xDROutputStream.putLong(this.repositoryUsage);
        this.snapRef.xdrEncode(xDROutputStream);
        xDROutputStream.setLength(n);
    }
}

